# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ProductLicenseImage',
    'GetLicenseRecordsFilterResult',
    'GetLicenseRecordsLicenseRecordCollectionResult',
    'GetLicenseRecordsLicenseRecordCollectionItemResult',
    'GetProductLicenseConsumersItemResult',
    'GetProductLicenseConsumersItemMissingProductResult',
    'GetProductLicenseImageResult',
    'GetProductLicensesFilterResult',
    'GetProductLicensesProductLicenseCollectionResult',
    'GetProductLicensesProductLicenseCollectionItemResult',
    'GetProductLicensesProductLicenseCollectionItemImageResult',
    'GetTopUtilizedProductLicensesItemResult',
    'GetTopUtilizedResourcesItemResult',
]

@pulumi.output_type
class ProductLicenseImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listingId":
            suggest = "listing_id"
        elif key == "packageVersion":
            suggest = "package_version"
        elif key == "listingName":
            suggest = "listing_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProductLicenseImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProductLicenseImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProductLicenseImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 listing_id: str,
                 package_version: str,
                 id: Optional[str] = None,
                 listing_name: Optional[str] = None,
                 publisher: Optional[str] = None):
        """
        :param str listing_id: (Updatable) Marketplace image listing ID.
        :param str package_version: (Updatable) Image package version.
        :param str id: The image ID associated with the product license.
        :param str listing_name: The listing name associated with the product license.
        :param str publisher: The image publisher.
        """
        ProductLicenseImage._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            listing_id=listing_id,
            package_version=package_version,
            id=id,
            listing_name=listing_name,
            publisher=publisher,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             listing_id: str,
             package_version: str,
             id: Optional[str] = None,
             listing_name: Optional[str] = None,
             publisher: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'listingId' in kwargs:
            listing_id = kwargs['listingId']
        if 'packageVersion' in kwargs:
            package_version = kwargs['packageVersion']
        if 'listingName' in kwargs:
            listing_name = kwargs['listingName']

        _setter("listing_id", listing_id)
        _setter("package_version", package_version)
        if id is not None:
            _setter("id", id)
        if listing_name is not None:
            _setter("listing_name", listing_name)
        if publisher is not None:
            _setter("publisher", publisher)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> str:
        """
        (Updatable) Marketplace image listing ID.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> str:
        """
        (Updatable) Image package version.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingName")
    def listing_name(self) -> Optional[str]:
        """
        The listing name associated with the product license.
        """
        return pulumi.get(self, "listing_name")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class GetLicenseRecordsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetLicenseRecordsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLicenseRecordsLicenseRecordCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetLicenseRecordsLicenseRecordCollectionItemResult']):
        GetLicenseRecordsLicenseRecordCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetLicenseRecordsLicenseRecordCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLicenseRecordsLicenseRecordCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetLicenseRecordsLicenseRecordCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 expiration_date: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_perpetual: bool,
                 is_unlimited: bool,
                 license_count: int,
                 license_unit: str,
                 product_id: str,
                 product_license: str,
                 product_license_id: str,
                 state: str,
                 support_end_date: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the license record is created.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: The license record display name. Avoid entering confidential information.
        :param str expiration_date: The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The license record [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param bool is_perpetual: Specifies if the license record term is perpertual.
        :param bool is_unlimited: Specifies if the license count is unlimited.
        :param int license_count: The number of license units added by the user for the given license record. Default 1
        :param str license_unit: The product license unit.
        :param str product_id: The license record product ID.
        :param str product_license: The product license name with which the license record is associated.
        :param str product_license_id: Unique product license identifier.
        :param str state: The current license record state.
        :param str support_end_date: The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the license record was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param str time_updated: The time the license record was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        GetLicenseRecordsLicenseRecordCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            expiration_date=expiration_date,
            freeform_tags=freeform_tags,
            id=id,
            is_perpetual=is_perpetual,
            is_unlimited=is_unlimited,
            license_count=license_count,
            license_unit=license_unit,
            product_id=product_id,
            product_license=product_license,
            product_license_id=product_license_id,
            state=state,
            support_end_date=support_end_date,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             expiration_date: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_perpetual: bool,
             is_unlimited: bool,
             license_count: int,
             license_unit: str,
             product_id: str,
             product_license: str,
             product_license_id: str,
             state: str,
             support_end_date: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'expirationDate' in kwargs:
            expiration_date = kwargs['expirationDate']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isPerpetual' in kwargs:
            is_perpetual = kwargs['isPerpetual']
        if 'isUnlimited' in kwargs:
            is_unlimited = kwargs['isUnlimited']
        if 'licenseCount' in kwargs:
            license_count = kwargs['licenseCount']
        if 'licenseUnit' in kwargs:
            license_unit = kwargs['licenseUnit']
        if 'productId' in kwargs:
            product_id = kwargs['productId']
        if 'productLicense' in kwargs:
            product_license = kwargs['productLicense']
        if 'productLicenseId' in kwargs:
            product_license_id = kwargs['productLicenseId']
        if 'supportEndDate' in kwargs:
            support_end_date = kwargs['supportEndDate']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("expiration_date", expiration_date)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_perpetual", is_perpetual)
        _setter("is_unlimited", is_unlimited)
        _setter("license_count", license_count)
        _setter("license_unit", license_unit)
        _setter("product_id", product_id)
        _setter("product_license", product_license)
        _setter("product_license_id", product_license_id)
        _setter("state", state)
        _setter("support_end_date", support_end_date)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the license record is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The license record display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> str:
        """
        The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The license record [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPerpetual")
    def is_perpetual(self) -> bool:
        """
        Specifies if the license record term is perpertual.
        """
        return pulumi.get(self, "is_perpetual")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> bool:
        """
        Specifies if the license count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="licenseCount")
    def license_count(self) -> int:
        """
        The number of license units added by the user for the given license record. Default 1
        """
        return pulumi.get(self, "license_count")

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> str:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> str:
        """
        The license record product ID.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="productLicense")
    def product_license(self) -> str:
        """
        The product license name with which the license record is associated.
        """
        return pulumi.get(self, "product_license")

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> str:
        """
        Unique product license identifier.
        """
        return pulumi.get(self, "product_license_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current license record state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportEndDate")
    def support_end_date(self) -> str:
        """
        The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        """
        return pulumi.get(self, "support_end_date")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the license record was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the license record was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetProductLicenseConsumersItemResult(dict):
    def __init__(__self__, *,
                 are_all_options_available: bool,
                 is_base_license_available: bool,
                 license_unit_type: str,
                 license_units_consumed: float,
                 missing_products: Sequence['outputs.GetProductLicenseConsumersItemMissingProductResult'],
                 product_name: str,
                 resource_compartment_id: str,
                 resource_compartment_name: str,
                 resource_id: str,
                 resource_name: str,
                 resource_unit_count: float,
                 resource_unit_type: str):
        """
        :param bool are_all_options_available: Specifies if all options are available.
        :param bool is_base_license_available: Specifies if the base license is available.
        :param str license_unit_type: The product license unit.
        :param float license_units_consumed: Number of license units consumed by the resource.
        :param Sequence['GetProductLicenseConsumersItemMissingProductArgs'] missing_products: Collection of missing product licenses.
        :param str product_name: The resource product name.
        :param str resource_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the resource.
        :param str resource_compartment_name: The display name of the compartment that contains the resource.
        :param str resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        :param str resource_name: The display name of the resource.
        :param float resource_unit_count: Number of units of the resource
        :param str resource_unit_type: The unit type for the resource.
        """
        GetProductLicenseConsumersItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            are_all_options_available=are_all_options_available,
            is_base_license_available=is_base_license_available,
            license_unit_type=license_unit_type,
            license_units_consumed=license_units_consumed,
            missing_products=missing_products,
            product_name=product_name,
            resource_compartment_id=resource_compartment_id,
            resource_compartment_name=resource_compartment_name,
            resource_id=resource_id,
            resource_name=resource_name,
            resource_unit_count=resource_unit_count,
            resource_unit_type=resource_unit_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             are_all_options_available: bool,
             is_base_license_available: bool,
             license_unit_type: str,
             license_units_consumed: float,
             missing_products: Sequence['outputs.GetProductLicenseConsumersItemMissingProductResult'],
             product_name: str,
             resource_compartment_id: str,
             resource_compartment_name: str,
             resource_id: str,
             resource_name: str,
             resource_unit_count: float,
             resource_unit_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'areAllOptionsAvailable' in kwargs:
            are_all_options_available = kwargs['areAllOptionsAvailable']
        if 'isBaseLicenseAvailable' in kwargs:
            is_base_license_available = kwargs['isBaseLicenseAvailable']
        if 'licenseUnitType' in kwargs:
            license_unit_type = kwargs['licenseUnitType']
        if 'licenseUnitsConsumed' in kwargs:
            license_units_consumed = kwargs['licenseUnitsConsumed']
        if 'missingProducts' in kwargs:
            missing_products = kwargs['missingProducts']
        if 'productName' in kwargs:
            product_name = kwargs['productName']
        if 'resourceCompartmentId' in kwargs:
            resource_compartment_id = kwargs['resourceCompartmentId']
        if 'resourceCompartmentName' in kwargs:
            resource_compartment_name = kwargs['resourceCompartmentName']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceName' in kwargs:
            resource_name = kwargs['resourceName']
        if 'resourceUnitCount' in kwargs:
            resource_unit_count = kwargs['resourceUnitCount']
        if 'resourceUnitType' in kwargs:
            resource_unit_type = kwargs['resourceUnitType']

        _setter("are_all_options_available", are_all_options_available)
        _setter("is_base_license_available", is_base_license_available)
        _setter("license_unit_type", license_unit_type)
        _setter("license_units_consumed", license_units_consumed)
        _setter("missing_products", missing_products)
        _setter("product_name", product_name)
        _setter("resource_compartment_id", resource_compartment_id)
        _setter("resource_compartment_name", resource_compartment_name)
        _setter("resource_id", resource_id)
        _setter("resource_name", resource_name)
        _setter("resource_unit_count", resource_unit_count)
        _setter("resource_unit_type", resource_unit_type)

    @property
    @pulumi.getter(name="areAllOptionsAvailable")
    def are_all_options_available(self) -> bool:
        """
        Specifies if all options are available.
        """
        return pulumi.get(self, "are_all_options_available")

    @property
    @pulumi.getter(name="isBaseLicenseAvailable")
    def is_base_license_available(self) -> bool:
        """
        Specifies if the base license is available.
        """
        return pulumi.get(self, "is_base_license_available")

    @property
    @pulumi.getter(name="licenseUnitType")
    def license_unit_type(self) -> str:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit_type")

    @property
    @pulumi.getter(name="licenseUnitsConsumed")
    def license_units_consumed(self) -> float:
        """
        Number of license units consumed by the resource.
        """
        return pulumi.get(self, "license_units_consumed")

    @property
    @pulumi.getter(name="missingProducts")
    def missing_products(self) -> Sequence['outputs.GetProductLicenseConsumersItemMissingProductResult']:
        """
        Collection of missing product licenses.
        """
        return pulumi.get(self, "missing_products")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> str:
        """
        The resource product name.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceCompartmentName")
    def resource_compartment_name(self) -> str:
        """
        The display name of the compartment that contains the resource.
        """
        return pulumi.get(self, "resource_compartment_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The display name of the resource.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceUnitCount")
    def resource_unit_count(self) -> float:
        """
        Number of units of the resource
        """
        return pulumi.get(self, "resource_unit_count")

    @property
    @pulumi.getter(name="resourceUnitType")
    def resource_unit_type(self) -> str:
        """
        The unit type for the resource.
        """
        return pulumi.get(self, "resource_unit_type")


@pulumi.output_type
class GetProductLicenseConsumersItemMissingProductResult(dict):
    def __init__(__self__, *,
                 category: str,
                 count: float,
                 name: str):
        """
        :param str category: Product category base or option.
        :param float count: Units required for the missing product.
        :param str name: Name of the product.
        """
        GetProductLicenseConsumersItemMissingProductResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            category=category,
            count=count,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             category: str,
             count: float,
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("category", category)
        _setter("count", count)
        _setter("name", name)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Product category base or option.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def count(self) -> float:
        """
        Units required for the missing product.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the product.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetProductLicenseImageResult(dict):
    def __init__(__self__, *,
                 id: str,
                 listing_id: str,
                 listing_name: str,
                 package_version: str,
                 publisher: str):
        """
        :param str id: The image ID associated with the product license.
        :param str listing_id: The image listing ID.
        :param str listing_name: The listing name associated with the product license.
        :param str package_version: The image package version.
        :param str publisher: The image publisher.
        """
        GetProductLicenseImageResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            listing_id=listing_id,
            listing_name=listing_name,
            package_version=package_version,
            publisher=publisher,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: str,
             listing_id: str,
             listing_name: str,
             package_version: str,
             publisher: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'listingId' in kwargs:
            listing_id = kwargs['listingId']
        if 'listingName' in kwargs:
            listing_name = kwargs['listingName']
        if 'packageVersion' in kwargs:
            package_version = kwargs['packageVersion']

        _setter("id", id)
        _setter("listing_id", listing_id)
        _setter("listing_name", listing_name)
        _setter("package_version", package_version)
        _setter("publisher", publisher)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> str:
        """
        The image listing ID.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="listingName")
    def listing_name(self) -> str:
        """
        The listing name associated with the product license.
        """
        return pulumi.get(self, "listing_name")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> str:
        """
        The image package version.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class GetProductLicensesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetProductLicensesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProductLicensesProductLicenseCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProductLicensesProductLicenseCollectionItemResult']):
        GetProductLicensesProductLicenseCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProductLicensesProductLicenseCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProductLicensesProductLicenseCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProductLicensesProductLicenseCollectionItemResult(dict):
    def __init__(__self__, *,
                 active_license_record_count: int,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 images: Sequence['outputs.GetProductLicensesProductLicenseCollectionItemImageResult'],
                 is_over_subscribed: bool,
                 is_unlimited: bool,
                 is_vendor_oracle: bool,
                 license_unit: str,
                 state: str,
                 status: str,
                 status_description: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 total_active_license_unit_count: int,
                 total_license_record_count: int,
                 total_license_units_consumed: float,
                 vendor_name: str):
        """
        :param int active_license_record_count: The number of active license records associated with the product license.
        :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: License record name
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The image ID associated with the product license.
        :param Sequence['GetProductLicensesProductLicenseCollectionItemImageArgs'] images: The images associated with the product license.
        :param bool is_over_subscribed: Specifies whether or not the product license is oversubscribed.
        :param bool is_unlimited: Specifies if the license unit count is unlimited.
        :param bool is_vendor_oracle: Specifies whether the vendor is Oracle or a third party.
        :param str license_unit: The product license unit.
        :param str state: The current product license state.
        :param str status: The current product license status.
        :param str status_description: Status description for the current product license status.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param str time_updated: The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param int total_active_license_unit_count: The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        :param int total_license_record_count: The number of license records associated with the product license.
        :param float total_license_units_consumed: The number of license units consumed. Updated after each allocation run.
        :param str vendor_name: The vendor of the ProductLicense
        """
        GetProductLicensesProductLicenseCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            active_license_record_count=active_license_record_count,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            images=images,
            is_over_subscribed=is_over_subscribed,
            is_unlimited=is_unlimited,
            is_vendor_oracle=is_vendor_oracle,
            license_unit=license_unit,
            state=state,
            status=status,
            status_description=status_description,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            total_active_license_unit_count=total_active_license_unit_count,
            total_license_record_count=total_license_record_count,
            total_license_units_consumed=total_license_units_consumed,
            vendor_name=vendor_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             active_license_record_count: int,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             images: Sequence['outputs.GetProductLicensesProductLicenseCollectionItemImageResult'],
             is_over_subscribed: bool,
             is_unlimited: bool,
             is_vendor_oracle: bool,
             license_unit: str,
             state: str,
             status: str,
             status_description: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             total_active_license_unit_count: int,
             total_license_record_count: int,
             total_license_units_consumed: float,
             vendor_name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'activeLicenseRecordCount' in kwargs:
            active_license_record_count = kwargs['activeLicenseRecordCount']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isOverSubscribed' in kwargs:
            is_over_subscribed = kwargs['isOverSubscribed']
        if 'isUnlimited' in kwargs:
            is_unlimited = kwargs['isUnlimited']
        if 'isVendorOracle' in kwargs:
            is_vendor_oracle = kwargs['isVendorOracle']
        if 'licenseUnit' in kwargs:
            license_unit = kwargs['licenseUnit']
        if 'statusDescription' in kwargs:
            status_description = kwargs['statusDescription']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'totalActiveLicenseUnitCount' in kwargs:
            total_active_license_unit_count = kwargs['totalActiveLicenseUnitCount']
        if 'totalLicenseRecordCount' in kwargs:
            total_license_record_count = kwargs['totalLicenseRecordCount']
        if 'totalLicenseUnitsConsumed' in kwargs:
            total_license_units_consumed = kwargs['totalLicenseUnitsConsumed']
        if 'vendorName' in kwargs:
            vendor_name = kwargs['vendorName']

        _setter("active_license_record_count", active_license_record_count)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("images", images)
        _setter("is_over_subscribed", is_over_subscribed)
        _setter("is_unlimited", is_unlimited)
        _setter("is_vendor_oracle", is_vendor_oracle)
        _setter("license_unit", license_unit)
        _setter("state", state)
        _setter("status", status)
        _setter("status_description", status_description)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("total_active_license_unit_count", total_active_license_unit_count)
        _setter("total_license_record_count", total_license_record_count)
        _setter("total_license_units_consumed", total_license_units_consumed)
        _setter("vendor_name", vendor_name)

    @property
    @pulumi.getter(name="activeLicenseRecordCount")
    def active_license_record_count(self) -> int:
        """
        The number of active license records associated with the product license.
        """
        return pulumi.get(self, "active_license_record_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        License record name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetProductLicensesProductLicenseCollectionItemImageResult']:
        """
        The images associated with the product license.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="isOverSubscribed")
    def is_over_subscribed(self) -> bool:
        """
        Specifies whether or not the product license is oversubscribed.
        """
        return pulumi.get(self, "is_over_subscribed")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> bool:
        """
        Specifies if the license unit count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="isVendorOracle")
    def is_vendor_oracle(self) -> bool:
        """
        Specifies whether the vendor is Oracle or a third party.
        """
        return pulumi.get(self, "is_vendor_oracle")

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> str:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current product license state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current product license status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDescription")
    def status_description(self) -> str:
        """
        Status description for the current product license status.
        """
        return pulumi.get(self, "status_description")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalActiveLicenseUnitCount")
    def total_active_license_unit_count(self) -> int:
        """
        The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        """
        return pulumi.get(self, "total_active_license_unit_count")

    @property
    @pulumi.getter(name="totalLicenseRecordCount")
    def total_license_record_count(self) -> int:
        """
        The number of license records associated with the product license.
        """
        return pulumi.get(self, "total_license_record_count")

    @property
    @pulumi.getter(name="totalLicenseUnitsConsumed")
    def total_license_units_consumed(self) -> float:
        """
        The number of license units consumed. Updated after each allocation run.
        """
        return pulumi.get(self, "total_license_units_consumed")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> str:
        """
        The vendor of the ProductLicense
        """
        return pulumi.get(self, "vendor_name")


@pulumi.output_type
class GetProductLicensesProductLicenseCollectionItemImageResult(dict):
    def __init__(__self__, *,
                 id: str,
                 listing_id: str,
                 listing_name: str,
                 package_version: str,
                 publisher: str):
        """
        :param str id: The image ID associated with the product license.
        :param str listing_id: The image listing ID.
        :param str listing_name: The listing name associated with the product license.
        :param str package_version: The image package version.
        :param str publisher: The image publisher.
        """
        GetProductLicensesProductLicenseCollectionItemImageResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            listing_id=listing_id,
            listing_name=listing_name,
            package_version=package_version,
            publisher=publisher,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: str,
             listing_id: str,
             listing_name: str,
             package_version: str,
             publisher: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'listingId' in kwargs:
            listing_id = kwargs['listingId']
        if 'listingName' in kwargs:
            listing_name = kwargs['listingName']
        if 'packageVersion' in kwargs:
            package_version = kwargs['packageVersion']

        _setter("id", id)
        _setter("listing_id", listing_id)
        _setter("listing_name", listing_name)
        _setter("package_version", package_version)
        _setter("publisher", publisher)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> str:
        """
        The image listing ID.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="listingName")
    def listing_name(self) -> str:
        """
        The listing name associated with the product license.
        """
        return pulumi.get(self, "listing_name")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> str:
        """
        The image package version.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class GetTopUtilizedProductLicensesItemResult(dict):
    def __init__(__self__, *,
                 is_unlimited: bool,
                 product_license_id: str,
                 product_type: str,
                 status: str,
                 total_license_unit_count: int,
                 total_units_consumed: float,
                 unit_type: str):
        """
        :param bool is_unlimited: Specifies if the license unit count is unlimited.
        :param str product_license_id: The product license [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str product_type: The product type.
        :param str status: The current product license status.
        :param int total_license_unit_count: Total number of license units in the product license provided by the user.
        :param float total_units_consumed: Number of license units consumed.
        :param str unit_type: The product license unit.
        """
        GetTopUtilizedProductLicensesItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_unlimited=is_unlimited,
            product_license_id=product_license_id,
            product_type=product_type,
            status=status,
            total_license_unit_count=total_license_unit_count,
            total_units_consumed=total_units_consumed,
            unit_type=unit_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_unlimited: bool,
             product_license_id: str,
             product_type: str,
             status: str,
             total_license_unit_count: int,
             total_units_consumed: float,
             unit_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isUnlimited' in kwargs:
            is_unlimited = kwargs['isUnlimited']
        if 'productLicenseId' in kwargs:
            product_license_id = kwargs['productLicenseId']
        if 'productType' in kwargs:
            product_type = kwargs['productType']
        if 'totalLicenseUnitCount' in kwargs:
            total_license_unit_count = kwargs['totalLicenseUnitCount']
        if 'totalUnitsConsumed' in kwargs:
            total_units_consumed = kwargs['totalUnitsConsumed']
        if 'unitType' in kwargs:
            unit_type = kwargs['unitType']

        _setter("is_unlimited", is_unlimited)
        _setter("product_license_id", product_license_id)
        _setter("product_type", product_type)
        _setter("status", status)
        _setter("total_license_unit_count", total_license_unit_count)
        _setter("total_units_consumed", total_units_consumed)
        _setter("unit_type", unit_type)

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> bool:
        """
        Specifies if the license unit count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> str:
        """
        The product license [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "product_license_id")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> str:
        """
        The product type.
        """
        return pulumi.get(self, "product_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current product license status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalLicenseUnitCount")
    def total_license_unit_count(self) -> int:
        """
        Total number of license units in the product license provided by the user.
        """
        return pulumi.get(self, "total_license_unit_count")

    @property
    @pulumi.getter(name="totalUnitsConsumed")
    def total_units_consumed(self) -> float:
        """
        Number of license units consumed.
        """
        return pulumi.get(self, "total_units_consumed")

    @property
    @pulumi.getter(name="unitType")
    def unit_type(self) -> str:
        """
        The product license unit.
        """
        return pulumi.get(self, "unit_type")


@pulumi.output_type
class GetTopUtilizedResourcesItemResult(dict):
    def __init__(__self__, *,
                 resource_compartment_id: str,
                 resource_compartment_name: str,
                 resource_id: str,
                 resource_name: str,
                 total_units: float,
                 unit_type: str):
        """
        :param str resource_compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that contains the resource.
        :param str resource_compartment_name: The display name of the compartment that contains the resource.
        :param str resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        :param str resource_name: Resource canonical name.
        :param float total_units: Number of license units consumed by the resource.
        :param str unit_type: The resource unit.
        """
        GetTopUtilizedResourcesItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            resource_compartment_id=resource_compartment_id,
            resource_compartment_name=resource_compartment_name,
            resource_id=resource_id,
            resource_name=resource_name,
            total_units=total_units,
            unit_type=unit_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             resource_compartment_id: str,
             resource_compartment_name: str,
             resource_id: str,
             resource_name: str,
             total_units: float,
             unit_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'resourceCompartmentId' in kwargs:
            resource_compartment_id = kwargs['resourceCompartmentId']
        if 'resourceCompartmentName' in kwargs:
            resource_compartment_name = kwargs['resourceCompartmentName']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceName' in kwargs:
            resource_name = kwargs['resourceName']
        if 'totalUnits' in kwargs:
            total_units = kwargs['totalUnits']
        if 'unitType' in kwargs:
            unit_type = kwargs['unitType']

        _setter("resource_compartment_id", resource_compartment_id)
        _setter("resource_compartment_name", resource_compartment_name)
        _setter("resource_id", resource_id)
        _setter("resource_name", resource_name)
        _setter("total_units", total_units)
        _setter("unit_type", unit_type)

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that contains the resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceCompartmentName")
    def resource_compartment_name(self) -> str:
        """
        The display name of the compartment that contains the resource.
        """
        return pulumi.get(self, "resource_compartment_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        Resource canonical name.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="totalUnits")
    def total_units(self) -> float:
        """
        Number of license units consumed by the resource.
        """
        return pulumi.get(self, "total_units")

    @property
    @pulumi.getter(name="unitType")
    def unit_type(self) -> str:
        """
        The resource unit.
        """
        return pulumi.get(self, "unit_type")


