# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogAnalyticsEntityTopologyResult',
    'AwaitableGetLogAnalyticsEntityTopologyResult',
    'get_log_analytics_entity_topology',
    'get_log_analytics_entity_topology_output',
]

@pulumi.output_type
class GetLogAnalyticsEntityTopologyResult:
    """
    A collection of values returned by getLogAnalyticsEntityTopology.
    """
    def __init__(__self__, id=None, items=None, log_analytics_entity_id=None, namespace=None, state=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if log_analytics_entity_id and not isinstance(log_analytics_entity_id, str):
            raise TypeError("Expected argument 'log_analytics_entity_id' to be a str")
        pulumi.set(__self__, "log_analytics_entity_id", log_analytics_entity_id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLogAnalyticsEntityTopologyItemResult']:
        """
        Array of log analytics entity summary.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="logAnalyticsEntityId")
    def log_analytics_entity_id(self) -> str:
        return pulumi.get(self, "log_analytics_entity_id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the log analytics entity.
        """
        return pulumi.get(self, "state")


class AwaitableGetLogAnalyticsEntityTopologyResult(GetLogAnalyticsEntityTopologyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsEntityTopologyResult(
            id=self.id,
            items=self.items,
            log_analytics_entity_id=self.log_analytics_entity_id,
            namespace=self.namespace,
            state=self.state)


def get_log_analytics_entity_topology(log_analytics_entity_id: Optional[str] = None,
                                      namespace: Optional[str] = None,
                                      state: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsEntityTopologyResult:
    """
    This data source provides details about a specific Log Analytics Entity Topology resource in Oracle Cloud Infrastructure Log Analytics service.

    Return a log analytics entity topology collection that contains a set of log analytics entities and a set of relationships between those, for the input source entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity_topology = oci.LogAnalytics.get_log_analytics_entity_topology(log_analytics_entity_id=oci_log_analytics_log_analytics_entity["test_log_analytics_entity"]["id"],
        namespace=var["log_analytics_entity_topology_namespace"],
        state=var["log_analytics_entity_topology_state"])
    ```


    :param str log_analytics_entity_id: The log analytics entity OCID.
    :param str namespace: The Logging Analytics namespace used for the request.
    :param str state: A filter to return only those log analytics entities with the specified lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['logAnalyticsEntityId'] = log_analytics_entity_id
    __args__['namespace'] = namespace
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsEntityTopology:getLogAnalyticsEntityTopology', __args__, opts=opts, typ=GetLogAnalyticsEntityTopologyResult).value

    return AwaitableGetLogAnalyticsEntityTopologyResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        log_analytics_entity_id=pulumi.get(__ret__, 'log_analytics_entity_id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_log_analytics_entity_topology)
def get_log_analytics_entity_topology_output(log_analytics_entity_id: Optional[pulumi.Input[str]] = None,
                                             namespace: Optional[pulumi.Input[str]] = None,
                                             state: Optional[pulumi.Input[Optional[str]]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogAnalyticsEntityTopologyResult]:
    """
    This data source provides details about a specific Log Analytics Entity Topology resource in Oracle Cloud Infrastructure Log Analytics service.

    Return a log analytics entity topology collection that contains a set of log analytics entities and a set of relationships between those, for the input source entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity_topology = oci.LogAnalytics.get_log_analytics_entity_topology(log_analytics_entity_id=oci_log_analytics_log_analytics_entity["test_log_analytics_entity"]["id"],
        namespace=var["log_analytics_entity_topology_namespace"],
        state=var["log_analytics_entity_topology_state"])
    ```


    :param str log_analytics_entity_id: The log analytics entity OCID.
    :param str namespace: The Logging Analytics namespace used for the request.
    :param str state: A filter to return only those log analytics entities with the specified lifecycle state. The state value is case-insensitive.
    """
    ...
