# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogAnalyticsImportCustomContentArgs', 'LogAnalyticsImportCustomContent']

@pulumi.input_type
class LogAnalyticsImportCustomContentArgs:
    def __init__(__self__, *,
                 import_custom_content_file: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 expect: Optional[pulumi.Input[str]] = None,
                 is_overwrite: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a LogAnalyticsImportCustomContent resource.
        :param pulumi.Input[str] import_custom_content_file: Path to the file to upload which contains the custom content.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[str] expect: A value of `100-continue` requests preliminary verification of the request method, path, and headers before the request body is sent. If no error results from such verification, the server will send a 100 (Continue) interim response to indicate readiness for the request body. The only allowed value for this parameter is "100-Continue" (case-insensitive).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[bool] is_overwrite: A flag indicating whether or not to overwrite existing content if a conflict is found during import content operation.
        """
        LogAnalyticsImportCustomContentArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            import_custom_content_file=import_custom_content_file,
            namespace=namespace,
            expect=expect,
            is_overwrite=is_overwrite,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             import_custom_content_file: pulumi.Input[str],
             namespace: pulumi.Input[str],
             expect: Optional[pulumi.Input[str]] = None,
             is_overwrite: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'importCustomContentFile' in kwargs:
            import_custom_content_file = kwargs['importCustomContentFile']
        if 'isOverwrite' in kwargs:
            is_overwrite = kwargs['isOverwrite']

        _setter("import_custom_content_file", import_custom_content_file)
        _setter("namespace", namespace)
        if expect is not None:
            _setter("expect", expect)
        if is_overwrite is not None:
            _setter("is_overwrite", is_overwrite)

    @property
    @pulumi.getter(name="importCustomContentFile")
    def import_custom_content_file(self) -> pulumi.Input[str]:
        """
        Path to the file to upload which contains the custom content.
        """
        return pulumi.get(self, "import_custom_content_file")

    @import_custom_content_file.setter
    def import_custom_content_file(self, value: pulumi.Input[str]):
        pulumi.set(self, "import_custom_content_file", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def expect(self) -> Optional[pulumi.Input[str]]:
        """
        A value of `100-continue` requests preliminary verification of the request method, path, and headers before the request body is sent. If no error results from such verification, the server will send a 100 (Continue) interim response to indicate readiness for the request body. The only allowed value for this parameter is "100-Continue" (case-insensitive).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "expect")

    @expect.setter
    def expect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expect", value)

    @property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether or not to overwrite existing content if a conflict is found during import content operation.
        """
        return pulumi.get(self, "is_overwrite")

    @is_overwrite.setter
    def is_overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_overwrite", value)


@pulumi.input_type
class _LogAnalyticsImportCustomContentState:
    def __init__(__self__, *,
                 change_lists: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsImportCustomContentChangeListArgs']]]] = None,
                 content_name: Optional[pulumi.Input[str]] = None,
                 expect: Optional[pulumi.Input[str]] = None,
                 field_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 import_custom_content_file: Optional[pulumi.Input[str]] = None,
                 is_overwrite: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 parser_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering LogAnalyticsImportCustomContent resources.
        :param pulumi.Input[Sequence[pulumi.Input['LogAnalyticsImportCustomContentChangeListArgs']]] change_lists: LogAnalyticsImportCustomChangeList
        :param pulumi.Input[str] content_name: The content name.
        :param pulumi.Input[str] expect: A value of `100-continue` requests preliminary verification of the request method, path, and headers before the request body is sent. If no error results from such verification, the server will send a 100 (Continue) interim response to indicate readiness for the request body. The only allowed value for this parameter is "100-Continue" (case-insensitive).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_names: The field names.
        :param pulumi.Input[str] import_custom_content_file: Path to the file to upload which contains the custom content.
        :param pulumi.Input[bool] is_overwrite: A flag indicating whether or not to overwrite existing content if a conflict is found during import content operation.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parser_names: The parser names.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_names: The source names.
        """
        _LogAnalyticsImportCustomContentState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            change_lists=change_lists,
            content_name=content_name,
            expect=expect,
            field_names=field_names,
            import_custom_content_file=import_custom_content_file,
            is_overwrite=is_overwrite,
            namespace=namespace,
            parser_names=parser_names,
            source_names=source_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             change_lists: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsImportCustomContentChangeListArgs']]]] = None,
             content_name: Optional[pulumi.Input[str]] = None,
             expect: Optional[pulumi.Input[str]] = None,
             field_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             import_custom_content_file: Optional[pulumi.Input[str]] = None,
             is_overwrite: Optional[pulumi.Input[bool]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             parser_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             source_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'changeLists' in kwargs:
            change_lists = kwargs['changeLists']
        if 'contentName' in kwargs:
            content_name = kwargs['contentName']
        if 'fieldNames' in kwargs:
            field_names = kwargs['fieldNames']
        if 'importCustomContentFile' in kwargs:
            import_custom_content_file = kwargs['importCustomContentFile']
        if 'isOverwrite' in kwargs:
            is_overwrite = kwargs['isOverwrite']
        if 'parserNames' in kwargs:
            parser_names = kwargs['parserNames']
        if 'sourceNames' in kwargs:
            source_names = kwargs['sourceNames']

        if change_lists is not None:
            _setter("change_lists", change_lists)
        if content_name is not None:
            _setter("content_name", content_name)
        if expect is not None:
            _setter("expect", expect)
        if field_names is not None:
            _setter("field_names", field_names)
        if import_custom_content_file is not None:
            _setter("import_custom_content_file", import_custom_content_file)
        if is_overwrite is not None:
            _setter("is_overwrite", is_overwrite)
        if namespace is not None:
            _setter("namespace", namespace)
        if parser_names is not None:
            _setter("parser_names", parser_names)
        if source_names is not None:
            _setter("source_names", source_names)

    @property
    @pulumi.getter(name="changeLists")
    def change_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsImportCustomContentChangeListArgs']]]]:
        """
        LogAnalyticsImportCustomChangeList
        """
        return pulumi.get(self, "change_lists")

    @change_lists.setter
    def change_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsImportCustomContentChangeListArgs']]]]):
        pulumi.set(self, "change_lists", value)

    @property
    @pulumi.getter(name="contentName")
    def content_name(self) -> Optional[pulumi.Input[str]]:
        """
        The content name.
        """
        return pulumi.get(self, "content_name")

    @content_name.setter
    def content_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_name", value)

    @property
    @pulumi.getter
    def expect(self) -> Optional[pulumi.Input[str]]:
        """
        A value of `100-continue` requests preliminary verification of the request method, path, and headers before the request body is sent. If no error results from such verification, the server will send a 100 (Continue) interim response to indicate readiness for the request body. The only allowed value for this parameter is "100-Continue" (case-insensitive).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "expect")

    @expect.setter
    def expect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expect", value)

    @property
    @pulumi.getter(name="fieldNames")
    def field_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The field names.
        """
        return pulumi.get(self, "field_names")

    @field_names.setter
    def field_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "field_names", value)

    @property
    @pulumi.getter(name="importCustomContentFile")
    def import_custom_content_file(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the file to upload which contains the custom content.
        """
        return pulumi.get(self, "import_custom_content_file")

    @import_custom_content_file.setter
    def import_custom_content_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_custom_content_file", value)

    @property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether or not to overwrite existing content if a conflict is found during import content operation.
        """
        return pulumi.get(self, "is_overwrite")

    @is_overwrite.setter
    def is_overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_overwrite", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="parserNames")
    def parser_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The parser names.
        """
        return pulumi.get(self, "parser_names")

    @parser_names.setter
    def parser_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "parser_names", value)

    @property
    @pulumi.getter(name="sourceNames")
    def source_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The source names.
        """
        return pulumi.get(self, "source_names")

    @source_names.setter
    def source_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_names", value)


class LogAnalyticsImportCustomContent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expect: Optional[pulumi.Input[str]] = None,
                 import_custom_content_file: Optional[pulumi.Input[str]] = None,
                 is_overwrite: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Log Analytics Import Custom Content resource in Oracle Cloud Infrastructure Log Analytics service.

        Imports the specified custom content from the input in zip format.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_import_custom_content = oci.log_analytics.LogAnalyticsImportCustomContent("testLogAnalyticsImportCustomContent",
            import_custom_content_file=var["log_analytics_import_custom_content_import_custom_content_file"],
            namespace=var["log_analytics_import_custom_content_namespace"],
            expect=var["log_analytics_import_custom_content_expect"],
            is_overwrite=var["log_analytics_import_custom_content_is_overwrite"])
        ```

        ## Import

        Import is not supported for LogAnalyticsImportCustomContent

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expect: A value of `100-continue` requests preliminary verification of the request method, path, and headers before the request body is sent. If no error results from such verification, the server will send a 100 (Continue) interim response to indicate readiness for the request body. The only allowed value for this parameter is "100-Continue" (case-insensitive).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] import_custom_content_file: Path to the file to upload which contains the custom content.
        :param pulumi.Input[bool] is_overwrite: A flag indicating whether or not to overwrite existing content if a conflict is found during import content operation.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogAnalyticsImportCustomContentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Log Analytics Import Custom Content resource in Oracle Cloud Infrastructure Log Analytics service.

        Imports the specified custom content from the input in zip format.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_import_custom_content = oci.log_analytics.LogAnalyticsImportCustomContent("testLogAnalyticsImportCustomContent",
            import_custom_content_file=var["log_analytics_import_custom_content_import_custom_content_file"],
            namespace=var["log_analytics_import_custom_content_namespace"],
            expect=var["log_analytics_import_custom_content_expect"],
            is_overwrite=var["log_analytics_import_custom_content_is_overwrite"])
        ```

        ## Import

        Import is not supported for LogAnalyticsImportCustomContent

        :param str resource_name: The name of the resource.
        :param LogAnalyticsImportCustomContentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogAnalyticsImportCustomContentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            LogAnalyticsImportCustomContentArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expect: Optional[pulumi.Input[str]] = None,
                 import_custom_content_file: Optional[pulumi.Input[str]] = None,
                 is_overwrite: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogAnalyticsImportCustomContentArgs.__new__(LogAnalyticsImportCustomContentArgs)

            __props__.__dict__["expect"] = expect
            if import_custom_content_file is None and not opts.urn:
                raise TypeError("Missing required property 'import_custom_content_file'")
            __props__.__dict__["import_custom_content_file"] = import_custom_content_file
            __props__.__dict__["is_overwrite"] = is_overwrite
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["change_lists"] = None
            __props__.__dict__["content_name"] = None
            __props__.__dict__["field_names"] = None
            __props__.__dict__["parser_names"] = None
            __props__.__dict__["source_names"] = None
        super(LogAnalyticsImportCustomContent, __self__).__init__(
            'oci:LogAnalytics/logAnalyticsImportCustomContent:LogAnalyticsImportCustomContent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            change_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogAnalyticsImportCustomContentChangeListArgs']]]]] = None,
            content_name: Optional[pulumi.Input[str]] = None,
            expect: Optional[pulumi.Input[str]] = None,
            field_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            import_custom_content_file: Optional[pulumi.Input[str]] = None,
            is_overwrite: Optional[pulumi.Input[bool]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            parser_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            source_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'LogAnalyticsImportCustomContent':
        """
        Get an existing LogAnalyticsImportCustomContent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogAnalyticsImportCustomContentChangeListArgs']]]] change_lists: LogAnalyticsImportCustomChangeList
        :param pulumi.Input[str] content_name: The content name.
        :param pulumi.Input[str] expect: A value of `100-continue` requests preliminary verification of the request method, path, and headers before the request body is sent. If no error results from such verification, the server will send a 100 (Continue) interim response to indicate readiness for the request body. The only allowed value for this parameter is "100-Continue" (case-insensitive).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_names: The field names.
        :param pulumi.Input[str] import_custom_content_file: Path to the file to upload which contains the custom content.
        :param pulumi.Input[bool] is_overwrite: A flag indicating whether or not to overwrite existing content if a conflict is found during import content operation.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parser_names: The parser names.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_names: The source names.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogAnalyticsImportCustomContentState.__new__(_LogAnalyticsImportCustomContentState)

        __props__.__dict__["change_lists"] = change_lists
        __props__.__dict__["content_name"] = content_name
        __props__.__dict__["expect"] = expect
        __props__.__dict__["field_names"] = field_names
        __props__.__dict__["import_custom_content_file"] = import_custom_content_file
        __props__.__dict__["is_overwrite"] = is_overwrite
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["parser_names"] = parser_names
        __props__.__dict__["source_names"] = source_names
        return LogAnalyticsImportCustomContent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="changeLists")
    def change_lists(self) -> pulumi.Output[Sequence['outputs.LogAnalyticsImportCustomContentChangeList']]:
        """
        LogAnalyticsImportCustomChangeList
        """
        return pulumi.get(self, "change_lists")

    @property
    @pulumi.getter(name="contentName")
    def content_name(self) -> pulumi.Output[str]:
        """
        The content name.
        """
        return pulumi.get(self, "content_name")

    @property
    @pulumi.getter
    def expect(self) -> pulumi.Output[str]:
        """
        A value of `100-continue` requests preliminary verification of the request method, path, and headers before the request body is sent. If no error results from such verification, the server will send a 100 (Continue) interim response to indicate readiness for the request body. The only allowed value for this parameter is "100-Continue" (case-insensitive).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "expect")

    @property
    @pulumi.getter(name="fieldNames")
    def field_names(self) -> pulumi.Output[Sequence[str]]:
        """
        The field names.
        """
        return pulumi.get(self, "field_names")

    @property
    @pulumi.getter(name="importCustomContentFile")
    def import_custom_content_file(self) -> pulumi.Output[str]:
        """
        Path to the file to upload which contains the custom content.
        """
        return pulumi.get(self, "import_custom_content_file")

    @property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> pulumi.Output[bool]:
        """
        A flag indicating whether or not to overwrite existing content if a conflict is found during import content operation.
        """
        return pulumi.get(self, "is_overwrite")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="parserNames")
    def parser_names(self) -> pulumi.Output[Sequence[str]]:
        """
        The parser names.
        """
        return pulumi.get(self, "parser_names")

    @property
    @pulumi.getter(name="sourceNames")
    def source_names(self) -> pulumi.Output[Sequence[str]]:
        """
        The source names.
        """
        return pulumi.get(self, "source_names")

