# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamCdnConfigArgs', 'StreamCdnConfig']

@pulumi.input_type
class StreamCdnConfigArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['StreamCdnConfigConfigArgs'],
                 display_name: pulumi.Input[str],
                 distribution_channel_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a StreamCdnConfig resource.
        :param pulumi.Input['StreamCdnConfigConfigArgs'] config: (Updatable) Base fields of the StreamCdnConfig configuration object.
        :param pulumi.Input[str] display_name: (Updatable) CDN Config display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[str] distribution_channel_id: Distribution Channel Identifier.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether publishing to CDN is enabled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        StreamCdnConfigArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            config=config,
            display_name=display_name,
            distribution_channel_id=distribution_channel_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            is_enabled=is_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             config: pulumi.Input['StreamCdnConfigConfigArgs'],
             display_name: pulumi.Input[str],
             distribution_channel_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_enabled: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'distributionChannelId' in kwargs:
            distribution_channel_id = kwargs['distributionChannelId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']

        _setter("config", config)
        _setter("display_name", display_name)
        _setter("distribution_channel_id", distribution_channel_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_enabled is not None:
            _setter("is_enabled", is_enabled)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['StreamCdnConfigConfigArgs']:
        """
        (Updatable) Base fields of the StreamCdnConfig configuration object.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['StreamCdnConfigConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) CDN Config display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="distributionChannelId")
    def distribution_channel_id(self) -> pulumi.Input[str]:
        """
        Distribution Channel Identifier.
        """
        return pulumi.get(self, "distribution_channel_id")

    @distribution_channel_id.setter
    def distribution_channel_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution_channel_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether publishing to CDN is enabled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)


@pulumi.input_type
class _StreamCdnConfigState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input['StreamCdnConfigConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 distribution_channel_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 lifecyle_details: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StreamCdnConfig resources.
        :param pulumi.Input[str] compartment_id: Compartment Identifier.
        :param pulumi.Input['StreamCdnConfigConfigArgs'] config: (Updatable) Base fields of the StreamCdnConfig configuration object.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) CDN Config display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[str] distribution_channel_id: Distribution Channel Identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether publishing to CDN is enabled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] state: The current state of the CDN Configuration.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time when the CDN Config was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the CDN Config was updated. An RFC3339 formatted datetime string.
        """
        _StreamCdnConfigState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            config=config,
            defined_tags=defined_tags,
            display_name=display_name,
            distribution_channel_id=distribution_channel_id,
            freeform_tags=freeform_tags,
            is_enabled=is_enabled,
            lifecyle_details=lifecyle_details,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             config: Optional[pulumi.Input['StreamCdnConfigConfigArgs']] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             distribution_channel_id: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_enabled: Optional[pulumi.Input[bool]] = None,
             lifecyle_details: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'distributionChannelId' in kwargs:
            distribution_channel_id = kwargs['distributionChannelId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']
        if 'lifecyleDetails' in kwargs:
            lifecyle_details = kwargs['lifecyleDetails']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if config is not None:
            _setter("config", config)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if distribution_channel_id is not None:
            _setter("distribution_channel_id", distribution_channel_id)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_enabled is not None:
            _setter("is_enabled", is_enabled)
        if lifecyle_details is not None:
            _setter("lifecyle_details", lifecyle_details)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['StreamCdnConfigConfigArgs']]:
        """
        (Updatable) Base fields of the StreamCdnConfig configuration object.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['StreamCdnConfigConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) CDN Config display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="distributionChannelId")
    def distribution_channel_id(self) -> Optional[pulumi.Input[str]]:
        """
        Distribution Channel Identifier.
        """
        return pulumi.get(self, "distribution_channel_id")

    @distribution_channel_id.setter
    def distribution_channel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distribution_channel_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether publishing to CDN is enabled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @lifecyle_details.setter
    def lifecyle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecyle_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the CDN Configuration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the CDN Config was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the CDN Config was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class StreamCdnConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['StreamCdnConfigConfigArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 distribution_channel_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Stream Cdn Config resource in Oracle Cloud Infrastructure Media Services service.

        Creates a new CDN Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stream_cdn_config = oci.media_services.StreamCdnConfig("testStreamCdnConfig",
            config=oci.media_services.StreamCdnConfigConfigArgs(
                type=var["stream_cdn_config_config_type"],
                edge_hostname=var["stream_cdn_config_config_edge_hostname"],
                edge_path_prefix=var["stream_cdn_config_config_edge_path_prefix"],
                edge_token_key=var["stream_cdn_config_config_edge_token_key"],
                edge_token_salt=var["stream_cdn_config_config_edge_token_salt"],
                is_edge_token_auth=var["stream_cdn_config_config_is_edge_token_auth"],
                origin_auth_secret_key_a=var["stream_cdn_config_config_origin_auth_secret_key_a"],
                origin_auth_secret_key_b=var["stream_cdn_config_config_origin_auth_secret_key_b"],
                origin_auth_secret_key_nonce_a=var["stream_cdn_config_config_origin_auth_secret_key_nonce_a"],
                origin_auth_secret_key_nonce_b=var["stream_cdn_config_config_origin_auth_secret_key_nonce_b"],
                origin_auth_sign_encryption=var["stream_cdn_config_config_origin_auth_sign_encryption"],
                origin_auth_sign_type=var["stream_cdn_config_config_origin_auth_sign_type"],
            ),
            display_name=var["stream_cdn_config_display_name"],
            distribution_channel_id=oci_mysql_channel["test_channel"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_enabled=var["stream_cdn_config_is_enabled"])
        ```

        ## Import

        StreamCdnConfigs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:MediaServices/streamCdnConfig:StreamCdnConfig test_stream_cdn_config "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['StreamCdnConfigConfigArgs']] config: (Updatable) Base fields of the StreamCdnConfig configuration object.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) CDN Config display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[str] distribution_channel_id: Distribution Channel Identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether publishing to CDN is enabled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamCdnConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Stream Cdn Config resource in Oracle Cloud Infrastructure Media Services service.

        Creates a new CDN Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stream_cdn_config = oci.media_services.StreamCdnConfig("testStreamCdnConfig",
            config=oci.media_services.StreamCdnConfigConfigArgs(
                type=var["stream_cdn_config_config_type"],
                edge_hostname=var["stream_cdn_config_config_edge_hostname"],
                edge_path_prefix=var["stream_cdn_config_config_edge_path_prefix"],
                edge_token_key=var["stream_cdn_config_config_edge_token_key"],
                edge_token_salt=var["stream_cdn_config_config_edge_token_salt"],
                is_edge_token_auth=var["stream_cdn_config_config_is_edge_token_auth"],
                origin_auth_secret_key_a=var["stream_cdn_config_config_origin_auth_secret_key_a"],
                origin_auth_secret_key_b=var["stream_cdn_config_config_origin_auth_secret_key_b"],
                origin_auth_secret_key_nonce_a=var["stream_cdn_config_config_origin_auth_secret_key_nonce_a"],
                origin_auth_secret_key_nonce_b=var["stream_cdn_config_config_origin_auth_secret_key_nonce_b"],
                origin_auth_sign_encryption=var["stream_cdn_config_config_origin_auth_sign_encryption"],
                origin_auth_sign_type=var["stream_cdn_config_config_origin_auth_sign_type"],
            ),
            display_name=var["stream_cdn_config_display_name"],
            distribution_channel_id=oci_mysql_channel["test_channel"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_enabled=var["stream_cdn_config_is_enabled"])
        ```

        ## Import

        StreamCdnConfigs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:MediaServices/streamCdnConfig:StreamCdnConfig test_stream_cdn_config "id"
        ```

        :param str resource_name: The name of the resource.
        :param StreamCdnConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamCdnConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            StreamCdnConfigArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['StreamCdnConfigConfigArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 distribution_channel_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamCdnConfigArgs.__new__(StreamCdnConfigArgs)

            if config is not None and not isinstance(config, StreamCdnConfigConfigArgs):
                config = config or {}
                def _setter(key, value):
                    config[key] = value
                StreamCdnConfigConfigArgs._configure(_setter, **config)
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if distribution_channel_id is None and not opts.urn:
                raise TypeError("Missing required property 'distribution_channel_id'")
            __props__.__dict__["distribution_channel_id"] = distribution_channel_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["lifecyle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(StreamCdnConfig, __self__).__init__(
            'oci:MediaServices/streamCdnConfig:StreamCdnConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            config: Optional[pulumi.Input[pulumi.InputType['StreamCdnConfigConfigArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            distribution_channel_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            lifecyle_details: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'StreamCdnConfig':
        """
        Get an existing StreamCdnConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: Compartment Identifier.
        :param pulumi.Input[pulumi.InputType['StreamCdnConfigConfigArgs']] config: (Updatable) Base fields of the StreamCdnConfig configuration object.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) CDN Config display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[str] distribution_channel_id: Distribution Channel Identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether publishing to CDN is enabled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] state: The current state of the CDN Configuration.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time when the CDN Config was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the CDN Config was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamCdnConfigState.__new__(_StreamCdnConfigState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config"] = config
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["distribution_channel_id"] = distribution_channel_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["lifecyle_details"] = lifecyle_details
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return StreamCdnConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.StreamCdnConfigConfig']:
        """
        (Updatable) Base fields of the StreamCdnConfig configuration object.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) CDN Config display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="distributionChannelId")
    def distribution_channel_id(self) -> pulumi.Output[str]:
        """
        Distribution Channel Identifier.
        """
        return pulumi.get(self, "distribution_channel_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether publishing to CDN is enabled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the CDN Configuration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the CDN Config was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when the CDN Config was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

