# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'CustomTableSavedCustomTableArgs',
    'CustomTableSavedCustomTableGroupByTagArgs',
    'QueryQueryDefinitionArgs',
    'QueryQueryDefinitionCostAnalysisUiArgs',
    'QueryQueryDefinitionReportQueryArgs',
    'QueryQueryDefinitionReportQueryForecastArgs',
    'QueryQueryDefinitionReportQueryGroupByTagArgs',
    'ScheduleQueryPropertiesArgs',
    'ScheduleQueryPropertiesDateRangeArgs',
    'ScheduleQueryPropertiesGroupByTagArgs',
    'ScheduleResultLocationArgs',
    'UsageForecastArgs',
    'UsageGroupByTagArgs',
    'UsageItemArgs',
    'UsageItemTagArgs',
    'GetCustomTablesFilterArgs',
    'GetQueriesFilterArgs',
    'GetScheduledRunsFilterArgs',
    'GetSchedulesFilterArgs',
]

@pulumi.input_type
class CustomTableSavedCustomTableArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 column_group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_depth: Optional[pulumi.Input[float]] = None,
                 group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input['CustomTableSavedCustomTableGroupByTagArgs']]]] = None,
                 row_group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) The name of the custom table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] column_group_bies: (Updatable) The column groupBy key list. example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "tenantId", "tenantName"]`
        :param pulumi.Input[float] compartment_depth: (Updatable) The compartment depth level.
        :param pulumi.Input[Sequence[pulumi.Input['CustomTableSavedCustomTableGroupByTagArgs']]] group_by_tags: (Updatable) GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only one tag in the list is supported. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] row_group_bies: (Updatable) The row groupBy key list. example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "tenantId", "tenantName"]`
        :param pulumi.Input[float] version: (Updatable) The version of the custom table.
        """
        CustomTableSavedCustomTableArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            column_group_bies=column_group_bies,
            compartment_depth=compartment_depth,
            group_by_tags=group_by_tags,
            row_group_bies=row_group_bies,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: pulumi.Input[str],
             column_group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             compartment_depth: Optional[pulumi.Input[float]] = None,
             group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input['CustomTableSavedCustomTableGroupByTagArgs']]]] = None,
             row_group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             version: Optional[pulumi.Input[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'columnGroupBies' in kwargs:
            column_group_bies = kwargs['columnGroupBies']
        if 'compartmentDepth' in kwargs:
            compartment_depth = kwargs['compartmentDepth']
        if 'groupByTags' in kwargs:
            group_by_tags = kwargs['groupByTags']
        if 'rowGroupBies' in kwargs:
            row_group_bies = kwargs['rowGroupBies']

        _setter("display_name", display_name)
        if column_group_bies is not None:
            _setter("column_group_bies", column_group_bies)
        if compartment_depth is not None:
            _setter("compartment_depth", compartment_depth)
        if group_by_tags is not None:
            _setter("group_by_tags", group_by_tags)
        if row_group_bies is not None:
            _setter("row_group_bies", row_group_bies)
        if version is not None:
            _setter("version", version)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the custom table.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="columnGroupBies")
    def column_group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The column groupBy key list. example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "tenantId", "tenantName"]`
        """
        return pulumi.get(self, "column_group_bies")

    @column_group_bies.setter
    def column_group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "column_group_bies", value)

    @property
    @pulumi.getter(name="compartmentDepth")
    def compartment_depth(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The compartment depth level.
        """
        return pulumi.get(self, "compartment_depth")

    @compartment_depth.setter
    def compartment_depth(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "compartment_depth", value)

    @property
    @pulumi.getter(name="groupByTags")
    def group_by_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomTableSavedCustomTableGroupByTagArgs']]]]:
        """
        (Updatable) GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only one tag in the list is supported. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        """
        return pulumi.get(self, "group_by_tags")

    @group_by_tags.setter
    def group_by_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomTableSavedCustomTableGroupByTagArgs']]]]):
        pulumi.set(self, "group_by_tags", value)

    @property
    @pulumi.getter(name="rowGroupBies")
    def row_group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The row groupBy key list. example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "tenantId", "tenantName"]`
        """
        return pulumi.get(self, "row_group_bies")

    @row_group_bies.setter
    def row_group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "row_group_bies", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The version of the custom table.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class CustomTableSavedCustomTableGroupByTagArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) The tag key.
        :param pulumi.Input[str] namespace: (Updatable) The tag namespace.
        :param pulumi.Input[str] value: (Updatable) The tag value.
        """
        CustomTableSavedCustomTableGroupByTagArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            namespace=namespace,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if key is not None:
            _setter("key", key)
        if namespace is not None:
            _setter("namespace", namespace)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The tag namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class QueryQueryDefinitionArgs:
    def __init__(__self__, *,
                 cost_analysis_ui: pulumi.Input['QueryQueryDefinitionCostAnalysisUiArgs'],
                 display_name: pulumi.Input[str],
                 report_query: pulumi.Input['QueryQueryDefinitionReportQueryArgs'],
                 version: pulumi.Input[float]):
        """
        :param pulumi.Input['QueryQueryDefinitionCostAnalysisUiArgs'] cost_analysis_ui: (Updatable) The common fields for Cost Analysis UI rendering.
        :param pulumi.Input[str] display_name: (Updatable) The query display name. Avoid entering confidential information.
        :param pulumi.Input['QueryQueryDefinitionReportQueryArgs'] report_query: (Updatable) The request of the generated Cost Analysis report.
        :param pulumi.Input[float] version: (Updatable) The saved query version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        QueryQueryDefinitionArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cost_analysis_ui=cost_analysis_ui,
            display_name=display_name,
            report_query=report_query,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cost_analysis_ui: pulumi.Input['QueryQueryDefinitionCostAnalysisUiArgs'],
             display_name: pulumi.Input[str],
             report_query: pulumi.Input['QueryQueryDefinitionReportQueryArgs'],
             version: pulumi.Input[float],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'costAnalysisUi' in kwargs:
            cost_analysis_ui = kwargs['costAnalysisUi']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'reportQuery' in kwargs:
            report_query = kwargs['reportQuery']

        _setter("cost_analysis_ui", cost_analysis_ui)
        _setter("display_name", display_name)
        _setter("report_query", report_query)
        _setter("version", version)

    @property
    @pulumi.getter(name="costAnalysisUi")
    def cost_analysis_ui(self) -> pulumi.Input['QueryQueryDefinitionCostAnalysisUiArgs']:
        """
        (Updatable) The common fields for Cost Analysis UI rendering.
        """
        return pulumi.get(self, "cost_analysis_ui")

    @cost_analysis_ui.setter
    def cost_analysis_ui(self, value: pulumi.Input['QueryQueryDefinitionCostAnalysisUiArgs']):
        pulumi.set(self, "cost_analysis_ui", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The query display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="reportQuery")
    def report_query(self) -> pulumi.Input['QueryQueryDefinitionReportQueryArgs']:
        """
        (Updatable) The request of the generated Cost Analysis report.
        """
        return pulumi.get(self, "report_query")

    @report_query.setter
    def report_query(self, value: pulumi.Input['QueryQueryDefinitionReportQueryArgs']):
        pulumi.set(self, "report_query", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[float]:
        """
        (Updatable) The saved query version.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[float]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class QueryQueryDefinitionCostAnalysisUiArgs:
    def __init__(__self__, *,
                 graph: Optional[pulumi.Input[str]] = None,
                 is_cumulative_graph: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] graph: (Updatable) The graph type.
        :param pulumi.Input[bool] is_cumulative_graph: (Updatable) A cumulative graph.
        """
        QueryQueryDefinitionCostAnalysisUiArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            graph=graph,
            is_cumulative_graph=is_cumulative_graph,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             graph: Optional[pulumi.Input[str]] = None,
             is_cumulative_graph: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isCumulativeGraph' in kwargs:
            is_cumulative_graph = kwargs['isCumulativeGraph']

        if graph is not None:
            _setter("graph", graph)
        if is_cumulative_graph is not None:
            _setter("is_cumulative_graph", is_cumulative_graph)

    @property
    @pulumi.getter
    def graph(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The graph type.
        """
        return pulumi.get(self, "graph")

    @graph.setter
    def graph(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graph", value)

    @property
    @pulumi.getter(name="isCumulativeGraph")
    def is_cumulative_graph(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A cumulative graph.
        """
        return pulumi.get(self, "is_cumulative_graph")

    @is_cumulative_graph.setter
    def is_cumulative_graph(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cumulative_graph", value)


@pulumi.input_type
class QueryQueryDefinitionReportQueryArgs:
    def __init__(__self__, *,
                 granularity: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 compartment_depth: Optional[pulumi.Input[float]] = None,
                 date_range_name: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 forecast: Optional[pulumi.Input['QueryQueryDefinitionReportQueryForecastArgs']] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input['QueryQueryDefinitionReportQueryGroupByTagArgs']]]] = None,
                 is_aggregate_by_time: Optional[pulumi.Input[bool]] = None,
                 query_type: Optional[pulumi.Input[str]] = None,
                 time_usage_ended: Optional[pulumi.Input[str]] = None,
                 time_usage_started: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] granularity: (Updatable) The usage granularity. HOURLY - Hourly data aggregation. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation. TOTAL - Not yet supported.
        :param pulumi.Input[str] tenant_id: (Updatable) Tenant ID.
        :param pulumi.Input[float] compartment_depth: (Updatable) The compartment depth level.
        :param pulumi.Input[str] date_range_name: (Updatable) The UI date range, for example, LAST_THREE_MONTHS. Conflicts with timeUsageStarted and timeUsageEnded.
        :param pulumi.Input[str] filter: (Updatable) The filter object for query usage.
        :param pulumi.Input['QueryQueryDefinitionReportQueryForecastArgs'] forecast: (Updatable) Forecast configuration of usage/cost.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_bies: (Updatable) Aggregate the result by. example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "tenantId", "tenantName"]`
        :param pulumi.Input[Sequence[pulumi.Input['QueryQueryDefinitionReportQueryGroupByTagArgs']]] group_by_tags: (Updatable) GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        :param pulumi.Input[bool] is_aggregate_by_time: (Updatable) Whether aggregated by time. If isAggregateByTime is true, all usage/cost over the query time period will be added up.
        :param pulumi.Input[str] query_type: (Updatable) The query usage type. COST by default if it is missing. Usage - Query the usage data. Cost - Query the cost/billing data. Credit - Query the credit adjustments data. ExpiredCredit - Query the expired credits data AllCredit - Query the credit adjustments and expired credit
        :param pulumi.Input[str] time_usage_ended: (Updatable) The usage end time.
        :param pulumi.Input[str] time_usage_started: (Updatable) The usage start time.
        """
        QueryQueryDefinitionReportQueryArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            granularity=granularity,
            tenant_id=tenant_id,
            compartment_depth=compartment_depth,
            date_range_name=date_range_name,
            filter=filter,
            forecast=forecast,
            group_bies=group_bies,
            group_by_tags=group_by_tags,
            is_aggregate_by_time=is_aggregate_by_time,
            query_type=query_type,
            time_usage_ended=time_usage_ended,
            time_usage_started=time_usage_started,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             granularity: pulumi.Input[str],
             tenant_id: pulumi.Input[str],
             compartment_depth: Optional[pulumi.Input[float]] = None,
             date_range_name: Optional[pulumi.Input[str]] = None,
             filter: Optional[pulumi.Input[str]] = None,
             forecast: Optional[pulumi.Input['QueryQueryDefinitionReportQueryForecastArgs']] = None,
             group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input['QueryQueryDefinitionReportQueryGroupByTagArgs']]]] = None,
             is_aggregate_by_time: Optional[pulumi.Input[bool]] = None,
             query_type: Optional[pulumi.Input[str]] = None,
             time_usage_ended: Optional[pulumi.Input[str]] = None,
             time_usage_started: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tenantId' in kwargs:
            tenant_id = kwargs['tenantId']
        if 'compartmentDepth' in kwargs:
            compartment_depth = kwargs['compartmentDepth']
        if 'dateRangeName' in kwargs:
            date_range_name = kwargs['dateRangeName']
        if 'groupBies' in kwargs:
            group_bies = kwargs['groupBies']
        if 'groupByTags' in kwargs:
            group_by_tags = kwargs['groupByTags']
        if 'isAggregateByTime' in kwargs:
            is_aggregate_by_time = kwargs['isAggregateByTime']
        if 'queryType' in kwargs:
            query_type = kwargs['queryType']
        if 'timeUsageEnded' in kwargs:
            time_usage_ended = kwargs['timeUsageEnded']
        if 'timeUsageStarted' in kwargs:
            time_usage_started = kwargs['timeUsageStarted']

        _setter("granularity", granularity)
        _setter("tenant_id", tenant_id)
        if compartment_depth is not None:
            _setter("compartment_depth", compartment_depth)
        if date_range_name is not None:
            _setter("date_range_name", date_range_name)
        if filter is not None:
            _setter("filter", filter)
        if forecast is not None:
            _setter("forecast", forecast)
        if group_bies is not None:
            _setter("group_bies", group_bies)
        if group_by_tags is not None:
            _setter("group_by_tags", group_by_tags)
        if is_aggregate_by_time is not None:
            _setter("is_aggregate_by_time", is_aggregate_by_time)
        if query_type is not None:
            _setter("query_type", query_type)
        if time_usage_ended is not None:
            _setter("time_usage_ended", time_usage_ended)
        if time_usage_started is not None:
            _setter("time_usage_started", time_usage_started)

    @property
    @pulumi.getter
    def granularity(self) -> pulumi.Input[str]:
        """
        (Updatable) The usage granularity. HOURLY - Hourly data aggregation. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation. TOTAL - Not yet supported.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: pulumi.Input[str]):
        pulumi.set(self, "granularity", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="compartmentDepth")
    def compartment_depth(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The compartment depth level.
        """
        return pulumi.get(self, "compartment_depth")

    @compartment_depth.setter
    def compartment_depth(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "compartment_depth", value)

    @property
    @pulumi.getter(name="dateRangeName")
    def date_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The UI date range, for example, LAST_THREE_MONTHS. Conflicts with timeUsageStarted and timeUsageEnded.
        """
        return pulumi.get(self, "date_range_name")

    @date_range_name.setter
    def date_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_range_name", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The filter object for query usage.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def forecast(self) -> Optional[pulumi.Input['QueryQueryDefinitionReportQueryForecastArgs']]:
        """
        (Updatable) Forecast configuration of usage/cost.
        """
        return pulumi.get(self, "forecast")

    @forecast.setter
    def forecast(self, value: Optional[pulumi.Input['QueryQueryDefinitionReportQueryForecastArgs']]):
        pulumi.set(self, "forecast", value)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Aggregate the result by. example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "tenantId", "tenantName"]`
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_bies", value)

    @property
    @pulumi.getter(name="groupByTags")
    def group_by_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueryQueryDefinitionReportQueryGroupByTagArgs']]]]:
        """
        (Updatable) GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        """
        return pulumi.get(self, "group_by_tags")

    @group_by_tags.setter
    def group_by_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueryQueryDefinitionReportQueryGroupByTagArgs']]]]):
        pulumi.set(self, "group_by_tags", value)

    @property
    @pulumi.getter(name="isAggregateByTime")
    def is_aggregate_by_time(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether aggregated by time. If isAggregateByTime is true, all usage/cost over the query time period will be added up.
        """
        return pulumi.get(self, "is_aggregate_by_time")

    @is_aggregate_by_time.setter
    def is_aggregate_by_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_aggregate_by_time", value)

    @property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The query usage type. COST by default if it is missing. Usage - Query the usage data. Cost - Query the cost/billing data. Credit - Query the credit adjustments data. ExpiredCredit - Query the expired credits data AllCredit - Query the credit adjustments and expired credit
        """
        return pulumi.get(self, "query_type")

    @query_type.setter
    def query_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_type", value)

    @property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The usage end time.
        """
        return pulumi.get(self, "time_usage_ended")

    @time_usage_ended.setter
    def time_usage_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_usage_ended", value)

    @property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The usage start time.
        """
        return pulumi.get(self, "time_usage_started")

    @time_usage_started.setter
    def time_usage_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_usage_started", value)


@pulumi.input_type
class QueryQueryDefinitionReportQueryForecastArgs:
    def __init__(__self__, *,
                 time_forecast_ended: pulumi.Input[str],
                 forecast_type: Optional[pulumi.Input[str]] = None,
                 time_forecast_started: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] time_forecast_ended: (Updatable) The forecast end time.
        :param pulumi.Input[str] forecast_type: (Updatable) BASIC uses the exponential smoothing (ETS) model to project future usage/costs based on history data. The basis for projections is a periodic set of equivalent historical days for which the projection is being made.
        :param pulumi.Input[str] time_forecast_started: (Updatable) The forecast start time. Defaults to UTC-1 if not specified.
        """
        QueryQueryDefinitionReportQueryForecastArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_forecast_ended=time_forecast_ended,
            forecast_type=forecast_type,
            time_forecast_started=time_forecast_started,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_forecast_ended: pulumi.Input[str],
             forecast_type: Optional[pulumi.Input[str]] = None,
             time_forecast_started: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeForecastEnded' in kwargs:
            time_forecast_ended = kwargs['timeForecastEnded']
        if 'forecastType' in kwargs:
            forecast_type = kwargs['forecastType']
        if 'timeForecastStarted' in kwargs:
            time_forecast_started = kwargs['timeForecastStarted']

        _setter("time_forecast_ended", time_forecast_ended)
        if forecast_type is not None:
            _setter("forecast_type", forecast_type)
        if time_forecast_started is not None:
            _setter("time_forecast_started", time_forecast_started)

    @property
    @pulumi.getter(name="timeForecastEnded")
    def time_forecast_ended(self) -> pulumi.Input[str]:
        """
        (Updatable) The forecast end time.
        """
        return pulumi.get(self, "time_forecast_ended")

    @time_forecast_ended.setter
    def time_forecast_ended(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_forecast_ended", value)

    @property
    @pulumi.getter(name="forecastType")
    def forecast_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) BASIC uses the exponential smoothing (ETS) model to project future usage/costs based on history data. The basis for projections is a periodic set of equivalent historical days for which the projection is being made.
        """
        return pulumi.get(self, "forecast_type")

    @forecast_type.setter
    def forecast_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forecast_type", value)

    @property
    @pulumi.getter(name="timeForecastStarted")
    def time_forecast_started(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The forecast start time. Defaults to UTC-1 if not specified.
        """
        return pulumi.get(self, "time_forecast_started")

    @time_forecast_started.setter
    def time_forecast_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_forecast_started", value)


@pulumi.input_type
class QueryQueryDefinitionReportQueryGroupByTagArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) The tag key.
        :param pulumi.Input[str] namespace: (Updatable) The tag namespace.
        :param pulumi.Input[str] value: (Updatable) The tag value.
        """
        QueryQueryDefinitionReportQueryGroupByTagArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            namespace=namespace,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if key is not None:
            _setter("key", key)
        if namespace is not None:
            _setter("namespace", namespace)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The tag namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScheduleQueryPropertiesArgs:
    def __init__(__self__, *,
                 date_range: pulumi.Input['ScheduleQueryPropertiesDateRangeArgs'],
                 granularity: pulumi.Input[str],
                 compartment_depth: Optional[pulumi.Input[float]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleQueryPropertiesGroupByTagArgs']]]] = None,
                 is_aggregate_by_time: Optional[pulumi.Input[bool]] = None,
                 query_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ScheduleQueryPropertiesDateRangeArgs'] date_range: Static or dynamic date range `dateRangeType`, which corresponds with type-specific characteristics.
        :param pulumi.Input[str] granularity: The usage granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation. Allowed values are: DAILY MONTHLY
        :param pulumi.Input[float] compartment_depth: The depth level of the compartment.
        :param pulumi.Input[str] filter: The filter object for query usage.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_bies: Aggregate the result by. For example: [ "tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "tenantId", "tenantName" ]
        :param pulumi.Input[Sequence[pulumi.Input['ScheduleQueryPropertiesGroupByTagArgs']]] group_by_tags: GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: [ { "namespace": "oracle", "key": "createdBy" ]
        :param pulumi.Input[bool] is_aggregate_by_time: Specifies whether aggregated by time. If isAggregateByTime is true, all usage or cost over the query time period will be added up.
        :param pulumi.Input[str] query_type: The query usage type. COST by default if it is missing. Usage - Query the usage data. Cost - Query the cost/billing data. Allowed values are: USAGE COST USAGE_AND_COST
        """
        ScheduleQueryPropertiesArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            date_range=date_range,
            granularity=granularity,
            compartment_depth=compartment_depth,
            filter=filter,
            group_bies=group_bies,
            group_by_tags=group_by_tags,
            is_aggregate_by_time=is_aggregate_by_time,
            query_type=query_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             date_range: pulumi.Input['ScheduleQueryPropertiesDateRangeArgs'],
             granularity: pulumi.Input[str],
             compartment_depth: Optional[pulumi.Input[float]] = None,
             filter: Optional[pulumi.Input[str]] = None,
             group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleQueryPropertiesGroupByTagArgs']]]] = None,
             is_aggregate_by_time: Optional[pulumi.Input[bool]] = None,
             query_type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'dateRange' in kwargs:
            date_range = kwargs['dateRange']
        if 'compartmentDepth' in kwargs:
            compartment_depth = kwargs['compartmentDepth']
        if 'groupBies' in kwargs:
            group_bies = kwargs['groupBies']
        if 'groupByTags' in kwargs:
            group_by_tags = kwargs['groupByTags']
        if 'isAggregateByTime' in kwargs:
            is_aggregate_by_time = kwargs['isAggregateByTime']
        if 'queryType' in kwargs:
            query_type = kwargs['queryType']

        _setter("date_range", date_range)
        _setter("granularity", granularity)
        if compartment_depth is not None:
            _setter("compartment_depth", compartment_depth)
        if filter is not None:
            _setter("filter", filter)
        if group_bies is not None:
            _setter("group_bies", group_bies)
        if group_by_tags is not None:
            _setter("group_by_tags", group_by_tags)
        if is_aggregate_by_time is not None:
            _setter("is_aggregate_by_time", is_aggregate_by_time)
        if query_type is not None:
            _setter("query_type", query_type)

    @property
    @pulumi.getter(name="dateRange")
    def date_range(self) -> pulumi.Input['ScheduleQueryPropertiesDateRangeArgs']:
        """
        Static or dynamic date range `dateRangeType`, which corresponds with type-specific characteristics.
        """
        return pulumi.get(self, "date_range")

    @date_range.setter
    def date_range(self, value: pulumi.Input['ScheduleQueryPropertiesDateRangeArgs']):
        pulumi.set(self, "date_range", value)

    @property
    @pulumi.getter
    def granularity(self) -> pulumi.Input[str]:
        """
        The usage granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation. Allowed values are: DAILY MONTHLY
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: pulumi.Input[str]):
        pulumi.set(self, "granularity", value)

    @property
    @pulumi.getter(name="compartmentDepth")
    def compartment_depth(self) -> Optional[pulumi.Input[float]]:
        """
        The depth level of the compartment.
        """
        return pulumi.get(self, "compartment_depth")

    @compartment_depth.setter
    def compartment_depth(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "compartment_depth", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        The filter object for query usage.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Aggregate the result by. For example: [ "tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "tenantId", "tenantName" ]
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_bies", value)

    @property
    @pulumi.getter(name="groupByTags")
    def group_by_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleQueryPropertiesGroupByTagArgs']]]]:
        """
        GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: [ { "namespace": "oracle", "key": "createdBy" ]
        """
        return pulumi.get(self, "group_by_tags")

    @group_by_tags.setter
    def group_by_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleQueryPropertiesGroupByTagArgs']]]]):
        pulumi.set(self, "group_by_tags", value)

    @property
    @pulumi.getter(name="isAggregateByTime")
    def is_aggregate_by_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether aggregated by time. If isAggregateByTime is true, all usage or cost over the query time period will be added up.
        """
        return pulumi.get(self, "is_aggregate_by_time")

    @is_aggregate_by_time.setter
    def is_aggregate_by_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_aggregate_by_time", value)

    @property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[pulumi.Input[str]]:
        """
        The query usage type. COST by default if it is missing. Usage - Query the usage data. Cost - Query the cost/billing data. Allowed values are: USAGE COST USAGE_AND_COST
        """
        return pulumi.get(self, "query_type")

    @query_type.setter
    def query_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_type", value)


@pulumi.input_type
class ScheduleQueryPropertiesDateRangeArgs:
    def __init__(__self__, *,
                 date_range_type: pulumi.Input[str],
                 dynamic_date_range_type: Optional[pulumi.Input[str]] = None,
                 time_usage_ended: Optional[pulumi.Input[str]] = None,
                 time_usage_started: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] date_range_type: Defines whether the schedule date range is STATIC or DYNAMIC.
        :param pulumi.Input[str] time_usage_ended: The usage end time.
        :param pulumi.Input[str] time_usage_started: The usage start time.
        """
        ScheduleQueryPropertiesDateRangeArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            date_range_type=date_range_type,
            dynamic_date_range_type=dynamic_date_range_type,
            time_usage_ended=time_usage_ended,
            time_usage_started=time_usage_started,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             date_range_type: pulumi.Input[str],
             dynamic_date_range_type: Optional[pulumi.Input[str]] = None,
             time_usage_ended: Optional[pulumi.Input[str]] = None,
             time_usage_started: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'dateRangeType' in kwargs:
            date_range_type = kwargs['dateRangeType']
        if 'dynamicDateRangeType' in kwargs:
            dynamic_date_range_type = kwargs['dynamicDateRangeType']
        if 'timeUsageEnded' in kwargs:
            time_usage_ended = kwargs['timeUsageEnded']
        if 'timeUsageStarted' in kwargs:
            time_usage_started = kwargs['timeUsageStarted']

        _setter("date_range_type", date_range_type)
        if dynamic_date_range_type is not None:
            _setter("dynamic_date_range_type", dynamic_date_range_type)
        if time_usage_ended is not None:
            _setter("time_usage_ended", time_usage_ended)
        if time_usage_started is not None:
            _setter("time_usage_started", time_usage_started)

    @property
    @pulumi.getter(name="dateRangeType")
    def date_range_type(self) -> pulumi.Input[str]:
        """
        Defines whether the schedule date range is STATIC or DYNAMIC.
        """
        return pulumi.get(self, "date_range_type")

    @date_range_type.setter
    def date_range_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "date_range_type", value)

    @property
    @pulumi.getter(name="dynamicDateRangeType")
    def dynamic_date_range_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dynamic_date_range_type")

    @dynamic_date_range_type.setter
    def dynamic_date_range_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dynamic_date_range_type", value)

    @property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> Optional[pulumi.Input[str]]:
        """
        The usage end time.
        """
        return pulumi.get(self, "time_usage_ended")

    @time_usage_ended.setter
    def time_usage_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_usage_ended", value)

    @property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> Optional[pulumi.Input[str]]:
        """
        The usage start time.
        """
        return pulumi.get(self, "time_usage_started")

    @time_usage_started.setter
    def time_usage_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_usage_started", value)


@pulumi.input_type
class ScheduleQueryPropertiesGroupByTagArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The tag key.
        :param pulumi.Input[str] namespace: (Updatable) The namespace needed to determine the object storage bucket.
        :param pulumi.Input[str] value: The tag value.
        """
        ScheduleQueryPropertiesGroupByTagArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            namespace=namespace,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if key is not None:
            _setter("key", key)
        if namespace is not None:
            _setter("namespace", namespace)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The namespace needed to determine the object storage bucket.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScheduleResultLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 location_type: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 region: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: (Updatable) The bucket name where usage or cost CSVs will be uploaded.
        :param pulumi.Input[str] location_type: (Updatable) Defines the type of location where the usage or cost CSVs will be stored.
        :param pulumi.Input[str] namespace: (Updatable) The namespace needed to determine the object storage bucket.
        :param pulumi.Input[str] region: (Updatable) The destination Object Store Region specified by the customer.
        """
        ScheduleResultLocationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            region=region,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: pulumi.Input[str],
             location_type: pulumi.Input[str],
             namespace: pulumi.Input[str],
             region: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'locationType' in kwargs:
            location_type = kwargs['locationType']

        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("region", region)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        (Updatable) The bucket name where usage or cost CSVs will be uploaded.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Defines the type of location where the usage or cost CSVs will be stored.
        """
        return pulumi.get(self, "location_type")

    @location_type.setter
    def location_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_type", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        (Updatable) The namespace needed to determine the object storage bucket.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        (Updatable) The destination Object Store Region specified by the customer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class UsageForecastArgs:
    def __init__(__self__, *,
                 time_forecast_ended: pulumi.Input[str],
                 forecast_type: Optional[pulumi.Input[str]] = None,
                 time_forecast_started: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] time_forecast_ended: The forecast end time.
        :param pulumi.Input[str] forecast_type: BASIC uses the exponential smoothing (ETS) model to project future usage/costs based on history data. The basis for projections is a periodic set of equivalent historical days for which the projection is being made.
        :param pulumi.Input[str] time_forecast_started: The forecast start time. Defaults to UTC-1 if not specified.
        """
        UsageForecastArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_forecast_ended=time_forecast_ended,
            forecast_type=forecast_type,
            time_forecast_started=time_forecast_started,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_forecast_ended: pulumi.Input[str],
             forecast_type: Optional[pulumi.Input[str]] = None,
             time_forecast_started: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeForecastEnded' in kwargs:
            time_forecast_ended = kwargs['timeForecastEnded']
        if 'forecastType' in kwargs:
            forecast_type = kwargs['forecastType']
        if 'timeForecastStarted' in kwargs:
            time_forecast_started = kwargs['timeForecastStarted']

        _setter("time_forecast_ended", time_forecast_ended)
        if forecast_type is not None:
            _setter("forecast_type", forecast_type)
        if time_forecast_started is not None:
            _setter("time_forecast_started", time_forecast_started)

    @property
    @pulumi.getter(name="timeForecastEnded")
    def time_forecast_ended(self) -> pulumi.Input[str]:
        """
        The forecast end time.
        """
        return pulumi.get(self, "time_forecast_ended")

    @time_forecast_ended.setter
    def time_forecast_ended(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_forecast_ended", value)

    @property
    @pulumi.getter(name="forecastType")
    def forecast_type(self) -> Optional[pulumi.Input[str]]:
        """
        BASIC uses the exponential smoothing (ETS) model to project future usage/costs based on history data. The basis for projections is a periodic set of equivalent historical days for which the projection is being made.
        """
        return pulumi.get(self, "forecast_type")

    @forecast_type.setter
    def forecast_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forecast_type", value)

    @property
    @pulumi.getter(name="timeForecastStarted")
    def time_forecast_started(self) -> Optional[pulumi.Input[str]]:
        """
        The forecast start time. Defaults to UTC-1 if not specified.
        """
        return pulumi.get(self, "time_forecast_started")

    @time_forecast_started.setter
    def time_forecast_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_forecast_started", value)


@pulumi.input_type
class UsageGroupByTagArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The tag key.
        :param pulumi.Input[str] namespace: The tag namespace.
        :param pulumi.Input[str] value: The tag value.
        """
        UsageGroupByTagArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            namespace=namespace,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if key is not None:
            _setter("key", key)
        if namespace is not None:
            _setter("namespace", namespace)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The tag namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class UsageItemArgs:
    def __init__(__self__, *,
                 ad: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compartment_name: Optional[pulumi.Input[str]] = None,
                 compartment_path: Optional[pulumi.Input[str]] = None,
                 computed_amount: Optional[pulumi.Input[float]] = None,
                 computed_quantity: Optional[pulumi.Input[float]] = None,
                 currency: Optional[pulumi.Input[str]] = None,
                 discount: Optional[pulumi.Input[float]] = None,
                 is_forecast: Optional[pulumi.Input[bool]] = None,
                 list_rate: Optional[pulumi.Input[float]] = None,
                 overage: Optional[pulumi.Input[str]] = None,
                 overages_flag: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_name: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 sku_name: Optional[pulumi.Input[str]] = None,
                 sku_part_number: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['UsageItemTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 time_usage_ended: Optional[pulumi.Input[str]] = None,
                 time_usage_started: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 unit_price: Optional[pulumi.Input[float]] = None,
                 weight: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] ad: The availability domain of the usage.
        :param pulumi.Input[str] compartment_id: The compartment OCID.
        :param pulumi.Input[str] compartment_name: The compartment name.
        :param pulumi.Input[str] compartment_path: The compartment path, starting from root.
        :param pulumi.Input[float] computed_amount: The computed cost.
        :param pulumi.Input[float] computed_quantity: The usage number.
        :param pulumi.Input[str] currency: The price currency.
        :param pulumi.Input[float] discount: The discretionary discount applied to the SKU.
        :param pulumi.Input[bool] is_forecast: The forecasted data.
        :param pulumi.Input[float] list_rate: The SKU list rate (not discount).
        :param pulumi.Input[str] overage: The overage usage.
        :param pulumi.Input[str] overages_flag: The SPM OverageFlag.
        :param pulumi.Input[str] platform: Platform for the cost.
        :param pulumi.Input[str] region: The region of the usage.
        :param pulumi.Input[str] resource_id: The resource OCID that is incurring the cost.
        :param pulumi.Input[str] resource_name: The resource name that is incurring the cost.
        :param pulumi.Input[str] service: The service name that is incurring the cost.
        :param pulumi.Input[str] shape: The resource shape.
        :param pulumi.Input[str] sku_name: The SKU friendly name.
        :param pulumi.Input[str] sku_part_number: The SKU part number.
        :param pulumi.Input[str] subscription_id: The subscription ID.
        :param pulumi.Input[Sequence[pulumi.Input['UsageItemTagArgs']]] tags: For grouping, a tag definition. For filtering, a definition and key.
        :param pulumi.Input[str] tenant_id: Tenant ID.
        :param pulumi.Input[str] tenant_name: The tenancy name.
        :param pulumi.Input[str] time_usage_ended: The usage end time.
        :param pulumi.Input[str] time_usage_started: The usage start time.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] unit: The usage unit.
        :param pulumi.Input[float] unit_price: The price per unit.
        :param pulumi.Input[float] weight: The resource size being metered.
        """
        UsageItemArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            compartment_id=compartment_id,
            compartment_name=compartment_name,
            compartment_path=compartment_path,
            computed_amount=computed_amount,
            computed_quantity=computed_quantity,
            currency=currency,
            discount=discount,
            is_forecast=is_forecast,
            list_rate=list_rate,
            overage=overage,
            overages_flag=overages_flag,
            platform=platform,
            region=region,
            resource_id=resource_id,
            resource_name=resource_name,
            service=service,
            shape=shape,
            sku_name=sku_name,
            sku_part_number=sku_part_number,
            subscription_id=subscription_id,
            tags=tags,
            tenant_id=tenant_id,
            tenant_name=tenant_name,
            time_usage_ended=time_usage_ended,
            time_usage_started=time_usage_started,
            unit=unit,
            unit_price=unit_price,
            weight=weight,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             compartment_name: Optional[pulumi.Input[str]] = None,
             compartment_path: Optional[pulumi.Input[str]] = None,
             computed_amount: Optional[pulumi.Input[float]] = None,
             computed_quantity: Optional[pulumi.Input[float]] = None,
             currency: Optional[pulumi.Input[str]] = None,
             discount: Optional[pulumi.Input[float]] = None,
             is_forecast: Optional[pulumi.Input[bool]] = None,
             list_rate: Optional[pulumi.Input[float]] = None,
             overage: Optional[pulumi.Input[str]] = None,
             overages_flag: Optional[pulumi.Input[str]] = None,
             platform: Optional[pulumi.Input[str]] = None,
             region: Optional[pulumi.Input[str]] = None,
             resource_id: Optional[pulumi.Input[str]] = None,
             resource_name: Optional[pulumi.Input[str]] = None,
             service: Optional[pulumi.Input[str]] = None,
             shape: Optional[pulumi.Input[str]] = None,
             sku_name: Optional[pulumi.Input[str]] = None,
             sku_part_number: Optional[pulumi.Input[str]] = None,
             subscription_id: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input['UsageItemTagArgs']]]] = None,
             tenant_id: Optional[pulumi.Input[str]] = None,
             tenant_name: Optional[pulumi.Input[str]] = None,
             time_usage_ended: Optional[pulumi.Input[str]] = None,
             time_usage_started: Optional[pulumi.Input[str]] = None,
             unit: Optional[pulumi.Input[str]] = None,
             unit_price: Optional[pulumi.Input[float]] = None,
             weight: Optional[pulumi.Input[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'compartmentName' in kwargs:
            compartment_name = kwargs['compartmentName']
        if 'compartmentPath' in kwargs:
            compartment_path = kwargs['compartmentPath']
        if 'computedAmount' in kwargs:
            computed_amount = kwargs['computedAmount']
        if 'computedQuantity' in kwargs:
            computed_quantity = kwargs['computedQuantity']
        if 'isForecast' in kwargs:
            is_forecast = kwargs['isForecast']
        if 'listRate' in kwargs:
            list_rate = kwargs['listRate']
        if 'overagesFlag' in kwargs:
            overages_flag = kwargs['overagesFlag']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceName' in kwargs:
            resource_name = kwargs['resourceName']
        if 'skuName' in kwargs:
            sku_name = kwargs['skuName']
        if 'skuPartNumber' in kwargs:
            sku_part_number = kwargs['skuPartNumber']
        if 'subscriptionId' in kwargs:
            subscription_id = kwargs['subscriptionId']
        if 'tenantId' in kwargs:
            tenant_id = kwargs['tenantId']
        if 'tenantName' in kwargs:
            tenant_name = kwargs['tenantName']
        if 'timeUsageEnded' in kwargs:
            time_usage_ended = kwargs['timeUsageEnded']
        if 'timeUsageStarted' in kwargs:
            time_usage_started = kwargs['timeUsageStarted']
        if 'unitPrice' in kwargs:
            unit_price = kwargs['unitPrice']

        if ad is not None:
            _setter("ad", ad)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if compartment_name is not None:
            _setter("compartment_name", compartment_name)
        if compartment_path is not None:
            _setter("compartment_path", compartment_path)
        if computed_amount is not None:
            _setter("computed_amount", computed_amount)
        if computed_quantity is not None:
            _setter("computed_quantity", computed_quantity)
        if currency is not None:
            _setter("currency", currency)
        if discount is not None:
            _setter("discount", discount)
        if is_forecast is not None:
            _setter("is_forecast", is_forecast)
        if list_rate is not None:
            _setter("list_rate", list_rate)
        if overage is not None:
            _setter("overage", overage)
        if overages_flag is not None:
            _setter("overages_flag", overages_flag)
        if platform is not None:
            _setter("platform", platform)
        if region is not None:
            _setter("region", region)
        if resource_id is not None:
            _setter("resource_id", resource_id)
        if resource_name is not None:
            _setter("resource_name", resource_name)
        if service is not None:
            _setter("service", service)
        if shape is not None:
            _setter("shape", shape)
        if sku_name is not None:
            _setter("sku_name", sku_name)
        if sku_part_number is not None:
            _setter("sku_part_number", sku_part_number)
        if subscription_id is not None:
            _setter("subscription_id", subscription_id)
        if tags is not None:
            _setter("tags", tags)
        if tenant_id is not None:
            _setter("tenant_id", tenant_id)
        if tenant_name is not None:
            _setter("tenant_name", tenant_name)
        if time_usage_ended is not None:
            _setter("time_usage_ended", time_usage_ended)
        if time_usage_started is not None:
            _setter("time_usage_started", time_usage_started)
        if unit is not None:
            _setter("unit", unit)
        if unit_price is not None:
            _setter("unit_price", unit_price)
        if weight is not None:
            _setter("weight", weight)

    @property
    @pulumi.getter
    def ad(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain of the usage.
        """
        return pulumi.get(self, "ad")

    @ad.setter
    def ad(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The compartment name.
        """
        return pulumi.get(self, "compartment_name")

    @compartment_name.setter
    def compartment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_name", value)

    @property
    @pulumi.getter(name="compartmentPath")
    def compartment_path(self) -> Optional[pulumi.Input[str]]:
        """
        The compartment path, starting from root.
        """
        return pulumi.get(self, "compartment_path")

    @compartment_path.setter
    def compartment_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_path", value)

    @property
    @pulumi.getter(name="computedAmount")
    def computed_amount(self) -> Optional[pulumi.Input[float]]:
        """
        The computed cost.
        """
        return pulumi.get(self, "computed_amount")

    @computed_amount.setter
    def computed_amount(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "computed_amount", value)

    @property
    @pulumi.getter(name="computedQuantity")
    def computed_quantity(self) -> Optional[pulumi.Input[float]]:
        """
        The usage number.
        """
        return pulumi.get(self, "computed_quantity")

    @computed_quantity.setter
    def computed_quantity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "computed_quantity", value)

    @property
    @pulumi.getter
    def currency(self) -> Optional[pulumi.Input[str]]:
        """
        The price currency.
        """
        return pulumi.get(self, "currency")

    @currency.setter
    def currency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "currency", value)

    @property
    @pulumi.getter
    def discount(self) -> Optional[pulumi.Input[float]]:
        """
        The discretionary discount applied to the SKU.
        """
        return pulumi.get(self, "discount")

    @discount.setter
    def discount(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "discount", value)

    @property
    @pulumi.getter(name="isForecast")
    def is_forecast(self) -> Optional[pulumi.Input[bool]]:
        """
        The forecasted data.
        """
        return pulumi.get(self, "is_forecast")

    @is_forecast.setter
    def is_forecast(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_forecast", value)

    @property
    @pulumi.getter(name="listRate")
    def list_rate(self) -> Optional[pulumi.Input[float]]:
        """
        The SKU list rate (not discount).
        """
        return pulumi.get(self, "list_rate")

    @list_rate.setter
    def list_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "list_rate", value)

    @property
    @pulumi.getter
    def overage(self) -> Optional[pulumi.Input[str]]:
        """
        The overage usage.
        """
        return pulumi.get(self, "overage")

    @overage.setter
    def overage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overage", value)

    @property
    @pulumi.getter(name="overagesFlag")
    def overages_flag(self) -> Optional[pulumi.Input[str]]:
        """
        The SPM OverageFlag.
        """
        return pulumi.get(self, "overages_flag")

    @overages_flag.setter
    def overages_flag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overages_flag", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        Platform for the cost.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the usage.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource OCID that is incurring the cost.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name that is incurring the cost.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        The service name that is incurring the cost.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The resource shape.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU friendly name.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="skuPartNumber")
    def sku_part_number(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU part number.
        """
        return pulumi.get(self, "sku_part_number")

    @sku_part_number.setter
    def sku_part_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku_part_number", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription ID.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsageItemTagArgs']]]]:
        """
        For grouping, a tag definition. For filtering, a definition and key.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsageItemTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[pulumi.Input[str]]:
        """
        The tenancy name.
        """
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_name", value)

    @property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> Optional[pulumi.Input[str]]:
        """
        The usage end time.
        """
        return pulumi.get(self, "time_usage_ended")

    @time_usage_ended.setter
    def time_usage_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_usage_ended", value)

    @property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> Optional[pulumi.Input[str]]:
        """
        The usage start time.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_usage_started")

    @time_usage_started.setter
    def time_usage_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_usage_started", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The usage unit.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="unitPrice")
    def unit_price(self) -> Optional[pulumi.Input[float]]:
        """
        The price per unit.
        """
        return pulumi.get(self, "unit_price")

    @unit_price.setter
    def unit_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "unit_price", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[float]]:
        """
        The resource size being metered.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class UsageItemTagArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The tag key.
        :param pulumi.Input[str] namespace: The tag namespace.
        :param pulumi.Input[str] value: The tag value.
        """
        UsageItemTagArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            namespace=namespace,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if key is not None:
            _setter("key", key)
        if namespace is not None:
            _setter("namespace", namespace)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The tag namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GetCustomTablesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetCustomTablesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetQueriesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetQueriesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetScheduledRunsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetScheduledRunsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSchedulesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Query parameter for filtering by name
        """
        GetSchedulesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Query parameter for filtering by name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


