# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MysqlConfigurationArgs', 'MysqlConfiguration']

@pulumi.input_type
class MysqlConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 shape_name: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 init_variables: Optional[pulumi.Input['MysqlConfigurationInitVariablesArgs']] = None,
                 parent_configuration_id: Optional[pulumi.Input[str]] = None,
                 variables: Optional[pulumi.Input['MysqlConfigurationVariablesArgs']] = None):
        """
        The set of arguments for constructing a MysqlConfiguration resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] shape_name: The name of the associated Shape.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) User-provided data about the Configuration.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the Configuration.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['MysqlConfigurationInitVariablesArgs'] init_variables: User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        :param pulumi.Input[str] parent_configuration_id: The OCID of the Configuration from which the new Configuration is derived. The values in CreateConfigurationDetails.variables supersede the variables of the parent Configuration.
        :param pulumi.Input['MysqlConfigurationVariablesArgs'] variables: User-defined service variables.
        """
        MysqlConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            shape_name=shape_name,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            init_variables=init_variables,
            parent_configuration_id=parent_configuration_id,
            variables=variables,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             shape_name: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             init_variables: Optional[pulumi.Input['MysqlConfigurationInitVariablesArgs']] = None,
             parent_configuration_id: Optional[pulumi.Input[str]] = None,
             variables: Optional[pulumi.Input['MysqlConfigurationVariablesArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'shapeName' in kwargs:
            shape_name = kwargs['shapeName']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'initVariables' in kwargs:
            init_variables = kwargs['initVariables']
        if 'parentConfigurationId' in kwargs:
            parent_configuration_id = kwargs['parentConfigurationId']

        _setter("compartment_id", compartment_id)
        _setter("shape_name", shape_name)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if init_variables is not None:
            _setter("init_variables", init_variables)
        if parent_configuration_id is not None:
            _setter("parent_configuration_id", parent_configuration_id)
        if variables is not None:
            _setter("variables", variables)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Input[str]:
        """
        The name of the associated Shape.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-provided data about the Configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the Configuration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initVariables")
    def init_variables(self) -> Optional[pulumi.Input['MysqlConfigurationInitVariablesArgs']]:
        """
        User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        """
        return pulumi.get(self, "init_variables")

    @init_variables.setter
    def init_variables(self, value: Optional[pulumi.Input['MysqlConfigurationInitVariablesArgs']]):
        pulumi.set(self, "init_variables", value)

    @property
    @pulumi.getter(name="parentConfigurationId")
    def parent_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Configuration from which the new Configuration is derived. The values in CreateConfigurationDetails.variables supersede the variables of the parent Configuration.
        """
        return pulumi.get(self, "parent_configuration_id")

    @parent_configuration_id.setter
    def parent_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_configuration_id", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input['MysqlConfigurationVariablesArgs']]:
        """
        User-defined service variables.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input['MysqlConfigurationVariablesArgs']]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class _MysqlConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 init_variables: Optional[pulumi.Input['MysqlConfigurationInitVariablesArgs']] = None,
                 parent_configuration_id: Optional[pulumi.Input[str]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 variables: Optional[pulumi.Input['MysqlConfigurationVariablesArgs']] = None):
        """
        Input properties used for looking up and filtering MysqlConfiguration resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) User-provided data about the Configuration.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the Configuration.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['MysqlConfigurationInitVariablesArgs'] init_variables: User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        :param pulumi.Input[str] parent_configuration_id: The OCID of the Configuration from which the new Configuration is derived. The values in CreateConfigurationDetails.variables supersede the variables of the parent Configuration.
        :param pulumi.Input[str] shape_name: The name of the associated Shape.
        :param pulumi.Input[str] state: The current state of the Configuration.
        :param pulumi.Input[str] time_created: The date and time the Configuration was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the Configuration was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] type: The Configuration type, DEFAULT or CUSTOM.
        :param pulumi.Input['MysqlConfigurationVariablesArgs'] variables: User-defined service variables.
        """
        _MysqlConfigurationState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            init_variables=init_variables,
            parent_configuration_id=parent_configuration_id,
            shape_name=shape_name,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
            type=type,
            variables=variables,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             init_variables: Optional[pulumi.Input['MysqlConfigurationInitVariablesArgs']] = None,
             parent_configuration_id: Optional[pulumi.Input[str]] = None,
             shape_name: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             variables: Optional[pulumi.Input['MysqlConfigurationVariablesArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'initVariables' in kwargs:
            init_variables = kwargs['initVariables']
        if 'parentConfigurationId' in kwargs:
            parent_configuration_id = kwargs['parentConfigurationId']
        if 'shapeName' in kwargs:
            shape_name = kwargs['shapeName']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if init_variables is not None:
            _setter("init_variables", init_variables)
        if parent_configuration_id is not None:
            _setter("parent_configuration_id", parent_configuration_id)
        if shape_name is not None:
            _setter("shape_name", shape_name)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if type is not None:
            _setter("type", type)
        if variables is not None:
            _setter("variables", variables)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-provided data about the Configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the Configuration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initVariables")
    def init_variables(self) -> Optional[pulumi.Input['MysqlConfigurationInitVariablesArgs']]:
        """
        User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        """
        return pulumi.get(self, "init_variables")

    @init_variables.setter
    def init_variables(self, value: Optional[pulumi.Input['MysqlConfigurationInitVariablesArgs']]):
        pulumi.set(self, "init_variables", value)

    @property
    @pulumi.getter(name="parentConfigurationId")
    def parent_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Configuration from which the new Configuration is derived. The values in CreateConfigurationDetails.variables supersede the variables of the parent Configuration.
        """
        return pulumi.get(self, "parent_configuration_id")

    @parent_configuration_id.setter
    def parent_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_configuration_id", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the associated Shape.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Configuration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Configuration was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Configuration was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The Configuration type, DEFAULT or CUSTOM.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input['MysqlConfigurationVariablesArgs']]:
        """
        User-defined service variables.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input['MysqlConfigurationVariablesArgs']]):
        pulumi.set(self, "variables", value)


class MysqlConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 init_variables: Optional[pulumi.Input[pulumi.InputType['MysqlConfigurationInitVariablesArgs']]] = None,
                 parent_configuration_id: Optional[pulumi.Input[str]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None,
                 variables: Optional[pulumi.Input[pulumi.InputType['MysqlConfigurationVariablesArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Mysql Configuration resource in Oracle Cloud Infrastructure MySQL Database service.

        Creates a new Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_mysql_configuration = oci.mysql.MysqlConfiguration("testMysqlConfiguration",
            compartment_id=var["compartment_id"],
            shape_name=oci_mysql_shape["test_shape"]["name"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["mysql_configuration_description"],
            display_name=var["mysql_configuration_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            init_variables=oci.mysql.MysqlConfigurationInitVariablesArgs(
                lower_case_table_names=var["mysql_configuration_init_variables_lower_case_table_names"],
            ),
            parent_configuration_id=oci_audit_configuration["test_configuration"]["id"],
            variables=oci.mysql.MysqlConfigurationVariablesArgs(
                autocommit=var["mysql_configuration_variables_autocommit"],
                big_tables=var["mysql_configuration_variables_big_tables"],
                binlog_expire_logs_seconds=var["mysql_configuration_variables_binlog_expire_logs_seconds"],
                binlog_row_metadata=var["mysql_configuration_variables_binlog_row_metadata"],
                binlog_row_value_options=var["mysql_configuration_variables_binlog_row_value_options"],
                binlog_transaction_compression=var["mysql_configuration_variables_binlog_transaction_compression"],
                completion_type=var["mysql_configuration_variables_completion_type"],
                connect_timeout=var["mysql_configuration_variables_connect_timeout"],
                connection_memory_chunk_size=var["mysql_configuration_variables_connection_memory_chunk_size"],
                connection_memory_limit=var["mysql_configuration_variables_connection_memory_limit"],
                cte_max_recursion_depth=var["mysql_configuration_variables_cte_max_recursion_depth"],
                default_authentication_plugin=var["mysql_configuration_variables_default_authentication_plugin"],
                foreign_key_checks=var["mysql_configuration_variables_foreign_key_checks"],
                generated_random_password_length=var["mysql_configuration_variables_generated_random_password_length"],
                global_connection_memory_limit=var["mysql_configuration_variables_global_connection_memory_limit"],
                global_connection_memory_tracking=var["mysql_configuration_variables_global_connection_memory_tracking"],
                group_replication_consistency=var["mysql_configuration_variables_group_replication_consistency"],
                information_schema_stats_expiry=var["mysql_configuration_variables_information_schema_stats_expiry"],
                innodb_buffer_pool_dump_pct=var["mysql_configuration_variables_innodb_buffer_pool_dump_pct"],
                innodb_buffer_pool_instances=var["mysql_configuration_variables_innodb_buffer_pool_instances"],
                innodb_buffer_pool_size=var["mysql_configuration_variables_innodb_buffer_pool_size"],
                innodb_ddl_buffer_size=var["mysql_configuration_variables_innodb_ddl_buffer_size"],
                innodb_ddl_threads=var["mysql_configuration_variables_innodb_ddl_threads"],
                innodb_ft_enable_stopword=var["mysql_configuration_variables_innodb_ft_enable_stopword"],
                innodb_ft_max_token_size=var["mysql_configuration_variables_innodb_ft_max_token_size"],
                innodb_ft_min_token_size=var["mysql_configuration_variables_innodb_ft_min_token_size"],
                innodb_ft_num_word_optimize=var["mysql_configuration_variables_innodb_ft_num_word_optimize"],
                innodb_ft_result_cache_limit=var["mysql_configuration_variables_innodb_ft_result_cache_limit"],
                innodb_ft_server_stopword_table=var["mysql_configuration_variables_innodb_ft_server_stopword_table"],
                innodb_lock_wait_timeout=var["mysql_configuration_variables_innodb_lock_wait_timeout"],
                innodb_log_writer_threads=var["mysql_configuration_variables_innodb_log_writer_threads"],
                innodb_max_purge_lag=var["mysql_configuration_variables_innodb_max_purge_lag"],
                innodb_max_purge_lag_delay=var["mysql_configuration_variables_innodb_max_purge_lag_delay"],
                innodb_stats_persistent_sample_pages=var["mysql_configuration_variables_innodb_stats_persistent_sample_pages"],
                innodb_stats_transient_sample_pages=var["mysql_configuration_variables_innodb_stats_transient_sample_pages"],
                interactive_timeout=var["mysql_configuration_variables_interactive_timeout"],
                local_infile=var["mysql_configuration_variables_local_infile"],
                mandatory_roles=var["mysql_configuration_variables_mandatory_roles"],
                max_allowed_packet=var["mysql_configuration_variables_max_allowed_packet"],
                max_binlog_cache_size=var["mysql_configuration_variables_max_binlog_cache_size"],
                max_connect_errors=var["mysql_configuration_variables_max_connect_errors"],
                max_connections=var["mysql_configuration_variables_max_connections"],
                max_execution_time=var["mysql_configuration_variables_max_execution_time"],
                max_heap_table_size=var["mysql_configuration_variables_max_heap_table_size"],
                max_prepared_stmt_count=var["mysql_configuration_variables_max_prepared_stmt_count"],
                mysql_firewall_mode=var["mysql_configuration_variables_mysql_firewall_mode"],
                mysql_zstd_default_compression_level=var["mysql_configuration_variables_mysql_zstd_default_compression_level"],
                mysqlx_connect_timeout=var["mysql_configuration_variables_mysqlx_connect_timeout"],
                mysqlx_deflate_default_compression_level=var["mysql_configuration_variables_mysqlx_deflate_default_compression_level"],
                mysqlx_deflate_max_client_compression_level=var["mysql_configuration_variables_mysqlx_deflate_max_client_compression_level"],
                mysqlx_document_id_unique_prefix=var["mysql_configuration_variables_mysqlx_document_id_unique_prefix"],
                mysqlx_enable_hello_notice=var["mysql_configuration_variables_mysqlx_enable_hello_notice"],
                mysqlx_idle_worker_thread_timeout=var["mysql_configuration_variables_mysqlx_idle_worker_thread_timeout"],
                mysqlx_interactive_timeout=var["mysql_configuration_variables_mysqlx_interactive_timeout"],
                mysqlx_lz4default_compression_level=var["mysql_configuration_variables_mysqlx_lz4default_compression_level"],
                mysqlx_lz4max_client_compression_level=var["mysql_configuration_variables_mysqlx_lz4max_client_compression_level"],
                mysqlx_max_allowed_packet=var["mysql_configuration_variables_mysqlx_max_allowed_packet"],
                mysqlx_min_worker_threads=var["mysql_configuration_variables_mysqlx_min_worker_threads"],
                mysqlx_read_timeout=var["mysql_configuration_variables_mysqlx_read_timeout"],
                mysqlx_wait_timeout=var["mysql_configuration_variables_mysqlx_wait_timeout"],
                mysqlx_write_timeout=var["mysql_configuration_variables_mysqlx_write_timeout"],
                mysqlx_zstd_default_compression_level=var["mysql_configuration_variables_mysqlx_zstd_default_compression_level"],
                mysqlx_zstd_max_client_compression_level=var["mysql_configuration_variables_mysqlx_zstd_max_client_compression_level"],
                net_read_timeout=var["mysql_configuration_variables_net_read_timeout"],
                net_write_timeout=var["mysql_configuration_variables_net_write_timeout"],
                parser_max_mem_size=var["mysql_configuration_variables_parser_max_mem_size"],
                query_alloc_block_size=var["mysql_configuration_variables_query_alloc_block_size"],
                query_prealloc_size=var["mysql_configuration_variables_query_prealloc_size"],
                regexp_time_limit=var["mysql_configuration_variables_regexp_time_limit"],
                sort_buffer_size=var["mysql_configuration_variables_sort_buffer_size"],
                sql_mode=var["mysql_configuration_variables_sql_mode"],
                sql_require_primary_key=var["mysql_configuration_variables_sql_require_primary_key"],
                sql_warnings=var["mysql_configuration_variables_sql_warnings"],
                thread_pool_dedicated_listeners=var["mysql_configuration_variables_thread_pool_dedicated_listeners"],
                thread_pool_max_transactions_limit=var["mysql_configuration_variables_thread_pool_max_transactions_limit"],
                time_zone=var["mysql_configuration_variables_time_zone"],
                tmp_table_size=var["mysql_configuration_variables_tmp_table_size"],
                transaction_isolation=var["mysql_configuration_variables_transaction_isolation"],
                wait_timeout=var["mysql_configuration_variables_wait_timeout"],
            ))
        ```

        ## Import

        MysqlConfigurations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Mysql/mysqlConfiguration:MysqlConfiguration test_mysql_configuration "configurations/{configurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) User-provided data about the Configuration.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the Configuration.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['MysqlConfigurationInitVariablesArgs']] init_variables: User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        :param pulumi.Input[str] parent_configuration_id: The OCID of the Configuration from which the new Configuration is derived. The values in CreateConfigurationDetails.variables supersede the variables of the parent Configuration.
        :param pulumi.Input[str] shape_name: The name of the associated Shape.
        :param pulumi.Input[pulumi.InputType['MysqlConfigurationVariablesArgs']] variables: User-defined service variables.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MysqlConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Mysql Configuration resource in Oracle Cloud Infrastructure MySQL Database service.

        Creates a new Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_mysql_configuration = oci.mysql.MysqlConfiguration("testMysqlConfiguration",
            compartment_id=var["compartment_id"],
            shape_name=oci_mysql_shape["test_shape"]["name"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["mysql_configuration_description"],
            display_name=var["mysql_configuration_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            init_variables=oci.mysql.MysqlConfigurationInitVariablesArgs(
                lower_case_table_names=var["mysql_configuration_init_variables_lower_case_table_names"],
            ),
            parent_configuration_id=oci_audit_configuration["test_configuration"]["id"],
            variables=oci.mysql.MysqlConfigurationVariablesArgs(
                autocommit=var["mysql_configuration_variables_autocommit"],
                big_tables=var["mysql_configuration_variables_big_tables"],
                binlog_expire_logs_seconds=var["mysql_configuration_variables_binlog_expire_logs_seconds"],
                binlog_row_metadata=var["mysql_configuration_variables_binlog_row_metadata"],
                binlog_row_value_options=var["mysql_configuration_variables_binlog_row_value_options"],
                binlog_transaction_compression=var["mysql_configuration_variables_binlog_transaction_compression"],
                completion_type=var["mysql_configuration_variables_completion_type"],
                connect_timeout=var["mysql_configuration_variables_connect_timeout"],
                connection_memory_chunk_size=var["mysql_configuration_variables_connection_memory_chunk_size"],
                connection_memory_limit=var["mysql_configuration_variables_connection_memory_limit"],
                cte_max_recursion_depth=var["mysql_configuration_variables_cte_max_recursion_depth"],
                default_authentication_plugin=var["mysql_configuration_variables_default_authentication_plugin"],
                foreign_key_checks=var["mysql_configuration_variables_foreign_key_checks"],
                generated_random_password_length=var["mysql_configuration_variables_generated_random_password_length"],
                global_connection_memory_limit=var["mysql_configuration_variables_global_connection_memory_limit"],
                global_connection_memory_tracking=var["mysql_configuration_variables_global_connection_memory_tracking"],
                group_replication_consistency=var["mysql_configuration_variables_group_replication_consistency"],
                information_schema_stats_expiry=var["mysql_configuration_variables_information_schema_stats_expiry"],
                innodb_buffer_pool_dump_pct=var["mysql_configuration_variables_innodb_buffer_pool_dump_pct"],
                innodb_buffer_pool_instances=var["mysql_configuration_variables_innodb_buffer_pool_instances"],
                innodb_buffer_pool_size=var["mysql_configuration_variables_innodb_buffer_pool_size"],
                innodb_ddl_buffer_size=var["mysql_configuration_variables_innodb_ddl_buffer_size"],
                innodb_ddl_threads=var["mysql_configuration_variables_innodb_ddl_threads"],
                innodb_ft_enable_stopword=var["mysql_configuration_variables_innodb_ft_enable_stopword"],
                innodb_ft_max_token_size=var["mysql_configuration_variables_innodb_ft_max_token_size"],
                innodb_ft_min_token_size=var["mysql_configuration_variables_innodb_ft_min_token_size"],
                innodb_ft_num_word_optimize=var["mysql_configuration_variables_innodb_ft_num_word_optimize"],
                innodb_ft_result_cache_limit=var["mysql_configuration_variables_innodb_ft_result_cache_limit"],
                innodb_ft_server_stopword_table=var["mysql_configuration_variables_innodb_ft_server_stopword_table"],
                innodb_lock_wait_timeout=var["mysql_configuration_variables_innodb_lock_wait_timeout"],
                innodb_log_writer_threads=var["mysql_configuration_variables_innodb_log_writer_threads"],
                innodb_max_purge_lag=var["mysql_configuration_variables_innodb_max_purge_lag"],
                innodb_max_purge_lag_delay=var["mysql_configuration_variables_innodb_max_purge_lag_delay"],
                innodb_stats_persistent_sample_pages=var["mysql_configuration_variables_innodb_stats_persistent_sample_pages"],
                innodb_stats_transient_sample_pages=var["mysql_configuration_variables_innodb_stats_transient_sample_pages"],
                interactive_timeout=var["mysql_configuration_variables_interactive_timeout"],
                local_infile=var["mysql_configuration_variables_local_infile"],
                mandatory_roles=var["mysql_configuration_variables_mandatory_roles"],
                max_allowed_packet=var["mysql_configuration_variables_max_allowed_packet"],
                max_binlog_cache_size=var["mysql_configuration_variables_max_binlog_cache_size"],
                max_connect_errors=var["mysql_configuration_variables_max_connect_errors"],
                max_connections=var["mysql_configuration_variables_max_connections"],
                max_execution_time=var["mysql_configuration_variables_max_execution_time"],
                max_heap_table_size=var["mysql_configuration_variables_max_heap_table_size"],
                max_prepared_stmt_count=var["mysql_configuration_variables_max_prepared_stmt_count"],
                mysql_firewall_mode=var["mysql_configuration_variables_mysql_firewall_mode"],
                mysql_zstd_default_compression_level=var["mysql_configuration_variables_mysql_zstd_default_compression_level"],
                mysqlx_connect_timeout=var["mysql_configuration_variables_mysqlx_connect_timeout"],
                mysqlx_deflate_default_compression_level=var["mysql_configuration_variables_mysqlx_deflate_default_compression_level"],
                mysqlx_deflate_max_client_compression_level=var["mysql_configuration_variables_mysqlx_deflate_max_client_compression_level"],
                mysqlx_document_id_unique_prefix=var["mysql_configuration_variables_mysqlx_document_id_unique_prefix"],
                mysqlx_enable_hello_notice=var["mysql_configuration_variables_mysqlx_enable_hello_notice"],
                mysqlx_idle_worker_thread_timeout=var["mysql_configuration_variables_mysqlx_idle_worker_thread_timeout"],
                mysqlx_interactive_timeout=var["mysql_configuration_variables_mysqlx_interactive_timeout"],
                mysqlx_lz4default_compression_level=var["mysql_configuration_variables_mysqlx_lz4default_compression_level"],
                mysqlx_lz4max_client_compression_level=var["mysql_configuration_variables_mysqlx_lz4max_client_compression_level"],
                mysqlx_max_allowed_packet=var["mysql_configuration_variables_mysqlx_max_allowed_packet"],
                mysqlx_min_worker_threads=var["mysql_configuration_variables_mysqlx_min_worker_threads"],
                mysqlx_read_timeout=var["mysql_configuration_variables_mysqlx_read_timeout"],
                mysqlx_wait_timeout=var["mysql_configuration_variables_mysqlx_wait_timeout"],
                mysqlx_write_timeout=var["mysql_configuration_variables_mysqlx_write_timeout"],
                mysqlx_zstd_default_compression_level=var["mysql_configuration_variables_mysqlx_zstd_default_compression_level"],
                mysqlx_zstd_max_client_compression_level=var["mysql_configuration_variables_mysqlx_zstd_max_client_compression_level"],
                net_read_timeout=var["mysql_configuration_variables_net_read_timeout"],
                net_write_timeout=var["mysql_configuration_variables_net_write_timeout"],
                parser_max_mem_size=var["mysql_configuration_variables_parser_max_mem_size"],
                query_alloc_block_size=var["mysql_configuration_variables_query_alloc_block_size"],
                query_prealloc_size=var["mysql_configuration_variables_query_prealloc_size"],
                regexp_time_limit=var["mysql_configuration_variables_regexp_time_limit"],
                sort_buffer_size=var["mysql_configuration_variables_sort_buffer_size"],
                sql_mode=var["mysql_configuration_variables_sql_mode"],
                sql_require_primary_key=var["mysql_configuration_variables_sql_require_primary_key"],
                sql_warnings=var["mysql_configuration_variables_sql_warnings"],
                thread_pool_dedicated_listeners=var["mysql_configuration_variables_thread_pool_dedicated_listeners"],
                thread_pool_max_transactions_limit=var["mysql_configuration_variables_thread_pool_max_transactions_limit"],
                time_zone=var["mysql_configuration_variables_time_zone"],
                tmp_table_size=var["mysql_configuration_variables_tmp_table_size"],
                transaction_isolation=var["mysql_configuration_variables_transaction_isolation"],
                wait_timeout=var["mysql_configuration_variables_wait_timeout"],
            ))
        ```

        ## Import

        MysqlConfigurations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Mysql/mysqlConfiguration:MysqlConfiguration test_mysql_configuration "configurations/{configurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param MysqlConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            MysqlConfigurationArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 init_variables: Optional[pulumi.Input[pulumi.InputType['MysqlConfigurationInitVariablesArgs']]] = None,
                 parent_configuration_id: Optional[pulumi.Input[str]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None,
                 variables: Optional[pulumi.Input[pulumi.InputType['MysqlConfigurationVariablesArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlConfigurationArgs.__new__(MysqlConfigurationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if init_variables is not None and not isinstance(init_variables, MysqlConfigurationInitVariablesArgs):
                init_variables = init_variables or {}
                def _setter(key, value):
                    init_variables[key] = value
                MysqlConfigurationInitVariablesArgs._configure(_setter, **init_variables)
            __props__.__dict__["init_variables"] = init_variables
            __props__.__dict__["parent_configuration_id"] = parent_configuration_id
            if shape_name is None and not opts.urn:
                raise TypeError("Missing required property 'shape_name'")
            __props__.__dict__["shape_name"] = shape_name
            if variables is not None and not isinstance(variables, MysqlConfigurationVariablesArgs):
                variables = variables or {}
                def _setter(key, value):
                    variables[key] = value
                MysqlConfigurationVariablesArgs._configure(_setter, **variables)
            __props__.__dict__["variables"] = variables
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
        super(MysqlConfiguration, __self__).__init__(
            'oci:Mysql/mysqlConfiguration:MysqlConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            init_variables: Optional[pulumi.Input[pulumi.InputType['MysqlConfigurationInitVariablesArgs']]] = None,
            parent_configuration_id: Optional[pulumi.Input[str]] = None,
            shape_name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            variables: Optional[pulumi.Input[pulumi.InputType['MysqlConfigurationVariablesArgs']]] = None) -> 'MysqlConfiguration':
        """
        Get an existing MysqlConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) User-provided data about the Configuration.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the Configuration.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['MysqlConfigurationInitVariablesArgs']] init_variables: User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        :param pulumi.Input[str] parent_configuration_id: The OCID of the Configuration from which the new Configuration is derived. The values in CreateConfigurationDetails.variables supersede the variables of the parent Configuration.
        :param pulumi.Input[str] shape_name: The name of the associated Shape.
        :param pulumi.Input[str] state: The current state of the Configuration.
        :param pulumi.Input[str] time_created: The date and time the Configuration was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the Configuration was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] type: The Configuration type, DEFAULT or CUSTOM.
        :param pulumi.Input[pulumi.InputType['MysqlConfigurationVariablesArgs']] variables: User-defined service variables.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MysqlConfigurationState.__new__(_MysqlConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["init_variables"] = init_variables
        __props__.__dict__["parent_configuration_id"] = parent_configuration_id
        __props__.__dict__["shape_name"] = shape_name
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["variables"] = variables
        return MysqlConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) User-provided data about the Configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the Configuration.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="initVariables")
    def init_variables(self) -> pulumi.Output['outputs.MysqlConfigurationInitVariables']:
        """
        User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        """
        return pulumi.get(self, "init_variables")

    @property
    @pulumi.getter(name="parentConfigurationId")
    def parent_configuration_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Configuration from which the new Configuration is derived. The values in CreateConfigurationDetails.variables supersede the variables of the parent Configuration.
        """
        return pulumi.get(self, "parent_configuration_id")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Output[str]:
        """
        The name of the associated Shape.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Configuration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Configuration was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the Configuration was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The Configuration type, DEFAULT or CUSTOM.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Output['outputs.MysqlConfigurationVariables']:
        """
        User-defined service variables.
        """
        return pulumi.get(self, "variables")

