# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackendSetResult',
    'AwaitableGetBackendSetResult',
    'get_backend_set',
    'get_backend_set_output',
]

@pulumi.output_type
class GetBackendSetResult:
    """
    A collection of values returned by getBackendSet.
    """
    def __init__(__self__, backend_set_name=None, backends=None, health_checkers=None, id=None, ip_version=None, is_preserve_source=None, name=None, network_load_balancer_id=None, policy=None):
        if backend_set_name and not isinstance(backend_set_name, str):
            raise TypeError("Expected argument 'backend_set_name' to be a str")
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        if backends and not isinstance(backends, list):
            raise TypeError("Expected argument 'backends' to be a list")
        pulumi.set(__self__, "backends", backends)
        if health_checkers and not isinstance(health_checkers, list):
            raise TypeError("Expected argument 'health_checkers' to be a list")
        pulumi.set(__self__, "health_checkers", health_checkers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_version and not isinstance(ip_version, str):
            raise TypeError("Expected argument 'ip_version' to be a str")
        pulumi.set(__self__, "ip_version", ip_version)
        if is_preserve_source and not isinstance(is_preserve_source, bool):
            raise TypeError("Expected argument 'is_preserve_source' to be a bool")
        pulumi.set(__self__, "is_preserve_source", is_preserve_source)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_load_balancer_id and not isinstance(network_load_balancer_id, str):
            raise TypeError("Expected argument 'network_load_balancer_id' to be a str")
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> str:
        return pulumi.get(self, "backend_set_name")

    @property
    @pulumi.getter
    def backends(self) -> Sequence['outputs.GetBackendSetBackendResult']:
        """
        Array of backends.
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="healthCheckers")
    def health_checkers(self) -> Sequence['outputs.GetBackendSetHealthCheckerResult']:
        """
        The health check policy configuration. For more information, see [Editing Health Check Policies](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/editinghealthcheck.htm).
        """
        return pulumi.get(self, "health_checkers")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        """
        IP version associated with the backend set.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="isPreserveSource")
    def is_preserve_source(self) -> bool:
        """
        If this parameter is enabled, then the network load balancer preserves the source IP of the packet when it is forwarded to backends. Backends see the original source IP. If the isPreserveSourceDestination parameter is enabled for the network load balancer resource, then this parameter cannot be disabled. The value is true by default.
        """
        return pulumi.get(self, "is_preserve_source")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> str:
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The network load balancer policy for the backend set.  Example: `FIVE_TUPLE`
        """
        return pulumi.get(self, "policy")


class AwaitableGetBackendSetResult(GetBackendSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendSetResult(
            backend_set_name=self.backend_set_name,
            backends=self.backends,
            health_checkers=self.health_checkers,
            id=self.id,
            ip_version=self.ip_version,
            is_preserve_source=self.is_preserve_source,
            name=self.name,
            network_load_balancer_id=self.network_load_balancer_id,
            policy=self.policy)


def get_backend_set(backend_set_name: Optional[str] = None,
                    network_load_balancer_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendSetResult:
    """
    This data source provides details about a specific Backend Set resource in Oracle Cloud Infrastructure Network Load Balancer service.

    Retrieves the configuration information for the specified backend set.


    :param str backend_set_name: The name of the backend set to retrieve.  Example: `example_backend_set`
    :param str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
    """
    __args__ = dict()
    __args__['backendSetName'] = backend_set_name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkLoadBalancer/getBackendSet:getBackendSet', __args__, opts=opts, typ=GetBackendSetResult).value

    return AwaitableGetBackendSetResult(
        backend_set_name=pulumi.get(__ret__, 'backend_set_name'),
        backends=pulumi.get(__ret__, 'backends'),
        health_checkers=pulumi.get(__ret__, 'health_checkers'),
        id=pulumi.get(__ret__, 'id'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        is_preserve_source=pulumi.get(__ret__, 'is_preserve_source'),
        name=pulumi.get(__ret__, 'name'),
        network_load_balancer_id=pulumi.get(__ret__, 'network_load_balancer_id'),
        policy=pulumi.get(__ret__, 'policy'))


@_utilities.lift_output_func(get_backend_set)
def get_backend_set_output(backend_set_name: Optional[pulumi.Input[str]] = None,
                           network_load_balancer_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackendSetResult]:
    """
    This data source provides details about a specific Backend Set resource in Oracle Cloud Infrastructure Network Load Balancer service.

    Retrieves the configuration information for the specified backend set.


    :param str backend_set_name: The name of the backend set to retrieve.  Example: `example_backend_set`
    :param str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
    """
    ...
