# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBucketResult',
    'AwaitableGetBucketResult',
    'get_bucket',
    'get_bucket_output',
]

@pulumi.output_type
class GetBucketResult:
    """
    A collection of values returned by getBucket.
    """
    def __init__(__self__, access_type=None, approximate_count=None, approximate_size=None, auto_tiering=None, bucket_id=None, compartment_id=None, created_by=None, defined_tags=None, etag=None, freeform_tags=None, id=None, is_read_only=None, kms_key_id=None, metadata=None, name=None, namespace=None, object_events_enabled=None, object_lifecycle_policy_etag=None, replication_enabled=None, retention_rules=None, storage_tier=None, time_created=None, versioning=None):
        if access_type and not isinstance(access_type, str):
            raise TypeError("Expected argument 'access_type' to be a str")
        pulumi.set(__self__, "access_type", access_type)
        if approximate_count and not isinstance(approximate_count, str):
            raise TypeError("Expected argument 'approximate_count' to be a str")
        pulumi.set(__self__, "approximate_count", approximate_count)
        if approximate_size and not isinstance(approximate_size, str):
            raise TypeError("Expected argument 'approximate_size' to be a str")
        pulumi.set(__self__, "approximate_size", approximate_size)
        if auto_tiering and not isinstance(auto_tiering, str):
            raise TypeError("Expected argument 'auto_tiering' to be a str")
        pulumi.set(__self__, "auto_tiering", auto_tiering)
        if bucket_id and not isinstance(bucket_id, str):
            raise TypeError("Expected argument 'bucket_id' to be a str")
        pulumi.set(__self__, "bucket_id", bucket_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_read_only and not isinstance(is_read_only, bool):
            raise TypeError("Expected argument 'is_read_only' to be a bool")
        pulumi.set(__self__, "is_read_only", is_read_only)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if object_events_enabled and not isinstance(object_events_enabled, bool):
            raise TypeError("Expected argument 'object_events_enabled' to be a bool")
        pulumi.set(__self__, "object_events_enabled", object_events_enabled)
        if object_lifecycle_policy_etag and not isinstance(object_lifecycle_policy_etag, str):
            raise TypeError("Expected argument 'object_lifecycle_policy_etag' to be a str")
        pulumi.set(__self__, "object_lifecycle_policy_etag", object_lifecycle_policy_etag)
        if replication_enabled and not isinstance(replication_enabled, bool):
            raise TypeError("Expected argument 'replication_enabled' to be a bool")
        pulumi.set(__self__, "replication_enabled", replication_enabled)
        if retention_rules and not isinstance(retention_rules, list):
            raise TypeError("Expected argument 'retention_rules' to be a list")
        pulumi.set(__self__, "retention_rules", retention_rules)
        if storage_tier and not isinstance(storage_tier, str):
            raise TypeError("Expected argument 'storage_tier' to be a str")
        pulumi.set(__self__, "storage_tier", storage_tier)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if versioning and not isinstance(versioning, str):
            raise TypeError("Expected argument 'versioning' to be a str")
        pulumi.set(__self__, "versioning", versioning)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        The type of public access enabled on this bucket. A bucket is set to `NoPublicAccess` by default, which only allows an authenticated caller to access the bucket and its contents. When `ObjectRead` is enabled on the bucket, public access is allowed for the `GetObject`, `HeadObject`, and `ListObjects` operations. When `ObjectReadWithoutList` is enabled on the bucket, public access is allowed for the `GetObject` and `HeadObject` operations.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="approximateCount")
    def approximate_count(self) -> str:
        """
        The approximate number of objects in the bucket. Count statistics are reported periodically. You will see a lag between what is displayed and the actual object count.
        """
        return pulumi.get(self, "approximate_count")

    @property
    @pulumi.getter(name="approximateSize")
    def approximate_size(self) -> str:
        """
        The approximate total size in bytes of all objects in the bucket. Size statistics are reported periodically. You will see a lag between what is displayed and the actual size of the bucket.
        """
        return pulumi.get(self, "approximate_size")

    @property
    @pulumi.getter(name="autoTiering")
    def auto_tiering(self) -> str:
        """
        The auto tiering status on the bucket. A bucket is created with auto tiering `Disabled` by default. For auto tiering `InfrequentAccess`, objects are transitioned automatically between the 'Standard' and 'InfrequentAccess' tiers based on the access pattern of the objects.
        """
        return pulumi.get(self, "auto_tiering")

    @property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> str:
        """
        The OCID of the bucket which is a Oracle assigned unique identifier for this resource type (bucket). `bucket_id` cannot be used for bucket lookup.
        """
        return pulumi.get(self, "bucket_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment ID in which the bucket is authorized.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the bucket.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The entity tag (ETag) for the bucket.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> bool:
        """
        Whether or not this bucket is read only. By default, `isReadOnly` is set to `false`. This will be set to 'true' when this bucket is configured as a destination in a replication policy.
        """
        return pulumi.get(self, "is_read_only")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, Any]:
        """
        Arbitrary string keys and values for user-defined metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace in which the bucket resides.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectEventsEnabled")
    def object_events_enabled(self) -> bool:
        """
        Whether or not events are emitted for object state changes in this bucket. By default, `objectEventsEnabled` is set to `false`. Set `objectEventsEnabled` to `true` to emit events for object state changes. For more information about events, see [Overview of Events](https://docs.cloud.oracle.com/iaas/Content/Events/Concepts/eventsoverview.htm).
        """
        return pulumi.get(self, "object_events_enabled")

    @property
    @pulumi.getter(name="objectLifecyclePolicyEtag")
    def object_lifecycle_policy_etag(self) -> str:
        """
        The entity tag (ETag) for the live object lifecycle policy on the bucket.
        """
        return pulumi.get(self, "object_lifecycle_policy_etag")

    @property
    @pulumi.getter(name="replicationEnabled")
    def replication_enabled(self) -> bool:
        """
        Whether or not this bucket is a replication source. By default, `replicationEnabled` is set to `false`. This will be set to 'true' when you create a replication policy for the bucket.
        """
        return pulumi.get(self, "replication_enabled")

    @property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Sequence['outputs.GetBucketRetentionRuleResult']:
        """
        User specified list of retention rules for the bucket.
        """
        return pulumi.get(self, "retention_rules")

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> str:
        """
        The storage tier type assigned to the bucket. A bucket is set to `Standard` tier by default, which means objects uploaded or copied to the bucket will be in the standard storage tier. When the `Archive` tier type is set explicitly for a bucket, objects uploaded or copied to the bucket will be stored in archive storage. The `storageTier` property is immutable after bucket is created.
        """
        return pulumi.get(self, "storage_tier")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def versioning(self) -> str:
        """
        The versioning status on the bucket. A bucket is created with versioning `Disabled` by default. For versioning `Enabled`, objects are protected from overwrites and deletes, by maintaining their version history. When versioning is `Suspended`, the previous versions will still remain but new versions will no longer be created when overwitten or deleted.
        """
        return pulumi.get(self, "versioning")


class AwaitableGetBucketResult(GetBucketResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketResult(
            access_type=self.access_type,
            approximate_count=self.approximate_count,
            approximate_size=self.approximate_size,
            auto_tiering=self.auto_tiering,
            bucket_id=self.bucket_id,
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            defined_tags=self.defined_tags,
            etag=self.etag,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_read_only=self.is_read_only,
            kms_key_id=self.kms_key_id,
            metadata=self.metadata,
            name=self.name,
            namespace=self.namespace,
            object_events_enabled=self.object_events_enabled,
            object_lifecycle_policy_etag=self.object_lifecycle_policy_etag,
            replication_enabled=self.replication_enabled,
            retention_rules=self.retention_rules,
            storage_tier=self.storage_tier,
            time_created=self.time_created,
            versioning=self.versioning)


def get_bucket(name: Optional[str] = None,
               namespace: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketResult:
    """
    This data source provides details about a specific Bucket resource in Oracle Cloud Infrastructure Object Storage service.

    Gets the current representation of the given bucket in the given Object Storage namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bucket = oci.ObjectStorage.get_bucket(name=var["bucket_name"],
        namespace=var["bucket_namespace"])
    ```


    :param str name: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param str namespace: The Object Storage namespace used for the request.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ObjectStorage/getBucket:getBucket', __args__, opts=opts, typ=GetBucketResult).value

    return AwaitableGetBucketResult(
        access_type=pulumi.get(__ret__, 'access_type'),
        approximate_count=pulumi.get(__ret__, 'approximate_count'),
        approximate_size=pulumi.get(__ret__, 'approximate_size'),
        auto_tiering=pulumi.get(__ret__, 'auto_tiering'),
        bucket_id=pulumi.get(__ret__, 'bucket_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        etag=pulumi.get(__ret__, 'etag'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_read_only=pulumi.get(__ret__, 'is_read_only'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        object_events_enabled=pulumi.get(__ret__, 'object_events_enabled'),
        object_lifecycle_policy_etag=pulumi.get(__ret__, 'object_lifecycle_policy_etag'),
        replication_enabled=pulumi.get(__ret__, 'replication_enabled'),
        retention_rules=pulumi.get(__ret__, 'retention_rules'),
        storage_tier=pulumi.get(__ret__, 'storage_tier'),
        time_created=pulumi.get(__ret__, 'time_created'),
        versioning=pulumi.get(__ret__, 'versioning'))


@_utilities.lift_output_func(get_bucket)
def get_bucket_output(name: Optional[pulumi.Input[str]] = None,
                      namespace: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBucketResult]:
    """
    This data source provides details about a specific Bucket resource in Oracle Cloud Infrastructure Object Storage service.

    Gets the current representation of the given bucket in the given Object Storage namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bucket = oci.ObjectStorage.get_bucket(name=var["bucket_name"],
        namespace=var["bucket_namespace"])
    ```


    :param str name: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param str namespace: The Object Storage namespace used for the request.
    """
    ...
