# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetExadataInsightResult',
    'AwaitableGetExadataInsightResult',
    'get_exadata_insight',
    'get_exadata_insight_output',
]

@pulumi.output_type
class GetExadataInsightResult:
    """
    A collection of values returned by getExadataInsight.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, enterprise_manager_bridge_id=None, enterprise_manager_entity_display_name=None, enterprise_manager_entity_identifier=None, enterprise_manager_entity_name=None, enterprise_manager_entity_type=None, enterprise_manager_identifier=None, entity_source=None, exadata_display_name=None, exadata_infra_id=None, exadata_infra_resource_type=None, exadata_insight_id=None, exadata_name=None, exadata_rack_type=None, exadata_shape=None, exadata_type=None, freeform_tags=None, id=None, is_auto_sync_enabled=None, is_virtualized_exadata=None, lifecycle_details=None, member_vm_cluster_details=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if enterprise_manager_bridge_id and not isinstance(enterprise_manager_bridge_id, str):
            raise TypeError("Expected argument 'enterprise_manager_bridge_id' to be a str")
        pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if enterprise_manager_entity_display_name and not isinstance(enterprise_manager_entity_display_name, str):
            raise TypeError("Expected argument 'enterprise_manager_entity_display_name' to be a str")
        pulumi.set(__self__, "enterprise_manager_entity_display_name", enterprise_manager_entity_display_name)
        if enterprise_manager_entity_identifier and not isinstance(enterprise_manager_entity_identifier, str):
            raise TypeError("Expected argument 'enterprise_manager_entity_identifier' to be a str")
        pulumi.set(__self__, "enterprise_manager_entity_identifier", enterprise_manager_entity_identifier)
        if enterprise_manager_entity_name and not isinstance(enterprise_manager_entity_name, str):
            raise TypeError("Expected argument 'enterprise_manager_entity_name' to be a str")
        pulumi.set(__self__, "enterprise_manager_entity_name", enterprise_manager_entity_name)
        if enterprise_manager_entity_type and not isinstance(enterprise_manager_entity_type, str):
            raise TypeError("Expected argument 'enterprise_manager_entity_type' to be a str")
        pulumi.set(__self__, "enterprise_manager_entity_type", enterprise_manager_entity_type)
        if enterprise_manager_identifier and not isinstance(enterprise_manager_identifier, str):
            raise TypeError("Expected argument 'enterprise_manager_identifier' to be a str")
        pulumi.set(__self__, "enterprise_manager_identifier", enterprise_manager_identifier)
        if entity_source and not isinstance(entity_source, str):
            raise TypeError("Expected argument 'entity_source' to be a str")
        pulumi.set(__self__, "entity_source", entity_source)
        if exadata_display_name and not isinstance(exadata_display_name, str):
            raise TypeError("Expected argument 'exadata_display_name' to be a str")
        pulumi.set(__self__, "exadata_display_name", exadata_display_name)
        if exadata_infra_id and not isinstance(exadata_infra_id, str):
            raise TypeError("Expected argument 'exadata_infra_id' to be a str")
        pulumi.set(__self__, "exadata_infra_id", exadata_infra_id)
        if exadata_infra_resource_type and not isinstance(exadata_infra_resource_type, str):
            raise TypeError("Expected argument 'exadata_infra_resource_type' to be a str")
        pulumi.set(__self__, "exadata_infra_resource_type", exadata_infra_resource_type)
        if exadata_insight_id and not isinstance(exadata_insight_id, str):
            raise TypeError("Expected argument 'exadata_insight_id' to be a str")
        pulumi.set(__self__, "exadata_insight_id", exadata_insight_id)
        if exadata_name and not isinstance(exadata_name, str):
            raise TypeError("Expected argument 'exadata_name' to be a str")
        pulumi.set(__self__, "exadata_name", exadata_name)
        if exadata_rack_type and not isinstance(exadata_rack_type, str):
            raise TypeError("Expected argument 'exadata_rack_type' to be a str")
        pulumi.set(__self__, "exadata_rack_type", exadata_rack_type)
        if exadata_shape and not isinstance(exadata_shape, str):
            raise TypeError("Expected argument 'exadata_shape' to be a str")
        pulumi.set(__self__, "exadata_shape", exadata_shape)
        if exadata_type and not isinstance(exadata_type, str):
            raise TypeError("Expected argument 'exadata_type' to be a str")
        pulumi.set(__self__, "exadata_type", exadata_type)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_sync_enabled and not isinstance(is_auto_sync_enabled, bool):
            raise TypeError("Expected argument 'is_auto_sync_enabled' to be a bool")
        pulumi.set(__self__, "is_auto_sync_enabled", is_auto_sync_enabled)
        if is_virtualized_exadata and not isinstance(is_virtualized_exadata, bool):
            raise TypeError("Expected argument 'is_virtualized_exadata' to be a bool")
        pulumi.set(__self__, "is_virtualized_exadata", is_virtualized_exadata)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if member_vm_cluster_details and not isinstance(member_vm_cluster_details, list):
            raise TypeError("Expected argument 'member_vm_cluster_details' to be a list")
        pulumi.set(__self__, "member_vm_cluster_details", member_vm_cluster_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment identifier of the Exadata insight resource
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> str:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @property
    @pulumi.getter(name="enterpriseManagerEntityDisplayName")
    def enterprise_manager_entity_display_name(self) -> str:
        """
        Enterprise Manager Entity Display Name
        """
        return pulumi.get(self, "enterprise_manager_entity_display_name")

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> str:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @property
    @pulumi.getter(name="enterpriseManagerEntityName")
    def enterprise_manager_entity_name(self) -> str:
        """
        Enterprise Manager Entity Name
        """
        return pulumi.get(self, "enterprise_manager_entity_name")

    @property
    @pulumi.getter(name="enterpriseManagerEntityType")
    def enterprise_manager_entity_type(self) -> str:
        """
        Enterprise Manager Entity Type
        """
        return pulumi.get(self, "enterprise_manager_entity_type")

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> str:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> str:
        """
        Source of the Exadata system.
        """
        return pulumi.get(self, "entity_source")

    @property
    @pulumi.getter(name="exadataDisplayName")
    def exadata_display_name(self) -> str:
        """
        The user-friendly name for the Exadata system. The name does not have to be unique.
        """
        return pulumi.get(self, "exadata_display_name")

    @property
    @pulumi.getter(name="exadataInfraId")
    def exadata_infra_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Infrastructure.
        """
        return pulumi.get(self, "exadata_infra_id")

    @property
    @pulumi.getter(name="exadataInfraResourceType")
    def exadata_infra_resource_type(self) -> str:
        """
        Oracle Cloud Infrastructure exadata infrastructure resource type
        """
        return pulumi.get(self, "exadata_infra_resource_type")

    @property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> str:
        return pulumi.get(self, "exadata_insight_id")

    @property
    @pulumi.getter(name="exadataName")
    def exadata_name(self) -> str:
        """
        The Exadata system name. If the Exadata systems managed by Enterprise Manager, the name is unique amongst the Exadata systems managed by the same Enterprise Manager.
        """
        return pulumi.get(self, "exadata_name")

    @property
    @pulumi.getter(name="exadataRackType")
    def exadata_rack_type(self) -> str:
        """
        Exadata rack type.
        """
        return pulumi.get(self, "exadata_rack_type")

    @property
    @pulumi.getter(name="exadataShape")
    def exadata_shape(self) -> str:
        """
        The shape of the Exadata Infrastructure.
        """
        return pulumi.get(self, "exadata_shape")

    @property
    @pulumi.getter(name="exadataType")
    def exadata_type(self) -> str:
        """
        Operations Insights internal representation of the the Exadata system type.
        """
        return pulumi.get(self, "exadata_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Exadata insight identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoSyncEnabled")
    def is_auto_sync_enabled(self) -> bool:
        return pulumi.get(self, "is_auto_sync_enabled")

    @property
    @pulumi.getter(name="isVirtualizedExadata")
    def is_virtualized_exadata(self) -> bool:
        """
        true if virtualization is used in the Exadata system
        """
        return pulumi.get(self, "is_virtualized_exadata")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="memberVmClusterDetails")
    def member_vm_cluster_details(self) -> Sequence['outputs.GetExadataInsightMemberVmClusterDetailResult']:
        return pulumi.get(self, "member_vm_cluster_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Exadata insight.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the status of an Exadata insight in Operations Insights
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the Exadata insight was first enabled. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Exadata insight was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetExadataInsightResult(GetExadataInsightResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExadataInsightResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            enterprise_manager_bridge_id=self.enterprise_manager_bridge_id,
            enterprise_manager_entity_display_name=self.enterprise_manager_entity_display_name,
            enterprise_manager_entity_identifier=self.enterprise_manager_entity_identifier,
            enterprise_manager_entity_name=self.enterprise_manager_entity_name,
            enterprise_manager_entity_type=self.enterprise_manager_entity_type,
            enterprise_manager_identifier=self.enterprise_manager_identifier,
            entity_source=self.entity_source,
            exadata_display_name=self.exadata_display_name,
            exadata_infra_id=self.exadata_infra_id,
            exadata_infra_resource_type=self.exadata_infra_resource_type,
            exadata_insight_id=self.exadata_insight_id,
            exadata_name=self.exadata_name,
            exadata_rack_type=self.exadata_rack_type,
            exadata_shape=self.exadata_shape,
            exadata_type=self.exadata_type,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_auto_sync_enabled=self.is_auto_sync_enabled,
            is_virtualized_exadata=self.is_virtualized_exadata,
            lifecycle_details=self.lifecycle_details,
            member_vm_cluster_details=self.member_vm_cluster_details,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_exadata_insight(exadata_insight_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExadataInsightResult:
    """
    This data source provides details about a specific Exadata Insight resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of an Exadata insight.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadata_insight = oci.Opsi.get_exadata_insight(exadata_insight_id=oci_opsi_exadata_insight["test_exadata_insight"]["id"])
    ```


    :param str exadata_insight_id: Unique Exadata insight identifier
    """
    __args__ = dict()
    __args__['exadataInsightId'] = exadata_insight_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getExadataInsight:getExadataInsight', __args__, opts=opts, typ=GetExadataInsightResult).value

    return AwaitableGetExadataInsightResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        enterprise_manager_bridge_id=pulumi.get(__ret__, 'enterprise_manager_bridge_id'),
        enterprise_manager_entity_display_name=pulumi.get(__ret__, 'enterprise_manager_entity_display_name'),
        enterprise_manager_entity_identifier=pulumi.get(__ret__, 'enterprise_manager_entity_identifier'),
        enterprise_manager_entity_name=pulumi.get(__ret__, 'enterprise_manager_entity_name'),
        enterprise_manager_entity_type=pulumi.get(__ret__, 'enterprise_manager_entity_type'),
        enterprise_manager_identifier=pulumi.get(__ret__, 'enterprise_manager_identifier'),
        entity_source=pulumi.get(__ret__, 'entity_source'),
        exadata_display_name=pulumi.get(__ret__, 'exadata_display_name'),
        exadata_infra_id=pulumi.get(__ret__, 'exadata_infra_id'),
        exadata_infra_resource_type=pulumi.get(__ret__, 'exadata_infra_resource_type'),
        exadata_insight_id=pulumi.get(__ret__, 'exadata_insight_id'),
        exadata_name=pulumi.get(__ret__, 'exadata_name'),
        exadata_rack_type=pulumi.get(__ret__, 'exadata_rack_type'),
        exadata_shape=pulumi.get(__ret__, 'exadata_shape'),
        exadata_type=pulumi.get(__ret__, 'exadata_type'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_sync_enabled=pulumi.get(__ret__, 'is_auto_sync_enabled'),
        is_virtualized_exadata=pulumi.get(__ret__, 'is_virtualized_exadata'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        member_vm_cluster_details=pulumi.get(__ret__, 'member_vm_cluster_details'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_exadata_insight)
def get_exadata_insight_output(exadata_insight_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExadataInsightResult]:
    """
    This data source provides details about a specific Exadata Insight resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of an Exadata insight.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadata_insight = oci.Opsi.get_exadata_insight(exadata_insight_id=oci_opsi_exadata_insight["test_exadata_insight"]["id"])
    ```


    :param str exadata_insight_id: Unique Exadata insight identifier
    """
    ...
