# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'VbInstanceAlternateCustomEndpointArgs',
    'VbInstanceAttachmentArgs',
    'VbInstanceCustomEndpointArgs',
    'VbInstanceIdcsInfoArgs',
    'GetVbInstancesFilterArgs',
]

@pulumi.input_type
class VbInstanceAlternateCustomEndpointArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str],
                 certificate_secret_id: Optional[pulumi.Input[str]] = None,
                 certificate_secret_version: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] hostname: (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        :param pulumi.Input[str] certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param pulumi.Input[int] certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        VbInstanceAlternateCustomEndpointArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hostname=hostname,
            certificate_secret_id=certificate_secret_id,
            certificate_secret_version=certificate_secret_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hostname: pulumi.Input[str],
             certificate_secret_id: Optional[pulumi.Input[str]] = None,
             certificate_secret_version: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'certificateSecretId' in kwargs:
            certificate_secret_id = kwargs['certificateSecretId']
        if 'certificateSecretVersion' in kwargs:
            certificate_secret_version = kwargs['certificateSecretVersion']

        _setter("hostname", hostname)
        if certificate_secret_id is not None:
            _setter("certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            _setter("certificate_secret_version", certificate_secret_version)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @certificate_secret_id.setter
    def certificate_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_secret_id", value)

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[pulumi.Input[int]]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @certificate_secret_version.setter
    def certificate_secret_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "certificate_secret_version", value)


@pulumi.input_type
class VbInstanceAttachmentArgs:
    def __init__(__self__, *,
                 is_implicit: Optional[pulumi.Input[bool]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_instance_url: Optional[pulumi.Input[str]] = None,
                 target_role: Optional[pulumi.Input[str]] = None,
                 target_service_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param pulumi.Input[str] target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param pulumi.Input[str] target_instance_url: The dataplane instance URL of the attached instance
        :param pulumi.Input[str] target_role: The role of the target attachment.
        :param pulumi.Input[str] target_service_type: The type of the target instance, such as "FUSION".
        """
        VbInstanceAttachmentArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_implicit=is_implicit,
            target_id=target_id,
            target_instance_url=target_instance_url,
            target_role=target_role,
            target_service_type=target_service_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_implicit: Optional[pulumi.Input[bool]] = None,
             target_id: Optional[pulumi.Input[str]] = None,
             target_instance_url: Optional[pulumi.Input[str]] = None,
             target_role: Optional[pulumi.Input[str]] = None,
             target_service_type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isImplicit' in kwargs:
            is_implicit = kwargs['isImplicit']
        if 'targetId' in kwargs:
            target_id = kwargs['targetId']
        if 'targetInstanceUrl' in kwargs:
            target_instance_url = kwargs['targetInstanceUrl']
        if 'targetRole' in kwargs:
            target_role = kwargs['targetRole']
        if 'targetServiceType' in kwargs:
            target_service_type = kwargs['targetServiceType']

        if is_implicit is not None:
            _setter("is_implicit", is_implicit)
        if target_id is not None:
            _setter("target_id", target_id)
        if target_instance_url is not None:
            _setter("target_instance_url", target_instance_url)
        if target_role is not None:
            _setter("target_role", target_role)
        if target_service_type is not None:
            _setter("target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> Optional[pulumi.Input[bool]]:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @is_implicit.setter
    def is_implicit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_implicit", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> Optional[pulumi.Input[str]]:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @target_instance_url.setter
    def target_instance_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_instance_url", value)

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of the target attachment.
        """
        return pulumi.get(self, "target_role")

    @target_role.setter
    def target_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_role", value)

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")

    @target_service_type.setter
    def target_service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_service_type", value)


@pulumi.input_type
class VbInstanceCustomEndpointArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str],
                 certificate_secret_id: Optional[pulumi.Input[str]] = None,
                 certificate_secret_version: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] hostname: (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        :param pulumi.Input[str] certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param pulumi.Input[int] certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        VbInstanceCustomEndpointArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hostname=hostname,
            certificate_secret_id=certificate_secret_id,
            certificate_secret_version=certificate_secret_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hostname: pulumi.Input[str],
             certificate_secret_id: Optional[pulumi.Input[str]] = None,
             certificate_secret_version: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'certificateSecretId' in kwargs:
            certificate_secret_id = kwargs['certificateSecretId']
        if 'certificateSecretVersion' in kwargs:
            certificate_secret_version = kwargs['certificateSecretVersion']

        _setter("hostname", hostname)
        if certificate_secret_id is not None:
            _setter("certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            _setter("certificate_secret_version", certificate_secret_version)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @certificate_secret_id.setter
    def certificate_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_secret_id", value)

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[pulumi.Input[int]]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @certificate_secret_version.setter
    def certificate_secret_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "certificate_secret_version", value)


@pulumi.input_type
class VbInstanceIdcsInfoArgs:
    def __init__(__self__, *,
                 idcs_app_display_name: Optional[pulumi.Input[str]] = None,
                 idcs_app_id: Optional[pulumi.Input[str]] = None,
                 idcs_app_location_url: Optional[pulumi.Input[str]] = None,
                 idcs_app_name: Optional[pulumi.Input[str]] = None,
                 instance_primary_audience_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] idcs_app_display_name: The IDCS application display name associated with the instance
        :param pulumi.Input[str] idcs_app_id: The IDCS application ID associated with the instance
        :param pulumi.Input[str] idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param pulumi.Input[str] idcs_app_name: The IDCS application name associated with the instance
        :param pulumi.Input[str] instance_primary_audience_url: The URL used as the primary audience for visual builder flows in this instance type: string
        """
        VbInstanceIdcsInfoArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            idcs_app_display_name=idcs_app_display_name,
            idcs_app_id=idcs_app_id,
            idcs_app_location_url=idcs_app_location_url,
            idcs_app_name=idcs_app_name,
            instance_primary_audience_url=instance_primary_audience_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             idcs_app_display_name: Optional[pulumi.Input[str]] = None,
             idcs_app_id: Optional[pulumi.Input[str]] = None,
             idcs_app_location_url: Optional[pulumi.Input[str]] = None,
             idcs_app_name: Optional[pulumi.Input[str]] = None,
             instance_primary_audience_url: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'idcsAppDisplayName' in kwargs:
            idcs_app_display_name = kwargs['idcsAppDisplayName']
        if 'idcsAppId' in kwargs:
            idcs_app_id = kwargs['idcsAppId']
        if 'idcsAppLocationUrl' in kwargs:
            idcs_app_location_url = kwargs['idcsAppLocationUrl']
        if 'idcsAppName' in kwargs:
            idcs_app_name = kwargs['idcsAppName']
        if 'instancePrimaryAudienceUrl' in kwargs:
            instance_primary_audience_url = kwargs['instancePrimaryAudienceUrl']

        if idcs_app_display_name is not None:
            _setter("idcs_app_display_name", idcs_app_display_name)
        if idcs_app_id is not None:
            _setter("idcs_app_id", idcs_app_id)
        if idcs_app_location_url is not None:
            _setter("idcs_app_location_url", idcs_app_location_url)
        if idcs_app_name is not None:
            _setter("idcs_app_name", idcs_app_name)
        if instance_primary_audience_url is not None:
            _setter("instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @idcs_app_display_name.setter
    def idcs_app_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_app_display_name", value)

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @idcs_app_id.setter
    def idcs_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_app_id", value)

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @idcs_app_location_url.setter
    def idcs_app_location_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_app_location_url", value)

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> Optional[pulumi.Input[str]]:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @idcs_app_name.setter
    def idcs_app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_app_name", value)

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL used as the primary audience for visual builder flows in this instance type: string
        """
        return pulumi.get(self, "instance_primary_audience_url")

    @instance_primary_audience_url.setter
    def instance_primary_audience_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_primary_audience_url", value)


@pulumi.input_type
class GetVbInstancesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetVbInstancesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


