# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'VbInstanceAlternateCustomEndpoint',
    'VbInstanceAttachment',
    'VbInstanceCustomEndpoint',
    'VbInstanceIdcsInfo',
    'GetVbInstanceAlternateCustomEndpointResult',
    'GetVbInstanceApplicationsApplicationSummaryCollectionResult',
    'GetVbInstanceApplicationsApplicationSummaryCollectionItemResult',
    'GetVbInstanceAttachmentResult',
    'GetVbInstanceCustomEndpointResult',
    'GetVbInstanceIdcsInfoResult',
    'GetVbInstancesFilterResult',
    'GetVbInstancesVbInstanceSummaryCollectionResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemAttachmentResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemIdcsInfoResult',
]

@pulumi.output_type
class VbInstanceAlternateCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceAlternateCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 certificate_secret_id: Optional[str] = None,
                 certificate_secret_version: Optional[int] = None):
        """
        :param str hostname: (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        :param str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        VbInstanceAlternateCustomEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hostname=hostname,
            certificate_secret_id=certificate_secret_id,
            certificate_secret_version=certificate_secret_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hostname: str,
             certificate_secret_id: Optional[str] = None,
             certificate_secret_version: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'certificateSecretId' in kwargs:
            certificate_secret_id = kwargs['certificateSecretId']
        if 'certificateSecretVersion' in kwargs:
            certificate_secret_version = kwargs['certificateSecretVersion']

        _setter("hostname", hostname)
        if certificate_secret_id is not None:
            _setter("certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            _setter("certificate_secret_version", certificate_secret_version)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")


@pulumi.output_type
class VbInstanceAttachment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isImplicit":
            suggest = "is_implicit"
        elif key == "targetId":
            suggest = "target_id"
        elif key == "targetInstanceUrl":
            suggest = "target_instance_url"
        elif key == "targetRole":
            suggest = "target_role"
        elif key == "targetServiceType":
            suggest = "target_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_implicit: Optional[bool] = None,
                 target_id: Optional[str] = None,
                 target_instance_url: Optional[str] = None,
                 target_role: Optional[str] = None,
                 target_service_type: Optional[str] = None):
        """
        :param bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param str target_instance_url: The dataplane instance URL of the attached instance
        :param str target_role: The role of the target attachment.
        :param str target_service_type: The type of the target instance, such as "FUSION".
        """
        VbInstanceAttachment._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_implicit=is_implicit,
            target_id=target_id,
            target_instance_url=target_instance_url,
            target_role=target_role,
            target_service_type=target_service_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_implicit: Optional[bool] = None,
             target_id: Optional[str] = None,
             target_instance_url: Optional[str] = None,
             target_role: Optional[str] = None,
             target_service_type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isImplicit' in kwargs:
            is_implicit = kwargs['isImplicit']
        if 'targetId' in kwargs:
            target_id = kwargs['targetId']
        if 'targetInstanceUrl' in kwargs:
            target_instance_url = kwargs['targetInstanceUrl']
        if 'targetRole' in kwargs:
            target_role = kwargs['targetRole']
        if 'targetServiceType' in kwargs:
            target_service_type = kwargs['targetServiceType']

        if is_implicit is not None:
            _setter("is_implicit", is_implicit)
        if target_id is not None:
            _setter("target_id", target_id)
        if target_instance_url is not None:
            _setter("target_instance_url", target_instance_url)
        if target_role is not None:
            _setter("target_role", target_role)
        if target_service_type is not None:
            _setter("target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> Optional[bool]:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> Optional[str]:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> Optional[str]:
        """
        The role of the target attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> Optional[str]:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class VbInstanceCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 certificate_secret_id: Optional[str] = None,
                 certificate_secret_version: Optional[int] = None):
        """
        :param str hostname: (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        :param str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        VbInstanceCustomEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hostname=hostname,
            certificate_secret_id=certificate_secret_id,
            certificate_secret_version=certificate_secret_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hostname: str,
             certificate_secret_id: Optional[str] = None,
             certificate_secret_version: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'certificateSecretId' in kwargs:
            certificate_secret_id = kwargs['certificateSecretId']
        if 'certificateSecretVersion' in kwargs:
            certificate_secret_version = kwargs['certificateSecretVersion']

        _setter("hostname", hostname)
        if certificate_secret_id is not None:
            _setter("certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            _setter("certificate_secret_version", certificate_secret_version)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")


@pulumi.output_type
class VbInstanceIdcsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idcsAppDisplayName":
            suggest = "idcs_app_display_name"
        elif key == "idcsAppId":
            suggest = "idcs_app_id"
        elif key == "idcsAppLocationUrl":
            suggest = "idcs_app_location_url"
        elif key == "idcsAppName":
            suggest = "idcs_app_name"
        elif key == "instancePrimaryAudienceUrl":
            suggest = "instance_primary_audience_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceIdcsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceIdcsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceIdcsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idcs_app_display_name: Optional[str] = None,
                 idcs_app_id: Optional[str] = None,
                 idcs_app_location_url: Optional[str] = None,
                 idcs_app_name: Optional[str] = None,
                 instance_primary_audience_url: Optional[str] = None):
        """
        :param str idcs_app_display_name: The IDCS application display name associated with the instance
        :param str idcs_app_id: The IDCS application ID associated with the instance
        :param str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param str idcs_app_name: The IDCS application name associated with the instance
        :param str instance_primary_audience_url: The URL used as the primary audience for visual builder flows in this instance type: string
        """
        VbInstanceIdcsInfo._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            idcs_app_display_name=idcs_app_display_name,
            idcs_app_id=idcs_app_id,
            idcs_app_location_url=idcs_app_location_url,
            idcs_app_name=idcs_app_name,
            instance_primary_audience_url=instance_primary_audience_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             idcs_app_display_name: Optional[str] = None,
             idcs_app_id: Optional[str] = None,
             idcs_app_location_url: Optional[str] = None,
             idcs_app_name: Optional[str] = None,
             instance_primary_audience_url: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'idcsAppDisplayName' in kwargs:
            idcs_app_display_name = kwargs['idcsAppDisplayName']
        if 'idcsAppId' in kwargs:
            idcs_app_id = kwargs['idcsAppId']
        if 'idcsAppLocationUrl' in kwargs:
            idcs_app_location_url = kwargs['idcsAppLocationUrl']
        if 'idcsAppName' in kwargs:
            idcs_app_name = kwargs['idcsAppName']
        if 'instancePrimaryAudienceUrl' in kwargs:
            instance_primary_audience_url = kwargs['instancePrimaryAudienceUrl']

        if idcs_app_display_name is not None:
            _setter("idcs_app_display_name", idcs_app_display_name)
        if idcs_app_id is not None:
            _setter("idcs_app_id", idcs_app_id)
        if idcs_app_location_url is not None:
            _setter("idcs_app_location_url", idcs_app_location_url)
        if idcs_app_name is not None:
            _setter("idcs_app_name", idcs_app_name)
        if instance_primary_audience_url is not None:
            _setter("instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> Optional[str]:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> Optional[str]:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> Optional[str]:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> Optional[str]:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> Optional[str]:
        """
        The URL used as the primary audience for visual builder flows in this instance type: string
        """
        return pulumi.get(self, "instance_primary_audience_url")


@pulumi.output_type
class GetVbInstanceAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: str,
                 certificate_secret_version: int,
                 hostname: str):
        """
        :param str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        GetVbInstanceAlternateCustomEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            certificate_secret_id=certificate_secret_id,
            certificate_secret_version=certificate_secret_version,
            hostname=hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             certificate_secret_id: str,
             certificate_secret_version: int,
             hostname: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'certificateSecretId' in kwargs:
            certificate_secret_id = kwargs['certificateSecretId']
        if 'certificateSecretVersion' in kwargs:
            certificate_secret_version = kwargs['certificateSecretVersion']

        _setter("certificate_secret_id", certificate_secret_id)
        _setter("certificate_secret_version", certificate_secret_version)
        _setter("hostname", hostname)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstanceApplicationsApplicationSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVbInstanceApplicationsApplicationSummaryCollectionItemResult']):
        GetVbInstanceApplicationsApplicationSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetVbInstanceApplicationsApplicationSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVbInstanceApplicationsApplicationSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVbInstanceApplicationsApplicationSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: str,
                 project_id: str,
                 state: str,
                 version: str):
        """
        :param str id: The Visual Builder application identifier.
        :param str project_id: The Visual Builder application project identifier.
        :param str state: The state of visual builder application. Either LIVE or STAGED
        :param str version: The Visual Builder application version
        """
        GetVbInstanceApplicationsApplicationSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            project_id=project_id,
            state=state,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: str,
             project_id: str,
             state: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']

        _setter("id", id)
        _setter("project_id", project_id)
        _setter("state", state)
        _setter("version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Visual Builder application identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The Visual Builder application project identifier.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of visual builder application. Either LIVE or STAGED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Visual Builder application version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetVbInstanceAttachmentResult(dict):
    def __init__(__self__, *,
                 is_implicit: bool,
                 target_id: str,
                 target_instance_url: str,
                 target_role: str,
                 target_service_type: str):
        """
        :param bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param str target_instance_url: The dataplane instance URL of the attached instance
        :param str target_role: The role of the target attachment.
        :param str target_service_type: The type of the target instance, such as "FUSION".
        """
        GetVbInstanceAttachmentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_implicit=is_implicit,
            target_id=target_id,
            target_instance_url=target_instance_url,
            target_role=target_role,
            target_service_type=target_service_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_implicit: bool,
             target_id: str,
             target_instance_url: str,
             target_role: str,
             target_service_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isImplicit' in kwargs:
            is_implicit = kwargs['isImplicit']
        if 'targetId' in kwargs:
            target_id = kwargs['targetId']
        if 'targetInstanceUrl' in kwargs:
            target_instance_url = kwargs['targetInstanceUrl']
        if 'targetRole' in kwargs:
            target_role = kwargs['targetRole']
        if 'targetServiceType' in kwargs:
            target_service_type = kwargs['targetServiceType']

        _setter("is_implicit", is_implicit)
        _setter("target_id", target_id)
        _setter("target_instance_url", target_instance_url)
        _setter("target_role", target_role)
        _setter("target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> bool:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> str:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> str:
        """
        The role of the target attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> str:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class GetVbInstanceCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: str,
                 certificate_secret_version: int,
                 hostname: str):
        """
        :param str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        GetVbInstanceCustomEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            certificate_secret_id=certificate_secret_id,
            certificate_secret_version=certificate_secret_version,
            hostname=hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             certificate_secret_id: str,
             certificate_secret_version: int,
             hostname: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'certificateSecretId' in kwargs:
            certificate_secret_id = kwargs['certificateSecretId']
        if 'certificateSecretVersion' in kwargs:
            certificate_secret_version = kwargs['certificateSecretVersion']

        _setter("certificate_secret_id", certificate_secret_id)
        _setter("certificate_secret_version", certificate_secret_version)
        _setter("hostname", hostname)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstanceIdcsInfoResult(dict):
    def __init__(__self__, *,
                 idcs_app_display_name: str,
                 idcs_app_id: str,
                 idcs_app_location_url: str,
                 idcs_app_name: str,
                 instance_primary_audience_url: str):
        """
        :param str idcs_app_display_name: The IDCS application display name associated with the instance
        :param str idcs_app_id: The IDCS application ID associated with the instance
        :param str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param str idcs_app_name: The IDCS application name associated with the instance
        :param str instance_primary_audience_url: The URL used as the primary audience for visual builder flows in this instance type: string
        """
        GetVbInstanceIdcsInfoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            idcs_app_display_name=idcs_app_display_name,
            idcs_app_id=idcs_app_id,
            idcs_app_location_url=idcs_app_location_url,
            idcs_app_name=idcs_app_name,
            instance_primary_audience_url=instance_primary_audience_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             idcs_app_display_name: str,
             idcs_app_id: str,
             idcs_app_location_url: str,
             idcs_app_name: str,
             instance_primary_audience_url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'idcsAppDisplayName' in kwargs:
            idcs_app_display_name = kwargs['idcsAppDisplayName']
        if 'idcsAppId' in kwargs:
            idcs_app_id = kwargs['idcsAppId']
        if 'idcsAppLocationUrl' in kwargs:
            idcs_app_location_url = kwargs['idcsAppLocationUrl']
        if 'idcsAppName' in kwargs:
            idcs_app_name = kwargs['idcsAppName']
        if 'instancePrimaryAudienceUrl' in kwargs:
            instance_primary_audience_url = kwargs['instancePrimaryAudienceUrl']

        _setter("idcs_app_display_name", idcs_app_display_name)
        _setter("idcs_app_id", idcs_app_id)
        _setter("idcs_app_location_url", idcs_app_location_url)
        _setter("idcs_app_name", idcs_app_name)
        _setter("instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> str:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> str:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> str:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> str:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> str:
        """
        The URL used as the primary audience for visual builder flows in this instance type: string
        """
        return pulumi.get(self, "instance_primary_audience_url")


@pulumi.output_type
class GetVbInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetVbInstancesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemResult']):
        GetVbInstancesVbInstanceSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 alternate_custom_endpoints: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult'],
                 attachments: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAttachmentResult'],
                 compartment_id: str,
                 consumption_model: str,
                 custom_endpoints: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 idcs_infos: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemIdcsInfoResult'],
                 idcs_open_id: str,
                 instance_url: str,
                 is_visual_builder_enabled: bool,
                 management_nat_gateway_ip: str,
                 management_vcn_id: str,
                 node_count: int,
                 service_nat_gateway_ip: str,
                 service_vcn_id: str,
                 state: str,
                 state_message: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointArgs'] alternate_custom_endpoints: A list of alternate custom endpoints used for the vb instance URL.
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemAttachmentArgs'] attachments: A list of associated attachments to other services
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str consumption_model: The entitlement used for billing purposes.
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointArgs'] custom_endpoints: Details for a custom endpoint for the vb instance.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier that is immutable on creation.
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemIdcsInfoArgs'] idcs_infos: Information for IDCS access
        :param str instance_url: The Vb Instance URL.
        :param bool is_visual_builder_enabled: Visual Builder is enabled or not.
        :param str management_nat_gateway_ip: The NAT gateway IP address for the VB management VCN
        :param str management_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        :param int node_count: The number of Nodes
        :param str service_nat_gateway_ip: The NAT gateway IP address for the VB service VCN
        :param str service_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        :param str state: Life cycle state to query on.
        :param str state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the the VbInstance was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        GetVbInstancesVbInstanceSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            alternate_custom_endpoints=alternate_custom_endpoints,
            attachments=attachments,
            compartment_id=compartment_id,
            consumption_model=consumption_model,
            custom_endpoints=custom_endpoints,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            idcs_infos=idcs_infos,
            idcs_open_id=idcs_open_id,
            instance_url=instance_url,
            is_visual_builder_enabled=is_visual_builder_enabled,
            management_nat_gateway_ip=management_nat_gateway_ip,
            management_vcn_id=management_vcn_id,
            node_count=node_count,
            service_nat_gateway_ip=service_nat_gateway_ip,
            service_vcn_id=service_vcn_id,
            state=state,
            state_message=state_message,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             alternate_custom_endpoints: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult'],
             attachments: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAttachmentResult'],
             compartment_id: str,
             consumption_model: str,
             custom_endpoints: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult'],
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             idcs_infos: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemIdcsInfoResult'],
             idcs_open_id: str,
             instance_url: str,
             is_visual_builder_enabled: bool,
             management_nat_gateway_ip: str,
             management_vcn_id: str,
             node_count: int,
             service_nat_gateway_ip: str,
             service_vcn_id: str,
             state: str,
             state_message: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'alternateCustomEndpoints' in kwargs:
            alternate_custom_endpoints = kwargs['alternateCustomEndpoints']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'consumptionModel' in kwargs:
            consumption_model = kwargs['consumptionModel']
        if 'customEndpoints' in kwargs:
            custom_endpoints = kwargs['customEndpoints']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'idcsInfos' in kwargs:
            idcs_infos = kwargs['idcsInfos']
        if 'idcsOpenId' in kwargs:
            idcs_open_id = kwargs['idcsOpenId']
        if 'instanceUrl' in kwargs:
            instance_url = kwargs['instanceUrl']
        if 'isVisualBuilderEnabled' in kwargs:
            is_visual_builder_enabled = kwargs['isVisualBuilderEnabled']
        if 'managementNatGatewayIp' in kwargs:
            management_nat_gateway_ip = kwargs['managementNatGatewayIp']
        if 'managementVcnId' in kwargs:
            management_vcn_id = kwargs['managementVcnId']
        if 'nodeCount' in kwargs:
            node_count = kwargs['nodeCount']
        if 'serviceNatGatewayIp' in kwargs:
            service_nat_gateway_ip = kwargs['serviceNatGatewayIp']
        if 'serviceVcnId' in kwargs:
            service_vcn_id = kwargs['serviceVcnId']
        if 'stateMessage' in kwargs:
            state_message = kwargs['stateMessage']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("alternate_custom_endpoints", alternate_custom_endpoints)
        _setter("attachments", attachments)
        _setter("compartment_id", compartment_id)
        _setter("consumption_model", consumption_model)
        _setter("custom_endpoints", custom_endpoints)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("idcs_infos", idcs_infos)
        _setter("idcs_open_id", idcs_open_id)
        _setter("instance_url", instance_url)
        _setter("is_visual_builder_enabled", is_visual_builder_enabled)
        _setter("management_nat_gateway_ip", management_nat_gateway_ip)
        _setter("management_vcn_id", management_vcn_id)
        _setter("node_count", node_count)
        _setter("service_nat_gateway_ip", service_nat_gateway_ip)
        _setter("service_vcn_id", service_vcn_id)
        _setter("state", state)
        _setter("state_message", state_message)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult']:
        """
        A list of alternate custom endpoints used for the vb instance URL.
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAttachmentResult']:
        """
        A list of associated attachments to other services
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> str:
        """
        The entitlement used for billing purposes.
        """
        return pulumi.get(self, "consumption_model")

    @property
    @pulumi.getter(name="customEndpoints")
    def custom_endpoints(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult']:
        """
        Details for a custom endpoint for the vb instance.
        """
        return pulumi.get(self, "custom_endpoints")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsInfos")
    def idcs_infos(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemIdcsInfoResult']:
        """
        Information for IDCS access
        """
        return pulumi.get(self, "idcs_infos")

    @property
    @pulumi.getter(name="idcsOpenId")
    def idcs_open_id(self) -> str:
        return pulumi.get(self, "idcs_open_id")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The Vb Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> bool:
        """
        Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @property
    @pulumi.getter(name="managementNatGatewayIp")
    def management_nat_gateway_ip(self) -> str:
        """
        The NAT gateway IP address for the VB management VCN
        """
        return pulumi.get(self, "management_nat_gateway_ip")

    @property
    @pulumi.getter(name="managementVcnId")
    def management_vcn_id(self) -> str:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        """
        return pulumi.get(self, "management_vcn_id")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of Nodes
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="serviceNatGatewayIp")
    def service_nat_gateway_ip(self) -> str:
        """
        The NAT gateway IP address for the VB service VCN
        """
        return pulumi.get(self, "service_nat_gateway_ip")

    @property
    @pulumi.getter(name="serviceVcnId")
    def service_vcn_id(self) -> str:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        """
        return pulumi.get(self, "service_vcn_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Life cycle state to query on.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the VbInstance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: str,
                 certificate_secret_version: int,
                 hostname: str):
        """
        :param str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            certificate_secret_id=certificate_secret_id,
            certificate_secret_version=certificate_secret_version,
            hostname=hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             certificate_secret_id: str,
             certificate_secret_version: int,
             hostname: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'certificateSecretId' in kwargs:
            certificate_secret_id = kwargs['certificateSecretId']
        if 'certificateSecretVersion' in kwargs:
            certificate_secret_version = kwargs['certificateSecretVersion']

        _setter("certificate_secret_id", certificate_secret_id)
        _setter("certificate_secret_version", certificate_secret_version)
        _setter("hostname", hostname)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemAttachmentResult(dict):
    def __init__(__self__, *,
                 is_implicit: bool,
                 target_id: str,
                 target_instance_url: str,
                 target_role: str,
                 target_service_type: str):
        """
        :param bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param str target_instance_url: The dataplane instance URL of the attached instance
        :param str target_role: The role of the target attachment.
        :param str target_service_type: The type of the target instance, such as "FUSION".
        """
        GetVbInstancesVbInstanceSummaryCollectionItemAttachmentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_implicit=is_implicit,
            target_id=target_id,
            target_instance_url=target_instance_url,
            target_role=target_role,
            target_service_type=target_service_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_implicit: bool,
             target_id: str,
             target_instance_url: str,
             target_role: str,
             target_service_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isImplicit' in kwargs:
            is_implicit = kwargs['isImplicit']
        if 'targetId' in kwargs:
            target_id = kwargs['targetId']
        if 'targetInstanceUrl' in kwargs:
            target_instance_url = kwargs['targetInstanceUrl']
        if 'targetRole' in kwargs:
            target_role = kwargs['targetRole']
        if 'targetServiceType' in kwargs:
            target_service_type = kwargs['targetServiceType']

        _setter("is_implicit", is_implicit)
        _setter("target_id", target_id)
        _setter("target_instance_url", target_instance_url)
        _setter("target_role", target_role)
        _setter("target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> bool:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> str:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> str:
        """
        The role of the target attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> str:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: str,
                 certificate_secret_version: int,
                 hostname: str):
        """
        :param str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            certificate_secret_id=certificate_secret_id,
            certificate_secret_version=certificate_secret_version,
            hostname=hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             certificate_secret_id: str,
             certificate_secret_version: int,
             hostname: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'certificateSecretId' in kwargs:
            certificate_secret_id = kwargs['certificateSecretId']
        if 'certificateSecretVersion' in kwargs:
            certificate_secret_version = kwargs['certificateSecretVersion']

        _setter("certificate_secret_id", certificate_secret_id)
        _setter("certificate_secret_version", certificate_secret_version)
        _setter("hostname", hostname)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemIdcsInfoResult(dict):
    def __init__(__self__, *,
                 idcs_app_display_name: str,
                 idcs_app_id: str,
                 idcs_app_location_url: str,
                 idcs_app_name: str,
                 instance_primary_audience_url: str):
        """
        :param str idcs_app_display_name: The IDCS application display name associated with the instance
        :param str idcs_app_id: The IDCS application ID associated with the instance
        :param str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param str idcs_app_name: The IDCS application name associated with the instance
        :param str instance_primary_audience_url: The URL used as the primary audience for visual builder flows in this instance type: string
        """
        GetVbInstancesVbInstanceSummaryCollectionItemIdcsInfoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            idcs_app_display_name=idcs_app_display_name,
            idcs_app_id=idcs_app_id,
            idcs_app_location_url=idcs_app_location_url,
            idcs_app_name=idcs_app_name,
            instance_primary_audience_url=instance_primary_audience_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             idcs_app_display_name: str,
             idcs_app_id: str,
             idcs_app_location_url: str,
             idcs_app_name: str,
             instance_primary_audience_url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'idcsAppDisplayName' in kwargs:
            idcs_app_display_name = kwargs['idcsAppDisplayName']
        if 'idcsAppId' in kwargs:
            idcs_app_id = kwargs['idcsAppId']
        if 'idcsAppLocationUrl' in kwargs:
            idcs_app_location_url = kwargs['idcsAppLocationUrl']
        if 'idcsAppName' in kwargs:
            idcs_app_name = kwargs['idcsAppName']
        if 'instancePrimaryAudienceUrl' in kwargs:
            instance_primary_audience_url = kwargs['instancePrimaryAudienceUrl']

        _setter("idcs_app_display_name", idcs_app_display_name)
        _setter("idcs_app_id", idcs_app_id)
        _setter("idcs_app_location_url", idcs_app_location_url)
        _setter("idcs_app_name", idcs_app_name)
        _setter("instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> str:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> str:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> str:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> str:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> str:
        """
        The URL used as the primary audience for visual builder flows in this instance type: string
        """
        return pulumi.get(self, "instance_primary_audience_url")


