# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HostScanTargetArgs', 'HostScanTarget']

@pulumi.input_type
class HostScanTargetArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 host_scan_recipe_id: pulumi.Input[str],
                 target_compartment_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a HostScanTarget resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment ID of the object (this).
        :param pulumi.Input[str] host_scan_recipe_id: (Updatable) ID of the host scan recipe this target applies.
        :param pulumi.Input[str] target_compartment_id: (Updatable) Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Target description.
        :param pulumi.Input[str] display_name: (Updatable) Target identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: (Updatable) List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.
        """
        HostScanTargetArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            host_scan_recipe_id=host_scan_recipe_id,
            target_compartment_id=target_compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            instance_ids=instance_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             host_scan_recipe_id: pulumi.Input[str],
             target_compartment_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'hostScanRecipeId' in kwargs:
            host_scan_recipe_id = kwargs['hostScanRecipeId']
        if 'targetCompartmentId' in kwargs:
            target_compartment_id = kwargs['targetCompartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'instanceIds' in kwargs:
            instance_ids = kwargs['instanceIds']

        _setter("compartment_id", compartment_id)
        _setter("host_scan_recipe_id", host_scan_recipe_id)
        _setter("target_compartment_id", target_compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if instance_ids is not None:
            _setter("instance_ids", instance_ids)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment ID of the object (this).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="hostScanRecipeId")
    def host_scan_recipe_id(self) -> pulumi.Input[str]:
        """
        (Updatable) ID of the host scan recipe this target applies.
        """
        return pulumi.get(self, "host_scan_recipe_id")

    @host_scan_recipe_id.setter
    def host_scan_recipe_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_scan_recipe_id", value)

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_compartment_id")

    @target_compartment_id.setter
    def target_compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Target description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Target identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_ids", value)


@pulumi.input_type
class _HostScanTargetState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_scan_recipe_id: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_compartment_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HostScanTarget resources.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment ID of the object (this).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Target description.
        :param pulumi.Input[str] display_name: (Updatable) Target identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_scan_recipe_id: (Updatable) ID of the host scan recipe this target applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: (Updatable) List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.
        :param pulumi.Input[str] state: The current state of the config.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_compartment_id: (Updatable) Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: Date and time the target was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[str] time_updated: Date and time the target was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        _HostScanTargetState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            host_scan_recipe_id=host_scan_recipe_id,
            instance_ids=instance_ids,
            state=state,
            system_tags=system_tags,
            target_compartment_id=target_compartment_id,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             host_scan_recipe_id: Optional[pulumi.Input[str]] = None,
             instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             target_compartment_id: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'hostScanRecipeId' in kwargs:
            host_scan_recipe_id = kwargs['hostScanRecipeId']
        if 'instanceIds' in kwargs:
            instance_ids = kwargs['instanceIds']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'targetCompartmentId' in kwargs:
            target_compartment_id = kwargs['targetCompartmentId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if host_scan_recipe_id is not None:
            _setter("host_scan_recipe_id", host_scan_recipe_id)
        if instance_ids is not None:
            _setter("instance_ids", instance_ids)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if target_compartment_id is not None:
            _setter("target_compartment_id", target_compartment_id)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment ID of the object (this).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Target description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Target identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostScanRecipeId")
    def host_scan_recipe_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) ID of the host scan recipe this target applies.
        """
        return pulumi.get(self, "host_scan_recipe_id")

    @host_scan_recipe_id.setter
    def host_scan_recipe_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_scan_recipe_id", value)

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_ids", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_compartment_id")

    @target_compartment_id.setter
    def target_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_compartment_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the target was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the target was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class HostScanTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_scan_recipe_id: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_compartment_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Host Scan Target resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

        Creates a new HostScanTarget. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_host_scan_target = oci.vulnerability_scanning.HostScanTarget("testHostScanTarget",
            compartment_id=var["compartment_id"],
            host_scan_recipe_id=oci_vulnerability_scanning_host_scan_recipe["test_host_scan_recipe"]["id"],
            target_compartment_id=oci_identity_compartment["test_compartment"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["host_scan_target_description"],
            display_name=var["host_scan_target_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            instance_ids=var["host_scan_target_instance_ids"])
        ```

        ## Import

        HostScanTargets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:VulnerabilityScanning/hostScanTarget:HostScanTarget test_host_scan_target "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment ID of the object (this).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Target description.
        :param pulumi.Input[str] display_name: (Updatable) Target identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_scan_recipe_id: (Updatable) ID of the host scan recipe this target applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: (Updatable) List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.
        :param pulumi.Input[str] target_compartment_id: (Updatable) Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostScanTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Host Scan Target resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

        Creates a new HostScanTarget. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_host_scan_target = oci.vulnerability_scanning.HostScanTarget("testHostScanTarget",
            compartment_id=var["compartment_id"],
            host_scan_recipe_id=oci_vulnerability_scanning_host_scan_recipe["test_host_scan_recipe"]["id"],
            target_compartment_id=oci_identity_compartment["test_compartment"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["host_scan_target_description"],
            display_name=var["host_scan_target_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            instance_ids=var["host_scan_target_instance_ids"])
        ```

        ## Import

        HostScanTargets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:VulnerabilityScanning/hostScanTarget:HostScanTarget test_host_scan_target "id"
        ```

        :param str resource_name: The name of the resource.
        :param HostScanTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostScanTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            HostScanTargetArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_scan_recipe_id: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_compartment_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostScanTargetArgs.__new__(HostScanTargetArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if host_scan_recipe_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_scan_recipe_id'")
            __props__.__dict__["host_scan_recipe_id"] = host_scan_recipe_id
            __props__.__dict__["instance_ids"] = instance_ids
            if target_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_compartment_id'")
            __props__.__dict__["target_compartment_id"] = target_compartment_id
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(HostScanTarget, __self__).__init__(
            'oci:VulnerabilityScanning/hostScanTarget:HostScanTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            host_scan_recipe_id: Optional[pulumi.Input[str]] = None,
            instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_compartment_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'HostScanTarget':
        """
        Get an existing HostScanTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment ID of the object (this).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Target description.
        :param pulumi.Input[str] display_name: (Updatable) Target identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_scan_recipe_id: (Updatable) ID of the host scan recipe this target applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: (Updatable) List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.
        :param pulumi.Input[str] state: The current state of the config.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_compartment_id: (Updatable) Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: Date and time the target was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[str] time_updated: Date and time the target was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostScanTargetState.__new__(_HostScanTargetState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host_scan_recipe_id"] = host_scan_recipe_id
        __props__.__dict__["instance_ids"] = instance_ids
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_compartment_id"] = target_compartment_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return HostScanTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment ID of the object (this).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Target description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Target identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostScanRecipeId")
    def host_scan_recipe_id(self) -> pulumi.Output[str]:
        """
        (Updatable) ID of the host scan recipe this target applies.
        """
        return pulumi.get(self, "host_scan_recipe_id")

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.
        """
        return pulumi.get(self, "instance_ids")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_compartment_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Date and time the target was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Date and time the target was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")

