/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import io.ray.api.options.BaseTaskOptions;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.api.runtimeenv.RuntimeEnv;
import java.util.HashMap;
import java.util.Map;

public class CallOptions
extends BaseTaskOptions {
    private final String name;
    private final PlacementGroup group;
    private final int bundleIndex;
    private final String concurrencyGroupName;
    private final String serializedRuntimeEnvInfo;

    private CallOptions(Builder builder) {
        super(builder.resources);
        this.name = builder.name;
        this.group = builder.group;
        this.bundleIndex = builder.bundleIndex;
        this.concurrencyGroupName = builder.concurrencyGroupName;
        this.serializedRuntimeEnvInfo = builder.runtimeEnv == null ? "" : builder.runtimeEnv.serializeToRuntimeEnvInfo();
    }

    public String getName() {
        return this.name;
    }

    public PlacementGroup getGroup() {
        return this.group;
    }

    public int getBundleIndex() {
        return this.bundleIndex;
    }

    public String getConcurrencyGroupName() {
        return this.concurrencyGroupName;
    }

    public String getSerializedRuntimeEnvInfo() {
        return this.serializedRuntimeEnvInfo;
    }

    public static class Builder {
        private String name;
        private Map<String, Double> resources = new HashMap<String, Double>();
        private PlacementGroup group;
        private int bundleIndex;
        private String concurrencyGroupName = "";
        private RuntimeEnv runtimeEnv = null;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setResource(String name, Double value) {
            this.resources.put(name, value);
            return this;
        }

        public Builder setResources(Map<String, Double> resources) {
            this.resources.putAll(resources);
            return this;
        }

        public Builder setPlacementGroup(PlacementGroup group, int bundleIndex) {
            this.group = group;
            this.bundleIndex = bundleIndex;
            return this;
        }

        public Builder setConcurrencyGroupName(String concurrencyGroupName) {
            this.concurrencyGroupName = concurrencyGroupName;
            return this;
        }

        public Builder setRuntimeEnv(RuntimeEnv runtimeEnv) {
            this.runtimeEnv = runtimeEnv;
            return this;
        }

        public CallOptions build() {
            return new CallOptions(this);
        }
    }
}

