from importlib import metadata

from ideas import exceptions

REQUIRED = [
    "beartype",
    "isx",
    "numpy",
    "pandas",
    "scipy",
    "scikit-image",
    "opencv-python",
    "matplotlib",
    "seaborn",
]

for mod in REQUIRED:
    try:
        metadata.distribution(mod)
    except metadata.PackageNotFoundError:
        raise exceptions.IdeasError(
            f"Missing analysis dependency '{mod}'. Install with: pip install ideas-python[analysis]"
        ) from None
