"""Constants shared across modules"""

import enum


# ----- exit status ------------------
class EXIT_STATUS(enum.Enum):
    """
    Defines a set of CLI exit statuses that can be used to indicate what type
    of error has been encountered.

    See also: https://inscopix.atlassian.net/l/cp/VG0eS656
    """

    SUCCESS = 0
    UNSPECIFIED_ERROR = 1
    INVALID_CREDENTIALS = 2
    QUOTA_EXCEEDED = 3
    UNHANDLED_ERROR = 4


# ----- support ------------------
SUPPORT_EMAIL = "Support.Inscopix@bruker.com"


# ----- tools and containers -----
IDEAS_DIR_NAME = ".ideas"
IDEAS_CONFIG_FILE_NAME = "config.json"
IDEAS_TOOL_SPEC_FILE_NAME = "tool_spec.json"
IDEAS_INPUTS_FILE_NAME = "inputs.json"
IDEAS_OUTPUT_DATA_FILE_NAME = "output_data.json"
CONTAINER_OUTPUT_DIR_PATH = "/tmp/outputs"
CONTAINER_DATA_DIR_PATH = "/tmp"
TOOL_SPEC_SCHEMA_VERSION = "3.0.0"
TOOL_CONFIG_SCHEMA_VERSION = "1.0.0"
RUNNING_CONTAINER_NAME = "ideas-cli-tool-run"
SUPPORTED_ARCHITECTURES = ["amd64"]
CONTAINER_ARCHITECTURE = "linux/amd64"
MAX_BUNDLE_FILE_SIZE = 500 * 1024 * 1024  # Units are bytes (500 MB)
OUTPUT_DATA_JSON_FILENAME = "output_data.json"
OUTPUT_DATA_SCHEMA_VERSION = "1.0.0"
