; Python tree-sitter queries
; --------------
;

; Bare functions
(module
  (function_definition
    name: (identifier) @func.name
    parameters: (parameters
      (identifier) @arg.name
    )
  )
)
(module
  (function_definition
    name: (identifier) @func.name
    parameters: (parameters
      (default_parameter
        name: (identifier) @arg.name
        value: (_) @arg.default
      )
    )
  )
)
(module
  (function_definition
    name: (identifier) @func.name
    parameters: (parameters
      (typed_parameter
        (identifier) @arg.name
        type: (_) @arg.type
      )
    )
  )
)
(module
  (function_definition
    name: (identifier) @func.name
    parameters: (parameters
      (typed_default_parameter
        name: (identifier) @arg.name
        type: (_) @arg.type
        value: (_) @arg.default
      )
    )
  )
)

; Decorated functions
(module
  (decorated_definition
    (function_definition
      name: (identifier) @func.name
      parameters: (parameters
        (identifier) @arg.name
      )
    )
  )
)
(module
  (decorated_definition
    (function_definition
      name: (identifier) @func.name
      parameters: (parameters
        (default_parameter
          name: (identifier) @arg.name
          value: (_) @arg.default
        )
      )
    )
  )
)
(module
  (decorated_definition
    (function_definition
      name: (identifier) @func.name
      parameters: (parameters
        (typed_parameter
          (identifier) @arg.name
          type: (_) @arg.type
        )
      )
    )
  )
)
(module
  (decorated_definition
    (function_definition
      name: (identifier) @func.name
      parameters: (parameters
        (typed_default_parameter
          name: (identifier) @arg.name
          type: (_) @arg.type
          value: (_) @arg.default
        )
      )
    )
  )
)

; Docstrings
; match first comment as doc, if it exists - doesn't match single-line comments
(module
  (function_definition
    name: (identifier) @func.name
    body: (block .
      (expression_statement
        (string
          (string_content) @func.doc
        )
      )
    )*
  )
)
(module
  (decorated_definition
    (function_definition
      name: (identifier) @func.name
      body: (block .
        (expression_statement
          (string
            (string_content) @func.doc
          )
        )
      )*
    )
  )
)
