import os
import platform
import subprocess


def is_windows():
    return platform.system() == "Windows"


def is_mac():
    return platform.system() == "Darwin"


def is_linux():
    return platform.system() == "Linux"


def open_file_with_default_app(filepath):
    if is_mac():
        subprocess.call(("open", filepath))
    elif is_windows():
        os.startfile(filepath)
    elif is_linux():
        subprocess.call(("gio", "open", filepath))
