"""
    Production API

    API exposing endpoints for managing well  and daily production.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.tubing import Tubing
from openapi_client.model.tubing_input import TubingInput


class TubingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_tubing(
            self,
            uwi,
            wellbore_index,
            **kwargs
        ):
            """Bulk Add / Update Tubing Data by Well and Wellbore  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_tubing(uwi, wellbore_index, async_req=True)
            >>> result = thread.get()

            Args:
                uwi (str):
                wellbore_index (int):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                int
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['uwi'] = \
                uwi
            kwargs['wellbore_index'] = \
                wellbore_index
            return self.call_with_http_info(**kwargs)

        self.delete_tubing = Endpoint(
            settings={
                'response_type': (int,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/api/production/tubing/{uwi}/{wellboreIndex}',
                'operation_id': 'delete_tubing',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'uwi',
                    'wellbore_index',
                ],
                'required': [
                    'uwi',
                    'wellbore_index',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'uwi':
                        (str,),
                    'wellbore_index':
                        (int,),
                },
                'attribute_map': {
                    'uwi': 'uwi',
                    'wellbore_index': 'wellboreIndex',
                },
                'location_map': {
                    'uwi': 'path',
                    'wellbore_index': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-ndjson'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_tubing
        )

        def __get_tubing(
            self,
            uwi,
            wellbore_index,
            **kwargs
        ):
            """Fetch Tubing Records by Well and Wellbore  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tubing(uwi, wellbore_index, async_req=True)
            >>> result = thread.get()

            Args:
                uwi (str):
                wellbore_index (int):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Tubing
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['uwi'] = \
                uwi
            kwargs['wellbore_index'] = \
                wellbore_index
            return self.call_with_http_info(**kwargs)

        self.get_tubing = Endpoint(
            settings={
                'response_type': (Tubing,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/api/production/tubing/{uwi}/{wellboreIndex}',
                'operation_id': 'get_tubing',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'uwi',
                    'wellbore_index',
                ],
                'required': [
                    'uwi',
                    'wellbore_index',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'uwi':
                        (str,),
                    'wellbore_index':
                        (int,),
                },
                'attribute_map': {
                    'uwi': 'uwi',
                    'wellbore_index': 'wellboreIndex',
                },
                'location_map': {
                    'uwi': 'path',
                    'wellbore_index': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-ndjson'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tubing
        )

        def __upsert_tubing(
            self,
            tubing_input,
            **kwargs
        ):
            """Bulk Add / Update Tubing Data by Well and Wellbore  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.upsert_tubing(tubing_input, async_req=True)
            >>> result = thread.get()

            Args:
                tubing_input ([TubingInput]):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [Tubing]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['tubing_input'] = \
                tubing_input
            return self.call_with_http_info(**kwargs)

        self.upsert_tubing = Endpoint(
            settings={
                'response_type': ([Tubing],),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/api/production/tubing',
                'operation_id': 'upsert_tubing',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'tubing_input',
                ],
                'required': [
                    'tubing_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tubing_input':
                        ([TubingInput],),
                },
                'attribute_map': {
                },
                'location_map': {
                    'tubing_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-ndjson'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__upsert_tubing
        )
