# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import typing

class FqEncoderOption:
    kmer_size: int
    qual_offset: int
    bases: list[int]
    vectorized_target: bool
    threads: int
    def __new__(
        cls,
        kmer_size: int,
        qual_offset: int,
        bases: str,
        vectorized_target: bool,
        threads: int | None,
    ): ...

class JsonEncoder: ...
class ParquetEncoder: ...

class Predict:
    r"""A struct to store the prediction result."""

    prediction: list[int]
    seq: str
    id: str
    is_truncated: bool
    qual: str | None
    def __new__(
        cls,
        prediction: typing.Sequence[int],
        seq: str,
        id: str,
        is_truncated: bool,
        qual: str | None,
    ): ...
    def __repr__(self) -> str: ...
    def prediction_region(self) -> list[tuple[int, int]]:
        r"""Get the prediction region."""

    def smooth_prediction(self, window_size: int) -> list[tuple[int, int]]:
        r"""Get the smooth prediction region."""

    def smooth_label(self, window_size: int) -> list[int]:
        r"""Get the smooth label."""

    def smooth_and_select_intervals(
        self,
        smooth_window_size: int,
        min_interval_size: int,
        append_interval_number: int,
    ) -> list[tuple[int, int]]:
        r"""Smooth and select intervals."""

    def seq_len(self) -> int:
        r"""Get the sequence length."""

    def qual_array(self) -> list[int]:
        r"""Get the quality score array."""

    def show_info(
        self, smooth_interval: typing.Sequence[tuple[int, int]], text_width: int | None
    ) -> str:
        r"""Show the information of the prediction."""

    def __getstate__(self) -> typing.Any: ...
    def __setstate__(self, state: typing.Any) -> None: ...

class RecordData:
    id: str
    seq: str
    qual: str
    def __new__(cls, id: str, seq: str, qual: str): ...
    def set_id(self, id: str) -> None: ...
    def set_seq(self, seq: str) -> None: ...
    def set_qual(self, qual: str) -> None: ...

def encode_qual(qual: str, qual_offset: int) -> list[int]:
    r"""Convert ASCII quality to Phred score for Phred+33 encoding."""

def generate_kmers(base: str, k: int) -> list[str]: ...
def get_label_region(labels: typing.Sequence[int]) -> list[tuple[int, int]]: ...
def kmers_to_seq(kmers: typing.Sequence[str]) -> str: ...
def normalize_seq(seq: str, iupac: bool) -> str: ...
def seq_to_kmers(seq: str, k: int, overlap: bool) -> list[str]: ...
def test_predicts(predicts: typing.Sequence[Predict]) -> None: ...
