# -*- coding: utf-8 -*-
#
# This file was automatically generated.
#
from typing import Optional

from .card_data_for_dcc import CardDataForDcc
from .point_of_sale_data_for_dcc import PointOfSaleDataForDcc
from .transaction_data_for_dcc import TransactionDataForDcc

from worldline.acquiring.sdk.domain.data_object import DataObject


class GetDCCRateRequest(DataObject):

    __card_payment_data: Optional[CardDataForDcc] = None
    __operation_id: Optional[str] = None
    __point_of_sale_data: Optional[PointOfSaleDataForDcc] = None
    __rate_reference_id: Optional[str] = None
    __target_currency: Optional[str] = None
    __transaction: Optional[TransactionDataForDcc] = None

    @property
    def card_payment_data(self) -> Optional[CardDataForDcc]:
        """
        Type: :class:`worldline.acquiring.sdk.v1.domain.card_data_for_dcc.CardDataForDcc`
        """
        return self.__card_payment_data

    @card_payment_data.setter
    def card_payment_data(self, value: Optional[CardDataForDcc]) -> None:
        self.__card_payment_data = value

    @property
    def operation_id(self) -> Optional[str]:
        """
        | A unique identifier of the operation, generated by the client.

        Type: str
        """
        return self.__operation_id

    @operation_id.setter
    def operation_id(self, value: Optional[str]) -> None:
        self.__operation_id = value

    @property
    def point_of_sale_data(self) -> Optional[PointOfSaleDataForDcc]:
        """
        Type: :class:`worldline.acquiring.sdk.v1.domain.point_of_sale_data_for_dcc.PointOfSaleDataForDcc`
        """
        return self.__point_of_sale_data

    @point_of_sale_data.setter
    def point_of_sale_data(self, value: Optional[PointOfSaleDataForDcc]) -> None:
        self.__point_of_sale_data = value

    @property
    def rate_reference_id(self) -> Optional[str]:
        """
        | The reference of a previously used rate
        | This can be used in case of refund if you want to use the same rate as the original transaction.

        Type: str
        """
        return self.__rate_reference_id

    @rate_reference_id.setter
    def rate_reference_id(self, value: Optional[str]) -> None:
        self.__rate_reference_id = value

    @property
    def target_currency(self) -> Optional[str]:
        """
        | The currency to convert to

        Type: str
        """
        return self.__target_currency

    @target_currency.setter
    def target_currency(self, value: Optional[str]) -> None:
        self.__target_currency = value

    @property
    def transaction(self) -> Optional[TransactionDataForDcc]:
        """
        Type: :class:`worldline.acquiring.sdk.v1.domain.transaction_data_for_dcc.TransactionDataForDcc`
        """
        return self.__transaction

    @transaction.setter
    def transaction(self, value: Optional[TransactionDataForDcc]) -> None:
        self.__transaction = value

    def to_dictionary(self) -> dict:
        dictionary = super(GetDCCRateRequest, self).to_dictionary()
        if self.card_payment_data is not None:
            dictionary['cardPaymentData'] = self.card_payment_data.to_dictionary()
        if self.operation_id is not None:
            dictionary['operationId'] = self.operation_id
        if self.point_of_sale_data is not None:
            dictionary['pointOfSaleData'] = self.point_of_sale_data.to_dictionary()
        if self.rate_reference_id is not None:
            dictionary['rateReferenceId'] = self.rate_reference_id
        if self.target_currency is not None:
            dictionary['targetCurrency'] = self.target_currency
        if self.transaction is not None:
            dictionary['transaction'] = self.transaction.to_dictionary()
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'GetDCCRateRequest':
        super(GetDCCRateRequest, self).from_dictionary(dictionary)
        if 'cardPaymentData' in dictionary:
            if not isinstance(dictionary['cardPaymentData'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['cardPaymentData']))
            value = CardDataForDcc()
            self.card_payment_data = value.from_dictionary(dictionary['cardPaymentData'])
        if 'operationId' in dictionary:
            self.operation_id = dictionary['operationId']
        if 'pointOfSaleData' in dictionary:
            if not isinstance(dictionary['pointOfSaleData'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['pointOfSaleData']))
            value = PointOfSaleDataForDcc()
            self.point_of_sale_data = value.from_dictionary(dictionary['pointOfSaleData'])
        if 'rateReferenceId' in dictionary:
            self.rate_reference_id = dictionary['rateReferenceId']
        if 'targetCurrency' in dictionary:
            self.target_currency = dictionary['targetCurrency']
        if 'transaction' in dictionary:
            if not isinstance(dictionary['transaction'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['transaction']))
            value = TransactionDataForDcc()
            self.transaction = value.from_dictionary(dictionary['transaction'])
        return self
