! (C) Copyright 2024- ECMWF.
! 
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.
!

INTERFACE
SUBROUTINE GPNORM_TRANSTL_dp(PGP,KFIELDS,KPROMA,PAVE,KRESOL)


!**** *GPNORM_TRANSTL_dp* - calculate grid-point norms
!                        reduced version for linear model

!     Purpose.
!     --------
!        calculate grid-point norms

!**   Interface.
!     ----------
!     CALL GPNORM_TRANSTL_dp(...)

!     Explicit arguments :
!     --------------------
!     PGP(:,:,:) - gridpoint fields (input)
!                  PGP is  dimensioned (NPROMA,KFIELDS,NGPBLKS) where
!                  NPROMA is the blocking factor, KFIELDS the total number
!                  of fields and NGPBLKS the number of NPROMA blocks.
!     KFIELDS     - number of fields (input)
!                   (these do not have to be just levels)
!     KPROMA      - required blocking factor (input)
!     PAVE        - average (output)
!     KRESOL      -  resolution tag (optional)
!                    default assumes first defined resolution
!

!     Author.
!     -------
!        Filip Vana, (c) ECMWF
!        9-Sep-2024

!     Modifications.
!     --------------

!     ------------------------------------------------------------------

USE EC_PARKIND  ,ONLY : JPIM     ,JPRD

IMPLICIT NONE

! Declaration of arguments
  
REAL(KIND=JPRD),INTENT(IN)    :: PGP(:,:,:)
REAL(KIND=JPRD),INTENT(OUT)   :: PAVE(:)
INTEGER(KIND=JPIM),INTENT(IN) :: KFIELDS
INTEGER(KIND=JPIM),INTENT(IN) :: KPROMA
INTEGER(KIND=JPIM) ,OPTIONAL, INTENT(IN)  :: KRESOL

END SUBROUTINE GPNORM_TRANSTL_dp
END INTERFACE
