"""This file contains a dict with all Strings that will be
   added to the maps"""
from pokete.classes.asset_service.resources import ObmapDict

# Those are some vars used in map_data
CENTER = r"""  __________
 /         /\
/_Center!_/  \
| # ___ # |  |
|___| |___|__|"""

SHOP = r"""  __________
 /         /\
/__Shop!__/  \
| # ___ # |  |
|___| |___|__|"""

HOUSE1 = r"""  ________
 /       /\
/_______/  \
|# ___ #|  |
|__| |__|__|"""

# This is the actual map_data dict
map_data: dict[str, ObmapDict] = {
    #     "playmap_1": {
    #         "hard_obs": {
    #         },
    #         "soft_obs": {
    #         },
    #         "dors": {
    #         },
    #         "balls": {
    #         }
    #     },
    "playmap_1": {
        "hard_obs": {
            "tree_group_1": {
                "x": 35,
                "y": 2,
                "txt": """ (()(()((())((()((()
())(())))())))()))(()
 || ||| ||||| |||||"""
            },
            "tree_group_2": {
                "x": 25,
                "y": 15,
                "txt": """ (()(()((())((()((()
())(())))())))()))(()
 || ||| ||||| ||||||"""
            },
            "tree_group_3": {
                "x": 73,
                "y": 18,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "pokecenter": {
                "x": 20,
                "y": 0,
                "txt": CENTER
            },
            "house1": {
                "x": 2,
                "y": 0,
                "txt": HOUSE1
            },
            "house2": {
                "x": 5,
                "y": 17,
                "txt": HOUSE1
            },
            "house3": {
                "x": 53,
                "y": 17,
                "txt": HOUSE1
            },
            "house4": {
                "x": 61,
                "y": 0,
                "txt": HOUSE1
            },
            "fence": {
                "x": 0,
                "y": 0,
                "txt": """                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         ##


                                                                                         ##
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
                                                                                         #
##########################################################################################"""
            },
            "tree_group_4": {
                "x": 2,
                "y": 10,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            #            "cave_1_entrance": {
            #                "x": 60,
            #                "y": 0,
            #                "txt": r"""\  \_/  _____/ \______/
            # \_____/"""
            #            },
        },
        "soft_obs": {
            #            "meadow1": {
            #                "x": 1,
            #                "y": 8,
            #                "txt": """     ;;;;;;;
            #   ;;;;;;;;;;;;
            # ;;;;;;;;;;;;;;;;
            # ;;;;;;;;;;;;;;;;;;;
            # ;;;;;;;;;;;;;;;;;
            #   ;;;;;;;;;;;;;
            #      ;;;;;;"""
            #            },
            "meadow2": {
                "x": 68,
                "y": 7,
                "txt": """    ;;;;;;;;;;;
  ;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;
;;;;;;;;;;;;
 ;;;;;;;;;
"""
            },
        },
        "dors": {
            "dor_playmap_51_1": {
                "x": 90,
                "y": 12,
                "args": {"map": "playmap_51", "x": 1, "y": 28}
            },
            "dor_playmap_51_2": {
                "x": 90,
                "y": 13,
                "args": {"map": "playmap_51", "x": 1, "y": 29}
            },
        },
        "special_dors": {
            "dor": {
                "x": 25,
                "y": 4
            }
        },
        "balls": {
            "ball_1": {
                "x": 54,
                "y": 4
            },
            "ball_2": {
                "x": 38,
                "y": 16
            },
            "ball_3": {
                "x": 78,
                "y": 21
            },
        }
    },
    "playmap_2": {
        "hard_obs": {
            "tree_group_1": {
                "x": 36,
                "y": 0,
                "txt": """ ())
())))
())()
(()))
((())
 |||"""
            },
            "tree_group_2": {
                "x": 0,
                "y": 7,
                "txt": """
                        ())
                       ())))
                       ())())
                      ((())()                                                                              ()))
                      (((())                                                                              ()())
                       ())))                                                                              ((())
                       ((())                                                                              (()))
                      ((())))                                                                            (())))
(((()()))))()(((((()))))))()())()()())))()()()))))))(()()()()()()))))))((()))))()(()))))))))(((((())))))))())))
(()())))))(())))))((((())))((((()))((((()()()))))(()()))))()()(()))))))()(()()))))((()))))))))(((()))))))))))()
(()())))))((()()()))()()())))()()))())))))((((()()))))()()()))((((((((()(((((()()()))))(())))))(((())))))))()))
|||||||| |||||| | | | ||| | | |  ||||||| | | ||||||| | | |  |||||| | | |||| | | || |||| ||| ||| ||  |||||| || |"""
            },
            "tree_group_3": {
                "x": 58,
                "y": 0,
                "txt": """ ())
())))
())()
(()))
((())
 |||"""
            },
            "tree_group_4": {
                "x": 106,
                "y": 0,
                "txt": """ ()))
())))
(()))
())()
())))
(()))
(()))
((())
 ||||"""
            },
            "cave_1_entrance": {
                "x": 0,
                "y": 2,
                "txt": r"""\
 \
 |
(
 |
 |
 /
/
"""
            },
        },
        "soft_obs": {
            "meadow1": {
                "x": 10,
                "y": 0,
                "txt": """        ;;;;;;
      ;;;;;;;;;;
    ;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;
  ;;;;;; ;;;;;;
 ;;;;;;;;;;;;
 ;;;;;;;;;
  ;;;;;;;"""
            },
            "meadow2": {
                "x": 40,
                "y": 7,
                "txt": """      ;;;;;;;
    ;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;
         ;;;;;;"""
            },
            "meadow3": {
                "x": 70,
                "y": 1,
                "txt": """
         ;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;
         ;;;;;;;;;;;;;
           ;;;;;;;;;;"""
            },
        },
        "dors": {
            "dor_cave_1": {
                "x": 1,
                "y": 5,
                "args": {"map": "cave_1", "x": 39, "y": 3}
            },
            "dor_playmap_3_1": {
                "x": 110,
                "y": 9,
                "args": {"map": "playmap_3", "x": 1, "y": 9}
            },
            "dor_playmap_3_2": {
                "x": 110,
                "y": 10,
                "args": {"map": "playmap_3", "x": 1, "y": 10}
            },
        },
        "balls": {
            "ball_1": {
                "x": 58,
                "y": 0
            },
            "ball_2": {
                "x": 18,
                "y": 4
            },
        }
    },
    "cave_1": {
        "hard_obs": {
            "innerwalls": {
                "x": 0,
                "y": 0,
                "txt": r"""+--------+
|        |
|        |                     +-------\_
|        +-----------+         |         )
|                    |         |   +---/¯
|        +--------+  |         |   |
|        |        |  |         |   |
+--------+   +----+  +---------+   |
             |                     |
             |                     |
             |  +-----+ +----------+
      +------+  |     | |
      |         |     +-+
      |  +-+    |
      |  +-+    |
      |         |
      +------+  |
             |  |
             |  |
             |  |"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_51_1": {
                "x": 14,
                "y": 20,
                "args": {"map": "playmap_51", "x": 21, "y": 1}
            },
            "dor_playmap_51_2": {
                "x": 15,
                "y": 20,
                "args": {"map": "playmap_51", "x": 21, "y": 1}
            },
            "dor_playmap_2": {
                "x": 40,
                "y": 3,
                "args": {"map": "playmap_2", "x": 2, "y": 5}
            },
        },
        "balls": {
            "ball_1": {
                "x": 1,
                "y": 1
            },
            "ball_2": {
                "x": 7,
                "y": 12
            },
        }
    },
    "playmap_3": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": """())
))()
()))
)()(
))()
()))
()))
(())
|||"""
            },
            "tree_group_2": {
                "x": 0,
                "y": 11,
                "txt": """())
))()
()))
)()(
(())
|||"""
            },
            "tree_group_3": {
                "x": 35,
                "y": 4,
                "txt": """ ())
())()
 |||"""
            },
            "tree_group_5": {
                "x": 45,
                "y": 4,
                "txt": """ ())
())()
 |||"""
            },
            "tree_group_6": {
                "x": 49,
                "y": 19,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "tree_group_7": {
                "x": 51,
                "y": 10,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "tree_group_8": {
                "x": 6,
                "y": 15,
                "txt": """()))
())))
()())
||||"""
            },
            "tree_group_9": {
                "x": 31,
                "y": 12,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "pokecenter": {
                "x": 20,
                "y": 2,
                "txt": CENTER
            },
            "shop": {
                "x": 56,
                "y": 2,
                "txt": SHOP
            },
            "house2": {
                "x": 18,
                "y": 11,
                "txt": HOUSE1
            },
            "house3": {
                "x": 18,
                "y": 17,
                "txt": HOUSE1
            },
            "house4": {
                "x": 58,
                "y": 9,
                "txt": HOUSE1
            },
            "fence1": {
                "x": 3,
                "y": 0,
                "txt": """                                   #
  ##################################
  #
  #
  #
  #
  #
  #
###
"""
            },
            "fence2": {
                "x": 45,
                "y": 0,
                "txt": """#
###################################
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
                                  #
###################################
#"""
            },
            "fence3": {
                "x": 3,
                "y": 11,
                "txt": """###
  #
  #
  #
  #
  #
  #
  #
  #
  #
  #
  #
  #
  #
  ##################################
                                   #"""
            },
        },
        "soft_obs": {
            "meadow1": {
                "x": 61,
                "y": 17,
                "txt": """    ;;;;;
  ;;;;;;;;;
 ;;;;;;;;;;;;
;;;;;;;;;;;;;;
;;;;;;;;;;;;;
 ;;;;;;;;;;;
   ;;;;;;;"""
            },
        },
        "dors": {
            "dor_playmap_2_1": {
                "x": 0,
                "y": 9,
                "args": {"map": "playmap_2", "x": 109, "y": 9}
            },
            "dor_playmap_2_2": {
                "x": 0,
                "y": 10,
                "args": {"map": "playmap_2", "x": 109, "y": 10}
            },
            "dor_playmap_4_1": {
                "x": 39,
                "y": 0,
                "args": {"map": "playmap_4", "x": 29, "y": 58}
            },
            "dor_playmap_4_2": {
                "x": 40,
                "y": 0,
                "args": {"map": "playmap_4", "x": 29, "y": 58}
            },
            "dor_playmap_4_3": {
                "x": 41,
                "y": 0,
                "args": {"map": "playmap_4", "x": 29, "y": 58}
            },
            "dor_playmap_4_4": {
                "x": 42,
                "y": 0,
                "args": {"map": "playmap_4", "x": 30, "y": 58}
            },
            "dor_playmap_4_5": {
                "x": 43,
                "y": 0,
                "args": {"map": "playmap_4", "x": 30, "y": 58}
            },
            "dor_playmap_4_6": {
                "x": 44,
                "y": 0,
                "args": {"map": "playmap_4", "x": 30, "y": 58}
            },
            "dor_playmap_6_1": {
                "x": 39,
                "y": 26,
                "args": {"map": "playmap_6", "x": 29, "y": 1}
            },
            "dor_playmap_6_2": {
                "x": 40,
                "y": 26,
                "args": {"map": "playmap_6", "x": 29, "y": 1}
            },
            "dor_playmap_6_3": {
                "x": 41,
                "y": 26,
                "args": {"map": "playmap_6", "x": 29, "y": 1}
            },
            "dor_playmap_6_4": {
                "x": 42,
                "y": 26,
                "args": {"map": "playmap_6", "x": 30, "y": 1}
            },
            "dor_playmap_6_5": {
                "x": 43,
                "y": 26,
                "args": {"map": "playmap_6", "x": 30, "y": 1}
            },
            "dor_playmap_6_6": {
                "x": 44,
                "y": 26,
                "args": {"map": "playmap_6", "x": 30, "y": 1}
            },
            "dor_playmap_49": {
                "x": 22,
                "y": 15,
                "args": {"map": "playmap_49", "x": 11, "y": 7}
            },
        },
        "special_dors": {
            "dor": {
                "x": 25,
                "y": 6,
            },
            "shopdor": {
                "x": 61,
                "y": 6,
            }
        },
        "balls": {
            "ball_1": {
                "x": 56,
                "y": 13
            },
            "ball_2": {
                "x": 22,
                "y": 21
            },
            "ball_3": {
                "x": 6,
                "y": 2
            },
        }
    },
    "playmap_4": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 54,
                "txt": """(())))))()                                             ()(()
())))()()))(((()                                (()())))))()
())))((((((()()()))()                   ()()))()((((((((((()
()))))))()((((((((()))))))         (((()()))))(((((((()()())
()()()))))()()()())))((()))))  (((())()(((()()(()((((((())))
|||| || | |||| | |||| | | ||    || |||| | ||| ||||| |||| |||"""
            },
            "tree_group_2": {
                "x": 29,
                "y": 33,
                "txt": """ (()(((()())))())((())((()((())
(())))()))())(())))())))()))(()
 || ||| ||||| ||| ||||| |||||||"""
            },
            "tree_group_3": {
                "x": 0,
                "y": 22,
                "txt": """
(()(((()())))())((())((()((()) ())
(())))()))())(())))()))))())()))(()
|||||| ||||| ||| | || |||| ||| |||"""
            },
            "tree_group_4": {
                "x": 0,
                "y": 42,
                "txt": """ ())()
())()))
 |||||"""
            },
            "tree_group_5": {
                "x": 56,
                "y": 16,
                "txt": """ ())
()))
()()
()))
())(
 |||


 ())
((()
()))
(())
 |||"""
            },
        },
        "soft_obs": {
            "meadow1": {
                "x": 17,
                "y": 42,
                "txt": """      ;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;
         ;;;;;;;;;;;;;
            ;;;;;;;;"""
            },
            "meadow2": {
                "x": 0,
                "y": 28,
                "txt": """        ;;;;;;
      ;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;
;;;;;;;; ;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;
  ;;;;;;;"""
            },
            "water1": {
                "x": 0,
                "y": 0,
                "cls": "water",
                "txt": """~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~         ~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~                 ~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~                    ~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~                                ~~~~~~~~~~~~~~
~~~~~~~~~                                           ~~~~~~~~
~~~"""
            },
        },
        "dors": {
            "dor_playmap_3_1": {
                "x": 29,
                "y": 59,
                "args": {"map": "playmap_3", "x": 41, "y": 1}
            },
            "dor_playmap_3_2": {
                "x": 30,
                "y": 59,
                "args": {"map": "playmap_3", "x": 42, "y": 1}
            },
            "dor_playmap_28_1": {
                "x": 59,
                "y": 22,
                "args": {"map": "playmap_28", "x": 1, "y": 40}
            },
            "dor_playmap_28_2": {
                "x": 59,
                "y": 23,
                "args": {"map": "playmap_28", "x": 1, "y": 41}
            },
        },
        "balls": {
            "ball_1": {
                "x": 0,
                "y": 44
            },
            "ball_2": {
                "x": 46,
                "y": 35
            },
            "ball_3": {
                "x": 8,
                "y": 32
            },
        }
    },
    "playmap_5": {
        "hard_obs": {
            "innerwalls": {
                "x": 0,
                "y": 0,
                "txt": """                         +-----------+
                         |           |
                         |           |
                         |           |
                         |           |
                         |           |
                         |           |
         +---------------+           |
         |                           +-----+
         |                                 |
         |                                 |
         |                                 |
         +------+ +---+ +------------------+
                | |   | |
                | |   +-+
                | |
                | |"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_4": {
                "x": 17,
                "y": 17,
                "args": {"map": "playmap_4", "x": 56, "y": 2}
            },
        },
        "balls": {
        }
    },
    "playmap_6": {
        "hard_obs": {
            "stone_formation_1": {
                "x": 0,
                "y": 28,
                "txt": r"""\
 \
 |
 \
\ \
| |
|(
| |
| \
\  \
 \  \
  \  \_
\  \_  \
 \   \  \
  \   \  \
   \   \  \
\   \  |  |
 \  |  |  |
 |  |  |  \
 |  |  \   \
 |  \   \   \
 \   \   \   \
  \   \  |    \___
   \  |  |        \
   |  |  |         \
   |  \  \          \
\  \   \  \______    \_____
 \  \   \______  \         \
  \  \_______  \  \         \
\  \_______  \  \  \         \___________
 \_______  \  \  \  \                    \
         \  \  \  \  \_________________   \ """
            },
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": """())) ()))((())() ())()()((()
()(((()()(())))((()()(((())))
(())) |||| ||| |  |||| |||||
)(())
())))
 |||"""
            },
            "tree_group_2": {
                "x": 31,
                "y": 0,
                "txt": """ ())) ()))((())() ())()()((()
()(((()()(())))((()()(((())))
 || || ||||| ||| |  ||| ()(()
                        (()()
                        ()(()
                        ())))
                        )()((
                        ()(()
                        ())()
                       ()()((
                        ()(()
                        (()))
                        (()()
                        ()(()
                        ()))(
                        )(())
                       ()))()
                        ())))
                        ((())
        ((((()) ())())))(()))
       ()))))()()()))()))((()
        ||| ||| ||| ||| ())))
                        (()))
                        )((()
                       ()()((
                        ()(()
                        (()))
                        (()()
                        ()(()
                        ()))(
                        ()(()
                        ()(()
                       ()()))
                        (()()
                        ()(()
                        ()))(
                        ()(()
                       ()()))
                        (()()
                        ()(()
        ()()()((((()))))()))(
       (((()))((()))((()))()(
        ||| |||| |||||| (()))
                        (()()
                        ()(()
                         ||||


                         ()))
                        ())))
                        ()())
                        ()(()
                        ()))(
                        ()(()
                       (()())
                        ()(()
                        ()))(
            ()()()()()()()(()
           (()))))()()())(())
            ||| ||| ||| || ||"""
            }
        },
        "soft_obs": {
            "meadow1": {
                "x": 10,
                "y": 7,
                "txt": """
         ;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;
         ;;;;;;;;;;;;;
           ;;;;;;;;;;"""
            },
            "meadow2": {
                "x": 2,
                "y": 30,
                "txt": """;;;;;
;;;;;;;;
 ;;;;;;;;;
 ;;;;;;;;;;
 ;;;;;;;;;;
 ;;;;;;;;;
 ;;;;;;;
  ;;;;"""
            },
            "meadow3": {
                "x": 29,
                "y": 26,
                "txt": """    ;;;;;
  ;;;;;;;;;
 ;;;;;;;;;;;;
;;;;;;;;;;;;;;
;;;;;;;;;;;;;
 ;;;;;;;;;;;
   ;;;;;;;"""
            },
            "meadow4": {
                "x": 28,
                "y": 45,
                "txt": """    ;;;;;
  ;;;;;;;;;
 ;;;;;;;;;;;;
;;;;;;;;;;;;;;
;;;;;;;;;;;;;
 ;;;;;;;;;;;
   ;;;;;;;"""
            }
        },
        "dors": {
            "dor_playmap_3_1": {
                "x": 29,
                "y": 0,
                "args": {"map": "playmap_3", "x": 41, "y": 25}
            },
            "dor_playmap_3_2": {
                "x": 30,
                "y": 0,
                "args": {"map": "playmap_3", "x": 42, "y": 25}
            },
            "dor_playmap_7": {
                "x": 2,
                "y": 34,
                "args": {"map": "playmap_7", "x": 27, "y": 12}
            },
            "dor_playmap_8_1": {
                "x": 59,
                "y": 46,
                "args": {"map": "playmap_8", "x": 1, "y": 9}
            },
            "dor_playmap_8_2": {
                "x": 59,
                "y": 47,
                "args": {"map": "playmap_8", "x": 1, "y": 10}
            },
        },
        "balls": {
            "ball_1": {
                "x": 42,
                "y": 42
            },
        }
    },
    "playmap_7": {
        "hard_obs": {
            "inner_walls": {
                "x": 0,
                "y": 0,
                "txt": r"""        +--------+
        |        |
        |        |
        |        |
        |        +------+
+----+  |               |
|    |  |     +--+      |
|    +--+     |  |      |
|             |  +------+
|    +--+     |
+----+  |     |
        |     +-------------\
        |                    )
        |     +-------------/
        |     |
        |     +-------+
        |             |
        +---------+   |
                  |   |
                  +---+"""
            }
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_6": {
                "x": 28,
                "y": 12,
                "args": {"map": "playmap_6", "x": 3, "y": 34}
            },
        },
        "balls": {
            "ball_1": {
                "x": 19,
                "y": 18
            },
            "ball_2": {
                "x": 23,
                "y": 7
            },
            "ball_3": {
                "x": 1,
                "y": 6
            },
        }
    },
    "playmap_8": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": """())
))()
()))
()))
(())
)())
)()(
(())
|||"""
            },
            "tree_group_2": {
                "x": 0,
                "y": 11,
                "txt": """())                                                                          ())
))()                                                                        ()((
()))                                                                        ()))
()))                                                                        ()()
(())                                                                        (())
)())                                                                        ()))
)()((())))))())()())))()()() ()   ()   ())   ()) ())(((()((()()))()()((()))))())
(())))))()())))()()))())())))())()()) ()(((()()(())()))()()((())))))(()))()))())
||||| || ||| ||| ||| | ||||| ||| |||   |||  ||||| | |||| || ||| | ||||| |||| |||"""
            },
            "tree_group_3": {
                "x": 34,
                "y": 0,
                "txt": """ (()
())()
(()))
(()))
((())
((())
 |||"""
            },
            "tree_group_4": {
                "x": 76,
                "y": 0,
                "txt": """ ())
()()
()))
(())
(())
()))
(()(
(())
 |||"""
            },
            "house1": {
                "x": 40,
                "y": 0,
                "txt": HOUSE1
            },
            "house2": {
                "x": 46,
                "y": 10,
                "txt": HOUSE1
            },
        },
        "soft_obs": {
            "meadow1": {
                "x": 9,
                "y": 5,
                "txt": """       ;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;
          ;;;;;;;;;"""
            },
            "meadow2": {
                "x": 57,
                "y": 2,
                "txt": """    ;;;;;
  ;;;;;;;;;
 ;;;;;;;;;;;;
;;;;;;;;;;;;;;
;;;;;;;;;;;;;
 ;;;;;;;;;;;
   ;;;;;;;"""
            },
        },
        "dors": {
            "dor_playmap_6_1": {
                "x": 0,
                "y": 9,
                "args": {"map": "playmap_6", "x": 58, "y": 46}
            },
            "dor_playmap_6_2": {
                "x": 0,
                "y": 10,
                "args": {"map": "playmap_6", "x": 58, "y": 47}
            },
            "dor_playmap_9": {
                "x": 44,
                "y": 4,
                "args": {"map": "playmap_9", "x": 14, "y": 10}
            },
            "dor_playmap_10": {
                "x": 50,
                "y": 14,
                "args": {"map": "playmap_10", "x": 11, "y": 7}
            },
            "dor_playmap_11": {
                "x": 37,
                "y": 19,
                "args": {"map": "playmap_11", "x": 37, "y": 1}
            },
            "dor_playmap_12_1": {
                "x": 79,
                "y": 9,
                "args": {"map": "playmap_12", "x": 1, "y": 6}
            },
            "dor_playmap_12_2": {
                "x": 79,
                "y": 10,
                "args": {"map": "playmap_12", "x": 1, "y": 7}
            },
        },
        "balls": {
            "ball_1": {
                "x": 3,
                "y": 8
            },
            "ball_2": {
                "x": 34,
                "y": 0
            },
            "ball_3": {
                "x": 58,
                "y": 14
            },
        }
    },
    "playmap_9": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """
_________________________
|____#_____________#____|
|##       |  |          |
|         ¯¯¯¯          |
|                       |
|#                      |
|               ########|
|___________ ___#_______|
|__________| |__________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_8": {
                "x": 14,
                "y": 11,
                "args": {"map": "playmap_8", "x": 44, "y": 5}
            },
        },
        "balls": {
            "ball_1": {
                "x": 25,
                "y": 4
            },
        }
    },
    "playmap_10": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_8": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_8", "x": 50, "y": 15}
            },
        },
        "balls": {
        },
    },
    "playmap_11": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": """())) ()))((())() ())()()((()())))())
()(((()()(())))((()()(((())))()))))))
(())) |||| ||| |  |||| ||||| ||| |||
)(())
())))
||||"""
            },
            "tree_group_2": {
                "x": 38,
                "y": 0,
                "txt": """ ())) ()))(() ())())()
()(((()()(())))()(()))
 || || |||| || | ()(()
                 (()()
                 ()(()
                  ||||"""
            },
            "tree_group_3": {
                "x": 42,
                "y": 8,
                "txt": """ ())()
())()))
 |||||"""
            },
            "house1": {
                "x": 7,
                "y": 4,
                "txt": HOUSE1
            },
        },
        "soft_obs": {
            "water1": {
                "x": 0,
                "y": 12,
                "cls": "water",
                "txt": """~~~~~                                                 ~~~~~~
~~~~~~~~~~~~                                 ~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~                       ~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~                   ~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~          ~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~""",
            }
        },
        "dors": {
            "dor_playmap_8": {
                "x": 37,
                "y": 0,
                "args": {"map": "playmap_8", "x": 37, "y": 18}
            },
        },
        "balls": {
            "ball_1": {
                "x": 0,
                "y": 6
            },
            "ball_2": {
                "x": 54,
                "y": 2
            },
            "ball_3": {
                "x": 48,
                "y": 10
            },
        },
    },
    "playmap_12": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": """()))()()((())))))()())))))()()())))))()())))))))))()()())()))()()(()))   ())))()
((()) ||| || | || (()(())()((()()))                  (()()))())          ())()))
()))              ())()())())()())                    ())())))            ||()()
()))               ()()))(()()))))                    ()())())              (())
(())              ()()))))()))()()                     (()))()              ()((
|||                ()())))())))))         ()))        (()())))              ((((
                    ()))((()))())        )())))       ()())(((              ()))
                     ||||| | |||         ()()))       ())())))              ()((
())                                       ||||        )())))))              )()(
()()                                                  ()))))()              ())(
))()                 (()))  ())                        || |||               )(()
()))                (()))(  ()()                                            ((((
))()                ()))()()()))         ()()))                             ))))
())))              ())))))())))))       ())())()       ()))()              ((())
())))()(()()()((()()()()()()()())(()()(()()()()))((())())(()(()))(())()(()))()()"""
            },
        },
        "soft_obs": {
            "meadow_1": {
                "x": 3,
                "y": 2,
                "txt": """    ;;;;;;;;
   ;;;;;;;;;;
  ;;;;;;;;;;;;
 ;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;
  ;;;;;;;;;;;;
  ;;;;;;;;;;;;
   ;;;;;;;;;;;
    ;;;;;;;;;"""
            },
            "meadow_2": {
                "x": 32,
                "y": 5,
                "txt": """   ;;;;
  ;;;;;;
 ;;;;;;;
;;;;;;;;;
;;;;;;;;
;;;;;;;;;
 ;;;;;;;
 ;;;;;;
  ;;;;"""
            },
            "meadow_3": {
                "x": 41,
                "y": 1,
                "txt": """ ;;;;
;;;;;;
;;;;;
 ;;;"""
            },
            "meadow_4": {
                "x": 46,
                "y": 7,
                "txt": """  ;;;;
 ;;;;;;
;;;;;;;;
;;;;;;;;
 ;;;;;;
  ;;;;
   ;;"""
            },
            "meadow_5": {
                "x": 63,
                "y": 3,
                "txt": """   ;;;;;
 ;;;;;;;;;;
;;;;;;;;;;;;
;;;;;;;;;;;
 ;;;;;;;;;
   ;;;;;"""
            },
        },
        "dors": {
            "dor_playmap_8_1": {
                "x": 0,
                "y": 6,
                "args": {"map": "playmap_8", "x": 78, "y": 9}
            },
            "dor_playmap_8_2": {
                "x": 0,
                "y": 7,
                "args": {"map": "playmap_8", "x": 78, "y": 10}
            },
            "dor_playmap_13_1": {
                "x": 70,
                "y": 0,
                "args": {"map": "playmap_13", "x": 34, "y": 33}
            },
            "dor_playmap_13_2": {
                "x": 71,
                "y": 0,
                "args": {"map": "playmap_13", "x": 35, "y": 33}
            },
            "dor_playmap_13_3": {
                "x": 72,
                "y": 0,
                "args": {"map": "playmap_13", "x": 36, "y": 33}
            },
        },
        "balls": {
            "ball_1": {
                "x": 28,
                "y": 7
            },
            "ball_2": {
                "x": 35,
                "y": 1
            },
            "ball_3": {
                "x": 57,
                "y": 10
            },
            "ball_4": {
                "x": 5,
                "y": 13
            },
        },
    },
    "playmap_13": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": r"""()()()()()))((()))(())(  __________________  ((((()))()()()((()()(()))
(())()())()((()()))()())/                 /\())()())))()()()))()(((()(
)()( || |||| || | |||| /_________________/  \||| || |||| ||| | |||()((
)()(                   |  #    ____   #  |  |                     )(()
()()                   |_______|  |______|__|                     ()((
)()(                                                              ((((
)(()                                                              (()(
())(                         ()()()))                             )()(
()()                        ())())))))                            ()()
)()(                        ()())())))                            ))))
)()(                         ||| ||||                          () (())
)()(                                                          ()))(()(
()()                                                          ()))())(
))((                         (()())))                          || ()))
()))                        ()()))()))                            ()))
()()                        (())()(())                            ()()
)()(                        ()())())))                            ))()
)())                         ())()())                             )(((
()))                          || |||                              (())
))()                                                              ())(
((()                                                              ))((
(())                                                              )()(
)()(         ()())))()                          )())((())))       ()()
()()        ()()))())))                        ())()()))))()      (())
()))         || |||| |                          ||| |||| ||       ()()
(()(                                                              ()()
)(()                                                              (())
)())                                                              ((()
())(                                                              ()))
())(                                                              ()()
)()(                                                              ((()
))((                                                              )(((
()())                                                            ())))
(()))((((()()()()()(((()()))(()))     (())(((()(((()((()())(((()()())(
()()))((()()()))()(()(((()()(((())   (()())((()()()()()()))()))((())()
"""
            },
            "pokecenter": {
                "x": 9,
                "y": 25,
                "txt": CENTER
            },
            "shop": {
                "x": 47,
                "y": 25,
                "txt": SHOP
            },
            "house1": {
                "x": 47,
                "y": 4,
                "txt": HOUSE1
            },
            "house2": {
                "x": 47,
                "y": 10,
                "txt": HOUSE1
            },
            "house3": {
                "x": 47,
                "y": 16,
                "txt": HOUSE1
            },
            "house4": {
                "x": 10,
                "y": 4,
                "txt": HOUSE1
            },
            "house5": {
                "x": 10,
                "y": 10,
                "txt": HOUSE1
            },
            "house6": {
                "x": 10,
                "y": 16,
                "txt": HOUSE1
            },
        },
        "soft_obs": {
            "meadow_1": {
                "x": 29,
                "y": 22,
                "txt": """   ;;;;;
 ;;;;;;;;;;
;;;;;;;;;;;;
;;;;;;;;;;;
 ;;;;;;;;;
   ;;;;;"""
            },
        },
        "dors": {
            "dor_playmap_12_1": {
                "x": 34,
                "y": 34,
                "args": {"map": "playmap_12", "x": 70, "y": 1}
            },
            "dor_playmap_12_2": {
                "x": 35,
                "y": 34,
                "args": {"map": "playmap_12", "x": 71, "y": 1}
            },
            "dor_playmap_12_3": {
                "x": 36,
                "y": 34,
                "args": {"map": "playmap_12", "x": 72, "y": 1}
            },
            "dor_playmap_14_1": {
                "x": 32,
                "y": 4,
                "args": {"map": "playmap_14", "x": 14, "y": 13}
            },
            "dor_playmap_14_2": {
                "x": 33,
                "y": 4,
                "args": {"map": "playmap_14", "x": 15, "y": 13}
            },
            "dor_playmap_20": {
                "x": 51,
                "y": 14,
                "args": {"map": "playmap_20", "x": 11, "y": 7}
            },
        },
        "special_dors": {
            "dor": {
                "x": 14,
                "y": 29,
            },
            "shopdor": {
                "x": 52,
                "y": 29,
            }
        },
        "balls": {
            "ball_1": {
                "x": 14,
                "y": 14
            },
            "ball_2": {
                "x": 65,
                "y": 13
            },
            "ball_3": {
                "x": 64,
                "y": 32
            },
        }
    },
    "playmap_14": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """
___________________________
|__________|  |___________|
|                         |
|                         |
|                         |
|____________________     |
|___________________|     |
|                         |
|                         |
|                         |
|___________  ____________|
|__________|  |___________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_13_1": {
                "x": 14,
                "y": 14,
                "args": {"map": "playmap_13", "x": 32, "y": 5}
            },
            "dor_playmap_13_2": {
                "x": 15,
                "y": 14,
                "args": {"map": "playmap_13", "x": 33, "y": 5}
            },
            "dor_playmap_15_1": {
                "x": 14,
                "y": 3,
                "args": {"map": "playmap_15", "x": 33, "y": 23}
            },
            "dor_playmap_15_2": {
                "x": 15,
                "y": 3,
                "args": {"map": "playmap_15", "x": 34, "y": 23}
            },
        },
        "balls": {
        }
    },
    "playmap_15": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": """()(()())))))((())(()))((((())))((((()))))))))(()())((()()))()))()()()())))(((())()))()())))(()((())))(())()())))()(()())
))((()()()()((()()()()((()))((()(()))))(((()()))(()()()()))))(((()()()()())()()()()(((()))))(((()))((()))(()))()(()())))
()()) |||| | ||||| ||| | || | |||| ||| ||||| | ||||| || |||| |||||| || |||||| | || (()))())) ||| || ||||| |||||||| (()))
(())                                                                                ()(()))                         ()()
()()                                                                                ))(()()                         ()()
((()                                                                                ())()))                         ((()
()()                                                             (()))()            ()))(()                         ()))
()))                                                            ())((()()           ()))())                         (())
()))                                                            ()))()())           ((())))                         ()))
()))           ((()()))()(()()))))((()()))()(((((()))           (()()()()            |||||                          ()))
(()(          ()))()()))))((()()()()()))(((())()()()()          (()))()))                                           (())
))((          ()))((()))((())()()((((((())()())))()())           ||| |||                                             |||
()()           |||| |||||| ||| ||| |||| |||||| ||| ||
()))
(())                                                                                                                 ())
))((                                                                                                                ()()
(())                                                                          ()()))(())))))()                      ()()
)()(                                                                         (()))))(()()))()))                     ()))
))((                                                                         ())()((()))(()))))                     ()))
((()                                                    (())()))()            ||||| |||| |||||                      (())
()))                                                   (()))))()())                                                 ()))
())))                                                  (()))())()()                                                (()))
()())((())()))(()())))()()))()()    ()))((()()()((()()())))((()()(((()()(((()()))((()()()()((((()()))(()()(()))))((()())
())))()()(((((())((()))(())()))))  (()((()))((())(()(()(()))()(())))((()()()()()(((()))((()()()((()()(((()()())))((())))
| |||| ||| ||||| |||| ||| ||||||    || ||||| ||| ||| || ||| |||| ||| ||| || | |||||| ||||||| | |||||| ||||| ||||| ||||||
"""
            },
        },
        "soft_obs": {
            "meadow1": {
                "x": 96,
                "y": 5,
                "txt": """     ;;;;;;
    ;;;;;;;;;
   ;;;;;;;;;;
  ;;;;;;;;;;;;
 ;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;
  ;;;;;;;;;;;;
  ;;;;;;;;;;;;
   ;;;;;;;;;;;
    ;;;;;;;;;
       ;;;;"""
            },
            "meadow2": {
                "x": 10,
                "y": 14,
                "txt": """     ;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;"""
            },
            "meadow3": {
                "x": 6,
                "y": 4,
                "txt": """  ;;;;
 ;;;;;;
;;;;;;;;
;;;;;;;;
 ;;;;;;
  ;;;;
   ;;"""
            },
            "meadow4": {
                "x": 55,
                "y": 12,
                "txt": """   ;;;;;
 ;;;;;;;;;;
;;;;;;;;;;;;
;;;;;;;;;;;
 ;;;;;;;;;
   ;;;;;"""
            },
            "meadow5": {
                "x": 74,
                "y": 9,
                "txt": """   ;;;;;
 ;;;;;;;;;;
;;;;;;;;;;;;
;;;;;;;;;;;
 ;;;;;;;;;
   ;;;;;"""
            },
            "meadow6": {
                "x": 39,
                "y": 4,
                "txt": """ ;;;;
;;;;;;
;;;;;
 ;;;"""
            },
        },
        "dors": {
            "dor_playmap_14_1": {
                "x": 33,
                "y": 24,
                "args": {"map": "playmap_14", "x": 14, "y": 4}
            },
            "dor_playmap_14_2": {
                "x": 34,
                "y": 24,
                "args": {"map": "playmap_14", "x": 15, "y": 4}
            },
            "dor_playmap_16_1": {
                "x": 119,
                "y": 12,
                "args": {"map": "playmap_16", "x": 1, "y": 8}
            },
            "dor_playmap_16_2": {
                "x": 119,
                "y": 13,
                "args": {"map": "playmap_16", "x": 1, "y": 9}
            },
        },
        "balls": {
            "ball_1": {
                "x": 114,
                "y": 2
            },
            "ball_2": {
                "x": 68,
                "y": 11
            },
            "ball_3": {
                "x": 5,
                "y": 2
            },
        }
    },
    "playmap_16": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": """())()()))(())()()))((()())())(((((()((()))))(()()(())((()))()))()
()))) ||| ||| |||||| ||| |||||| || |||||| ||| ||||| |||| || ((())
()))                                                         (())
()))                                                         )(()
)(()                                                         ()()
()))                                                         ()))
)())                                                         ()))
|||                                                           |||


())                                                           (()
(())                         ())))                           ()))
()()                        ()))())                          ()()
))))                        ()(()))                          ()))
()()                         |||||                           ()()
)()))                                                       (()))
)())())((()()()()()))(()))()()))())())()(()((()(()(()))()()))()))"""
            },
            "house1": {
                "x": 46,
                "y": 2,
                "txt": HOUSE1
            },
            "tree_group_2": {
                "x": 37,
                "y": 4,
                "txt": """ ())()
())()))
 |||||"""
            },
        },
        "soft_obs": {
            "meadow1": {
                "x": 8,
                "y": 5,
                "txt": """     ;;;;;;;
   ;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;
   ;;;;;;;;;;;;
       ;;;;;"""
            },
            "meadow2": {
                "x": 42,
                "y": 9,
                "txt": """   ;;;;;
 ;;;;;;;;;;
;;;;;;;;;;;;
;;;;;;;;;;;
 ;;;;;;;;;
   ;;;;;"""
            },
        },
        "dors": {
            "dor_playmap_15_1": {
                "x": 0,
                "y": 8,
                "args": {"map": "playmap_15", "x": 118, "y": 12}
            },
            "dor_playmap_15_2": {
                "x": 0,
                "y": 9,
                "args": {"map": "playmap_15", "x": 118, "y": 13}
            },
            "dor_playmap_17": {
                "x": 50,
                "y": 6,
                "args": {"map": "playmap_17", "x": 11, "y": 7}
            },
            "dor_playmap_18_1": {
                "x": 64,
                "y": 8,
                "args": {"map": "playmap_18", "x": 1, "y": 11}
            },
            "dor_playmap_18_2": {
                "x": 64,
                "y": 9,
                "args": {"map": "playmap_18", "x": 1, "y": 12}
            },
        },
        "balls": {
            "ball_1": {
                "x": 5,
                "y": 1
            },
            "ball_2": {
                "x": 59,
                "y": 15
            },
            "ball_3": {
                "x": 43,
                "y": 6
            },
        }
    },
    "playmap_17": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_16": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_16", "x": 50, "y": 7}
            },
        },
        "balls": {
        },
    },
    "playmap_18": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": r"""(())(()()))(())()()()))((())())(()))()())()\___   \________       \______            \        \
((()()()))(()))(()()()()()(())(()))(()))()))   \___/ \__   \_____        \_____       \        \
(())) || || | |||| |||| |||| ||||| ||| ||||             \_____   \____         \       \        \
()))                                                          \____   \___      \       \___     \
()()                                                               \_____ \__    \___       \
(())                                                                     \   \__     \       \
())(                          (())())                                     \_    \     \       \
()))                         ()()))(()                                      \    \_    \      |
(())                         (((()(())                                       \_    \   |       )
()))                          ||| |||                                          \    \  |      |
|||                                              (())()                         \   |  \     /
                                                (()))()(                        |   |   \   /
                                                (())()))                        /   /   |  /
(()                                              || |||                       _/   /    |  |
()))         (())()))())                                                     /   _/     |  |
()))        (())())()))))                                                  _/   /       / /
()()        ()()()((())))                                               __/   _/       /  |
()))         |||| ||||||                                            ___/   __/        /   /
()()                                                           ____/   ___/      ____/   /       /
()))                                                     _____/   ____/         /       /       /
(()))                                           ________/   _____/             /       /       /
(())()())))(())()()))((()()()()()(())(()))  ___/   ________/            ______/       /    ___/
((())()()))((()())(((()()(()(()))(()(())())/      /                    /             /    /"""
            },
        },
        "soft_obs": {
            "meadow1": {
                "x": 9,
                "y": 4,
                "txt": """     ;;;;;;
   ;;;;;;;;;;;
 ;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;
   ;;;;;;;;;;;
     ;;;;;;;"""
            },
            "meadow2": {
                "x": 29,
                "y": 12,
                "txt": """     ;;;;;;;
 ;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;
    ;;;;;;;;;
       ;;;;"""
            },
            "meadow3": {
                "x": 45,
                "y": 1,
                "txt": """;;
 ;;;;;;;;;;
  ;;;;;;;;
    ;;;;"""
            },
            "meadow4": {
                "x": 89,
                "y": 5,
                "txt": """   ;
  ;;;
 ;;;;
;;;;;
;;;;;
 ;;;
  ;
"""
            },
            "water4": {
                "x": 72,
                "y": 7,
                "cls": "water",
                "txt": """  ~~
 ~~~~
~~~~~~~
~~~~~~~~
~~~~~~~~
~~~~~~~~
~~~~~~
 ~~~~
 ~~"""
            },
        },
        "dors": {
            "dor_playmap_16_1": {
                "x": 0,
                "y": 11,
                "args": {"map": "playmap_16", "x": 63, "y": 8}
            },
            "dor_playmap_16_2": {
                "x": 0,
                "y": 12,
                "args": {"map": "playmap_16", "x": 63, "y": 9}
            },
            "dor_playmap_19_1": {
                "x": 52,
                "y": 1,
                "args": {"map": "playmap_19", "x": 13, "y": 28}
            },
            "dor_playmap_19_2": {
                "x": 94,
                "y": 8,
                "args": {"map": "playmap_19", "x": 35, "y": 25}
            },
        },
        "balls": {
            "ball_1": {
                "x": 43,
                "y": 2
            },
            "ball_2": {
                "x": 51,
                "y": 13
            },
            "ball_3": {
                "x": 42,
                "y": 21
            },
            "ball_4": {
                "x": 12,
                "y": 17
            },
            "ball_5": {
                "x": 73,
                "y": 0
            },
            "ball_6": {
                "x": 90,
                "y": 14
            },
        }
    },
    "playmap_19": {
        "hard_obs": {
            "inner_walls": {
                "x": 0,
                "y": 0,
                "txt": r"""                         |  |
                         |  |   +----------+
                         |  |   |          |
                         |  |   |          |
        +------------+   |  +---+          |
        |            |   |                 |
        |            |   |  +---+          |
        |            +---+  |   |          |
        |                   |   |          |
        |            +---+  |   +----------+
        +------------+   |  |
                         |  |
         +---------------+  +------------------+
         |                                     |
     +---+                                     |
     |                                         |
     |                        +-----+          |
     |                        |     |          |
     +------+ +---------------+     +----+  +--+
            | |                          |  |
            | |                          |  |
            | |                          |  |
            | |                          |  |
            | |                          |  |
            | |                   /------+  |
            | |                  (          |
            | |                   \---------+
            | |
            | |
            | |"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_18_1": {
                "x": 13,
                "y": 29,
                "args": {"map": "playmap_18", "x": 52, "y": 2}
            },
            "dor_playmap_18_2": {
                "x": 34,
                "y": 25,
                "args": {"map": "playmap_18", "x": 93, "y": 8}
            },
            "dor_playmap_21_1": {
                "x": 26,
                "y": 0,
                "args": {"map": "playmap_21", "x": 5, "y": 25}
            },
            "dor_playmap_21_2": {
                "x": 27,
                "y": 0,
                "args": {"map": "playmap_21", "x": 5, "y": 25}
            },
        },
        "balls": {
            "ball_1": {
                "x": 46,
                "y": 13
            },
            "ball_2": {
                "x": 9,
                "y": 5
            },
            "ball_3": {
                "x": 42,
                "y": 8
            },
        }
    },
    "intromap": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |a              |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_1": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_1", "x": 6, "y": 5}
            },
        },
        "balls": {
        },
    },
    "playmap_20": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_13": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_13", "x": 51, "y": 15}
            },
        },
        "balls": {
        },
    },
    "playmap_21": {
        "hard_obs": {
            "tree_group_1": {
                "x": 0,
                "y": 0,
                "txt": r"""))())())())))()()())))((())(()()()))()))())(((()())())()()()()())))())))))(()(()()()()))((()  #    #  (((()))()((()()(()))((()()())((()()))()()))())))
()) ||||  ||| || ||||| | ||||||| || || |||| |||| ||||| || | || | ||| || | | | |||||| |(()))####    ####|||  || | | ||||| ||| ||| |||||| | ||||| || (()
()                                                                                    ((())                                                         ))
))                                                                                    ()())                                                         ()
()                                                                                     |||                                                          ((
)(                                                                                                                                                   |
)(                                                                                                                                                  __
((                                                                                                                                                 /
))                                                                                                                                                /
()                                                                                                                                               /
))                                                                                                                                              /    _
()                                                                                                                                             /    /
))                                                                                                                                             |   /
()                                                                                                                                              )  |
))                                                                                                                                             |   |
()                                                                                                                                             |   |
)(                                                                                                                                             /   /
()                                                                                                                                            /   /
)(                                                                                                                                       ____/   /
((                                                                                                                                      /   ____/
()                                                                                                                                     /   /        __
()                                                                                                                                    /   /        /
))                                                                                                                                ___/   /        /
()                                                                                                                               /     _/        /
|                                                                                                                               /     /      ___/
\___   ____                                                                                                        ____________/     /      /        /
    \_/    \                                                                                         _____________/                 /      /        /
\____       \                                                                                _______/             _________________/      /     ___/
     \___    \___  (())()(())))()))(()))))()))()((()())(())(((()((()((()(((()(()((())  _____/  __________________/                    ___/     /
\        \       \(()()))(()(()))())()))()()()(()))((()))()())())((((())(()((()))()())/       /                                      /        /      /
"""
            },
            "tree_group_2": {
                "x": 21,
                "y": 4,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "tree_group_3": {
                "x": 35,
                "y": 21,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "tree_group_4": {
                "x": 60,
                "y": 21,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "tree_group_5": {
                "x": 60,
                "y": 4,
                "txt": """ ()))
(())))
())())
)())))
()))()
 ||||"""
            },
            "tree_group_6": {
                "x": 111,
                "y": 16,
                "txt": """ (())())
()()))(()
(((()(())
 ||| |||"""
            },
            "tree_group_7": {
                "x": 100,
                "y": 7,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "tree_group_8": {
                "x": 4,
                "y": 12,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "tree_group_9": {
                "x": 28,
                "y": 12,
                "txt": """ ()())()))
()()))(()()
()))()))())
(((()(())))
 ||||| |||"""
            },
            "pokecenter": {
                "x": 5,
                "y": 3,
                "txt": CENTER
            },
            "shop": {
                "x": 29,
                "y": 3,
                "txt": SHOP
            },
            "hotel": {
                "x": 43,
                "y": 18,
                "txt": r"""   ..___________
  /||          /\
 / ||         /  \
/___Hotel!___/    \
| ##      ## | ## |
|    ____    |    |
|____|  |____|____|"""
            },
            "townhall": {
                "x": 108,
                "y": 2,
                "txt": r"""      _____
     /    /\
   _/____/ _\___
  / | ## |     /\
 /  |    |    /  \
/____________/    \
| ## ____ ## | ## |
| ## |  | ## |    |
|____|  |____|____|"""
            },
            "house1": {
                "x": 21,
                "y": 20,
                "txt": HOUSE1
            },
            "house2": {
                "x": 69,
                "y": 20,
                "txt": HOUSE1
            },
            "house3": {
                "x": 46,
                "y": 3,
                "txt": HOUSE1
            },
            "house4": {
                "x": 84,
                "y": 20,
                "txt": r"""  ______________
 /             /\
/_Pokete-Care_/  \####
| # ___  #### |  |   #
|___| |_______|_######"""
            },
            "house5": {
                "x": 130,
                "y": 6,
                "txt": HOUSE1
            },
            "house6": {
                "x": 72,
                "y": 2,
                "txt": HOUSE1
            },
        },
        "soft_obs": {
            "water1": {
                "x": 65,
                "y": 10,
                "cls": "water",
                "txt": """       ~~~~~~~~~~~
   ~~~~~~~~~~~~~~~~~~
 ~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~
 ~~~~~~~~~~~~~~~~~~~~~
    ~~~~~~~~~~~~~~
       ~~~~~~~~"""
            }
        },
        "dors": {
            "dor_playmap_19": {
                "x": 5,
                "y": 25,
                "args": {"map": "playmap_19", "x": 26, "y": 1}
            },
            "dor_playmap_22_1": {
                "x": 49,
                "y": 24,
                "args": {"map": "playmap_22", "x": 13, "y": 10}
            },
            "dor_playmap_22_2": {
                "x": 50,
                "y": 24,
                "args": {"map": "playmap_22", "x": 14, "y": 10}
            },
            "dor_playmap_24": {
                "x": 88,
                "y": 24,
                "args": {"map": "playmap_24", "x": 11, "y": 7}
            },
            "dor_playmap_25_1": {
                "x": 114,
                "y": 10,
                "args": {"map": "playmap_25", "x": 13, "y": 10}
            },
            "dor_playmap_25_2": {
                "x": 115,
                "y": 10,
                "args": {"map": "playmap_25", "x": 14, "y": 10}
            },
            "dor_playmap_27": {
                "x": 143,
                "y": 13,
                "args": {"map": "playmap_27", "x": 3, "y": 8}
            },
            "dor_playmap_29": {
                "x": 76,
                "y": 6,
                "args": {"map": "playmap_29", "x": 11, "y": 7}
            },
            "dor_playmap_40_1": {
                "x": 95,
                "y": 0,
                "args": {"map": "playmap_40", "x": 69, "y": 28}
            },
            "dor_playmap_40_2": {
                "x": 96,
                "y": 0,
                "args": {"map": "playmap_40", "x": 70, "y": 28}
            },
            "dor_playmap_40_3": {
                "x": 97,
                "y": 0,
                "args": {"map": "playmap_40", "x": 71, "y": 28}
            },
            "dor_playmap_40_4": {
                "x": 98,
                "y": 0,
                "args": {"map": "playmap_40", "x": 72, "y": 28}
            },
            "dor_playmap_50": {
                "x": 89,
                "y": 24,
                "args": {"map": "playmap_50", "x": 11, "y": 7}
            },
        },
        "special_dors": {
            "dor": {
                "x": 10,
                "y": 7,
            },
            "shopdor": {
                "x": 34,
                "y": 7,
            }
        },
        "balls": {
            "ball_1": {
                "x": 146,
                "y": 1
            },
            "ball_2": {
                "x": 115,
                "y": 19
            },
            "ball_3": {
                "x": 85,
                "y": 28
            },
            "ball_4": {
                "x": 3,
                "y": 1
            },
        },
    },
    "playmap_22": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """________________________
|______________________|
|          a           |
|       ________       |
|                      |
|                      | |
|                        |
|                      __|
|__________  __________|
|_________|  |_________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_21_1": {
                "x": 13,
                "y": 11,
                "args": {"map": "playmap_21", "x": 49, "y": 25}
            },
            "dor_playmap_21_2": {
                "x": 14,
                "y": 11,
                "args": {"map": "playmap_21", "x": 50, "y": 25}
            },
            "dor_playmap_23": {
                "x": 26,
                "y": 5,
                "args": {"map": "playmap_23", "x": 26, "y": 5}
            },
        },
        "balls": {
        },
    },
    "playmap_23": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """________________________
|______________________|
|                      |__
|                        |
|____ ___________ _____| |
|___| |____|____| |____| |
|          |           |
|          |           |
|__________|___________|
|______________________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_22": {
                "x": 26,
                "y": 6,
                "args": {"map": "playmap_22", "x": 26, "y": 6}
            },
        },
        "balls": {
        },
    },
    "playmap_24": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_21": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_21", "x": 88, "y": 25}
            },
        },
        "balls": {
        },
    },
    "playmap_25": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """________________________
|______________________|
|          a           |
|       ________       |
|                      |
|                      | |
|                        |
|                      __|
|__________  __________|
|_________|  |_________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_21_1": {
                "x": 13,
                "y": 11,
                "args": {"map": "playmap_21", "x": 114, "y": 11}
            },
            "dor_playmap_21_2": {
                "x": 14,
                "y": 11,
                "args": {"map": "playmap_21", "x": 115, "y": 11}
            },
            "dor_playmap_23": {
                "x": 26,
                "y": 5,
                "args": {"map": "playmap_26", "x": 26, "y": 5}
            },
        },
        "balls": {
        },
    },
    "playmap_26": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """________________________
|__________________|___|
|                  |   |__
|    -----         |     |
|                  |   | |
|                      | |
|                  |   |
|                  |   |
|__________________|___|
|______________________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_25": {
                "x": 26,
                "y": 6,
                "args": {"map": "playmap_25", "x": 26, "y": 6}
            },
        },
        "balls": {
        },
    },
    "playmap_27": {
        "hard_obs": {
            "inner_walls": {
                "x": 1,
                "y": 1,
                "txt": r"""
          ____________
     ____/            \
    /                  \_
   /                     \
  /                       \
 /+                       |
(                         +-----\
 \+                              )
  |                        +----/
  \                        |
   \_____                __/
         \______________/"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_21": {
                "x": 2,
                "y": 8,
                "args": {"map": "playmap_21", "x": 142, "y": 13}
            },
            "dor_playmap_33": {
                "x": 33,
                "y": 9,
                "args": {"map": "playmap_33", "x": 1, "y": 25}
            },
        },
        "balls": {
        },
    },
    "playmap_28": {
        "hard_obs": {
            "trees": {
                "x": 0,
                "y": 0,
                "txt": """                                                                                                                                    ()()())()())))()()()()()()()()()()()(()()()())((()))(()()))((()))(
                                                                                                                                    (()()())((())))())())((())(()()))(()())))(()()()))(((((()()))()())
                                                                                                                                    )))() |||| ||| |||||| | || || || ||| | |||||| | |||||| | | | ())((
                                                                                                                                    )()(                                                          ()()
                                                                                                                                    )()(                                                          ((()
                                                                                                                                    )))(                                                          ()()
                                                                                                                                    ()()                                                          ((((
                                                                                                                                    ((((                         ())())()()())                    ))((
                                                                                                                                    ))))                        (()()()))()()))                   ()()
                                                                                                                                    ()()                        ((()()((()))())                   ()()
                                                                                                                                    ((()                         ||| || ||||||                     |||
                                                                                                                                    ()()
                                                                                                                                    (())
                                                                                                                                    ))))                                                           ()(
                                                                                                                                    ((((                                                          (()(
                                                                                                                                    (())                                                          ()()
                                                                                                                                    ((()                                                          ((((
                                                                                                                                    (())())()()()))                                               ()()
                                                                                                                                    ()()(()()())))()                                              ())(
                                                                                                                                    (())()()()()))))                                              ()))
                                                                                                                                    ()() || | |||||                                               ((()
                                                                                                                                    ()()                                         (()()))))()()()()()))
(())(()())()(((()()()()())))))()()()((())))()()()()())))((()()()()()()((())))(())()()()())))))))()()()()(((((()()()()()()()()())())))())                                        (()()))((()()()()(()()
())()()(()()(())(((((())))()()()(((((()()()())))))))((((()()()))))))((()()()())(((((()))()()()(((()()()()((((((())()(((()())()))(()()(()                                        ())())(()(()))()))(())
))))) |||| ||||| | ||||| | ||||||| | || | ())() |||||||| | ||||| | ||| | |||||||||| | | ||| |||| || ||||||| | || ||||| ()()) | ||| |||||                                         |||| | | ||||| | (()(
((((                                      ())))                                                                        (()))                                                                      ((((
()()                                      ()())                                                                        ())))                                                                      ()()
(())                                      (()))                                                                        (()()                                                                      )(()
()()                                      ())))                                                                        ()())                                                                      ()()
(())                                      (()))                                                                        ((())                                                                      ((((
()()                                      (((()                                                                        )()))                                                                      ()()
()))                                      ()())                                  ((()))(((()(()))())()())              ()())())(()()))))((())()()))((()))()))(()()()))))(                         ((((
()()                                      ())()                                 ()())))()()()()))()())()()             ()())(((()))()(((())))()())))()()))))()()))()()()))                        ()()
((((                                      ())()                                 ()((()))((()()()))))((()))             ())))(())()()))))))()()()())))()()(()))()()))))))()                        ((()
)))(()()))((())()())))                (())()())                                 (())(((()(())(()))(((())()             )())) ||||| ||||| || | |||||| | | |||||| | | | |||                         ()))
()()())((())(()))())())              ())))(())(                                  ||||| | |||||| | | |||||              ))()(                                                                      ()()
()()()))()()())()))()))              (((()()())                                                                        (()()                                                                      (())
))() |||| ||| | ||||||                ||| (((()                                                                        ()())                                                                      ())(
(())                                      ()())                                                                        ()())                                                                      ()))
|||                                       ((())                                                                        (()))                                                                      ((()
                                          ()())                                                                         |||                                                                       (())
                                          )))))                                                                                                                                                   ((()
())                                       ()())                     ()())                                                                                                                         ))))
())(                                      ())))                    ())()))                                              ())                                                                       (())
()))                                       |||                     ((())()                                             ())()                                                                      ()()
((()                                                               (()()))                                             (()))                                                                      ))))
()()                                                               ()()))(                                             ))())                                                                      ()()
()))                                                               ()()())                                             (()()                                                                      ((()
()()                                                               (()()))                                             ())))                                                                      ()))
)))(                                                               ((())()                                             (()))                                                                      ()()
()))                                                               ()()())                                             ()())                                                                     ()())
()))))()((())))()))()((()))()))())()())))()))()))()(()())()()()())))((())()))()()()())))(()(((())(())(()(((((()()()()))())(((((()))))((((((())))))()()()()(((()()()()))()()()))))()))))())))(()))()(((
()()))(())()()()))()(((()(((()())))()()(()))))(()(())((((()((((((()))()()()(((((((()()()((())))))(())((((()())()()()(()(((()()()())()()()())()()())))()()())()()))))()()()())))()()((()())))))(()()()("""
            }
        },
        "soft_obs": {
            "grass": {
                "x": 0,
                "y": 0,
                "txt": """




                                                                                                                                              ;;;;;;;;;;;
                                                                                                                                            ;;;;;;;;;;;;;;
                                                                                                                                            ;;;;;;;;;;;;;;;
                                                                                                                                             ;;;;;;;;;;;;;
                                                                                                                                             ;;;;;;;;;;;;
                                                                                                                                               ;;;;;;;;;
                                                                                                                                                  ;;;;

                                                                                                                                                                                       ;;;;;
                                                                                                                                                                                     ;;;;;;;;;
                                                                                                                                                                                    ;;;;;;;;;;;
                                                                                                                                                                                    ;;;;;;;;;;
                                                                                                                                                                                      ;;;;;;;
                                                                                                                                                                                        ;;;




                                                                                                                                                        ;;;;;;;;
                                                                                                                                                     ;;;;;;;;;;;;;;
                                                                                                                                                    ;;;;;;;;;;;;;;;;
             ;;;;;;;;;;;;;;;;;;;;                                                                                                                   ;;;;;;;;;;;;;;;
          ;;;;;;;;;;;;;;;;;;;;;;;;;;                    ;;;;;;;;;;;;                                                                                  ;;;;;;;;;;;;
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;               ;;;;;;;;;;;;;;;;;;                                                                                   ;;;;;;;
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;              ;;;;;;;;;;;;;;;;;;;;;
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;               ;;;;;;;;;;;;;;;;;;;;;
          ;;;;;;;;;;;;;;;;;;;;;;;;;                ;;;;;;;;;;;;;;;;;;;;
              ;;;;;;;;;;;;;;;;                      ;;;;;;;;;;;;;;;;;;;
                                                     ;;;;;;;;;;;;;;;;;
                                                     ;;;;;;;;;;;;;;;;;
                                                      ;;;;;;;;;;;;;;;
                                                       ;;;;;;;;;;;;;
                                                          ;;;;;;;;                                                                            ;;;;;;;;;;;;;;;;;;;;;;;;
                                                                                                                                          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
               ;;;;;;;;;;;;;                                                                                                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
              ;;;;;;;;;;;;;;;                                                                                                         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
              ;;;;;;;;;;;;;;;;                                                     ;;;;;;;;;;;;;;;;;;;;;;;;                          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
             ;;;;;;;;;;;;;;;;;                                                   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;                        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
             ;;;;;;;;;;;;;;;;;;                                                 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
             ;;;;;;;;;;;;;;;;;;                                               ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
              ;;;;;;;;;;;;;;;;;                                                ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                             ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
              ;;;;;;;;;;;;;;;;                                                  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                                 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
               ;;;;;;;;;;;;;;                                                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;                                        ;;;;;;;;;;;;;;;;;;;;;;;
                 ;;;;;;;;;;                                                        ;;;;;;;;;;;;;;;;;;;;;;;                                                ;;;;;;;;;;;"""
            }
        },
        "dors": {
            "dor_playmap_4_1": {
                "x": 0,
                "y": 40,
                "args": {"map": "playmap_4", "x": 58, "y": 22}
            },
            "dor_playmap_4_2": {
                "x": 0,
                "y": 41,
                "args": {"map": "playmap_4", "x": 58, "y": 23}
            },
            "dor_playmap_30_1": {
                "x": 197,
                "y": 11,
                "args": {"map": "playmap_30", "x": 1, "y": 15}
            },
            "dor_playmap_30_2": {
                "x": 197,
                "y": 12,
                "args": {"map": "playmap_30", "x": 1, "y": 16}
            },
        },
        "balls": {
            "ball_1": {
                "x": 91,
                "y": 24,
            },
            "ball_2": {
                "x": 74,
                "y": 50,
            },
            "ball_3": {
                "x": 41,
                "y": 37,
            },
            "ball_4": {
                "x": 91,
                "y": 24,
            },
            "ball_5": {
                "x": 5,
                "y": 24,
            },
            "ball_6": {
                "x": 159,
                "y": 34,
            },
            "ball_7": {
                "x": 186,
                "y": 2,
            },
        }
    },
    "playmap_29": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_21": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_21", "x": 76, "y": 7}
            },
        },
        "balls": {
        },
    },
    "playmap_30": {
        "hard_obs": {
            "main": {
                "x": 0,
                "y": 0,
                "txt": r"""()(()))((()(()))()()((()()()()()())))()()()())()()()))))))()(((()())((((()()()(((())()())(())(()()(())(()()))((()(()(())))(()())())((()))()()()())()
)())) ||| |||| | | |||| || ||||| | | ||||| ||| ||| ||||| ||| |||||| ||| || |||||||| | ||||| ||||| ||||| ||||| ||| ||||| || |||||| | |||||||| || ()))
))()                                                                                               ________________                              ())
()()                                                                                              /               /\                            ())(
()()                                                                                             /_______________/  \        ())()))()          ()))
()))                                                                                             |  ##  ___  ##  |  |       (()())())))         )())
(())                                                                                             |______| |______|__|        |||| ||||          ()()
(())                                                                                                                                            (())
(())                                               _____________________________                                                                )())
()()                                              /                            /\                                                           ())))()(
(()(                                             /         _______            /  \                                  (()()))                ()())())(
()))                                            /          |Arena|           /    \                                ()())()))                || |)())
()))                                           /____________________________/      \                               ()()))()))                   ((((
()))                          ())())()()) ()   |                            |      |     ()()() ()() )             (()()))()                    ()()
|||                          ())()))()())))))  |    ###              ###    |  ##  |    ())())(())()())              ()())                      ()()
                             (())(())()()))()  |    ###     ____     ###    |  ##  |    ())()()((()))()               | | ())                   ())(
                              || |||| || |||   |____________|  |____________|______|     || | |||| |||            ()) | |/                      ()()
())                                                                                                                  \| |                       )())
()))                                                                                                        __________| |___________            ()))
))()                                                                                                        |______________________|            ()))
())(                                                                                                                                            ()))
()()                                                                                                                                            ((()
(())      ______________           ________________                                                                                             ()()
()))     /             /\         /               /\                ____________            ________                          ____________      (())
()()    /             /  \       /               /  \())())()      /           /\          /       /\   ()())(()))(()))(     /           /\     ()))
()))   /_____________/    \     /_______________/ ##(()())()))    /___________/  \  ())   /_______/  \ (())()))())())()))   /___________/  \    ))()
()))   |  ___   ###  | ## |     |  ##  ___  ##  |   ()(())()))    | ## ___ ## |  | ())()  |# ___ #|  | (()))((()()()))())   | ## ___ ## |  |    ))()
()()   |__| |________|____|     |______| |______|____||||| ||     |____| |____|__|  |||   |__| |__|__|  ||||| | ||| ||||    |____| |____|__|    ()))
)(()                                                                                                                                            )())
()))                                                                                                                                            ()))
()))()()))())(()())(())())()()()()())()()(()()()()()()()()))()()()()()()()()()))))))()())(()()())))))))(()()()()((((()(())))))()()()(())))()()((()))
()())))))))()()()())))))))((()))(()(()()(((((()()()()()()()))))((()(()()()()()((())((()()(()))((()))())(()(((()))((()()))())))))(()())))()())()((())
"""
            },
            "pokecenter": {
                "x": 8,
                "y": 3,
                "txt": CENTER
            },
            "shop": {
                "x": 25,
                "y": 3,
                "txt": SHOP
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_28_1": {
                "x": 0,
                "y": 15,
                "args": {"map": "playmap_28", "x": 196, "y": 11}
            },
            "dor_playmap_28_2": {
                "x": 0,
                "y": 16,
                "args": {"map": "playmap_28", "x": 196, "y": 12}
            },
            "dor_playmap_31_1": {
                "x": 61,
                "y": 16,
                "args": {"map": "playmap_31", "x": 17, "y": 12}
            },
            "dor_playmap_31_2": {
                "x": 62,
                "y": 16,
                "args": {"map": "playmap_31", "x": 18, "y": 12}
            },
            "dor_playmap_32": {
                "x": 94,
                "y": 27,
                "args": {"map": "playmap_32", "x": 11, "y": 7}
            },
        },
        "special_dors": {
            "dor": {
                "x": 13,
                "y": 7,
            },
            "shopdor": {
                "x": 30,
                "y": 7,
            }
        },
        "balls": {
            "ball_1": {
                "x": 58,
                "y": 27,
            },
            "ball_2": {
                "x": 143,
                "y": 29,
            },
            "ball_4": {
                "x": 142,
                "y": 11,
            },
            "ball_5": {
                "x": 98,
                "y": 16,
            },
            "ball_6": {
                "x": 23,
                "y": 1,
            },
            "ball_7": {
                "x": 29,
                "y": 16,
            },
        },
    },
    "playmap_31": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """_____________________________________
|___________________________________|
|                                   |
|                                |  |
|                                |  |
|                                |  |
|                                |  |
|                                |  |
|                                |  |
|                                |  |
|                                |  |
|______________  ________________|  |
|_____________|  |_______________|  |"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_30_1": {
                "x": 36,
                "y": 13,
                "args": {"map": "playmap_30", "x": 61, "y": 17}
            },
            "dor_playmap_30_2": {
                "x": 37,
                "y": 13,
                "args": {"map": "playmap_30", "x": 62, "y": 17}
            },
        },
        "balls": {
        },
    },
    "playmap_32": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_30": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_30", "x": 94, "y": 28}
            },
        },
        "balls": {
        },
    },
    "playmap_33": {
        "hard_obs": {
            "main": {
                "x": 0,
                "y": 0,
                "txt": r"""())((())()()())((()()()))((())()()())((()))()()))((())(())(()(())(())))((())()())((())))(()(()()))(()()()()())(())())((())))(()())))()((())()))((())(()))(
())( || |||| |||| |||| || || || || | | ||||| | ||||| | | |||| | ||||| ||||| | || ||||| || ||||| || || | ||||| | | | ||||| | |||||| |||| | |||| | |||| )(()
())                                                                                                                                                    ))(
(()                                                                                                                                                    ())
())                                                                                                                                                    ())
)))                                                                                                                                                    ))(
(()                  ()()))                                                                                                                            ())
())                 (())()))                                                                                                                           (()
(((                  ||| ||                                                                                                                            )))
)))                                                                                                        (())()))                                    (((
)()                                                                                                       (()))())()                                   ())
))(                                                                                                        |||| |||                                    ())
()(                                                                                                                                                    (((
())                                                                                                                                                    )()
())                                               ()))()))))                                                                                           ())
))(                                              (())())())))                                                                                          ())
())                                               || ||| |||                                                                                           (((
())                                                                                                                                                    )))
)()                                                                                                                                                    (()
))(                                                                     __________                                                                     ))(
))(                                                                    /         /\                                                                    )((
(()                                                                   /_________/  \                                                                    ||
())                                                                   | # ___ # |  |
())                                                                   |___| |___|__|
||                                                                                                                                                      ()
                                                                                                                                                       (()
                                                                                                                                                       ())
()                                                                                                                                                     (((
())                                                                                                                                                    )))
(()                                                                                                                                                    ())
())                                                        ()))                                                                                        ())
())                                                       (())()                                      ())())()))                                       ())
)))                                                        ||||                                      (())()))()))                                      )))
()(                                                                                                   || ||||| |                                       )))
())                                                                                                                                                    ())
))(                  (()))()()))                                                                                                                       ))(
())                 (())()()))())                                                                                                                      )))
())                  ||| | |||||                                                                                                                       ())
)))                                                                                                                                                    ())
(()                                                                                                                                                    )))
)()                                                                                                                                                    ))(
()(                                                                                                                                                    )()
()))                                                                                                                                                  (())
(()))(()(()((()()))(()))()()()))((()))(((()()))(()()()())(())))(()()((()))(()(()())))())()))()()()()(())(()))(())())()()))(())(())))()()()()))(())((()))()"""
            },
        },
        "soft_obs": {
            "grass_1": {
                "x": 7,
                "y": 11,
                "txt": """            ;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;
            ;;;;;;;;"""
            },
            "grass_2": {
                "x": 93,
                "y": 14,
                "txt": """            ;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;
            ;;;;;;;;;;;"""
            },
            "grass_3": {
                "x": 60,
                "y": 5,
                "txt": """            ;;;;;;;;;;;
         ;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;;;;;;;;
          ;;;;;;;;;;;;;;;;;;"""
            },
            "grass_4": {
                "x": 65,
                "y": 31,
                "txt": """            ;;;;;;;;;;;
         ;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;;;;;;;;
          ;;;;;;;;;;;;;;;;;;"""
            },
            "grass_5": {
                "x": 115,
                "y": 32,
                "txt": """            ;;;;;;;;;
         ;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;
          ;;;;;;;;;;;"""
            },
            "grass_6": {
                "x": 116,
                "y": 4,
                "txt": """            ;;;;;;;;;
         ;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;
          ;;;;;;;;;;;"""
            },
            "grass_7": {
                "x": 30,
                "y": 28,
                "txt": """            ;;;;;;;
         ;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;
          ;;;;;;;;"""
            },
        },
        "dors": {
            "dor_playmap_27_1": {
                "x": 0,
                "y": 25,
                "args": {"map": "playmap_27", "x": 32, "y": 9}
            },
            "dor_playmap_27_2": {
                "x": 0,
                "y": 26,
                "args": {"map": "playmap_27", "x": 32, "y": 9}
            },
            "dor_playmap_34": {
                "x": 75,
                "y": 23,
                "args": {"map": "playmap_34", "x": 11, "y": 7}
            },
            "dor_playmap_35_1": {
                "x": 153,
                "y": 22,
                "args": {"map": "playmap_35", "x": 1, "y": 14}
            },
            "dor_playmap_35_2": {
                "x": 153,
                "y": 23,
                "args": {"map": "playmap_35", "x": 1, "y": 15}
            },
        },
        "balls": {
            "ball_1": {
                "x": 52,
                "y": 16,
            },
            "ball_2": {
                "x": 104,
                "y": 33,
            },
            "ball_3": {
                "x": 149,
                "y": 42,
            },
            "ball_4": {
                "x": 106,
                "y": 11,
            },
            "ball_5": {
                "x": 7,
                "y": 1,
            },
            "ball_6": {
                "x": 24,
                "y": 37,
            },
        },
    },
    "playmap_34": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_33": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_33", "x": 75, "y": 24}
            },
        },
        "balls": {
        },
    },
    "playmap_35": {
        "hard_obs": {
            "main": {
                "x": 0,
                "y": 0,
                "txt": r"""(()((())()())))))())))()())(()(())()(((()))()())))))()())((((())()((()(()))))())())(()(((()(((((((((())(()(()(((()))(())(()())))(())((())))(()(
()( |||| ||||||| | |||||||| | | ||||||||||| | || ||||||||||||| | ||||||||||| || |||||||||||| | ||||||||| | | | | ||| | |||| | || |||||||||| (()
(((                                                                                                                                         )((
(((                                                                                                                                         ))(
(()                                                                                                                                         (((
)))                                                                                                                                         ())
)))                                                                                                                                         ())
))(                                                                                                                                         )()
()(                                                                                                                                         )((
())                                                                                                                                         ())
))(                                                                                                                          ()()())        (((
()(                                                                                                                         (((()()))       (((
()(                                                                                                                         ()())()))       (((
||                                                                                                                           || ||||        )))
                                                                                                                                            )))
                                                                                                                                            ))(
()                                                                                                                          __________      (()
(((                                                                                                                        /         /\     (()
()(                                                                                                                       /_________/  \    (((
(()                                                                                                                       | # ___ # |  |    (((
())                                                                                                                       |___| |___|__|    (((
)((                                                                                                                                         (((
))(                                                                                                                                         ))(
))()                                                                                                                                       ())(
)()()                                                                 (())                                                                ()(()
)()()################################################################(()())#############################           #######################()())
))(|                                                                 ())())                            #           #                       |())
()(                                                                   ||#|   ________                                                       ())
)()                                                                     #   /       /\                                                      (((
(((                                                                     #  /_______/  \                                                     (()
()(                                                       (())())       #  |  ___  |  |                                                     ))(
())                                                      ()())(())      #  |__| |__|__|                                                     ()(
)()                                                      (()()))))      #                                                                   ()(
)))                                                       ||| | |       #                                                                   )()
)((                                                                    ##                                                                   ())
)()                                                                                                                                         ))(
)((                                                                                                                                         )()
()(                                                                                                                                         )()
(((                                                                                                                                         (((
(()                                                                    ##                                                                   (((
))(                                                                     #                                                                   )((
))(                                                       (()())))      #                                                                   )((
))(                                                      (())(())))     #                                                                   (()
())                                                      (())())())     #                                                                   )()
(((                                                       | || |||      #                                                                  ()()
())                                                                   ()()                                                                ()())
(()                                                                  (()())###############################################################()))(
)()                                                                  (())()                                                                |)((
(()                                                                   ||#|                                                                  )()
(()                                                                     #                                                                   ))(
)))                                                                     #                                                                   (()
(()                                                                     #                                                       (()()))     (()
))(                                                                     #                                                      ()())(())    (()
(()                                                                     #                                                      (()()))))    ()(
(((                                                                     #                                                       || ||||     )()
()(                                                                     ##                                                                  )))
(((                                                                                                                                         ))(
(((                                                                                                                                         )))
(((                                                                                                                                         (((
)()                                                                                                                           ________      )((
(()                                                                     ##                                                   /       /\     ))(
())                                                                     #                                                   /_______/  \    )((
())                                                         (()()()     #                                                   |  ___  |  |    )()
(()                                                        (()())())    #                                                   |__| |__|__|    (()
)((                                                        (()()())(    #                                                                   )((
(((                                                         || | ||     #                                                                   ))(
())                                                                     #                                                                   )))
)(()                                                                    #                                     #    #                        ()(
())()())()())))(((()(()))(()()))()))((()))()(()))))())(()((((()(((()))()(()((()()((())))))()))())(((()((())(((#    #)()()()(())((()))(()(()))(("""
            },
        },
        "soft_obs": {
            "grass_1": {
                "x": 9,
                "y": 4,
                "txt": """                 ;;;;;;;;;;;;;;                                        ;;;;;;;;;;
          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                        ;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;;;;;;;;;;;;;;;;;;;;;                            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
               ;;;;;;;;;;;;                                      ;;;;;;;;;;;;;;;;;;;"""
            },
            "grass_2": {
                "x": 76,
                "y": 29,
                "txt": """                  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
               ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
               ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
               ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"""
            },
            "grass_3": {
                "x": 7,
                "y": 28,
                "txt": """            ;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
            ;;;;;;;;;;;;;;;;;;;"""
            },
            "grass_4": {
                "x": 80,
                "y": 50,
                "txt": """            ;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;
            ;;;;;;;;;;;"""
            },
        },
        "dors": {
            "dor_playmap_33_1": {
                "x": 0,
                "y": 14,
                "args": {"map": "playmap_33", "x": 152, "y": 22}
            },
            "dor_playmap_33_2": {
                "x": 0,
                "y": 15,
                "args": {"map": "playmap_33", "x": 152, "y": 23}
            },
            "dor_playmap_36": {
                "x": 127,
                "y": 20,
                "args": {"map": "playmap_36", "x": 11, "y": 7}
            },
            "dor_playmap_37": {
                "x": 79,
                "y": 31,
                "args": {"map": "playmap_37", "x": 11, "y": 7}
            },
            "dor_playmap_38": {
                "x": 128,
                "y": 63,
                "args": {"map": "playmap_38", "x": 11, "y": 7}
            },
            "dor_playmap_39_1": {
                "x": 111,
                "y": 68,
                "args": {"map": "playmap_39", "x": 96, "y": 1}
            },
            "dor_playmap_39_2": {
                "x": 112,
                "y": 68,
                "args": {"map": "playmap_39", "x": 97, "y": 1}
            },
            "dor_playmap_39_3": {
                "x": 113,
                "y": 68,
                "args": {"map": "playmap_39", "x": 98, "y": 1}
            },
            "dor_playmap_39_4": {
                "x": 114,
                "y": 68,
                "args": {"map": "playmap_39", "x": 99, "y": 1}
            },
        },
        "balls": {
            "ball_1": {
                "x": 31,
                "y": 1,
            },
            "ball_2": {
                "x": 137,
                "y": 24,
            },
            "ball_3": {
                "x": 74,
                "y": 45,
            },
            "ball_4": {
                "x": 3,
                "y": 27,
            },
            "ball_5": {
                "x": 4,
                "y": 67,
            },
            "ball_6": {
                "x": 130,
                "y": 54,
            },
        },
    },
    "playmap_36": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_35": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_35", "x": 127, "y": 21}
            },
        },
        "balls": {
        },
    },
    "playmap_37": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_35": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_35", "x": 79, "y": 32}
            },
        },
        "balls": {
        },
    },
    "playmap_38": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_35": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_35", "x": 128, "y": 64}
            },
        },
        "balls": {
        },
    },
    "playmap_39": {
        "hard_obs": {
            "walls": {
                "x": 0,
                "y": 0,
                "txt": r""")())))))))))()))))())(())(((((((((())))())(((()(((((()))(((())))()(())())))(((((()(())())()(()(#    #)()((((()(()((((())()()(()))())))()))((()((()))(()###############################################
(() | ||||| | ||||| | |||||| ||| | |||| || ||| | |||| | ||||||| | | |||| || ||||| | |||| |||| ##    ##||| | |||| | ||||| | |||| || |||| | || || |(()(())                                             #
(((                             _________________                ___________          #                         ____________              ______  || ||##                                            #
)))                            /                /\       ())    / ##       /\         #                        /           /\    (()     /  #  /\       #                                            #
()(                           /________________/  \     ((())  /__________/  \        #                       /___________/  \  ()())   /_____/  \      #                                            #
)((                           | ___      ___ # |  |     ()())  |   ___ ## |  |  #  #  #                       | ___  ##   |  |  ()())   | ___ |  |      #                                            #
)((                           |_| |_#____| |___|__|      |||   |___| |____|_#####  ####                       |_| |_______|__|   |||    |_| |_|__|     ##                                            #
())                                 #                                                                                                                                                                #
)((                                 #                                                                                                                  ##                                            #
(()                                 #                                                                                                                   #                                            #
(((                                 #                                                                                                                   #                                            #
(()                                 #                                                                                                                   #                                            #
))(                                 #                                                     _____                                                         #                                            #
(((                                 #                                    (()             / #  /\                                                  ())   #                                            #
(((                                 #                                   ((())           /____/  \                     ())                        ()())  #                                            #
)))                                 #                                   ()())      _____| ## |  |_______             ())))      _____________    ())))  #                                            #
))(                                 #                                    |||      /     |    |  |      /\            (()()     /     #      /\    |||   #                                            #
)((                                 #                                            /                    /  \            |||     /____________/  \        (()                                           #
()(                                 #                      ____________         /____________________/____\_________          |    ___  #  |  |       (()()                                       ((()
())                                 #                     /           /\        |                    |   /   #     /\      ###|____| |_____|_#########())()######################################(((()
())                                 #                    /___________/  \       |  ###   ____   ###  |  /_________/  \     #                           |||                                        |())
)()                                 #                    | ## ___ ## |  |       |  ###   |  |   ###  |  | # ___ # |  |     #                                                                       )()
())                                 #                    |____| |____|_#########|________|  |________|__|___| |___|__#######                                   __________            __________    )((
)((                                 #                                                                                                                         /         /\          /         /\   )))
))(                                 #                                                                                                                        /_________/  \        /_________/  \  ()(
)()                                 #                                                                                                                        | # ___ # |  |        | # ___ # |  |  ))(
()(         ____________________    #                                                                                                                        |___| |___|_##########|___| |___|__|  )()
()(        /                   /\   #                                                                                   ________________________                                                   ))(
)))       /___________________/  \  #                     ())                                                          /  / /\         / /\    /\                                                  )))
)))       | # ___  ###  ___ # |  |  #                    ())((                         [------]                       /   |#||         |#||   /  \     ())())                                      (((
())#######|___| |_______| |___|_#####                    (()))                     [--]        [--]                  /_______________________/    \   ())())()                       __________    ))(
|| #                                                     ())()                      |     ||     |                   |         Arena         |    |   ((()))()                      /         /\   )((
####                                                     ()())                      |    [/\]    |                   | #   #    ____   #   # |    |   (())(())                     /_________/  \  )))
                                                         ((())                      |            |                   | #   #    |  |   #   # |    |    ||| ||                      | # ___ # |  |  ())
                                                         ()())                     [--]        [--]                  |__________|  |_________|____|                                |___| |___|__|  ()(
####                                                      |||                          [------]                                                                                                    (()
() #                                                                                                                                                                                               )((
(()         _______________________            ___________________                                                                                                                                 (((
))(        /                      /\          /                  /\                                                                                                                  __________    )((
(()####   /______________________/  \        /__________________/  \                                                                                                                /         /\   ())
())   #   | ## ___   ##   ___ ## |  |        |    ___    ###    |  |                                                                                                               /_________/  \  ()(
)))   ####|____| |________| |____|_##########|____| |_______#___|__|                                                                                                               | # ___ # |  |  (()
(((                                                         #                    ^__^                                 __________________                                           |___| |___|__|  (((
())                                                         #                 ___(oo)____________________            /     / /\        /\                                                          ()(
())                                                         #                /   (__)   MowCow-Burger   /\          /      |#||       /  \                                                         )()
))(                                                         ##              /__________________________/  \        /_________________/    \    ()()))()                                            )((
(((                                                                         |  ##   ##  ____  ##   ##  |  |        |                 |    |   ()))()))()                  ()()          ()()       )))
())   ())                                                                   |___________|  |___________|_######    |  ##   ___   ##  |    |   (()()())))                 ()(())        ()())(      ())
)))  ((())      _____________                               ##                                                #####|_______| |_______|____|    ||| ||||                  ()()))        ()))()      )()
())  ())))     /            /\                              #                                                                                                             ||||          ||||       (((
())   |||     /____________/  \                             #                   ()()            ()))                                                                                               )((
(((           | ## ___  ## |  |                             #                  ())())          ((()()                                                                                     _____    (()
)))   ########|____| |_____|_###                            #                  ()))()          ()()))                                                                                    /    /\   )()
()(   #                        #                            #                   ||||            ||||                                                                                    /____/  \  (()
)()####                        #                           ())                                                                                                                          |___ |  |  ())
)()                            ###########################()())       ())                                                                                            ())                || |_|__| ()((
)()                                                       ()())      (()()                                                                                          ()())                        (())(
(()                                                        |||#######())()                                                                                          ((())          #   #         (()))
()(           \|/ __  \|/                                             |||##                                                                                          |||############   ###########|))(
))(          _\|//_/\_\|/__                                               #                                                                                           #                            ())
(((         /  | |#||  |  /\                                              #                                                                        ______________     #                            ())
(()        /_____________/  \                                             ##                                                                      /             /\    #                            )))
)()        |  #  ___  #  |  |                                                                                                                    /_____________/  \   #                            )()
)((        |_____| |_____|__|                                                                                                                    |  #  ___  #  |  |   #                            ()(
()(                                                                       ##                                                                     |_____| |_____|__|   #                            ()(
))(                                                                       #                                                                                           #                            (()
(((                                                                       #                                                                                           #                            )()
((((())()())))(((())()((((()))())())(()(())((()()(()((((()(((())((()()(()(())))()(((())))()))))()))((())()()))(()(()()())))))))((()())())))))()()())())())()())()))))))()(()()((()()())((()))))))()())
"""
            },
            "pokecenter": {
                "x": 39,
                "y": 48,
                "txt": CENTER
            },
            "shop": {
                "x": 117,
                "y": 60,
                "txt": SHOP
            },
            "tree_group_1": {
                "x": 135,
                "y": 61,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
            "tree_group_2": {
                "x": 109,
                "y": 61,
                "txt": """ ()))
(())))
())())
 ||||"""
            },
        },
        "soft_obs": {
            "water1": {
                "x": 85,
                "y": 29,
                "cls": "water",
                "txt": """
  ~~~~~~~~
~~~~~  ~~~~~
~~~~    ~~~~
~~~~~~~~~~~~
  ~~~~~~~~"""
            },
            "grass_1": {
                "x": 155,
                "y": 2,
                "txt": """          ;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;;;;;;;;;;;;;;;;;;;;;;;;;"""
            },
            "grass_2": {
                "x": 32,
                "y": 57,
                "txt": """          ;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"""
            },
            "grass_3": {
                "x": 168,
                "y": 59,
                "txt": """
    ;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;"""
            },
            "grass_4": {
                "x": 4,
                "y": 3,
                "txt": """   ;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;"""

            },
        },
        "dors": {
            "dor_playmap_35_1": {
                "x": 96,
                "y": 0,
                "args": {"map": "playmap_35", "x": 111, "y": 67}
            },
            "dor_playmap_35_2": {
                "x": 97,
                "y": 0,
                "args": {"map": "playmap_35", "x": 112, "y": 67}
            },
            "dor_playmap_35_3": {
                "x": 98,
                "y": 0,
                "args": {"map": "playmap_35", "x": 113, "y": 67}
            },
            "dor_playmap_35_4": {
                "x": 99,
                "y": 0,
                "args": {"map": "playmap_35", "x": 114, "y": 67}
            },
            "dor_playmap_41_1": {
                "x": 42,
                "y": 6,
                "args": {"map": "playmap_41", "x": 26, "y": 7}
            },
            "dor_playmap_41_2": {
                "x": 33,
                "y": 6,
                "args": {"map": "playmap_41", "x": 11, "y": 7}
            },
            "dor_playmap_42_1": {
                "x": 89,
                "y": 47,
                "args": {"map": "playmap_42", "x": 18, "y": 7}
            },
            "dor_playmap_42_2": {
                "x": 90,
                "y": 47,
                "args": {"map": "playmap_42", "x": 19, "y": 7}
            },
            "dor_playmap_43": {
                "x": 18,
                "y": 63,
                "args": {"map": "playmap_43", "x": 11, "y": 7}
            },
            "dor_playmap_44_1": {
                "x": 90,
                "y": 22,
                "args": {"map": "playmap_44", "x": 13, "y": 10}
            },
            "dor_playmap_44_2": {
                "x": 91,
                "y": 22,
                "args": {"map": "playmap_44", "x": 14, "y": 10}
            },
            "dor_playmap_46_1": {
                "x": 129,
                "y": 34,
                "args": {"map": "playmap_46", "x": 22, "y": 10}
            },
            "dor_playmap_46_2": {
                "x": 130,
                "y": 34,
                "args": {"map": "playmap_46", "x": 22, "y": 10}
            },
            "dor_playmap_47": {
                "x": 68,
                "y": 6,
                "args": {"map": "playmap_47", "x": 11, "y": 7}
            },
            "dor_playmap_48": {
                "x": 152,
                "y": 64,
                "args": {"map": "playmap_48", "x": 11, "y": 7}
            },
        },
        "special_dors": {
            "dor": {
                "x": 44,
                "y": 52,
            },
            "shopdor": {
                "x": 122,
                "y": 64,
            }
        },
        "balls": {
            "ball_1": {
                "x": 3,
                "y": 29,
            },
            "ball_2": {
                "x": 35,
                "y": 29,
            },
            "ball_3": {
                "x": 35,
                "y": 7,
            },
            "ball_4": {
                "x": 28,
                "y": 1,
            },
            "ball_5": {
                "x": 3,
                "y": 1,
            },
            "ball_6": {
                "x": 72,
                "y": 16,
            },
            "ball_7": {
                "x": 83,
                "y": 1,
            },
            "ball_8": {
                "x": 3,
                "y": 40,
            },
            "ball_9": {
                "x": 193,
                "y": 18,
            },
            "ball_10": {
                "x": 178,
                "y": 25,
            },
            "ball_11": {
                "x": 154,
                "y": 33,
            },
            "ball_12": {
                "x": 167,
                "y": 59,
            },
            "ball_13": {
                "x": 7,
                "y": 53,
            },
            "ball_14": {
                "x": 31,
                "y": 66,
            },
            "ball_15": {
                "x": 69,
                "y": 58,
            },
            "ball_16": {
                "x": 109,
                "y": 48,
            },
            "ball_17": {
                "x": 140,
                "y": 64,
            },
        },
    },
    "playmap_40": {
        "hard_obs": {
            "trees": {
                "x": 0,
                "y": 0,
                "txt": """




















())
()()
())(                                                                                                                                     (((
(())                                                                                                                                    ()()
()))                                                                                                                                    (())
())(                                                                                                                                    ()()
())()                                                                                                                                  (()()
(()()))))(()))(()(((()(())(()))())))())((()))(()()())((()))(())((() #    # ())()()(()))(()()())()())((()()()))(()))()))()(())))((()))()))(()
(())((())()()()(((())((())(()()(())((()()()())((()))(()()()))((()())#    #(()))(()()()()))(((()))((()))(((())))(((())(()()))((((())))((()))("""
            }
        },
        "soft_obs": {
            "water1": {
                "x": 0,
                "y": 0,
                "cls": "water",
                "txt": """~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~          ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~~~~~~~                         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~~~~~                                       ~~~~~~~~~~~~~~~~~~~~~~~                                        ~~~~~~~~~~~~~~~~~~~~
~~~~~~~~~~~~~~                                                   ~~~                                                              ~~~~~~~~~~
~~~~~~~~~~                                                                                                                                ~~
~~~"""
            },
            "sand1": {
                "x": 10,
                "y": 15,
                "cls": "sand",
                "txt": """    ............
 ....................
.......................
 ...................
    ..............
          ..."""
            },
            "sand2": {
                "x": 86,
                "y": 12,
                "cls": "sand",
                "txt": """             .....
        ..............
    .....................
 ..........................
.............................
 ...........................
    ......................
       .................
          ..........
             ..."""
            },
            "sand3": {
                "x": 39,
                "y": 19,
                "cls": "sand",
                "txt": """    ............
 ..................
.....................
 ..................
  ................
     ......."""
            },
            "sand4": {
                "x": 115,
                "y": 20,
                "cls": "sand",
                "txt": """    .........
 ..............
................
 ...............
  .............
     ......."""
            },
        },
        "dors": {
            "dor_playmap_21_1": {
                "x": 69,
                "y": 29,
                "args": {"map": "playmap_21", "x": 95, "y": 1}
            },
            "dor_playmap_21_2": {
                "x": 70,
                "y": 29,
                "args": {"map": "playmap_21", "x": 96, "y": 1}
            },
            "dor_playmap_21_3": {
                "x": 71,
                "y": 29,
                "args": {"map": "playmap_21", "x": 97, "y": 1}
            },
            "dor_playmap_21_4": {
                "x": 72,
                "y": 29,
                "args": {"map": "playmap_21", "x": 98, "y": 1}
            },
        },
        "balls": {
            "ball_1": {
                "x": 5,
                "y": 27,
            },
            "ball_2": {
                "x": 89,
                "y": 18,
            },
            "ball_3": {
                "x": 139,
                "y": 22,
            },
        }
    },
    "playmap_41": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ ________________________________
 |______________________________|
 |                              |
 |                              |
 |                              |
 |_______ ______________ _______|
 |______| |____________| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_39_1": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_39", "x": 33, "y": 7}
            },
            "dor_playmap_39_2": {
                "x": 26,
                "y": 8,
                "args": {"map": "playmap_39", "x": 42, "y": 7}
            }
        },
        "balls": {
        },
    },
    "playmap_42": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ ________________________________
 |______________________________|
 |                              |
 |--------                      |
 |                              |
 |______________  ______________|
 |_____________|  |_____________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_39_1": {
                "x": 18,
                "y": 8,
                "args": {"map": "playmap_39", "x": 89, "y": 48}
            },
            "dor_playmap_39_2": {
                "x": 19,
                "y": 8,
                "args": {"map": "playmap_39", "x": 90, "y": 48}
            }
        },
        "balls": {
        },
    },
    "playmap_43": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_35": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_39", "x": 18, "y": 64}
            },
        },
        "balls": {
        },
    },
    "playmap_44": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """________________________
|______________________|
|          a           |
|       ________       |
|                      |
|                      | |
|                        |
|                      __|
|__________  __________|
|_________|  |_________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_39_1": {
                "x": 13,
                "y": 11,
                "args": {"map": "playmap_39", "x": 90, "y": 23}
            },
            "dor_playmap_39_2": {
                "x": 14,
                "y": 11,
                "args": {"map": "playmap_39", "x": 91, "y": 23}
            },
            "dor_playmap_45": {
                "x": 26,
                "y": 5,
                "args": {"map": "playmap_45", "x": 26, "y": 5}
            },
        },
        "balls": {
        },
    },
    "playmap_45": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """________________________
|__________________|___|
|                  |   |__
|    -----         |     |
|                  |   | |
|                      | |
|                  |   |
|                  |   |
|__________________|___|
|______________________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_44": {
                "x": 26,
                "y": 6,
                "args": {"map": "playmap_44", "x": 26, "y": 6}
            },
        },
        "balls": {
        },
    },
    "playmap_46": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """________________________
|______________________|
|                      |__
|                        |
|   ___________________| |
|   |__________________| |
|                      | |
|                      | |
|___________________ __| |
|__________________| |_| |
                    #"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_39": {
                "x": 26,
                "y": 11,
                "args": {"map": "playmap_39", "x": 129, "y": 35}
            },
        },
        "balls": {
        },
    },
    "playmap_47": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_35": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_39", "x": 68, "y": 7}
            },
        },
        "balls": {
        },
    },
    "playmap_48": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_35": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_39", "x": 152, "y": 65}
            },
        },
        "balls": {
        },
    },
    "playmap_49": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ _________________
 |_______________|
 |               |
 |               |
 |               |
 |_______ _______|
 |______| |______|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_35": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_3", "x": 22, "y": 16}
            },
        },
        "balls": {
        },
    },
    "playmap_50": {
        "hard_obs": {
            "inner_walls": {
                "x": 2,
                "y": 1,
                "txt": """ __________________________
 |___________________#____|
 |                   #    |
 |-----              #####|
 |                        |
 |_______ ________________|
 |______| |_______________|"""
            },
        },
        "soft_obs": {
        },
        "dors": {
            "dor_playmap_21": {
                "x": 11,
                "y": 8,
                "args": {"map": "playmap_21", "x": 89, "y": 25}
            },
        },
        "balls": {
        },
    },
    "playmap_51": {
        "hard_obs": {
            "inner_walls": {
                "x": 0,
                "y": 0,
                "txt": r""")((()((\  \_/  _____/ \______/((()())))(())()((()(())(((()(((()())()((())))))))))(((()()((())))))()())))))))
))(     \_____/                      (((()))                                                             ()(
))(                                   ())()                                                              (()
(((                                   ())()                                                              )()
(()                                   ()())                                                              (()
(()                                   ())()                                                              ())
(((                                   ()())                                                              (()
()(                                   (()))                                                              )))
(((                                   (())(                                                              ())
))(                                   ())()                                                              ())
(((                                   ())()                            ())             ()()()))((()()()()))(
(()                                   ())()                           ())()           ())()()))()())())))(((
)()                                   ()())                           ())()           (()())(()()()())))))))
)()                                   (()))                           ())))            ||| ||| ||||| || )(()
)))                                   ((())                           )()))                              )((
)()                                    |||                            ())()                              )()
)))                                                                   ()())                              (((
(((                                                                   ))(()                              (((
)()                                                                   (())(                              )()
(()                                                                   ())()                              (((
()(                                                                   ())()                              ()(
)((                                                                   ()())                              ()(
)))                                                                   (()))                              (((
)()()())()()()(()))()()()()))(()()()())(())(()()))((()()())(()()()((()))(()))              ()(())(())()()))(
)(())()())(()()(()()()))((()()()(())()()())(((()()))(()()()()()(())()()()())))            (()())(()))()())((
() ||| | |||| | |||| |||| | ||| ())()() ||| ||| ||||| | |||| ||| ||||| ||||||              ||| ||| |||| (())
 #                               ())))                                                                   )()
##                               (()))                                                                   ))(
                                 ())((                                                                   (()
                                  |||                                                                    )))
##                                                                                                       (()
 #                                                                                                       ()(
))                                ())                                                                    )()
())                              ()())                                                                   (()
(()                              ()())                                                                   )))
)()                              (()))                                                                   (()
)()                             (())())                                                                  ()(
)(((())()()()(()())))))(()()()())()()))())(())())))(())()(((())((()()(())())(()()())))((()(())))))(()())))(("""
            },
        },
        "soft_obs": {
            "meadow_1": {
                "x": 0,
                "y": 0,
                "txt": """

                                                     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                 ;;;;;;;;                      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
           ;;;;;;;;;;;;;;;;;;;                ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;;;;;;;              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;             ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;              ;;;;;;;;;;;;;;;;;;         ;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                   ;;;;;;;                   ;;;
       ;;;;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;;;;;;;;;                                              ;;;;
        ;;;;;;;;;;;;;;;;;;;;;;;;;;                                            ;;;;;;;;;;;;;;;;;;;;;
          ;;;;;;;;;;;;;;;;;;;;;;                 ;;;;;;;;;;;;;               ;;;;;;;;;;;;;;;;;;;;;;;;;
               ;;;;;;;;;;;;;;                 ;;;;;;;;;;;;;;;;;;             ;;;;;;;;;;;;;;;;;;;;;;;;;
                                             ;;;;;;;;;;;;;;;;;;;;             ;;;;;;;;;;;;;;;;;;;;;;;
                                              ;;;;;;;;;;;;;;;;;;                 ;;;;;;;;;;;;;;;;;
                                                ;;;;;;;;;;;                         ;;;;;





           ;;;;;;;;;;;                             ;;;;;;;                        ;;;;;;
        ;;;;;;;;;;;;;;;;;;                     ;;;;;;;;;;;;;;;;;;           ;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;;;                ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
       ;;;;;;;;;;;;;;;;;;;;;;              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;;;;;;;;;;;;;;;;;;;;;              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;;;;;;;;;;;;;;;;;;;;                ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ;;;;;;;;;;;;;;;;                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          ;;;;;;;;;;;;;;                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
            ;;;;;;;;;                                    ;;;;;;;;;;;;;;;;;;;;;;;"""
            },
        },
        "dors": {
            "dor_cave_1": {
                "x": 21,
                "y": 0,
                "args": {"map": "cave_1", "x": 14, "y": 19}
            },
            "dor_playmap_1_1": {
                "x": 0,
                "y": 28,
                "args": {"map": "playmap_1", "x": 89, "y": 12}
            },
            "dor_playmap_1_2": {
                "x": 0,
                "y": 29,
                "args": {"map": "playmap_1", "x": 89, "y": 13}
            },
        },
        "balls": {
            "ball_1": {
                "x": 27,
                "y": 25,
            },
            "ball_2": {
                "x": 104,
                "y": 36,
            },
            "ball_3": {
                "x": 90,
                "y": 13,
            },
            "ball_4": {
                "x": 44,
                "y": 1,
            },
            "ball_5": {
                "x": 3,
                "y": 22,
            },
            "ball_6": {
                "x": 38,
                "y": 15,
            },
        },
    },
}

if __name__ == "__main__":
    print("\033[31;1mDo not execute this!\033[0m")
