/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHcsClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the cluster Managed Resource. If not specified, it is defaulted to the value of `managed_application_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/cluster#cluster_name DataHcsCluster#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/cluster#id DataHcsCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the HCS Azure Managed Application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/cluster#managed_application_name DataHcsCluster#managed_application_name}
    */
    readonly managedApplicationName: string;
    /**
    * The name of the Resource Group in which the HCS Azure Managed Application belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/cluster#resource_group_name DataHcsCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/cluster#timeouts DataHcsCluster#timeouts}
    */
    readonly timeouts?: DataHcsClusterTimeouts;
}
export interface DataHcsClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/cluster#default DataHcsCluster#default}
    */
    readonly default?: string;
}
export declare function dataHcsClusterTimeoutsToTerraform(struct?: DataHcsClusterTimeouts | cdktf.IResolvable): any;
export declare class DataHcsClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataHcsClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataHcsClusterTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/cluster hcs_cluster}
*/
export declare class DataHcsCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hcs_cluster";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/cluster hcs_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHcsClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataHcsClusterConfig);
    get blobContainerName(): string;
    get clusterMode(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    get consulAutomaticUpgrades(): cdktf.IResolvable;
    get consulCaFile(): string;
    get consulClusterId(): string;
    get consulConfigFile(): string;
    get consulConnect(): cdktf.IResolvable;
    get consulDatacenter(): string;
    get consulExternalEndpoint(): cdktf.IResolvable;
    get consulExternalEndpointUrl(): string;
    get consulFederationToken(): string;
    get consulPrivateEndpointUrl(): string;
    get consulSnapshotInterval(): string;
    get consulSnapshotRetention(): string;
    get consulVersion(): string;
    get email(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    get managedApplicationId(): string;
    private _managedApplicationName?;
    get managedApplicationName(): string;
    set managedApplicationName(value: string);
    get managedApplicationNameInput(): string | undefined;
    get managedResourceGroupName(): string;
    get planName(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get state(): string;
    get storageAccountName(): string;
    get storageAccountResourceGroup(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get vnetCidr(): string;
    get vnetId(): string;
    get vnetName(): string;
    get vnetResourceGroupName(): string;
    private _timeouts;
    get timeouts(): DataHcsClusterTimeoutsOutputReference;
    putTimeouts(value: DataHcsClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataHcsClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
