/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHcsConsulVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/consul_versions#id DataHcsConsulVersions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/consul_versions#timeouts DataHcsConsulVersions#timeouts}
    */
    readonly timeouts?: DataHcsConsulVersionsTimeouts;
}
export interface DataHcsConsulVersionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/consul_versions#default DataHcsConsulVersions#default}
    */
    readonly default?: string;
}
export declare function dataHcsConsulVersionsTimeoutsToTerraform(struct?: DataHcsConsulVersionsTimeouts | cdktf.IResolvable): any;
export declare class DataHcsConsulVersionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataHcsConsulVersionsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataHcsConsulVersionsTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/consul_versions hcs_consul_versions}
*/
export declare class DataHcsConsulVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hcs_consul_versions";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/consul_versions hcs_consul_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHcsConsulVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataHcsConsulVersionsConfig);
    get available(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get preview(): string[];
    get recommended(): string;
    private _timeouts;
    get timeouts(): DataHcsConsulVersionsTimeoutsOutputReference;
    putTimeouts(value: DataHcsConsulVersionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataHcsConsulVersionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
