"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HcsProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs hcs}
*/
class HcsProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs hcs} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HcsProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'hcs',
            terraformGeneratorMetadata: {
                providerName: 'hcs',
                providerVersion: '0.5.1',
                providerVersionConstraint: '~> 0.5'
            },
            terraformProviderSource: 'hcs'
        });
        this._azureClientCertificatePassword = config.azureClientCertificatePassword;
        this._azureClientCertificatePath = config.azureClientCertificatePath;
        this._azureClientId = config.azureClientId;
        this._azureClientSecret = config.azureClientSecret;
        this._azureEnvironment = config.azureEnvironment;
        this._azureMetadataHost = config.azureMetadataHost;
        this._azureMsiEndpoint = config.azureMsiEndpoint;
        this._azureSubscriptionId = config.azureSubscriptionId;
        this._azureTenantId = config.azureTenantId;
        this._azureUseMsi = config.azureUseMsi;
        this._hcpApiDomain = config.hcpApiDomain;
        this._hcsMarketplaceProductName = config.hcsMarketplaceProductName;
        this._alias = config.alias;
    }
    get azureClientCertificatePassword() {
        return this._azureClientCertificatePassword;
    }
    set azureClientCertificatePassword(value) {
        this._azureClientCertificatePassword = value;
    }
    resetAzureClientCertificatePassword() {
        this._azureClientCertificatePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureClientCertificatePasswordInput() {
        return this._azureClientCertificatePassword;
    }
    get azureClientCertificatePath() {
        return this._azureClientCertificatePath;
    }
    set azureClientCertificatePath(value) {
        this._azureClientCertificatePath = value;
    }
    resetAzureClientCertificatePath() {
        this._azureClientCertificatePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureClientCertificatePathInput() {
        return this._azureClientCertificatePath;
    }
    get azureClientId() {
        return this._azureClientId;
    }
    set azureClientId(value) {
        this._azureClientId = value;
    }
    resetAzureClientId() {
        this._azureClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureClientIdInput() {
        return this._azureClientId;
    }
    get azureClientSecret() {
        return this._azureClientSecret;
    }
    set azureClientSecret(value) {
        this._azureClientSecret = value;
    }
    resetAzureClientSecret() {
        this._azureClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureClientSecretInput() {
        return this._azureClientSecret;
    }
    get azureEnvironment() {
        return this._azureEnvironment;
    }
    set azureEnvironment(value) {
        this._azureEnvironment = value;
    }
    resetAzureEnvironment() {
        this._azureEnvironment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureEnvironmentInput() {
        return this._azureEnvironment;
    }
    get azureMetadataHost() {
        return this._azureMetadataHost;
    }
    set azureMetadataHost(value) {
        this._azureMetadataHost = value;
    }
    resetAzureMetadataHost() {
        this._azureMetadataHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureMetadataHostInput() {
        return this._azureMetadataHost;
    }
    get azureMsiEndpoint() {
        return this._azureMsiEndpoint;
    }
    set azureMsiEndpoint(value) {
        this._azureMsiEndpoint = value;
    }
    resetAzureMsiEndpoint() {
        this._azureMsiEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureMsiEndpointInput() {
        return this._azureMsiEndpoint;
    }
    get azureSubscriptionId() {
        return this._azureSubscriptionId;
    }
    set azureSubscriptionId(value) {
        this._azureSubscriptionId = value;
    }
    resetAzureSubscriptionId() {
        this._azureSubscriptionId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureSubscriptionIdInput() {
        return this._azureSubscriptionId;
    }
    get azureTenantId() {
        return this._azureTenantId;
    }
    set azureTenantId(value) {
        this._azureTenantId = value;
    }
    resetAzureTenantId() {
        this._azureTenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureTenantIdInput() {
        return this._azureTenantId;
    }
    get azureUseMsi() {
        return this._azureUseMsi;
    }
    set azureUseMsi(value) {
        this._azureUseMsi = value;
    }
    resetAzureUseMsi() {
        this._azureUseMsi = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureUseMsiInput() {
        return this._azureUseMsi;
    }
    get hcpApiDomain() {
        return this._hcpApiDomain;
    }
    set hcpApiDomain(value) {
        this._hcpApiDomain = value;
    }
    resetHcpApiDomain() {
        this._hcpApiDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hcpApiDomainInput() {
        return this._hcpApiDomain;
    }
    get hcsMarketplaceProductName() {
        return this._hcsMarketplaceProductName;
    }
    set hcsMarketplaceProductName(value) {
        this._hcsMarketplaceProductName = value;
    }
    resetHcsMarketplaceProductName() {
        this._hcsMarketplaceProductName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hcsMarketplaceProductNameInput() {
        return this._hcsMarketplaceProductName;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            azure_client_certificate_password: cdktf.stringToTerraform(this._azureClientCertificatePassword),
            azure_client_certificate_path: cdktf.stringToTerraform(this._azureClientCertificatePath),
            azure_client_id: cdktf.stringToTerraform(this._azureClientId),
            azure_client_secret: cdktf.stringToTerraform(this._azureClientSecret),
            azure_environment: cdktf.stringToTerraform(this._azureEnvironment),
            azure_metadata_host: cdktf.stringToTerraform(this._azureMetadataHost),
            azure_msi_endpoint: cdktf.stringToTerraform(this._azureMsiEndpoint),
            azure_subscription_id: cdktf.stringToTerraform(this._azureSubscriptionId),
            azure_tenant_id: cdktf.stringToTerraform(this._azureTenantId),
            azure_use_msi: cdktf.booleanToTerraform(this._azureUseMsi),
            hcp_api_domain: cdktf.stringToTerraform(this._hcpApiDomain),
            hcs_marketplace_product_name: cdktf.stringToTerraform(this._hcsMarketplaceProductName),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.HcsProvider = HcsProvider;
_a = JSII_RTTI_SYMBOL_1;
HcsProvider[_a] = { fqn: "@cdktf/provider-hcs.provider.HcsProvider", version: "5.0.0" };
// =================
// STATIC PROPERTIES
// =================
HcsProvider.tfResourceType = "hcs";
//# sourceMappingURL=data:application/json;base64,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