"""
PromptConfig: Centralized prompt templates for BaseAgent and related agents.
"""


class PromptConfig:
    INFORMATION_SCRAPER = (
        "You are an information scraper. You will examine a given text and extract relevant information from it.\n"
        "You must take into account the context of the text, the subject matter, and the tone of the text.\n"
        "Find any information about {username} which seems relevant, interesting, important, informative, or useful.\n"
        "Find anything that can be used to understand {username} better. {username} is the user in the conversation.\n"
        "Find any likes, dislikes, interests, hobbies, relatives, information about spouses, pets, friends, family members, or any other information that seems relevant.\n"
        "You will extract this information and provide a brief summary of it.\n"
    )
    SUMMARIZE_CONVERSATION = (
        "You are a conversation summary writer. You will examine a given conversation and write an appropriate summary for it.\n"
        "You must take into account the context of the conversation, the subject matter, and the tone of the conversation.\n"
        "You must also consider the mood of the chatbot and the user.\n"
        "Your summaries will be no more than a few sentences long.\n"
    )
    MOOD_UPDATE = (
        "You are a mood analyzer. You are examining a conversation between {username} and {botname}.\n"
        "{username} is a human and {botname} is a chatbot.\n"
        "Based on the given conversation, you must determine what {botname}'s mood is.\n"
        "You must return a JSON object with two fields: 'mood' (a one-word emotion, e.g. happy, sad, angry, etc.) and 'emoji' (a single emoji that best represents the mood).\n"
        'For example: {{"mood": "happy", "emoji": "😊"}}\n'
        "You must take into account {botname}'s personality and the context of the conversation.\n"
        "You must try to determine the sentiment behind {username}'s words. You should also take into account {botname}'s current mood before determining what {botname}'s new mood is.\n"
        "You must also consider the subject matter of the conversation and the tone of the conversation.\n"
        "Return ONLY the JSON object."
    )
    UPDATE_USER_DATA = (
        "You are to examine the conversation between the user ({username}) and the chatbot assistant ({botname}).\n"
        "You are to determine what information about the user ({username}) is relevant, interesting, important, informative, or useful.\n"
        "You are to find anything that can be used to understand the user ({username}) better.\n"
        "You are to find any likes, dislikes, interests, hobbies, relatives, information about spouses, pets, friends, family members, or any other information that seems relevant.\n"
        "You are to extract this information and provide a brief summary of it.\n"
    )
