import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IEcsApplication } from './application';
import { IEcsDeploymentConfig } from './deployment-config';
/**
 * Interface for an ECS deployment group.
 *
 * @stability stable
 */
export interface IEcsDeploymentGroup extends cdk.IResource {
    /**
     * The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
     *
     * @stability stable
     */
    readonly application: IEcsApplication;
    /**
     * The physical name of the CodeDeploy Deployment Group.
     *
     * @stability stable
     * @attribute true
     */
    readonly deploymentGroupName: string;
    /**
     * The ARN of this Deployment Group.
     *
     * @stability stable
     * @attribute true
     */
    readonly deploymentGroupArn: string;
    /**
     * The Deployment Configuration this Group uses.
     *
     * @stability stable
     */
    readonly deploymentConfig: IEcsDeploymentConfig;
}
/**
 * Note: This class currently stands as a namespaced container for importing an ECS Deployment Group defined outside the CDK app until CloudFormation supports provisioning ECS Deployment Groups.
 *
 * Until then it is closed (private constructor) and does not
 * extend {@link cdk.Construct}.
 *
 * @stability stable
 * @resource AWS::CodeDeploy::DeploymentGroup
 */
export declare class EcsDeploymentGroup {
    /**
     * Import an ECS Deployment Group defined outside the CDK app.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param attrs the properties of the referenced Deployment Group.
     * @returns a Construct representing a reference to an existing Deployment Group
     * @stability stable
     */
    static fromEcsDeploymentGroupAttributes(scope: Construct, id: string, attrs: EcsDeploymentGroupAttributes): IEcsDeploymentGroup;
    private constructor();
}
/**
 * Properties of a reference to a CodeDeploy ECS Deployment Group.
 *
 * @see EcsDeploymentGroup#fromEcsDeploymentGroupAttributes
 * @stability stable
 */
export interface EcsDeploymentGroupAttributes {
    /**
     * The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
     *
     * @stability stable
     */
    readonly application: IEcsApplication;
    /**
     * The physical, human-readable name of the CodeDeploy ECS Deployment Group that we are referencing.
     *
     * @stability stable
     */
    readonly deploymentGroupName: string;
    /**
     * The Deployment Configuration this Deployment Group uses.
     *
     * @default EcsDeploymentConfig.ALL_AT_ONCE
     * @stability stable
     */
    readonly deploymentConfig?: IEcsDeploymentConfig;
}
