# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .file_metadata import FileMetadata
from .file_mime_type import FileMimeType


class File(UniversalBaseModel):
    id: str
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")]
    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")]
    filename: str
    display_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="displayName")] = None
    mime_type: typing_extensions.Annotated[FileMimeType, FieldMetadata(alias="mimeType")]
    size: float
    bucket_name: typing_extensions.Annotated[str, FieldMetadata(alias="bucketName")]
    gcs_path: typing_extensions.Annotated[str, FieldMetadata(alias="gcsPath")]
    gcs_generation: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="gcsGeneration")] = None
    uploaded_by_id: typing_extensions.Annotated[str, FieldMetadata(alias="uploadedById")]
    org_id: typing_extensions.Annotated[str, FieldMetadata(alias="orgId")]
    metadata: typing.Optional[FileMetadata] = None
    is_public: typing_extensions.Annotated[bool, FieldMetadata(alias="isPublic")]
    expires_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="expiresAt")] = None
    uploaded_by: typing_extensions.Annotated[typing.Optional["User"], FieldMetadata(alias="uploadedBy")] = None
    org: typing.Optional["Org"] = None
    project_files: typing_extensions.Annotated[
        typing.Optional[typing.List["ProjectFile"]], FieldMetadata(alias="projectFiles")
    ] = None
    thread_files: typing_extensions.Annotated[
        typing.Optional[typing.List["ThreadFile"]], FieldMetadata(alias="threadFiles")
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .call import Call  # noqa: E402, F401, I001
from .call_event import CallEvent  # noqa: E402, F401, I001
from .chat_message import ChatMessage  # noqa: E402, F401, I001
from .chat_session import ChatSession  # noqa: E402, F401, I001
from .conversation_message import ConversationMessage  # noqa: E402, F401, I001
from .conversation_message_topic import ConversationMessageTopic  # noqa: E402, F401, I001
from .invite import Invite  # noqa: E402, F401, I001
from .invite_response import InviteResponse  # noqa: E402, F401, I001
from .moderator import Moderator  # noqa: E402, F401, I001
from .org import Org  # noqa: E402, F401, I001
from .participant import Participant  # noqa: E402, F401, I001
from .participant_invite import ParticipantInvite  # noqa: E402, F401, I001
from .project import Project  # noqa: E402, F401, I001
from .project_file import ProjectFile  # noqa: E402, F401, I001
from .thread import Thread  # noqa: E402, F401, I001
from .thread_file import ThreadFile  # noqa: E402, F401, I001
from .user import User  # noqa: E402, F401, I001

update_forward_refs(File)
