# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .project_file_metadata import ProjectFileMetadata


class ProjectFile(UniversalBaseModel):
    id: str
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")]
    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")]
    project_id: typing_extensions.Annotated[str, FieldMetadata(alias="projectId")]
    file_id: typing_extensions.Annotated[str, FieldMetadata(alias="fileId")]
    description: typing.Optional[str] = None
    category: typing.Optional[str] = None
    metadata: typing.Optional[ProjectFileMetadata] = None
    project: typing.Optional["Project"] = None
    file: typing.Optional["File"] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .call import Call  # noqa: E402, F401, I001
from .call_event import CallEvent  # noqa: E402, F401, I001
from .chat_message import ChatMessage  # noqa: E402, F401, I001
from .chat_session import ChatSession  # noqa: E402, F401, I001
from .conversation_message import ConversationMessage  # noqa: E402, F401, I001
from .conversation_message_topic import ConversationMessageTopic  # noqa: E402, F401, I001
from .file import File  # noqa: E402, F401, I001
from .invite import Invite  # noqa: E402, F401, I001
from .invite_response import InviteResponse  # noqa: E402, F401, I001
from .moderator import Moderator  # noqa: E402, F401, I001
from .org import Org  # noqa: E402, F401, I001
from .participant import Participant  # noqa: E402, F401, I001
from .participant_invite import ParticipantInvite  # noqa: E402, F401, I001
from .project import Project  # noqa: E402, F401, I001
from .thread import Thread  # noqa: E402, F401, I001
from .thread_file import ThreadFile  # noqa: E402, F401, I001
from .user import User  # noqa: E402, F401, I001

update_forward_refs(ProjectFile)
