"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .streamedcompletionschoice import (
    StreamedCompletionsChoice,
    StreamedCompletionsChoiceTypedDict,
)
from friendli.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import NotRequired, TypedDict


StreamedCompletionsResultObject = Literal["text_completion"]
r"""The object type, which is always set to `text_completion`."""


class StreamedCompletionsResultUsageTypedDict(TypedDict):
    prompt_tokens: NotRequired[int]
    r"""Number of tokens in the prompt."""
    completion_tokens: NotRequired[int]
    r"""Number of tokens in the generated completions."""
    total_tokens: NotRequired[int]
    r"""Total number of tokens used in the request (`prompt_tokens` + `completion_tokens`)."""


class StreamedCompletionsResultUsage(BaseModel):
    prompt_tokens: Optional[int] = None
    r"""Number of tokens in the prompt."""

    completion_tokens: Optional[int] = None
    r"""Number of tokens in the generated completions."""

    total_tokens: Optional[int] = None
    r"""Total number of tokens used in the request (`prompt_tokens` + `completion_tokens`)."""


class StreamedCompletionsResultDataTypedDict(TypedDict):
    id: NotRequired[str]
    r"""A unique ID of the completion."""
    object: NotRequired[StreamedCompletionsResultObject]
    r"""The object type, which is always set to `text_completion`."""
    choices: NotRequired[List[StreamedCompletionsChoiceTypedDict]]
    usage: NotRequired[Nullable[StreamedCompletionsResultUsageTypedDict]]
    created: NotRequired[int]
    r"""The Unix timestamp (in seconds) for when the token sampled."""


class StreamedCompletionsResultData(BaseModel):
    id: Optional[str] = None
    r"""A unique ID of the completion."""

    object: Optional[StreamedCompletionsResultObject] = None
    r"""The object type, which is always set to `text_completion`."""

    choices: Optional[List[StreamedCompletionsChoice]] = None

    usage: OptionalNullable[StreamedCompletionsResultUsage] = UNSET

    created: Optional[int] = None
    r"""The Unix timestamp (in seconds) for when the token sampled."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "object", "choices", "usage", "created"]
        nullable_fields = ["usage"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StreamedCompletionsResultTypedDict(TypedDict):
    r"""Successfully generated completions."""

    data: NotRequired[StreamedCompletionsResultDataTypedDict]


class StreamedCompletionsResult(BaseModel):
    r"""Successfully generated completions."""

    data: Optional[StreamedCompletionsResultData] = None
