"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from friendli.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from friendli.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


Name = Literal[
    "math:calculator",
    "math:statistics",
    "math:calendar",
    "web:search",
    "web:url",
    "code:python-interpreter",
    "file:text",
]
r"""The name of the built-in tool."""

Status = Literal["STARTED", "UPDATING", "ENDED", "ERRORED"]
r"""Indicates the current execution status of the tool."""


class StreamedToolAssistedChatToolStatusParametersTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The name of the tool’s function parameter."""
    value: NotRequired[str]
    r"""The value of the tool’s function parameter."""


class StreamedToolAssistedChatToolStatusParameters(BaseModel):
    name: Optional[str] = None
    r"""The name of the tool’s function parameter."""

    value: Optional[str] = None
    r"""The value of the tool’s function parameter."""


class FilesTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The name of the file generated by the tool’s execution."""
    url: NotRequired[str]
    r"""URL of the file generated by the tool’s execution."""


class Files(BaseModel):
    name: Optional[str] = None
    r"""The name of the file generated by the tool’s execution."""

    url: Optional[str] = None
    r"""URL of the file generated by the tool’s execution."""


class ErrorTypedDict(TypedDict):
    type: NotRequired[str]
    r"""The type of error encountered during the tool’s execution."""
    msg: NotRequired[str]
    r"""The message of error."""


class Error(BaseModel):
    type: Optional[str] = None
    r"""The type of error encountered during the tool’s execution."""

    msg: Optional[str] = None
    r"""The message of error."""


class StreamedToolAssistedChatToolStatusDataTypedDict(TypedDict):
    tool_call_id: NotRequired[str]
    r"""The ID of the tool call."""
    name: NotRequired[Name]
    r"""The name of the built-in tool."""
    status: NotRequired[Status]
    r"""Indicates the current execution status of the tool."""
    parameters: NotRequired[List[StreamedToolAssistedChatToolStatusParametersTypedDict]]
    result: NotRequired[Nullable[str]]
    r"""The output from the tool’s execution."""
    files: NotRequired[Nullable[List[FilesTypedDict]]]
    message: NotRequired[Nullable[str]]
    r"""Message generated by the tool’s execution."""
    error: NotRequired[Nullable[ErrorTypedDict]]
    timestamp: NotRequired[float]
    r"""The Unix timestamp (in seconds) for when the event occurred."""


class StreamedToolAssistedChatToolStatusData(BaseModel):
    tool_call_id: Optional[str] = None
    r"""The ID of the tool call."""

    name: Optional[Name] = None
    r"""The name of the built-in tool."""

    status: Optional[Status] = None
    r"""Indicates the current execution status of the tool."""

    parameters: Optional[List[StreamedToolAssistedChatToolStatusParameters]] = None

    result: OptionalNullable[str] = UNSET
    r"""The output from the tool’s execution."""

    files: OptionalNullable[List[Files]] = UNSET

    message: OptionalNullable[str] = UNSET
    r"""Message generated by the tool’s execution."""

    error: OptionalNullable[Error] = UNSET

    timestamp: Optional[float] = None
    r"""The Unix timestamp (in seconds) for when the event occurred."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "tool_call_id",
            "name",
            "status",
            "parameters",
            "result",
            "files",
            "message",
            "error",
            "timestamp",
        ]
        nullable_fields = ["result", "files", "message", "error"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StreamedToolAssistedChatToolStatusTypedDict(TypedDict):
    event: Literal["tool_status"]
    data: NotRequired[StreamedToolAssistedChatToolStatusDataTypedDict]


class StreamedToolAssistedChatToolStatus(BaseModel):
    EVENT: Annotated[
        Annotated[
            Optional[Literal["tool_status"]],
            AfterValidator(validate_const("tool_status")),
        ],
        pydantic.Field(alias="event"),
    ] = "tool_status"

    data: Optional[StreamedToolAssistedChatToolStatusData] = None
