"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosInstance = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('threatAnalysis', ros.validateBoolean)(properties.threatAnalysis));
    errors.collect(ros.propertyValidator('quotaForMaliciousFileDetectionSdk', ros.validateNumber)(properties.quotaForMaliciousFileDetectionSdk));
    errors.collect(ros.propertyValidator('containerImageScan', ros.validateNumber)(properties.containerImageScan));
    errors.collect(ros.propertyValidator('threatAnalysisLogStorageCapacity', ros.validateNumber)(properties.threatAnalysisLogStorageCapacity));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('maliciousFileDetectionSdk', ros.validateBoolean)(properties.maliciousFileDetectionSdk));
    errors.collect(ros.propertyValidator('vCore', ros.validateNumber)(properties.vCore));
    errors.collect(ros.propertyValidator('vulnerabilityFixing', ros.validateBoolean)(properties.vulnerabilityFixing));
    errors.collect(ros.propertyValidator('quotaForWebTamperProofing', ros.validateNumber)(properties.quotaForWebTamperProofing));
    errors.collect(ros.propertyValidator('antiRansomwareManageService', ros.validateBoolean)(properties.antiRansomwareManageService));
    errors.collect(ros.propertyValidator('configurationAssessment', ros.validateBoolean)(properties.configurationAssessment));
    errors.collect(ros.propertyValidator('webTamperProtection', ros.validateBoolean)(properties.webTamperProtection));
    errors.collect(ros.propertyValidator('quotaForConfigurationAssessment', ros.validateNumber)(properties.quotaForConfigurationAssessment));
    errors.collect(ros.propertyValidator('antiRansomware', ros.validateNumber)(properties.antiRansomware));
    errors.collect(ros.propertyValidator('quotaForApplicationProtection', ros.validateNumber)(properties.quotaForApplicationProtection));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 6],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('quotaForCloudHoneypot', ros.validateNumber)(properties.quotaForCloudHoneypot));
    errors.collect(ros.propertyValidator('autoPay', ros.validateBoolean)(properties.autoPay));
    errors.collect(ros.propertyValidator('payType', ros.requiredValidator)(properties.payType));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "Postpay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "Prepay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    if (properties.edition && (typeof properties.edition) !== 'object') {
        errors.collect(ros.propertyValidator('edition', ros.validateAllowedValues)({
            data: properties.edition,
            allowedValues: ["Anti-virus", "Advanced", "Enterprise", "Ultimate", "Value-added Plan"],
        }));
    }
    errors.collect(ros.propertyValidator('edition', ros.validateString)(properties.edition));
    errors.collect(ros.propertyValidator('logAnalysis', ros.validateNumber)(properties.logAnalysis));
    errors.collect(ros.propertyValidator('postPayInstanceModule', RosInstance_PostPayInstanceModulePropertyValidator)(properties.postPayInstanceModule));
    errors.collect(ros.propertyValidator('protectedServers', ros.validateNumber)(properties.protectedServers));
    errors.collect(ros.propertyValidator('cloudHoneypot', ros.validateBoolean)(properties.cloudHoneypot));
    errors.collect(ros.propertyValidator('quotaForVulnerabilityFixing', ros.validateNumber)(properties.quotaForVulnerabilityFixing));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAS::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAS::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        'PayType': ros.stringToRosTemplate(properties.payType),
        'AntiRansomware': ros.numberToRosTemplate(properties.antiRansomware),
        'AntiRansomwareManageService': ros.booleanToRosTemplate(properties.antiRansomwareManageService),
        'AutoPay': ros.booleanToRosTemplate(properties.autoPay),
        'AutoRenew': ros.booleanToRosTemplate(properties.autoRenew),
        'CloudHoneypot': ros.booleanToRosTemplate(properties.cloudHoneypot),
        'ConfigurationAssessment': ros.booleanToRosTemplate(properties.configurationAssessment),
        'ContainerImageScan': ros.numberToRosTemplate(properties.containerImageScan),
        'Edition': ros.stringToRosTemplate(properties.edition),
        'LogAnalysis': ros.numberToRosTemplate(properties.logAnalysis),
        'MaliciousFileDetectionSDK': ros.booleanToRosTemplate(properties.maliciousFileDetectionSdk),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'PostPayInstanceModule': rosInstancePostPayInstanceModulePropertyToRosTemplate(properties.postPayInstanceModule),
        'ProtectedServers': ros.numberToRosTemplate(properties.protectedServers),
        'QuotaForApplicationProtection': ros.numberToRosTemplate(properties.quotaForApplicationProtection),
        'QuotaForCloudHoneypot': ros.numberToRosTemplate(properties.quotaForCloudHoneypot),
        'QuotaForConfigurationAssessment': ros.numberToRosTemplate(properties.quotaForConfigurationAssessment),
        'QuotaForMaliciousFileDetectionSDK': ros.numberToRosTemplate(properties.quotaForMaliciousFileDetectionSdk),
        'QuotaForVulnerabilityFixing': ros.numberToRosTemplate(properties.quotaForVulnerabilityFixing),
        'QuotaForWebTamperProofing': ros.numberToRosTemplate(properties.quotaForWebTamperProofing),
        'ThreatAnalysis': ros.booleanToRosTemplate(properties.threatAnalysis),
        'ThreatAnalysisLogStorageCapacity': ros.numberToRosTemplate(properties.threatAnalysisLogStorageCapacity),
        'VCore': ros.numberToRosTemplate(properties.vCore),
        'VulnerabilityFixing': ros.booleanToRosTemplate(properties.vulnerabilityFixing),
        'WebTamperProtection': ros.booleanToRosTemplate(properties.webTamperProtection),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::SAS::Instance`.
 * @Note This class does not contain additional functions, so it is recommended to use the `Instance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-sas-instance
 */
class RosInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.payType = props.payType;
        this.antiRansomware = props.antiRansomware;
        this.antiRansomwareManageService = props.antiRansomwareManageService;
        this.autoPay = props.autoPay;
        this.autoRenew = props.autoRenew;
        this.cloudHoneypot = props.cloudHoneypot;
        this.configurationAssessment = props.configurationAssessment;
        this.containerImageScan = props.containerImageScan;
        this.edition = props.edition;
        this.logAnalysis = props.logAnalysis;
        this.maliciousFileDetectionSdk = props.maliciousFileDetectionSdk;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.postPayInstanceModule = props.postPayInstanceModule;
        this.protectedServers = props.protectedServers;
        this.quotaForApplicationProtection = props.quotaForApplicationProtection;
        this.quotaForCloudHoneypot = props.quotaForCloudHoneypot;
        this.quotaForConfigurationAssessment = props.quotaForConfigurationAssessment;
        this.quotaForMaliciousFileDetectionSdk = props.quotaForMaliciousFileDetectionSdk;
        this.quotaForVulnerabilityFixing = props.quotaForVulnerabilityFixing;
        this.quotaForWebTamperProofing = props.quotaForWebTamperProofing;
        this.threatAnalysis = props.threatAnalysis;
        this.threatAnalysisLogStorageCapacity = props.threatAnalysisLogStorageCapacity;
        this.vCore = props.vCore;
        this.vulnerabilityFixing = props.vulnerabilityFixing;
        this.webTamperProtection = props.webTamperProtection;
    }
    get rosProperties() {
        return {
            payType: this.payType,
            antiRansomware: this.antiRansomware,
            antiRansomwareManageService: this.antiRansomwareManageService,
            autoPay: this.autoPay,
            autoRenew: this.autoRenew,
            cloudHoneypot: this.cloudHoneypot,
            configurationAssessment: this.configurationAssessment,
            containerImageScan: this.containerImageScan,
            edition: this.edition,
            logAnalysis: this.logAnalysis,
            maliciousFileDetectionSdk: this.maliciousFileDetectionSdk,
            period: this.period,
            periodUnit: this.periodUnit,
            postPayInstanceModule: this.postPayInstanceModule,
            protectedServers: this.protectedServers,
            quotaForApplicationProtection: this.quotaForApplicationProtection,
            quotaForCloudHoneypot: this.quotaForCloudHoneypot,
            quotaForConfigurationAssessment: this.quotaForConfigurationAssessment,
            quotaForMaliciousFileDetectionSdk: this.quotaForMaliciousFileDetectionSdk,
            quotaForVulnerabilityFixing: this.quotaForVulnerabilityFixing,
            quotaForWebTamperProofing: this.quotaForWebTamperProofing,
            threatAnalysis: this.threatAnalysis,
            threatAnalysisLogStorageCapacity: this.threatAnalysisLogStorageCapacity,
            vCore: this.vCore,
            vulnerabilityFixing: this.vulnerabilityFixing,
            webTamperProtection: this.webTamperProtection,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::SAS::Instance";
/**
 * Determine whether the given properties match those of a `PostPayInstanceModuleProperty`
 *
 * @param properties - the TypeScript properties of a `PostPayInstanceModuleProperty`
 *
 * @returns the result of the validation.
 */
function RosInstance_PostPayInstanceModulePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('ctdr', ros.validateBoolean)(properties.ctdr));
    errors.collect(ros.propertyValidator('agentlessDetection', ros.validateBoolean)(properties.agentlessDetection));
    errors.collect(ros.propertyValidator('cloudSecurityPostureManagement', ros.validateBoolean)(properties.cloudSecurityPostureManagement));
    errors.collect(ros.propertyValidator('serverlessAssetProtection', ros.validateBoolean)(properties.serverlessAssetProtection));
    errors.collect(ros.propertyValidator('vulnerabilityFixing', ros.validateBoolean)(properties.vulnerabilityFixing));
    errors.collect(ros.propertyValidator('hostAndContainerSecurity', ros.validateBoolean)(properties.hostAndContainerSecurity));
    return errors.wrap('supplied properties not correct for "PostPayInstanceModuleProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAS::Instance.PostPayInstanceModule` resource
 *
 * @param properties - the TypeScript properties of a `PostPayInstanceModuleProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAS::Instance.PostPayInstanceModule` resource.
 */
// @ts-ignore TS6133
function rosInstancePostPayInstanceModulePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosInstance_PostPayInstanceModulePropertyValidator(properties).assertSuccess();
    return {
        'CTDR': ros.booleanToRosTemplate(properties.ctdr),
        'AgentlessDetection': ros.booleanToRosTemplate(properties.agentlessDetection),
        'CloudSecurityPostureManagement': ros.booleanToRosTemplate(properties.cloudSecurityPostureManagement),
        'ServerlessAssetProtection': ros.booleanToRosTemplate(properties.serverlessAssetProtection),
        'VulnerabilityFixing': ros.booleanToRosTemplate(properties.vulnerabilityFixing),
        'HostAndContainerSecurity': ros.booleanToRosTemplate(properties.hostAndContainerSecurity),
    };
}
//# sourceMappingURL=data:application/json;base64,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