"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const sas_generated_1 = require("./sas.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return sas_generated_1.RosInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::SAS::Instance`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-sas-instance
 */
class Instance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosInstance = new sas_generated_1.RosInstance(this, id, {
            threatAnalysis: props.threatAnalysis,
            quotaForMaliciousFileDetectionSdk: props.quotaForMaliciousFileDetectionSdk,
            containerImageScan: props.containerImageScan,
            threatAnalysisLogStorageCapacity: props.threatAnalysisLogStorageCapacity,
            autoRenew: props.autoRenew === undefined || props.autoRenew === null ? false : props.autoRenew,
            maliciousFileDetectionSdk: props.maliciousFileDetectionSdk,
            vCore: props.vCore,
            vulnerabilityFixing: props.vulnerabilityFixing,
            quotaForWebTamperProofing: props.quotaForWebTamperProofing,
            antiRansomwareManageService: props.antiRansomwareManageService,
            configurationAssessment: props.configurationAssessment,
            webTamperProtection: props.webTamperProtection,
            quotaForConfigurationAssessment: props.quotaForConfigurationAssessment,
            antiRansomware: props.antiRansomware,
            quotaForApplicationProtection: props.quotaForApplicationProtection,
            period: props.period,
            quotaForCloudHoneypot: props.quotaForCloudHoneypot,
            autoPay: props.autoPay === undefined || props.autoPay === null ? true : props.autoPay,
            payType: props.payType === undefined || props.payType === null ? 'PREPAY' : props.payType,
            edition: props.edition,
            logAnalysis: props.logAnalysis,
            postPayInstanceModule: props.postPayInstanceModule,
            protectedServers: props.protectedServers,
            cloudHoneypot: props.cloudHoneypot,
            quotaForVulnerabilityFixing: props.quotaForVulnerabilityFixing,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrInstanceId = rosInstance.attrInstanceId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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