#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# ------------------------------------------------------------------------------
#
#   Copyright 2018 Fetch.AI Limited
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
# ------------------------------------------------------------------------------

from setuptools import setup
import os

here = os.path.abspath(os.path.dirname(__file__))
about = {}
with open(os.path.join(here, '__version__.py'), 'r') as f:
    exec(f.read(), about)

with open(os.path.join(here, 'README.md'), 'r') as f:
    readme = f.read()


setup(
    name=about['__title__'],
    description=about['__description__'],
    version=about['__version__'],
    author=about['__author__'],
    author_email=about['__author_email__'],
    url=about['__url__'],
    long_description=readme,
    long_description_content_type='text/markdown',
    packages=["oef"],
    cmdclass={},
    classifiers=[
        "Development Status :: 3 - Alpha", "Intended Audience :: Developers", "Natural Language :: English", "License :: OSI Approved :: Apache Software License", "Programming Language :: Python :: 3.6", "Programming Language :: Python :: 3.7"
    ],
    install_requires=["protobuf", "graphviz"],
    tests_require=["tox"],
    python_requires='>=3.6',
    license=about['__license__'],
    zip_safe=False
)
