#
# pymepack - a python interface for MEPACK,
#
# Copyright (C) 2023 Martin Koehler, Aleksey Maleyko
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#



cdef extern ssize_t mepack_memory_frontend(const char* func,
                    const char* factA,
                    const char* factB,
                    int M, int N)

cdef extern void mepack_double_trlyap_blocksize_set (int mb)
cdef extern void mepack_double_trstein_blocksize_set(int mb)
cdef extern void mepack_double_tglyap_blocksize_set(int mb)
cdef extern void mepack_double_tgstein_blocksize_set(int mb)
cdef extern void mepack_double_trsylv_blocksize_mb_set(int mb)
cdef extern void mepack_double_trsylv_blocksize_nb_set(int nb)
cdef extern void mepack_double_trsylv2_blocksize_mb_set(int mb)
cdef extern void mepack_double_trsylv2_blocksize_nb_set(int nb)
cdef extern void mepack_double_tgcsylv_blocksize_mb_set(int mb)
cdef extern void mepack_double_tgcsylv_blocksize_nb_set(int nb)
cdef extern void mepack_double_tgcsylv_dual_blocksize_mb_set(int mb)
cdef extern void mepack_double_tgcsylv_dual_blocksize_nb_set(int nb)
cdef extern void mepack_double_tgsylv_blocksize_mb_set(int mb)
cdef extern void mepack_double_tgsylv_blocksize_nb_set(int nb)

cdef extern void mepack_single_trlyap_blocksize_set (int mb)
cdef extern void mepack_single_trstein_blocksize_set(int mb)
cdef extern void mepack_single_tglyap_blocksize_set(int mb)
cdef extern void mepack_single_tgstein_blocksize_set(int mb)
cdef extern void mepack_single_trsylv_blocksize_mb_set(int mb)
cdef extern void mepack_single_trsylv_blocksize_nb_set(int nb)
cdef extern void mepack_single_trsylv2_blocksize_mb_set(int mb)
cdef extern void mepack_single_trsylv2_blocksize_nb_set(int nb)
cdef extern void mepack_single_tgcsylv_blocksize_mb_set(int mb)
cdef extern void mepack_single_tgcsylv_blocksize_nb_set(int nb)
cdef extern void mepack_single_tgcsylv_dual_blocksize_mb_set(int mb)
cdef extern void mepack_single_tgcsylv_dual_blocksize_nb_set(int nb)
cdef extern void mepack_single_tgsylv_blocksize_mb_set(int mb)
cdef extern void mepack_single_tgsylv_blocksize_nb_set(int nb)


cdef extern void mepack_trlyap_frontend_solver_set (int fs)
cdef extern void mepack_trstein_frontend_solver_set(int fs)
cdef extern void mepack_tglyap_frontend_solver_set(int fs)
cdef extern void mepack_tgstein_frontend_solver_set(int fs)
cdef extern void mepack_trsylv_frontend_solver_set(int fs)
cdef extern void mepack_trsylv2_frontend_solver_set(int fs)
cdef extern void mepack_tgcsylv_frontend_solver_set(int fs)
cdef extern void mepack_tgcsylv_dual_frontend_solver_set(int fs)
cdef extern void mepack_tgsylv_frontend_solver_set(int fs)

cdef extern void mepack_init()

#### solvers ####
cdef extern void mepack_double_gelyap(const char * FACT,
                              const char *TRANS,
                              int M,
                              double * A,
                              int LDA,
                              double * Q,
                              int LDQ,
                              double *X,
                              int LDX,
                              double * SCALE,
                              double *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_double_gestein(const char * FACT,
                              const char *TRANS,
                              int M,
                              double * A,
                              int LDA,
                              double * Q,
                              int LDQ,
                              double *X,
                              int LDX,
                              double * SCALE,
                              double *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_double_gglyap(const char * FACT,
                              const char *TRANS,
                              int M,
                              double * A,
                              int LDA,
                              double * B,
                              int LDB,
                              double * Q,
                              int LDQ,
                              double * Z,
                              int LDZ,
                              double *X,
                              int LDX,
                              double * SCALE,
                              double *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_double_ggstein(const char * FACT,
                              const char *TRANS,
                              int M,
                              double * A,
                              int LDA,
                              double * B,
                              int LDB,
                              double * Q,
                              int LDQ,
                              double * Z,
                              int LDZ,
                              double *X,
                              int LDX,
                              double * SCALE,
                              double *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_double_gelyap_refine(const char *TRANS,
                              const char *GUESS,
                              int M,
                              double *A,
                              int LDA,
                              double *X,
                              int LDX,
                              double *Y,
                              int LDY,
                              double *AS,
                              int LDAS,
                              double *Q,
                              int LDQ,
                              int *MAXIT,
                              double *TAU,
                              double *CONVLOG,
                              double *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_double_gestein_refine(const char *TRANS,
                              const char *GUESS,
                              int M,
                              double *A,
                              int LDA,
                              double *X,
                              int LDX,
                              double *Y,
                              int LDY,
                              double *AS,
                              int LDAS,
                              double *Q,
                              int LDQ,
                              int *MAXIT,
                              double *TAU,
                              double *CONVLOG,
                              double *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_double_gglyap_refine(const char *TRANS,
                              const char *GUESS,
                              int M,
                              double *A,
                              int LDA,
                              double *B,
                              int LDB,
                              double *X,
                              int LDX,
                              double *Y,
                              int LDY,
                              double *AS,
                              int LDAS,
                              double *BS,
                              int LDBS,
                              double *Q,
                              int LDQ,
                              double *Z,
                              int LDZ,
                              int *MAXIT,
                              double *TAU,
                              double *CONVLOG,
                              double *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_double_ggstein_refine(const char *TRANS,
                              const char *GUESS,
                              int M,
                              double *A,
                              int LDA,
                              double *B,
                              int LDB,
                              double *X,
                              int LDX,
                              double *Y,
                              int LDY,
                              double *AS,
                              int LDAS,
                              double *BS,
                              int LDBS,
                              double *Q,
                              int LDQ,
                              double *Z,
                              int LDZ,
                              int *MAXIT,
                              double *TAU,
                              double *CONVLOG,
                              double *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_double_gesylv(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              double SGN,
                              int M,
                              int N,
                              double* A,
                              int LDA,
                              double* B,
                              int LDB,
                              double* QA,
                              int LDQA,
                              double* QB,
                              int LDQB,
                              double* X,
                              int LDX,
                              double* SCALE,
                              double* WORK,
                              size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_gesylv2(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              double SGN,
                              int M,
                              int N,
                              double* A,
                              int LDA,
                              double* B,
                              int LDB,
                              double* QA,
                              int LDQA,
                              double* QB,
                              int LDQB,
                              double* X,
                              int LDX,
                              double* SCALE,
                              double* WORK,
                              size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_gesylv_refine(const char* TRANSA,
                              const char* TRANSB,
                              const char* GUESS,
                              double SGN,
                              int M,int N,
                              double* A,  int LDA,
                              double* B,  int LDB,
                              double* X,  int LDX,
                              double* Y,  int LDY,
                              double* AS, int LDAS,
                              double* BS, int LDBS,
                              double* Q,  int LDQ,
                              double* U,  int LDU,
                              int* MAXIT,
                              double* TAU,
                              double* CONVLOG,
                              double* WORK,
                              size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_gesylv2_refine(const char* TRANSA,
                              const char* TRANSB,
                              const char* GUESS,
                              double SGN,
                              int M,int N,
                              double* A,  int LDA,
                              double* B,  int LDB,
                              double* X,  int LDX,
                              double* Y,  int LDY,
                              double* AS, int LDAS,
                              double* BS, int LDBS,
                              double* Q,  int LDQ,
                              double* U,  int LDU,
                              int* MAXIT,
                              double* TAU,
                              double* CONVLOG,
                              double* WORK,
                              size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_ggcsylv(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              double SGN1, double SGN2,
                              int M, int N,
                              double* A, int LDA,
                              double* B, int LDB,
                              double* C, int LDC,
                              double* D, int LDD,
                              double* QA, int LDQA,
                              double* ZA, int LDZA,
                              double* QB, int LDQB,
                              double* ZB, int LDZB,
                              double* E, int LDE,
                              double* F, int LDF,
                              double* SCALE,
                              double* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_ggcsylv_dual(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              double SGN1, double SGN2,
                              int M, int N,
                              double* A, int LDA,
                              double* B, int LDB,
                              double* C, int LDC,
                              double* D, int LDD,
                              double* QA, int LDQA,
                              double* ZA, int LDZA,
                              double* QB, int LDQB,
                              double* ZB, int LDZB,
                              double* E, int LDE,
                              double* F, int LDF,
                              double* SCALE,
                              double* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_ggcsylv_refine(const char* TRANSA,
                              const char* TRANSB,
                              const char* GUESS,
                              double SGN1, double SGN2,
                              int M, int N,
                              double* A, int LDA,
                              double* B, int LDB,
                              double* C, int LDC,
                              double* D, int LDD,
                              double* R, int LDR,
                              double* L, int LDL,
                              double* E, int LDE,
                              double* F, int LDF,
                              double* AS, int LDAS,
                              double* BS, int LDBS,
                              double* CS, int LDCS,
                              double* DS, int LDDS,
                              double* Q, int LDQ,
                              double* Z, int LDZ,
                              double* U, int LDU,
                              double* V, int LDV,
                              int* MAXIT,
                              double* TAU,
                              double* CONVLOG,
                              double* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_ggcsylv_dual_refine(const char* TRANSA,
                              const char* TRANSB, const char* GUESS,
                              double SGN1, double SGN2,
                              int M, int N,
                              double* A, int LDA,
                              double* B, int LDB,
                              double* C, int LDC,
                              double* D, int LDD,
                              double* R, int LDR,
                              double* L, int LDL,
                              double* E, int LDE,
                              double* F, int LDF,
                              double* AS, int LDAS,
                              double* BS, int LDBS,
                              double* CS, int LDCS,
                              double* DS, int LDDS,
                              double* Q, int LDQ,
                              double* Z, int LDZ,
                              double* U, int LDU,
                              double* V, int LDV,
                              int* MAXIT,
                              double* TAU,
                              double* CONVLOG,
                              double* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_ggsylv(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              double SGN,
                              int M, int N,
                              double* A, int LDA,
                              double* B, int LDB,
                              double* C, int LDC,
                              double* D, int LDD,
                              double* QA, int LDQA,
                              double* ZA, int LDZA,
                              double* QB, int LDQB,
                              double* ZB, int LDZB,
                              double* X, int LDX,
                              double* SCALE,
                              double* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_double_ggsylv_refine(const char* TRANSA,
                              const char* TRANSB,
                              const char* GUESS,
                              double SGN,
                              int M, int N,
                              double* A, int LDA,
                              double* B, int LDB,
                              double* C, int LDC,
                              double* D, int LDD,
                              double* X, int LDX,
                              double* Y, int LDY,
                              double* AS, int LDAS,
                              double* BS, int LDBS,
                              double* CS, int LDCS,
                              double* DS, int LDDS,
                              double* Q, int LDQ,
                              double* Z, int LDZ,
                              double* U, int LDU,
                              double* V, int LDV,
                              int* MAXIT, double* TAU,
                              double* CONVLOG,
                              double* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_gelyap(const char * FACT,
                              const char *TRANS,
                              int M,
                              float * A,
                              int LDA,
                              float * Q,
                              int LDQ,
                              float *X,
                              int LDX,
                              float * SCALE,
                              float *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_single_gestein(const char * FACT,
                              const char *TRANS,
                              int M,
                              float * A,
                              int LDA,
                              float * Q,
                              int LDQ,
                              float *X,
                              int LDX,
                              float * SCALE,
                              float *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_single_gglyap(const char * FACT,
                              const char *TRANS,
                              int M,
                              float * A,
                              int LDA,
                              float * B,
                              int LDB,
                              float * Q,
                              int LDQ,
                              float * Z,
                              int LDZ,
                              float *X,
                              int LDX,
                              float * SCALE,
                              float *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_single_ggstein(const char * FACT,
                              const char *TRANS,
                              int M,
                              float * A,
                              int LDA,
                              float * B,
                              int LDB,
                              float * Q,
                              int LDQ,
                              float * Z,
                              int LDZ,
                              float *X,
                              int LDX,
                              float * SCALE,
                              float *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_single_gelyap_refine(const char *TRANS,
                              const char *GUESS,
                              int M,
                              float *A,
                              int LDA,
                              float *X,
                              int LDX,
                              float *Y,
                              int LDY,
                              float *AS,
                              int LDAS,
                              float *Q,
                              int LDQ,
                              int *MAXIT,
                              float *TAU,
                              float *CONVLOG,
                              float *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_single_gestein_refine(const char *TRANS,
                              const char *GUESS,
                              int M,
                              float *A,
                              int LDA,
                              float *X,
                              int LDX,
                              float *Y,
                              int LDY,
                              float *AS,
                              int LDAS,
                              float *Q,
                              int LDQ,
                              int *MAXIT,
                              float *TAU,
                              float *CONVLOG,
                              float *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_single_gglyap_refine(const char *TRANS,
                              const char *GUESS,
                              int M,
                              float *A,
                              int LDA,
                              float *B,
                              int LDB,
                              float *X,
                              int LDX,
                              float *Y,
                              int LDY,
                              float *AS,
                              int LDAS,
                              float *BS,
                              int LDBS,
                              float *Q,
                              int LDQ,
                              float *Z,
                              int LDZ,
                              int *MAXIT,
                              float *TAU,
                              float *CONVLOG,
                              float *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_single_ggstein_refine(const char *TRANS,
                              const char *GUESS,
                              int M,
                              float *A,
                              int LDA,
                              float *B,
                              int LDB,
                              float *X,
                              int LDX,
                              float *Y,
                              int LDY,
                              float *AS,
                              int LDAS,
                              float *BS,
                              int LDBS,
                              float *Q,
                              int LDQ,
                              float *Z,
                              int LDZ,
                              int *MAXIT,
                              float *TAU,
                              float *CONVLOG,
                              float *WORK,
                              size_t LDWORK,
                              int *INFO)

cdef extern void mepack_single_gesylv(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              float SGN,
                              int M,
                              int N,
                              float* A,
                              int LDA,
                              float* B,
                              int LDB,
                              float* QA,
                              int LDQA,
                              float* QB,
                              int LDQB,
                              float* X,
                              int LDX,
                              float* SCALE,
                              float* WORK,
                              size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_gesylv2(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              float SGN,
                              int M,
                              int N,
                              float* A,
                              int LDA,
                              float* B,
                              int LDB,
                              float* QA,
                              int LDQA,
                              float* QB,
                              int LDQB,
                              float* X,
                              int LDX,
                              float* SCALE,
                              float* WORK,
                              size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_gesylv_refine(const char* TRANSA,
                              const char* TRANSB,
                              const char* GUESS,
                              float SGN,
                              int M,int N,
                              float* A,  int LDA,
                              float* B,  int LDB,
                              float* X,  int LDX,
                              float* Y,  int LDY,
                              float* AS, int LDAS,
                              float* BS, int LDBS,
                              float* Q,  int LDQ,
                              float* U,  int LDU,
                              int* MAXIT,
                              float* TAU,
                              float* CONVLOG,
                              float* WORK,
                              size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_gesylv2_refine(const char* TRANSA,
                              const char* TRANSB,
                              const char* GUESS,
                              float SGN,
                              int M,int N,
                              float* A,  int LDA,
                              float* B,  int LDB,
                              float* X,  int LDX,
                              float* Y,  int LDY,
                              float* AS, int LDAS,
                              float* BS, int LDBS,
                              float* Q,  int LDQ,
                              float* U,  int LDU,
                              int* MAXIT,
                              float* TAU,
                              float* CONVLOG,
                              float* WORK,
                              size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_ggcsylv(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              float SGN1, float SGN2,
                              int M, int N,
                              float* A, int LDA,
                              float* B, int LDB,
                              float* C, int LDC,
                              float* D, int LDD,
                              float* QA, int LDQA,
                              float* ZA, int LDZA,
                              float* QB, int LDQB,
                              float* ZB, int LDZB,
                              float* E, int LDE,
                              float* F, int LDF,
                              float* SCALE,
                              float* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_ggcsylv_dual(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              float SGN1, float SGN2,
                              int M, int N,
                              float* A, int LDA,
                              float* B, int LDB,
                              float* C, int LDC,
                              float* D, int LDD,
                              float* QA, int LDQA,
                              float* ZA, int LDZA,
                              float* QB, int LDQB,
                              float* ZB, int LDZB,
                              float* E, int LDE,
                              float* F, int LDF,
                              float* SCALE,
                              float* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_ggcsylv_refine(const char* TRANSA,
                              const char* TRANSB,
                              const char* GUESS,
                              float SGN1, float SGN2,
                              int M, int N,
                              float* A, int LDA,
                              float* B, int LDB,
                              float* C, int LDC,
                              float* D, int LDD,
                              float* R, int LDR,
                              float* L, int LDL,
                              float* E, int LDE,
                              float* F, int LDF,
                              float* AS, int LDAS,
                              float* BS, int LDBS,
                              float* CS, int LDCS,
                              float* DS, int LDDS,
                              float* Q, int LDQ,
                              float* Z, int LDZ,
                              float* U, int LDU,
                              float* V, int LDV,
                              int* MAXIT,
                              float* TAU,
                              float* CONVLOG,
                              float* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_ggcsylv_dual_refine(const char* TRANSA,
                              const char* TRANSB, const char* GUESS,
                              float SGN1, float SGN2,
                              int M, int N,
                              float* A, int LDA,
                              float* B, int LDB,
                              float* C, int LDC,
                              float* D, int LDD,
                              float* R, int LDR,
                              float* L, int LDL,
                              float* E, int LDE,
                              float* F, int LDF,
                              float* AS, int LDAS,
                              float* BS, int LDBS,
                              float* CS, int LDCS,
                              float* DS, int LDDS,
                              float* Q, int LDQ,
                              float* Z, int LDZ,
                              float* U, int LDU,
                              float* V, int LDV,
                              int* MAXIT,
                              float* TAU,
                              float* CONVLOG,
                              float* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_ggsylv(const char* FACTA,
                              const char* FACTB,
                              const char* TRANSA,
                              const char* TRANSB,
                              float SGN,
                              int M, int N,
                              float* A, int LDA,
                              float* B, int LDB,
                              float* C, int LDC,
                              float* D, int LDD,
                              float* QA, int LDQA,
                              float* ZA, int LDZA,
                              float* QB, int LDQB,
                              float* ZB, int LDZB,
                              float* X, int LDX,
                              float* SCALE,
                              float* WORK, size_t LDWORK,
                              int* INFO)

cdef extern void mepack_single_ggsylv_refine(const char* TRANSA,
                              const char* TRANSB,
                              const char* GUESS,
                              float SGN,
                              int M, int N,
                              float* A, int LDA,
                              float* B, int LDB,
                              float* C, int LDC,
                              float* D, int LDD,
                              float* X, int LDX,
                              float* Y, int LDY,
                              float* AS, int LDAS,
                              float* BS, int LDBS,
                              float* CS, int LDCS,
                              float* DS, int LDDS,
                              float* Q, int LDQ,
                              float* Z, int LDZ,
                              float* U, int LDU,
                              float* V, int LDV,
                              int* MAXIT, float* TAU,
                              float* CONVLOG,
                              float* WORK, size_t LDWORK,
                              int* INFO)



# Residuals
cdef extern double mepack_double_residual_lyap(const char * TRANS, int M, double *A, int LDA, double *X, int LDX, double *Y, int LDY, double SCALE);
cdef extern float mepack_single_residual_lyap(const char * TRANS, int M, float *A, int LDA, float *X, int LDX, float *Y, int LDY, float SCALE);
cdef extern double mepack_double_residual_glyap(const char * TRANS, int M, double *A, int LDA, double *B, int LDB, double *X, int LDX, double *Y, int LDY, double SCALE);
cdef extern float mepack_single_residual_glyap(const char * TRANS, int M, float *A, int LDA, float *B, int LDB, float *X, int LDX, float *Y, int LDY, float SCALE);
cdef extern double mepack_double_residual_stein(const char * TRANS, int M, double *A, int LDA, double *X, int LDX, double *Y, int LDY, double SCALE);
cdef extern float mepack_single_residual_stein(const char * TRANS, int M, float *A, int LDA, float *X, int LDX, float *Y, int LDY, float SCALE);
cdef extern double mepack_double_residual_gstein(const char * TRANS, int M, double *A, int LDA, double *B, int LDB, double *X, int LDX, double *Y, int LDY, double SCALE);
cdef extern float mepack_single_residual_gstein(const char * TRANS, int M, float *A, int LDA, float *B, int LDB, float *X, int LDX, float *Y, int LDY, float SCALE);

cdef extern double mepack_double_residual_sylv(const char * TRANSA, const char *TRANSB, double SGN, int M, int N, double *A, int LDA, double *B, int LDB,
        double *X, int LDX, double *Y, int LDY, double SCALE);
cdef extern float mepack_single_residual_sylv(const char * TRANSA, const char *TRANSB, float SGN, int M, int N, float *A, int LDA, float *B, int LDB,
        float *X, int LDX, float *Y, int LDY, float SCALE);
cdef extern double mepack_double_residual_sylv2(const char * TRANSA, const char *TRANSB, double SGN, int M, int N, double *A, int LDA, double *B, int LDB,
        double *X, int LDX, double *Y, int LDY, double SCALE);
cdef extern float mepack_single_residual_sylv2(const char * TRANSA, const char *TRANSB, float SGN, int M, int N, float *A, int LDA, float *B, int LDB,
        float *X, int LDX, float *Y, int LDY, float SCALE);
cdef extern double mepack_double_residual_gsylv(const char * TRANSA, const char *TRANSB, double SGN, int M, int N, double *A, int LDA, double *B, int LDB,
        double *C, int LDC, double *D, int LDD,
        double *X, int LDX, double *Y, int LDY, double SCALE);
cdef extern float mepack_single_residual_gsylv(const char * TRANSA, const char *TRANSB, float SGN, int M, int N, float *A, int LDA, float *B, int LDB,
        float *C, int LDC, float *D, int LDD,
        float *X, int LDX, float *Y, int LDY, float SCALE);
cdef extern double mepack_double_residual_csylv(const char * TRANSA, const char *TRANSB, double SGN1, double SGN2, int M, int N, double *A, int LDA, double *B, int LDB,
        double *C, int LDC, double *D, int LDD,
        double *R, int LDR, double *L, int LDL,
        double *E, int LDE, double *F, int LDF, double SCALE);
cdef extern float mepack_single_residual_csylv(const char * TRANSA, const char *TRANSB, float SGN1, float SGN2, int M, int N, float *A, int LDA, float *B, int LDB,
        float *C, int LDC, float *D, int LDD,
        float *R, int LDR, float *L, int LDL,
        float *E, int LDE, float *F, int LDF, float SCALE);
cdef extern double mepack_double_residual_csylv_dual(const char * TRANSA, const char *TRANSB, double SGN1, double SGN2, int M, int N, double *A, int LDA, double *B, int LDB,
        double *C, int LDC, double *D, int LDD,
        double *R, int LDR, double *L, int LDL,
        double *E, int LDE, double *F, int LDF, double SCALE);
cdef extern float mepack_single_residual_csylv_dual(const char * TRANSA, const char *TRANSB, float SGN1, float SGN2, int M, int N, float *A, int LDA, float *B, int LDB,
        float *C, int LDC, float *D, int LDD,
        float *R, int LDR, float *L, int LDL,
        float *E, int LDE, float *F, int LDF, float SCALE);


