export declare enum DeploymentStatus {
    CREATED = "Created",
    QUEUED = "Queued",
    IN_PROGRESS = "InProgress",
    BAKING = "Baking",
    SUCCEEDED = "Succeeded",
    FAILED = "Failed",
    STOPPED = "Stopped",
    READY = "Ready"
}
/**
 * The request object that the custom resource lamba function receives from CloudFormation.
 */
export interface IsCompleteRequest {
    /**
     * The type of CloudFormation request (e.g. 'Create', 'Update', or 'Delete')
     */
    RequestType: string;
    /**
     * The physical resource id.
     */
    PhysicalResourceId: string;
}
/**
 * The response object that the custom resource lambda function returns to CloudFormation.
 */
export interface IsCompleteResponse {
    /**
     * True if and only if the deployment is in a final state.
     */
    IsComplete: boolean;
}
/**
 * The lambda function called from CloudFormation for this custom resource.
 *
 * @param event
 * @returns whether the deployment is complete
 */
export declare function handler(event: IsCompleteRequest): Promise<IsCompleteResponse>;
