import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteGitHubAccountTokenCommand, se_DeleteGitHubAccountTokenCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DeleteGitHubAccountTokenCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeDeploy_20141006", "DeleteGitHubAccountToken", {})
    .n("CodeDeployClient", "DeleteGitHubAccountTokenCommand")
    .f(void 0, void 0)
    .ser(se_DeleteGitHubAccountTokenCommand)
    .de(de_DeleteGitHubAccountTokenCommand)
    .build() {
}
