# Generated by ariadne-codegen
# Source: ../../../graphql/operations/

from datetime import datetime
from typing import List, Literal, Optional, Union
from uuid import UUID

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    CatalogFileFormatReferenceEnum,
    FileFormat,
    RepresentationType,
    TypedefCatalogTypeReferenceEnum,
    TypedefEngineStatusReferenceEnum,
    TypedefExecutionStatusReferenceEnum,
    TypedefObjectStateReferenceEnum,
    TypedefSessionStatusReferenceEnum,
    TypedefUserAuthTypeReferenceEnum,
)


class AppDetails(BaseModel):
    app_id: UUID = Field(alias="appId")
    name: str
    canonical_name: str = Field(alias="canonicalName")
    created_by_user_id: Optional[UUID] = Field(alias="createdByUserId")
    object_state: TypedefObjectStateReferenceEnum = Field(alias="objectState")
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")
    deleted_at: Optional[datetime] = Field(alias="deletedAt")


class CatalogDetails(BaseModel):
    catalog_id: UUID = Field(alias="catalogId")
    name: str
    canonical_name: str = Field(alias="canonicalName")
    description: str
    type: TypedefCatalogTypeReferenceEnum
    metadata: str
    warehouse_location: str = Field(alias="warehouseLocation")


class CommonCatalogNamespaceCreationResult(BaseModel):
    namespace_id: UUID = Field(alias="namespaceId")
    name: str
    created_at: datetime = Field(alias="createdAt")
    object_state: Optional[TypedefObjectStateReferenceEnum] = Field(alias="objectState")


class CommonCatalogNamespaceProperty(BaseModel):
    namespace_id: UUID = Field(alias="namespaceId")
    key: str
    value: str
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")


class DatasetDetails(BaseModel):
    dataset_id: UUID = Field(alias="datasetId")
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")
    properties: List["DatasetDetailsProperties"]
    schema_: str = Field(alias="schema")
    name: str


class DatasetDetailsProperties(BaseModel):
    key: str
    value: str


class EnvironmentDetails(BaseModel):
    environment_id: UUID = Field(alias="environmentId")
    name: str
    canonical_name: str = Field(alias="canonicalName")
    object_state: Optional[TypedefObjectStateReferenceEnum] = Field(alias="objectState")
    object_version: int = Field(alias="objectVersion")
    parent_organization_id: UUID = Field(alias="parentOrganizationId")
    description: str


class ExecutionStatus(BaseModel):
    status: Optional[TypedefExecutionStatusReferenceEnum]
    status_code: Optional[int] = Field(alias="statusCode")
    error_category: Optional[str] = Field(alias="errorCategory")
    error_code: Optional[int] = Field(alias="errorCode")
    error_message: Optional[str] = Field(alias="errorMessage")
    error_status: Optional[str] = Field(alias="errorStatus")
    query_execution_id: UUID = Field(alias="queryExecutionId")


class ExecutionDetails(ExecutionStatus):
    created_by_user_id: Optional[UUID] = Field(alias="createdByUserId")
    created_at: datetime = Field(alias="createdAt")
    started_at: Optional[datetime] = Field(alias="startedAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")
    completed_at: Optional[datetime] = Field(alias="completedAt")


class ExecutionSessionDetails(BaseModel):
    execution_session_id: UUID = Field(alias="executionSessionId")
    name: Optional[str]
    canonical_name: Optional[str] = Field(alias="canonicalName")
    environment_shared: Optional[bool] = Field(alias="environmentShared")
    created_by_user_id: Optional[UUID] = Field(alias="createdByUserId")
    created_at: datetime = Field(alias="createdAt")
    engine_status: TypedefEngineStatusReferenceEnum = Field(alias="engineStatus")
    engine_status_details: str = Field(alias="engineStatusDetails")
    engine_status_last_changed_at: Optional[datetime] = Field(
        alias="engineStatusLastChangedAt"
    )
    currently_managing_execution: Optional[bool] = Field(
        alias="currentlyManagingExecution"
    )
    last_action_ran_at: Optional[datetime] = Field(alias="lastActionRanAt")
    last_action_received_at: Optional[datetime] = Field(alias="lastActionReceivedAt")
    session_state: str = Field(alias="sessionState")
    terminated: Optional[bool]
    session_status: TypedefSessionStatusReferenceEnum = Field(alias="sessionStatus")
    app_id: Optional[UUID] = Field(alias="appId")
    ephemeral_catalog_id: UUID = Field(alias="ephemeralCatalogId")
    environment: "ExecutionSessionDetailsEnvironment"


class ExecutionSessionDetailsEnvironment(BaseModel):
    environment_id: UUID = Field(alias="environmentId")
    parent_organization_id: UUID = Field(alias="parentOrganizationId")


class ExecutionSessionMinimal(BaseModel):
    execution_session_id: UUID = Field(alias="executionSessionId")
    name: Optional[str]
    canonical_name: Optional[str] = Field(alias="canonicalName")
    created_by_user_id: Optional[UUID] = Field(alias="createdByUserId")


class NamespaceDetails(BaseModel):
    catalog: "NamespaceDetailsCatalog"
    catalog_id: UUID = Field(alias="catalogId")
    namespace_id: UUID = Field(alias="namespaceId")
    description: str
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")
    name: str
    properties: List["NamespaceDetailsProperties"]


class NamespaceDetailsCatalog(BaseModel):
    name: str
    canonical_name: str = Field(alias="canonicalName")


class NamespaceDetailsProperties(BaseModel):
    key: str
    value: str


class OrganizationDetails(BaseModel):
    organization_id: UUID = Field(alias="organizationId")
    name: str
    canonical_name: str = Field(alias="canonicalName")
    public_identifier: str = Field(alias="publicIdentifier")
    object_state: Optional[TypedefObjectStateReferenceEnum] = Field(alias="objectState")
    object_version: int = Field(alias="objectVersion")
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")


class SimpleCatalogNamespaceDetails(BaseModel):
    name: str
    description: str
    catalog_id: UUID = Field(alias="catalogId")
    catalog_name: str = Field(alias="catalogName")
    unique_identifier: str = Field(alias="uniqueIdentifier")
    properties: List[Optional["SimpleCatalogNamespaceDetailsProperties"]]


class SimpleCatalogNamespaceDetailsProperties(BaseModel):
    key: str
    value: str


class SimpleCatalogSchemaDetails(BaseModel):
    schema_id: int = Field(alias="schemaId")
    identifier_field_ids: Optional[List[int]] = Field(alias="identifierFieldIds")
    fields: List["SimpleCatalogSchemaDetailsFields"]


class SimpleCatalogSchemaDetailsFields(BaseModel):
    id: int
    name: str
    data_type: str = Field(alias="dataType")
    arrow_data_type: str = Field(alias="arrowDataType")
    nullable: bool
    metadata: Optional[str]


class SimpleCatalogTableDetails(BaseModel):
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")
    schema_: "SimpleCatalogTableDetailsSchema" = Field(alias="schema")
    name: str
    location: Optional[str]
    external: bool
    file_format: Optional[FileFormat] = Field(alias="fileFormat")
    partition_field_names: Optional[List[str]] = Field(alias="partitionFieldNames")


class SimpleCatalogTableDetailsSchema(SimpleCatalogSchemaDetails):
    pass


class SimpleCatalogViewDetails(BaseModel):
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")
    schema_: "SimpleCatalogViewDetailsSchema" = Field(alias="schema")
    representation: Union[
        "SimpleCatalogViewDetailsRepresentationSqlRepresentation",
    ] = Field(discriminator="typename__")
    properties: List[Optional["SimpleCatalogViewDetailsProperties"]]


class SimpleCatalogViewDetailsSchema(SimpleCatalogSchemaDetails):
    pass


class SimpleCatalogViewDetailsRepresentationSqlRepresentation(BaseModel):
    typename__: Literal["SqlRepresentation"] = Field(alias="__typename")
    typename__: Literal["SqlRepresentation"] = Field(alias="__typename")
    dialect: str
    sql: str
    type: RepresentationType


class SimpleCatalogViewDetailsProperties(BaseModel):
    key: str
    value: str


class TableDetails(DatasetDetails):
    table: Optional["TableDetailsTable"]


class TableDetailsTable(BaseModel):
    partition_field_names: List[str] = Field(alias="partitionFieldNames")
    file_format: CatalogFileFormatReferenceEnum = Field(alias="fileFormat")
    location: str
    externally_managed: bool = Field(alias="externallyManaged")


class TypedefCatalogDetails(BaseModel):
    typename__: str = Field(alias="__typename")
    catalog_id: UUID = Field(alias="catalogId")
    name: str
    canonical_name: str = Field(alias="canonicalName")
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")
    description: str
    ephemeral: bool


class UserDetails(BaseModel):
    auth_type: TypedefUserAuthTypeReferenceEnum = Field(alias="authType")
    created_at: datetime = Field(alias="createdAt")
    updated_at: Optional[datetime] = Field(alias="updatedAt")
    name: str
    canonical_name: str = Field(alias="canonicalName")
    user_id: UUID = Field(alias="userId")
    parent_organization_id: UUID = Field(alias="parentOrganizationId")
    auth_provider_user_id: str = Field(alias="authProviderUserId")
    object_version: int = Field(alias="objectVersion")
    object_state: Optional[TypedefObjectStateReferenceEnum] = Field(alias="objectState")


class ViewDetails(DatasetDetails):
    view: Optional["ViewDetailsView"]


class ViewDetailsView(BaseModel):
    sql: str
    dialect: str


AppDetails.model_rebuild()
CatalogDetails.model_rebuild()
CommonCatalogNamespaceCreationResult.model_rebuild()
CommonCatalogNamespaceProperty.model_rebuild()
DatasetDetails.model_rebuild()
EnvironmentDetails.model_rebuild()
ExecutionStatus.model_rebuild()
ExecutionDetails.model_rebuild()
ExecutionSessionDetails.model_rebuild()
ExecutionSessionMinimal.model_rebuild()
NamespaceDetails.model_rebuild()
OrganizationDetails.model_rebuild()
SimpleCatalogNamespaceDetails.model_rebuild()
SimpleCatalogSchemaDetails.model_rebuild()
SimpleCatalogTableDetails.model_rebuild()
SimpleCatalogViewDetails.model_rebuild()
TableDetails.model_rebuild()
TypedefCatalogDetails.model_rebuild()
UserDetails.model_rebuild()
ViewDetails.model_rebuild()
