/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.core.handler.AddEventListenerHandler;
import com.javonet.core.handler.ArrayGetItemHandler;
import com.javonet.core.handler.ArrayGetRankHandler;
import com.javonet.core.handler.ArrayGetSizeHandler;
import com.javonet.core.handler.ArrayHandler;
import com.javonet.core.handler.ArrayReferenceHandler;
import com.javonet.core.handler.ArraySetItemHandler;
import com.javonet.core.handler.AsKwargsHandler;
import com.javonet.core.handler.AsOutHandler;
import com.javonet.core.handler.AsRefHandler;
import com.javonet.core.handler.CastHandler;
import com.javonet.core.handler.ConvertTypeHandler;
import com.javonet.core.handler.CreateInstanceHandler;
import com.javonet.core.handler.CreateNullHandler;
import com.javonet.core.handler.DestructReferenceHandler;
import com.javonet.core.handler.EnableNamespaceHandler;
import com.javonet.core.handler.EnableTypeHandler;
import com.javonet.core.handler.ExceptionHandler;
import com.javonet.core.handler.GenerateLibraryHandler;
import com.javonet.core.handler.GetAsyncOperationResultHandler;
import com.javonet.core.handler.GetEnumItemHandler;
import com.javonet.core.handler.GetEnumNameHandler;
import com.javonet.core.handler.GetEnumValueHandler;
import com.javonet.core.handler.GetGlobalFieldHandler;
import com.javonet.core.handler.GetInstanceFieldHandler;
import com.javonet.core.handler.GetInstanceMethodAsDelegateHandler;
import com.javonet.core.handler.GetModuleHandler;
import com.javonet.core.handler.GetRefValueHandler;
import com.javonet.core.handler.GetResultTypeHandler;
import com.javonet.core.handler.GetStaticFieldHandler;
import com.javonet.core.handler.GetStaticMethodAsDelegateHandler;
import com.javonet.core.handler.GetTypeHandler;
import com.javonet.core.handler.HeartBeatHandler;
import com.javonet.core.handler.InvokeDelegateHandler;
import com.javonet.core.handler.InvokeGenericMethodHandler;
import com.javonet.core.handler.InvokeGenericStaticMethodHandler;
import com.javonet.core.handler.InvokeGlobalFunctionHandler;
import com.javonet.core.handler.InvokeInstanceMethodHandler;
import com.javonet.core.handler.InvokeStaticMethodHandler;
import com.javonet.core.handler.LoadLibraryHandler;
import com.javonet.core.handler.OptimizeHandler;
import com.javonet.core.handler.PassDelegateHandler;
import com.javonet.core.handler.PluginWrapperHandler;
import com.javonet.core.handler.RegisterForUpdateHandler;
import com.javonet.core.handler.ResolveInstanceHandler;
import com.javonet.core.handler.RetrieveArrayHandler;
import com.javonet.core.handler.SetInstanceFieldHandler;
import com.javonet.core.handler.SetStaticFieldHandler;
import com.javonet.core.handler.ValueForUpdateHandler;
import com.javonet.core.handler.ValueHandler;
import com.javonet.core.referencecache.ReferencesCache;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TypesHandler;
import com.javonet.utils.exceptions.ExceptionSerializer;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class Handler {
    static final Map<CommandType, AbstractHandler> HANDLERS = new HashMap<CommandType, AbstractHandler>();

    private Handler() {
    }

    public static Command handleCommand(Command command) {
        try {
            if (command.getCommandType() == CommandType.RETRIEVE_ARRAY) {
                Object array = HANDLERS.get((Object)CommandType.REFERENCE).handleCommand((Command)command.getPayload()[0]);
                Object[] responseArray = Handler.isArrayPrimitiveType(array) ? Handler.convertPrimitiveArrayToObjectArray(array) : (Object[])array;
                return Command.createArrayResponse(responseArray, command.getRuntimeName());
            }
            Object response = HANDLERS.get((Object)command.getCommandType()).handleCommand(command);
            return Handler.ParseResponse(response, command.getRuntimeName());
        }
        catch (Exception ex) {
            return Handler.resolveException(ex, command);
        }
    }

    private static Command ParseResponse(Object response, RuntimeName runtimeName) {
        Command responseCommand;
        if (TypesHandler.isPrimitiveOrNull(response).booleanValue()) {
            responseCommand = Command.createResponse(response, runtimeName);
        } else {
            if (Handler.isCommandGenerateLibType(response) || Handler.isCommandExceptionType(response)) {
                return (Command)response;
            }
            ReferencesCache cache = ReferencesCache.getInstance();
            String uuid = cache.cacheReference(response);
            responseCommand = Command.createReference(uuid, runtimeName);
        }
        ConcurrentHashMap<UUID, Object> invocationContexts = RegisterForUpdateHandler.invocationContexts.get();
        if (invocationContexts != null && !invocationContexts.isEmpty()) {
            ReferencesCache refCache = ReferencesCache.getInstance();
            for (Map.Entry<UUID, Object> contextEntry : invocationContexts.entrySet()) {
                String instanceGuid = refCache.cacheReference(contextEntry.getValue());
                Command updateContextCommand = new Command(runtimeName, CommandType.VALUE_FOR_UPDATE, contextEntry.getKey().toString(), instanceGuid);
                responseCommand = responseCommand.addArgToPayload(updateContextCommand);
            }
            invocationContexts.clear();
        }
        return responseCommand;
    }

    private static boolean isCommandGenerateLibType(Object result) {
        if (result.getClass() == Command.class) {
            return ((Command)result).getCommandType().equals((Object)CommandType.GENERATE_LIB);
        }
        return false;
    }

    private static boolean isCommandExceptionType(Object result) {
        if (result.getClass() == Command.class) {
            return ((Command)result).getCommandType().equals((Object)CommandType.EXCEPTION);
        }
        return false;
    }

    private static boolean isArrayPrimitiveType(Object result) {
        Class<?> resultClass = result.getClass();
        return resultClass.isArray() && resultClass.getComponentType().isPrimitive();
    }

    private static Object[] convertPrimitiveArrayToObjectArray(Object primitiveArray) {
        int length = Array.getLength(primitiveArray);
        Object[] objectArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            objectArray[i] = Array.get(primitiveArray, i);
        }
        return objectArray;
    }

    private static Command resolveException(Exception e, Command command) {
        if (e.getCause() != null) {
            return ExceptionSerializer.serializeException(e.getCause(), command);
        }
        return ExceptionSerializer.serializeException(e, command);
    }

    static {
        HANDLERS.put(CommandType.VALUE, new ValueHandler());
        HANDLERS.put(CommandType.LOAD_LIBRARY, new LoadLibraryHandler());
        HANDLERS.put(CommandType.INVOKE_STATIC_METHOD, new InvokeStaticMethodHandler());
        HANDLERS.put(CommandType.GET_STATIC_FIELD, new GetStaticFieldHandler());
        HANDLERS.put(CommandType.SET_STATIC_FIELD, new SetStaticFieldHandler());
        HANDLERS.put(CommandType.CREATE_INSTANCE, new CreateInstanceHandler());
        HANDLERS.put(CommandType.GET_TYPE, new GetTypeHandler());
        HANDLERS.put(CommandType.REFERENCE, new ResolveInstanceHandler());
        HANDLERS.put(CommandType.GET_MODULE, new GetModuleHandler());
        HANDLERS.put(CommandType.INVOKE_INSTANCE_METHOD, new InvokeInstanceMethodHandler());
        HANDLERS.put(CommandType.EXCEPTION, new ExceptionHandler());
        HANDLERS.put(CommandType.HEART_BEAT, new HeartBeatHandler());
        HANDLERS.put(CommandType.CAST, new CastHandler());
        HANDLERS.put(CommandType.GET_INSTANCE_FIELD, new GetInstanceFieldHandler());
        HANDLERS.put(CommandType.OPTIMIZE, new OptimizeHandler());
        HANDLERS.put(CommandType.GENERATE_LIB, new GenerateLibraryHandler());
        HANDLERS.put(CommandType.INVOKE_GLOBAL_FUNCTION, new InvokeGlobalFunctionHandler());
        HANDLERS.put(CommandType.DESTRUCT_REFERENCE, new DestructReferenceHandler());
        HANDLERS.put(CommandType.ARRAY_REFERENCE, new ArrayReferenceHandler());
        HANDLERS.put(CommandType.ARRAY_GET_ITEM, new ArrayGetItemHandler());
        HANDLERS.put(CommandType.ARRAY_GET_SIZE, new ArrayGetSizeHandler());
        HANDLERS.put(CommandType.ARRAY_GET_RANK, new ArrayGetRankHandler());
        HANDLERS.put(CommandType.ARRAY_SET_ITEM, new ArraySetItemHandler());
        HANDLERS.put(CommandType.ARRAY, new ArrayHandler());
        HANDLERS.put(CommandType.RETRIEVE_ARRAY, new RetrieveArrayHandler());
        HANDLERS.put(CommandType.SET_INSTANCE_FIELD, new SetInstanceFieldHandler());
        HANDLERS.put(CommandType.INVOKE_GENERIC_STATIC_METHOD, new InvokeGenericStaticMethodHandler());
        HANDLERS.put(CommandType.INVOKE_GENERIC_METHOD, new InvokeGenericMethodHandler());
        HANDLERS.put(CommandType.GET_ENUM_ITEM, new GetEnumItemHandler());
        HANDLERS.put(CommandType.GET_ENUM_NAME, new GetEnumNameHandler());
        HANDLERS.put(CommandType.GET_ENUM_VALUE, new GetEnumValueHandler());
        HANDLERS.put(CommandType.AS_REF, new AsRefHandler());
        HANDLERS.put(CommandType.AS_OUT, new AsOutHandler());
        HANDLERS.put(CommandType.GET_REF_VALUE, new GetRefValueHandler());
        HANDLERS.put(CommandType.ENABLE_NAMESPACE, new EnableNamespaceHandler());
        HANDLERS.put(CommandType.ENABLE_TYPE, new EnableTypeHandler());
        HANDLERS.put(CommandType.CREATE_NULL, new CreateNullHandler());
        HANDLERS.put(CommandType.GET_STATIC_METHOD_AS_DELEGATE, new GetStaticMethodAsDelegateHandler());
        HANDLERS.put(CommandType.GET_INSTANCE_METHOD_AS_DELEGATE, new GetInstanceMethodAsDelegateHandler());
        HANDLERS.put(CommandType.PASS_DELEGATE, new PassDelegateHandler());
        HANDLERS.put(CommandType.INVOKE_DELEGATE, new InvokeDelegateHandler());
        HANDLERS.put(CommandType.CONVERT_TYPE, new ConvertTypeHandler());
        HANDLERS.put(CommandType.ADD_EVENT_LISTENER, new AddEventListenerHandler());
        HANDLERS.put(CommandType.PLUGIN_WRAPPER, new PluginWrapperHandler());
        HANDLERS.put(CommandType.GET_ASYNC_OPERATION_RESULT, new GetAsyncOperationResultHandler());
        HANDLERS.put(CommandType.AS_KWARGS, new AsKwargsHandler());
        HANDLERS.put(CommandType.GET_RESULT_TYPE, new GetResultTypeHandler());
        HANDLERS.put(CommandType.GET_GLOBAL_FIELD, new GetGlobalFieldHandler());
        HANDLERS.put(CommandType.REGISTER_FOR_UPDATE, new RegisterForUpdateHandler());
        HANDLERS.put(CommandType.VALUE_FOR_UPDATE, new ValueForUpdateHandler());
    }
}

