/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class InvokeGenericStaticMethodHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 2;

    @Override
    public Object process(Command command) throws Exception {
        Method foundMethod;
        if (command.getPayload().length < 2) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 2);
        }
        Class classToLoad = (Class)command.getPayload()[0];
        String methodToInvoke = command.getPayload()[1].toString();
        Object[] arguments = Arrays.stream(command.getPayload()).skip(2L).toArray();
        Object[] parameterTypes = new Class[arguments.length];
        Arrays.fill(parameterTypes, Object.class);
        try {
            foundMethod = classToLoad.getMethod(methodToInvoke, (Class<?>[])parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Method[] methods = classToLoad.getMethods();
            StringBuilder message = new StringBuilder("Method " + methodToInvoke + " with arguments " + Arrays.toString(parameterTypes) + " not found in class " + classToLoad.getName() + ". Available methods:\n");
            for (Method method : methods) {
                message.append(method.getName()).append(" with arguments ").append(Arrays.toString(method.getParameterTypes())).append("\n");
            }
            throw new NoSuchMethodException(message.toString());
        }
        foundMethod.setAccessible(true);
        return foundMethod.invoke(null, arguments);
    }
}

