/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

class RegisterForUpdateHandler
extends AbstractHandler {
    static final ThreadLocal<ConcurrentHashMap<UUID, Object>> invocationContexts = new ThreadLocal();
    private static final int REQUIRED_PARAMETERS_COUNT = 2;

    RegisterForUpdateHandler() {
    }

    private static ConcurrentHashMap<UUID, Object> getOrCreateContextDictionary() {
        ConcurrentHashMap<UUID, Object> dict = invocationContexts.get();
        if (dict == null) {
            dict = new ConcurrentHashMap();
            invocationContexts.set(dict);
        }
        return dict;
    }

    @Override
    Object process(Command command) throws Exception {
        if (command.getPayload() == null || command.getPayload().length < 2) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires at least " + 2 + " payload argument(s)");
        }
        Object objectToRegister = command.getPayload()[0];
        UUID guidToRegister = UUID.randomUUID();
        if (command.getPayload().length > 1 && command.getPayload()[1] instanceof String) {
            try {
                guidToRegister = UUID.fromString((String)command.getPayload()[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ConcurrentHashMap<UUID, Object> contextDictionary = RegisterForUpdateHandler.getOrCreateContextDictionary();
        contextDictionary.putIfAbsent(guidToRegister, objectToRegister);
        return objectToRegister;
    }
}

