/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeDeserializer;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.JType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.StringEncodingMode;
import java.util.Arrays;

public class CommandDeserializer {
    private CommandDeserializer() {
    }

    public static Command deserialize(byte[] buffer) {
        Command command = new Command(RuntimeName.values()[buffer[0]], CommandType.values()[buffer[10]], new Object[0]);
        int position = 11;
        while (position < buffer.length) {
            Object[] result = CommandDeserializer.readObject(buffer, position);
            command = command.addArgToPayload(result[0]);
            position = (Integer)result[1];
        }
        return command;
    }

    private static Object[] readObject(byte[] buffer, int position) {
        JType jType = JType.values()[buffer[position]];
        switch (jType) {
            case COMMAND: {
                return CommandDeserializer.readCommand(buffer, position);
            }
            case STRING: {
                return CommandDeserializer.readString(buffer, position);
            }
            case INTEGER: {
                return CommandDeserializer.readInt(buffer, position);
            }
            case BOOLEAN: {
                return CommandDeserializer.readBool(buffer, position);
            }
            case FLOAT: {
                return CommandDeserializer.readFloat(buffer, position);
            }
            case BYTE: {
                return CommandDeserializer.readByte(buffer, position);
            }
            case CHAR: {
                return CommandDeserializer.readChar(buffer, position);
            }
            case LONG: {
                return CommandDeserializer.readLong(buffer, position);
            }
            case DOUBLE: {
                return CommandDeserializer.readDouble(buffer, position);
            }
            case UNSIGNED_LONG_LONG: {
                return CommandDeserializer.readUnsignedLongLong(buffer, position);
            }
            case UNSIGNED_INTEGER: {
                return CommandDeserializer.readUnsignedInteger(buffer, position);
            }
            case NULL: {
                return CommandDeserializer.readNull(buffer, position);
            }
        }
        throw new RuntimeException("Type not supported: " + buffer[position]);
    }

    private static Object[] readCommand(byte[] buffer, int position) {
        int p = position;
        int numberOfElementsInPayload = TypeDeserializer.deserializeInt(Arrays.copyOfRange(buffer, p + 1, p + 5));
        byte runtime = buffer[p + 5];
        byte commandType = buffer[p + 6];
        p += 7;
        Object[] payload = new Object[numberOfElementsInPayload];
        for (int i = 0; i < numberOfElementsInPayload; ++i) {
            Object[] result = CommandDeserializer.readObject(buffer, p);
            payload[i] = result[0];
            p = (Integer)result[1];
        }
        Command command = new Command(RuntimeName.values()[runtime], CommandType.values()[commandType], payload);
        return new Object[]{command, p};
    }

    private static Object[] readString(byte[] buffer, int position) {
        int p = position;
        StringEncodingMode stringEncodingMode = StringEncodingMode.values()[buffer[p + 1]];
        int size = TypeDeserializer.deserializeInt(Arrays.copyOfRange(buffer, p + 2, p + 6));
        int dataStart = p += 6;
        String result = TypeDeserializer.deserializeString(stringEncodingMode, Arrays.copyOfRange(buffer, dataStart, dataStart + size));
        return new Object[]{result, p += size};
    }

    private static Object[] readInt(byte[] buffer, int position) {
        int p;
        int size = 4;
        int dataStart = p = position + 2;
        Integer result = TypeDeserializer.deserializeInt(Arrays.copyOfRange(buffer, dataStart, dataStart + size));
        return new Object[]{result, p += size};
    }

    private static Object[] readBool(byte[] buffer, int position) {
        int size = 1;
        int p = position + 2;
        byte byteVal = buffer[p];
        Boolean result = TypeDeserializer.deserializeBool(new byte[]{byteVal});
        return new Object[]{result, p += size};
    }

    private static Object[] readFloat(byte[] buffer, int position) {
        int p;
        int size = 4;
        int dataStart = p = position + 2;
        Float result = TypeDeserializer.deserializeFloat(Arrays.copyOfRange(buffer, dataStart, dataStart + size));
        return new Object[]{result, p += size};
    }

    private static Object[] readByte(byte[] buffer, int position) {
        int size = 1;
        int p = position + 2;
        Byte result = TypeDeserializer.deserializeByte(buffer[p]);
        return new Object[]{result, p += size};
    }

    private static Object[] readChar(byte[] buffer, int position) {
        int size = 1;
        int p = position + 2;
        Character result = TypeDeserializer.deserializeChar(buffer[p]);
        return new Object[]{result, p += size};
    }

    private static Object[] readLong(byte[] buffer, int position) {
        int p;
        int size = 8;
        int dataStart = p = position + 2;
        Long result = TypeDeserializer.deserializeLongLong(Arrays.copyOfRange(buffer, dataStart, dataStart + size));
        return new Object[]{result, p += size};
    }

    private static Object[] readDouble(byte[] buffer, int position) {
        int p;
        int size = 8;
        int dataStart = p = position + 2;
        Double result = TypeDeserializer.deserializeDouble(Arrays.copyOfRange(buffer, dataStart, dataStart + size));
        return new Object[]{result, p += size};
    }

    private static Object[] readUnsignedLongLong(byte[] buffer, int position) {
        int p;
        int size = 8;
        int dataStart = p = position + 2;
        Long result = TypeDeserializer.deserializeLongLong(Arrays.copyOfRange(buffer, dataStart, dataStart + size));
        return new Object[]{result, p += size};
    }

    private static Object[] readUnsignedInteger(byte[] buffer, int position) {
        int p;
        int size = 4;
        int dataStart = p = position + 2;
        Integer result = TypeDeserializer.deserializeInt(Arrays.copyOfRange(buffer, dataStart, dataStart + size));
        return new Object[]{result, p += size};
    }

    private static Object[] readNull(byte[] buffer, int position) {
        int size = 1;
        int p = position + 2;
        return new Object[]{TypeDeserializer.deserializeNull(buffer[(p += size) - 1]), p};
    }
}

