/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeSerializer;
import com.javonet.core.referencecache.ReferencesCache;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TypesHandler;
import com.javonet.utils.connectiondata.IConnectionData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CommandSerializer {
    private CommandSerializer() {
    }

    public static byte[] serialize(Command rootCommand, IConnectionData connectionData) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write((byte)rootCommand.getRuntimeName().ordinal());
            stream.write(0);
            if (connectionData != null) {
                stream.write(connectionData.serializeConnectionData());
            } else {
                stream.write(new byte[]{0, 0, 0, 0, 0, 0, 0});
            }
            stream.write(new byte[]{(byte)RuntimeName.Jvm.ordinal(), (byte)rootCommand.getCommandType().ordinal()});
            CommandSerializer.serializeRecursively(rootCommand, stream);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error during serialization", e);
        }
    }

    private static void serializeRecursively(Command command, ByteArrayOutputStream stream) throws IOException {
        for (Object item : command.getPayload()) {
            if (item instanceof Command) {
                Command innerCommand = (Command)item;
                stream.write(TypeSerializer.serializeCommand(innerCommand));
                CommandSerializer.serializeRecursively(innerCommand, stream);
                continue;
            }
            if (TypesHandler.isPrimitiveOrNull(item).booleanValue()) {
                stream.write(TypeSerializer.serializePrimitive(item));
                continue;
            }
            Command cmd = new Command(RuntimeName.Jvm, CommandType.REFERENCE, (Object)ReferencesCache.getInstance().cacheReference(item));
            stream.write(TypeSerializer.serializeCommand(cmd));
            CommandSerializer.serializeRecursively(cmd, stream);
        }
    }
}

