/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.transmitter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public class TransmitterWrapper {
    private static String workingDirectory = "";

    public static void setWorkingDirectoryPath(String path) {
        workingDirectory = path;
    }

    private static String detectArchitecture() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.US);
        if (arch.contains("aarch64") || arch.contains("arm64")) {
            return "ARM64";
        }
        if (arch.contains("64") || arch.contains("amd64") || arch.contains("x86_64")) {
            return "X64";
        }
        if (arch.contains("arm")) {
            return "ARM";
        }
        return "X86";
    }

    public static void loadNativeLibrary() {
        String osFolder;
        String fileName;
        Path base = workingDirectory == null || workingDirectory.isEmpty() ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(workingDirectory, new String[0]);
        String arch = TransmitterWrapper.detectArchitecture();
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (System.getProperty("os.version", "").toLowerCase(Locale.US).contains("android")) {
            System.loadLibrary("JavonetJvmRuntimeNative");
            return;
        }
        if (osName.contains("win")) {
            fileName = "JavonetJvmRuntimeNative.dll";
            osFolder = "Windows";
        } else if (osName.contains("mac")) {
            fileName = "libJavonetJvmRuntimeNative.dylib";
            osFolder = "MacOs";
        } else {
            fileName = "libJavonetJvmRuntimeNative.so";
            osFolder = "Linux";
        }
        Path libPath = base.resolve(Paths.get("Binaries", "Native", osFolder, arch, fileName));
        try {
            String canonical = new File(libPath.toString()).getCanonicalPath();
            System.load(canonical);
        }
        catch (UnsatisfiedLinkError ule) {
            throw new UnsatisfiedLinkError("Failed to load native library at: " + libPath + " (exists=" + Files.isRegularFile(libPath, new LinkOption[0]) + ") -> " + ule.getMessage());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to resolve native library path: " + libPath + " -> " + ioe.getMessage(), ioe);
        }
    }

    public static native int sendCommand(byte[] var0);

    public static native int readResponse(byte[] var0);

    public static native boolean setEmbeddedRuntime(byte var0, byte var1, byte var2, String var3);

    public static native boolean deployRuntime(byte[] var0, String var1, byte var2);

    public static native int activate(String var0);

    public static native String getNativeError();

    public static native int setConfigSource(String var0);

    public static native int setWorkingDirectory(String var0);
}

