/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.sdk.RuntimeContext;
import com.javonet.sdk.internal.AbstractConfigRuntimeFactory;
import com.javonet.sdk.tools.JsonResolver;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.RuntimeNameHandler;
import com.javonet.utils.UtilsConst;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.connectiondata.InMemoryConnectionData;
import com.javonet.utils.connectiondata.TcpConnectionData;
import com.javonet.utils.connectiondata.WsConnectionData;
import java.io.File;
import java.net.UnknownHostException;
import java.nio.file.Paths;

public class ConfigRuntimeFactory
implements AbstractConfigRuntimeFactory {
    private static final String[] IN_MEMORY_CONNECTION_TYPES = new String[]{"inmemory", "memory"};
    private static final String[] WEB_SOCKET_CONNECTION_TYPES = new String[]{"websocket", "ws"};
    private static final String[] TCP_CONNECTION_TYPES = new String[]{"tcp"};
    private final String configSource_;

    public ConfigRuntimeFactory(String configSource) {
        this.configSource_ = configSource;
    }

    @Override
    public RuntimeContext clr(String configName) {
        return this.getRuntimeContext(RuntimeName.Clr, configName);
    }

    @Override
    public RuntimeContext jvm(String configName) {
        return this.getRuntimeContext(RuntimeName.Jvm, configName);
    }

    @Override
    public RuntimeContext netcore(String configName) {
        return this.getRuntimeContext(RuntimeName.Netcore, configName);
    }

    @Override
    public RuntimeContext perl(String configName) {
        return this.getRuntimeContext(RuntimeName.Perl, configName);
    }

    @Override
    public RuntimeContext ruby(String configName) {
        return this.getRuntimeContext(RuntimeName.Ruby, configName);
    }

    @Override
    public RuntimeContext nodejs(String configName) {
        return this.getRuntimeContext(RuntimeName.Nodejs, configName);
    }

    @Override
    public RuntimeContext python(String configName) {
        return this.getRuntimeContext(RuntimeName.Python, configName);
    }

    @Override
    public RuntimeContext php(String configName) {
        return this.getRuntimeContext(RuntimeName.Php, configName);
    }

    @Override
    public RuntimeContext python27(String configName) {
        return this.getRuntimeContext(RuntimeName.Python27, configName);
    }

    private RuntimeContext getRuntimeContext(RuntimeName runtime, String configName) {
        JsonResolver jsonResolver = new JsonResolver(this.configSource_);
        try {
            UtilsConst.setLicenseKey(jsonResolver.getLicenseKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UtilsConst.setJavonetWorkingDirectory(jsonResolver.getWorkingDirectory());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String connType = jsonResolver.getChannelType(RuntimeNameHandler.getName(runtime), configName).toLowerCase();
        IConnectionData connData = null;
        if (ConfigRuntimeFactory.contains(IN_MEMORY_CONNECTION_TYPES, connType)) {
            connData = new InMemoryConnectionData();
        } else if (ConfigRuntimeFactory.contains(TCP_CONNECTION_TYPES, connType)) {
            try {
                connData = new TcpConnectionData(jsonResolver.getChannelHost(RuntimeNameHandler.getName(runtime), configName), jsonResolver.getChannelPort(RuntimeNameHandler.getName(runtime), configName));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else if (ConfigRuntimeFactory.contains(WEB_SOCKET_CONNECTION_TYPES, connType)) {
            connData = new WsConnectionData(jsonResolver.getChannelHost(RuntimeNameHandler.getName(runtime), configName));
        } else {
            throw new RuntimeException("Invalid connection type. Use inmemory, tcp or websocket");
        }
        RuntimeContext rtmCtx = RuntimeContext.getInstance(runtime, connData);
        this.loadModules(runtime, configName, jsonResolver, rtmCtx);
        return rtmCtx;
    }

    private void loadModules(RuntimeName runtime, String configName, JsonResolver jfr, RuntimeContext rtmCtx) {
        String[] modules = jfr.getModules(RuntimeNameHandler.getName(runtime), configName).split(",");
        String configDirectoryAbsolutePath = System.getProperty("user.dir");
        if (jfr.isConfigSourcePath().booleanValue()) {
            configDirectoryAbsolutePath = Paths.get(this.configSource_, new String[0]).getParent().toString();
        }
        for (String module : modules) {
            if (module.isEmpty()) continue;
            if (Paths.get(module, new String[0]).isAbsolute()) {
                rtmCtx.loadLibrary(module);
                continue;
            }
            rtmCtx.loadLibrary(configDirectoryAbsolutePath + File.separator + module);
        }
    }

    private static boolean contains(String[] array, String value) {
        for (String item : array) {
            if (!item.equals(value)) continue;
            return true;
        }
        return false;
    }
}

