/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.delegatecache.DelegatesCache;
import com.javonet.core.generator.IOptimizedTransmitter;
import com.javonet.core.generator.TransmitterOptimizer;
import com.javonet.core.interpreter.Interpreter;
import com.javonet.sdk.internal.AbstractArrayContext;
import com.javonet.sdk.internal.AbstractEnumContext;
import com.javonet.sdk.internal.AbstractEventContext;
import com.javonet.sdk.internal.AbstractInstanceContext;
import com.javonet.sdk.internal.AbstractInvocationContext;
import com.javonet.sdk.internal.AbstractStaticContext;
import com.javonet.sdk.internal.InvocationContextIterator;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TypesHandler;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.exceptions.ExceptionThrower;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class InvocationContext
implements AbstractInvocationContext,
AbstractInstanceContext,
AbstractStaticContext,
AbstractArrayContext,
AbstractEnumContext,
AbstractEventContext,
Iterable<InvocationContext> {
    private final RuntimeName runtimeName;
    private Command currentCommand;
    private boolean isExecuted;
    private final IConnectionData connectionData;
    private Object resultValue;
    private final ReentrantLock materializationLock = new ReentrantLock();
    private static final ConcurrentHashMap<UUID, InvocationContext> invocationContexts = new ConcurrentHashMap();
    private final UUID guid = UUID.randomUUID();

    protected Command getCurrentCommand() {
        return this.currentCommand;
    }

    protected InvocationContext(RuntimeName runtime, IConnectionData tcpConnectionData, Command command) {
        this.runtimeName = runtime;
        this.connectionData = tcpConnectionData;
        this.currentCommand = command;
        this.isExecuted = false;
    }

    public InvocationContext(RuntimeName runtime, IConnectionData connectionData, Command command, boolean isExecuted) {
        this.runtimeName = runtime;
        this.connectionData = connectionData;
        this.currentCommand = command;
        this.isExecuted = isExecuted;
    }

    @Override
    @NotNull
    public Iterator<InvocationContext> iterator() {
        if (this.currentCommand.getCommandType() != CommandType.REFERENCE) {
            throw new RuntimeException("Object is not iterable");
        }
        return new InvocationContextIterator(this);
    }

    public Command getCommand() {
        return this.currentCommand;
    }

    public InvocationContext execute(boolean toOptimize) {
        if (toOptimize) {
            Integer commandHashCode = this.currentCommand.hashCode();
            if (!IOptimizedTransmitter.optimizedClasses.containsKey(commandHashCode)) {
                TransmitterOptimizer.optimize(this.currentCommand, this.connectionData);
            }
            Object[] arg = ((Command)this.currentCommand.getPayload()[2]).getPayload();
            this.resultValue = ((IOptimizedTransmitter)IOptimizedTransmitter.optimizedClasses.get(commandHashCode)).execute(arg);
            this.isExecuted = true;
            return this;
        }
        return this.execute();
    }

    @Override
    public CompletableFuture<InvocationContext> executeAsync() {
        return CompletableFuture.supplyAsync(this::execute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvocationContext execute() {
        ArrayList<ReentrantLock> locks = new ArrayList<ReentrantLock>();
        for (InvocationContext ic : invocationContexts.values()) {
            locks.add(ic.materializationLock);
        }
        locks.sort(Comparator.comparingInt(System::identityHashCode));
        for (ReentrantLock lock : locks) {
            lock.lock();
        }
        try {
            InvocationContext invocationContext;
            Command responseCommand = Interpreter.execute(this.currentCommand, this.connectionData);
            if (responseCommand.getCommandType() == CommandType.EXCEPTION) {
                ExceptionThrower.throwException(responseCommand);
            }
            if ((responseCommand = this.processUpdateInvocationContextCommands(responseCommand, invocationContexts)).getCommandType() == CommandType.CREATE_INSTANCE) {
                this.currentCommand = responseCommand;
                this.isExecuted = true;
                invocationContext = this;
                return invocationContext;
            }
            invocationContext = new InvocationContext(this.runtimeName, this.connectionData, responseCommand, true);
            return invocationContext;
        }
        finally {
            for (ReentrantLock lock : locks) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command processUpdateInvocationContextCommands(Command responseCommand, ConcurrentHashMap<UUID, InvocationContext> instancesToBeMaterialized) {
        Object[] payload = responseCommand.getPayload();
        if (payload == null || payload.length == 0) {
            return responseCommand;
        }
        ArrayList<Command> commandsToUpdate = new ArrayList<Command>();
        for (Object item : payload) {
            Command cmd;
            if (!(item instanceof Command) || (cmd = (Command)item).getCommandType() != CommandType.VALUE_FOR_UPDATE) continue;
            commandsToUpdate.add(cmd);
        }
        if (commandsToUpdate.isEmpty()) {
            return responseCommand;
        }
        ArrayList<Object> updatedPayload = new ArrayList<Object>(Arrays.asList(payload));
        this.materializationLock.lock();
        try {
            for (Command cmd : commandsToUpdate) {
                Object[] cmdPayload = cmd.getPayload();
                if (cmdPayload != null && cmdPayload.length >= 2) {
                    try {
                        UUID contextGuid = UUID.fromString(String.valueOf(cmdPayload[0]));
                        InvocationContext invCtx = instancesToBeMaterialized.get(contextGuid);
                        if (invCtx != null) {
                            String instanceGuid = String.valueOf(cmdPayload[1]);
                            invCtx.currentCommand = new Command(this.runtimeName, CommandType.REFERENCE, (Object)instanceGuid);
                            instancesToBeMaterialized.remove(contextGuid);
                            invocationContexts.remove(contextGuid);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                updatedPayload.remove(cmd);
            }
        }
        finally {
            this.materializationLock.unlock();
        }
        return new Command(responseCommand.getRuntimeName(), responseCommand.getCommandType(), updatedPayload.toArray());
    }

    public CompletableFuture<InvocationContext> getAsyncOperationResult() {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_ASYNC_OPERATION_RESULT, new Object[0]);
        InvocationContext localInvCtx = new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
        return localInvCtx.executeAsync();
    }

    @Override
    public InvocationContext invokeStaticMethod(String methodName, Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_STATIC_METHOD, this.createArgsArray(methodName, arguments));
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getInstanceField(String fieldName) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_INSTANCE_FIELD, (Object)fieldName);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setInstanceField(String fieldName, Object value) {
        Command localCommand = new Command(this.runtimeName, CommandType.SET_INSTANCE_FIELD, fieldName, value);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext invokeInstanceMethod(String methodName, Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_INSTANCE_METHOD, this.createArgsArray(methodName, arguments));
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext createInstance(Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.CREATE_INSTANCE, arguments);
        InvocationContext createInstanceInvCtx = new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
        return createInstanceInvCtx.registerForUpdate();
    }

    @Override
    public InvocationContext getStaticField(String fieldName) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_STATIC_FIELD, (Object)fieldName);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setStaticField(String fieldName, Object value) {
        Command localCommand = new Command(this.runtimeName, CommandType.SET_STATIC_FIELD, fieldName, value);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getIndex(Object ... indexes) {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_ITEM, indexes);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getSize() {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_SIZE, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getRank() {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_RANK, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setIndex(Object indexes, Object value) {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_SET_ITEM, indexes, value);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext invokeGenericStaticMethod(String methodName, Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_GENERIC_STATIC_METHOD, this.createArgsArray(methodName, args2));
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext invokeGenericMethod(String methodName, Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_GENERIC_METHOD, this.createArgsArray(methodName, args2));
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getEnumName() {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_ENUM_NAME, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getEnumValue() {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_ENUM_VALUE, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getRefValue() {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_REF_VALUE, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext createNull() {
        Command localCommand = new Command(this.runtimeName, CommandType.CREATE_NULL, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getStaticMethodAsDelegate(String methodName, Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_STATIC_METHOD_AS_DELEGATE, this.createArgsArray(methodName, args2));
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getInstanceMethodAsDelegate(String methodName, Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_INSTANCE_METHOD_AS_DELEGATE, this.createArgsArray(methodName, args2));
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext addEventListener(String eventName, Object eventHandler) {
        Command localCommand = new Command(this.runtimeName, CommandType.ADD_EVENT_LISTENER, eventName, eventHandler);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public Object getValue() {
        this.resultValue = this.currentCommand.getPayload()[0];
        return this.resultValue;
    }

    public Object[] retrieveArray(Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.RETRIEVE_ARRAY, args2);
        InvocationContext localInvCtx = new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
        InvocationContext arrayInvCtx = localInvCtx.execute();
        Object[] responseArray = (Object[])Array.newInstance(arrayInvCtx.currentCommand.getPayload()[0].getClass(), localInvCtx.currentCommand.getPayload().length);
        responseArray = (Object[])arrayInvCtx.currentCommand.getPayload().clone();
        return responseArray;
    }

    public String getResultType() {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_RESULT_TYPE, (Object)this.currentCommand);
        InvocationContext localInvCtx = new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
        return (String)localInvCtx.execute().getValue();
    }

    public RuntimeName getRuntimeName() {
        return this.runtimeName;
    }

    private InvocationContext registerForUpdate() {
        this.currentCommand = this.buildCommand(new Command(this.runtimeName, CommandType.REGISTER_FOR_UPDATE, new Object[]{this.guid.toString()}));
        invocationContexts.put(this.guid, this);
        return this;
    }

    private Command buildCommand(Command command) {
        Object[] payload = command.getPayload();
        Object[] newPayload = new Object[payload.length];
        for (int i = 0; i < payload.length; ++i) {
            newPayload[i] = this.encapsulatePayloadItem(payload[i]);
        }
        Command newCommand = new Command(command.getRuntimeName(), command.getCommandType(), newPayload);
        return newCommand.prependArgToPayload(this.currentCommand);
    }

    private Command encapsulatePayloadItem(Object payloadItem) {
        if (payloadItem == null) {
            return new Command(this.runtimeName, CommandType.VALUE, payloadItem);
        }
        if (payloadItem instanceof Command) {
            Command cmd = (Command)payloadItem;
            Object[] payload = cmd.getPayload();
            Object[] newPayload = new Object[payload.length];
            for (int i = 0; i < payload.length; ++i) {
                newPayload[i] = this.encapsulatePayloadItem(payload[i]);
            }
            return new Command(cmd.getRuntimeName(), cmd.getCommandType(), newPayload);
        }
        if (payloadItem instanceof InvocationContext) {
            return ((InvocationContext)payloadItem).getCurrentCommand();
        }
        if (payloadItem instanceof Type) {
            return new Command(this.runtimeName, CommandType.CONVERT_TYPE, (Object)TypesHandler.convertTypeToJType((Type)payloadItem));
        }
        if (payloadItem.getClass().isArray()) {
            int length = Array.getLength(payloadItem);
            Object[] objectArray = new Object[length];
            for (int i = 0; i < length; ++i) {
                objectArray[i] = this.encapsulatePayloadItem(Array.get(payloadItem, i));
            }
            return new Command(this.runtimeName, CommandType.ARRAY, objectArray);
        }
        if (payloadItem instanceof Method) {
            Object[] types = new Object[((Method)payloadItem).getParameterCount() + 1];
            for (int i = 0; i < types.length - 1; ++i) {
                types[i] = ((Method)payloadItem).getParameterTypes()[i];
            }
            types[types.length - 1] = ((Method)payloadItem).getReturnType();
            Object[] delegateArray = new Object[]{DelegatesCache.getInstance().addDelegate((Method)payloadItem), RuntimeName.Jvm.ordinal()};
            Object[] args2 = new Object[delegateArray.length + types.length];
            System.arraycopy(delegateArray, 0, args2, 0, delegateArray.length);
            System.arraycopy(types, 0, args2, delegateArray.length, types.length);
            for (int i = 0; i < args2.length; ++i) {
                args2[i] = this.encapsulatePayloadItem(args2[i]);
            }
            return new Command(this.runtimeName, CommandType.PASS_DELEGATE, args2);
        }
        if (TypesHandler.isPrimitiveOrNull(payloadItem).booleanValue()) {
            return new Command(this.runtimeName, CommandType.VALUE, payloadItem);
        }
        throw new IllegalArgumentException("Unsupported payload item type: " + payloadItem.getClass().getName() + " for payload item: " + payloadItem);
    }

    private Object[] createArgsArray(Object arg1, Object ... args2) {
        if (args2 == null) {
            return new Object[]{arg1, null};
        }
        Object[] argsArray = Arrays.copyOf(new Object[]{arg1}, args2.length + 1);
        System.arraycopy(args2, 0, argsArray, 1, args2.length);
        return argsArray;
    }
}

