/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.runtime.IEmbeddedRuntime;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.RuntimeContext;
import com.javonet.sdk.internal.AbstractRuntimeFactory;
import com.javonet.sdk.tools.BinariesUnloader;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.messagehelper.MessageHelper;
import java.io.IOException;

public class RuntimeFactory
implements AbstractRuntimeFactory {
    private final IConnectionData connectionData;

    public RuntimeFactory(IConnectionData connectionData) {
        this.connectionData = connectionData;
    }

    @Override
    public RuntimeContext clr() {
        return RuntimeContext.getInstance(RuntimeName.Clr, this.connectionData);
    }

    @Override
    public RuntimeContext jvm() {
        return RuntimeContext.getInstance(RuntimeName.Jvm, this.connectionData);
    }

    @Override
    public RuntimeContext netcore() {
        return RuntimeContext.getInstance(RuntimeName.Netcore, this.connectionData);
    }

    @Override
    public RuntimeContext perl() {
        return RuntimeContext.getInstance(RuntimeName.Perl, this.connectionData);
    }

    @Override
    public RuntimeContext ruby() {
        return RuntimeContext.getInstance(RuntimeName.Ruby, this.connectionData);
    }

    @Override
    public RuntimeContext nodejs() {
        return RuntimeContext.getInstance(RuntimeName.Nodejs, this.connectionData);
    }

    @Override
    public RuntimeContext python() {
        return RuntimeContext.getInstance(RuntimeName.Python, this.connectionData);
    }

    @Override
    public RuntimeContext php() {
        return RuntimeContext.getInstance(RuntimeName.Php, this.connectionData);
    }

    @Override
    public RuntimeContext python27() {
        return RuntimeContext.getInstance(RuntimeName.Python27, this.connectionData);
    }

    public RuntimeContext setEmbeddedRuntime(IEmbeddedRuntime runtime, String path) {
        try {
            BinariesUnloader.extractBinariesFromJar(runtime.getRuntimeLib().toString());
            byte[] bytes = runtime.getRuntimeBytes();
            Transmitter.deployRuntime(bytes, path, (byte)runtime.getRuntimeVersion());
            Transmitter.setEmbeddedRuntime((byte)runtime.getRuntimeLib().ordinal(), (byte)runtime.getRuntimeVersion(), path);
            return RuntimeContext.getInstance(runtime.getRuntimeLib(), this.connectionData);
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageHelper.getInstance().sendMessageToAppInsights("SdkException", "Error setting embedded runtime: " + e.getMessage());
            throw new RuntimeException("Error setting embedded runtime: " + e.getMessage());
        }
    }
}

