/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.configuration;

import com.google.gson.JsonParseException;
import com.javonet.sdk.configuration.Config;
import com.javonet.sdk.configuration.ConfigPriority;
import com.javonet.sdk.configuration.ConfigsDictionary;
import com.javonet.sdk.configuration.configresolvers.ConnectionStringConfigResolver;
import com.javonet.sdk.configuration.configresolvers.JsonConfigResolver;
import com.javonet.sdk.configuration.configresolvers.YamlConfigResolver;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ConfigSourceResolver {
    public static void addConfigs(ConfigPriority priority, String configSource) {
        System.out.println("Adding config from source: " + configSource + " with priority '" + (Object)((Object)priority) + "'");
        String configString = ConfigSourceResolver.getConfigSourceAsString(configSource);
        ConfigSourceResolver.parseConfigsAndAddToCollection(priority, configString);
    }

    public static Config getConfig(String configName) {
        System.out.println("Retrieving config " + configName);
        return ConfigsDictionary.getConfig(configName);
    }

    public static void clearConfigs() {
        ConfigsDictionary.clearConfigs();
    }

    private static String getConfigSourceAsString(String configSource) {
        String envPropValue;
        if (configSource == null || configSource.trim().isEmpty()) {
            throw new IllegalArgumentException("Config source cannot be null or whitespace.");
        }
        String envValue = System.getenv(configSource);
        if (envValue != null && !envValue.trim().isEmpty()) {
            configSource = envValue;
        }
        if ((envPropValue = System.getProperty(configSource)) != null && !envPropValue.trim().isEmpty()) {
            configSource = envPropValue;
        }
        try {
            Path path = Paths.get(configSource, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                configSource = new String(Files.readAllBytes(path));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configSource.trim();
    }

    private static void parseConfigsAndAddToCollection(ConfigPriority priority, String configString) {
        try {
            JsonConfigResolver.addConfigs(priority, configString);
            return;
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (Exception ex) {
            System.out.println("Failed to parse config source as JSON: " + ex.getMessage());
        }
        try {
            YamlConfigResolver.addConfigs(priority, configString);
            return;
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            System.out.println("Failed to parse config source as YAML: " + ex.getMessage());
        }
        try {
            ConnectionStringConfigResolver.addConfigs(priority, configString);
            return;
        }
        catch (Exception ex) {
            System.out.println("Failed to parse config source as connection string: " + ex.getMessage());
            throw new IllegalArgumentException("Config source is not in a recognized format (JSON, YAML, or connection string):\n" + configString);
        }
    }
}

