/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.configuration.configresolvers;

import com.javonet.sdk.configuration.Config;
import com.javonet.sdk.configuration.ConfigPriority;
import com.javonet.sdk.configuration.ConfigsDictionary;
import com.javonet.sdk.configuration.configresolvers.ConfigResolver;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.UtilsConst;
import com.javonet.utils.connectiondata.IConnectionData;
import java.util.Map;
import java.util.TreeMap;

public class ConnectionStringConfigResolver
extends ConfigResolver {
    public static void addConfigs(ConfigPriority priority, String connectionStringSource) {
        String[] lines;
        if (connectionStringSource == null || connectionStringSource.trim().isEmpty()) {
            throw new IllegalArgumentException("Connection string source cannot be null or empty.");
        }
        String normalized = connectionStringSource.replace("\r\n", "\n").replace('\r', '\n');
        for (String rawLine : lines = normalized.split("\n")) {
            String line = rawLine.trim();
            if (line.isEmpty() || line.startsWith("#") || line.startsWith("//")) continue;
            if (line.toLowerCase().startsWith("licensekey")) {
                ConnectionStringConfigResolver.setLicenseKey(line);
                continue;
            }
            try {
                Map<String, String> keyValues = ConnectionStringConfigResolver.parseKeyValues(line);
                String configName = keyValues.get("name");
                if (configName == null || configName.trim().isEmpty()) {
                    throw new IllegalArgumentException("Missing or empty config name.");
                }
                String runtimeValue = keyValues.get("runtime");
                if (runtimeValue == null || runtimeValue.trim().isEmpty()) {
                    throw new IllegalArgumentException("Missing or empty runtime.");
                }
                RuntimeName runtimeName = ConnectionStringConfigResolver.tryParseRuntime(runtimeValue);
                String hostValue = keyValues.get("host");
                IConnectionData connectionData = ConnectionStringConfigResolver.buildConnectionData(hostValue);
                String plugins = keyValues.get("plugins");
                String modules = keyValues.get("modules");
                Config config = new Config(runtimeName, connectionData, plugins != null ? plugins : "", modules != null ? modules : "");
                ConfigsDictionary.addConfig(configName, priority, config);
            }
            catch (Exception ex) {
                System.out.println("Failed to parse config line: '" + line + "'. Reason: " + ex.getMessage());
                throw ex;
            }
        }
    }

    private static void setLicenseKey(String line) {
        int eq = line.indexOf(61);
        if (eq > 0 && eq < line.length() - 1) {
            int slashes;
            int hashIdx;
            String valuePortion = line.substring(eq + 1).trim();
            int semicolon = valuePortion.indexOf(59);
            if (semicolon >= 0) {
                valuePortion = valuePortion.substring(0, semicolon).trim();
            }
            if ((hashIdx = valuePortion.indexOf(35)) >= 0) {
                valuePortion = valuePortion.substring(0, hashIdx).trim();
            }
            if ((slashes = valuePortion.indexOf("//")) >= 0) {
                valuePortion = valuePortion.substring(0, slashes).trim();
            }
            UtilsConst.setLicenseKey(valuePortion);
        }
    }

    private static Map<String, String> parseKeyValues(String line) {
        String[] segments;
        TreeMap<String, String> dict = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String segmentRaw : segments = line.split(";")) {
            String segment = segmentRaw.trim();
            if (segment.isEmpty()) continue;
            int eq = segment.indexOf(61);
            if (eq <= 0 || eq == segment.length() - 1) {
                System.out.println("Ignoring malformed token '" + segment + "' in line: " + line);
                continue;
            }
            String key = segment.substring(0, eq).trim();
            String value = segment.substring(eq + 1).trim();
            if (key.isEmpty()) continue;
            dict.put(key, value);
        }
        return dict;
    }
}

