/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.configuration.configresolvers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.javonet.sdk.configuration.Config;
import com.javonet.sdk.configuration.ConfigPriority;
import com.javonet.sdk.configuration.ConfigsDictionary;
import com.javonet.sdk.configuration.configresolvers.ConfigResolver;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.UtilsConst;
import com.javonet.utils.connectiondata.IConnectionData;
import java.util.Map;
import java.util.Set;

public class JsonConfigResolver
extends ConfigResolver {
    public static void addConfigs(ConfigPriority priority, JsonObject jsonObject) {
        JsonElement configsEl;
        if (jsonObject == null) {
            throw new NullPointerException("jsonObject");
        }
        JsonElement licenseEl = jsonObject.get("licenseKey");
        if (licenseEl != null && licenseEl.isJsonPrimitive() && licenseEl.getAsJsonPrimitive().isString()) {
            UtilsConst.setLicenseKey(licenseEl.getAsString().trim());
        }
        if ((configsEl = jsonObject.get("configurations")) == null || !configsEl.isJsonObject()) {
            throw new IllegalArgumentException("JSON must contain 'configurations' object.");
        }
        JsonObject configs = configsEl.getAsJsonObject();
        Set<Map.Entry<String, JsonElement>> entries = configs.entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            String configName = entry.getKey();
            JsonElement cfg = entry.getValue();
            try {
                if (!cfg.isJsonObject()) {
                    throw new IllegalArgumentException("Configuration value must be an object.");
                }
                JsonObject configObj = cfg.getAsJsonObject();
                RuntimeName runtimeName = JsonConfigResolver.tryParseRuntime(JsonConfigResolver.getRequiredString(configObj, "runtime"));
                String host = JsonConfigResolver.getOptionalString(configObj, "host");
                IConnectionData connectionData = JsonConfigResolver.buildConnectionData(host);
                String plugins = JsonConfigResolver.getOptionalString(configObj, "plugins");
                String modules = JsonConfigResolver.getOptionalString(configObj, "modules");
                Config config = new Config(runtimeName, connectionData, plugins, modules);
                ConfigsDictionary.addConfig(configName, priority, config);
            }
            catch (Exception ex) {
                System.out.println("Failed to add config '" + configName + "': " + ex.getMessage());
            }
        }
    }

    public static void addConfigs(ConfigPriority priority, String jsonString) {
        try {
            JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
            JsonConfigResolver.addConfigs(priority, jsonObject);
        }
        catch (JsonParseException e) {
            throw new JsonParseException("Failed to parse JSON string: " + e.getMessage(), e);
        }
        catch (Exception ex) {
            throw new JsonParseException("Failed to process JSON string: " + ex.getMessage(), ex);
        }
    }

    private static String getRequiredString(JsonObject obj, String property) {
        JsonElement el = obj.get(property);
        if (el == null || !el.isJsonPrimitive() || !el.getAsJsonPrimitive().isString()) {
            throw new IllegalArgumentException("Missing or invalid '" + property + "' property.");
        }
        String value = el.getAsString();
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Property '" + property + "' cannot be empty.");
        }
        return value.trim();
    }

    private static String getOptionalString(JsonObject obj, String property) {
        JsonElement el = obj.get(property);
        if (el != null && el.isJsonPrimitive() && el.getAsJsonPrimitive().isString()) {
            String value = el.getAsString();
            return value != null ? value : "";
        }
        return "";
    }
}

